"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuantizedMeshLoader = void 0;
Object.defineProperty(exports, "QuantizedMeshWorkerLoader", {
  enumerable: true,
  get: function () {
    return _quantizedMeshLoader.QuantizedMeshLoader;
  }
});
exports.TerrainLoader = void 0;
Object.defineProperty(exports, "TerrainWorkerLoader", {
  enumerable: true,
  get: function () {
    return _terrainLoader.TerrainLoader;
  }
});
exports._typecheckTerrainLoader = exports._typecheckQuantizedMeshLoader = void 0;
var _parseQuantizedMesh = _interopRequireDefault(require("./lib/parse-quantized-mesh"));
var _parseTerrain = _interopRequireDefault(require("./lib/parse-terrain"));
var _terrainLoader = require("./terrain-loader");
var _quantizedMeshLoader = require("./quantized-mesh-loader");
const TerrainLoader = {
  ..._terrainLoader.TerrainLoader,
  parse: _parseTerrain.default
};
exports.TerrainLoader = TerrainLoader;
const _typecheckTerrainLoader = TerrainLoader;
exports._typecheckTerrainLoader = _typecheckTerrainLoader;
const QuantizedMeshLoader = {
  ..._quantizedMeshLoader.QuantizedMeshLoader,
  parseSync: _parseQuantizedMesh.default,
  parse: async (arrayBuffer, options) => (0, _parseQuantizedMesh.default)(arrayBuffer, options)
};
exports.QuantizedMeshLoader = QuantizedMeshLoader;
const _typecheckQuantizedMeshLoader = QuantizedMeshLoader;
exports._typecheckQuantizedMeshLoader = _typecheckQuantizedMeshLoader;
//# sourceMappingURL=index.js.map