"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._typecheckTerrainWorkerLoader = exports.TerrainLoader = void 0;
var _version = require("./lib/utils/version");
const TerrainLoader = {
  name: 'Terrain',
  id: 'terrain',
  module: 'terrain',
  version: _version.VERSION,
  worker: true,
  extensions: ['png', 'pngraw', 'jpg', 'jpeg', 'gif', 'webp', 'bmp'],
  mimeTypes: ['image/png', 'image/jpeg', 'image/gif', 'image/webp', 'image/bmp'],
  options: {
    terrain: {
      tesselator: 'auto',
      bounds: null,
      meshMaxError: 10,
      elevationDecoder: {
        rScaler: 1,
        gScaler: 0,
        bScaler: 0,
        offset: 0
      },
      skirtHeight: null
    }
  }
};
exports.TerrainLoader = TerrainLoader;
const _typecheckTerrainWorkerLoader = TerrainLoader;
exports._typecheckTerrainWorkerLoader = _typecheckTerrainWorkerLoader;
//# sourceMappingURL=terrain-loader.js.map