import { getMeshBoundingBox } from '@loaders.gl/schema';
import decode, { DECODING_STEPS } from './decode-quantized-mesh';
import { addSkirt } from './helpers/skirt';
function getMeshAttributes(vertexData, header, bounds) {
  const {
    minHeight,
    maxHeight
  } = header;
  const [minX, minY, maxX, maxY] = bounds || [0, 0, 1, 1];
  const xScale = maxX - minX;
  const yScale = maxY - minY;
  const zScale = maxHeight - minHeight;
  const nCoords = vertexData.length / 3;
  const positions = new Float32Array(nCoords * 3);
  const texCoords = new Float32Array(nCoords * 2);
  for (let i = 0; i < nCoords; i++) {
    const x = vertexData[i] / 32767;
    const y = vertexData[i + nCoords] / 32767;
    const z = vertexData[i + nCoords * 2] / 32767;
    positions[3 * i + 0] = x * xScale + minX;
    positions[3 * i + 1] = y * yScale + minY;
    positions[3 * i + 2] = z * zScale + minHeight;
    texCoords[2 * i + 0] = x;
    texCoords[2 * i + 1] = y;
  }
  return {
    POSITION: {
      value: positions,
      size: 3
    },
    TEXCOORD_0: {
      value: texCoords,
      size: 2
    }
  };
}
function getTileMesh(arrayBuffer, options) {
  if (!arrayBuffer) {
    return null;
  }
  const {
    bounds
  } = options;
  const {
    header,
    vertexData,
    triangleIndices: originalTriangleIndices,
    westIndices,
    northIndices,
    eastIndices,
    southIndices
  } = decode(arrayBuffer, DECODING_STEPS.triangleIndices);
  let triangleIndices = originalTriangleIndices;
  let attributes = getMeshAttributes(vertexData, header, bounds);
  const boundingBox = getMeshBoundingBox(attributes);
  if (options.skirtHeight) {
    const {
      attributes: newAttributes,
      triangles: newTriangles
    } = addSkirt(attributes, triangleIndices, options.skirtHeight, {
      westIndices,
      northIndices,
      eastIndices,
      southIndices
    });
    attributes = newAttributes;
    triangleIndices = newTriangles;
  }
  return {
    loaderData: {
      header: {}
    },
    header: {
      vertexCount: triangleIndices.length,
      boundingBox
    },
    mode: 4,
    indices: {
      value: triangleIndices,
      size: 1
    },
    attributes
  };
}
export default function loadQuantizedMesh(arrayBuffer, options) {
  return getTileMesh(arrayBuffer, options['quantized-mesh']);
}
//# sourceMappingURL=parse-quantized-mesh.js.map