import type { LoaderWithParser } from '@loaders.gl/loader-utils';
import parseQuantizedMesh from './lib/parse-quantized-mesh';
import loadTerrain from './lib/parse-terrain';
import { TerrainLoader as TerrainWorkerLoader } from './terrain-loader';
import { QuantizedMeshLoader as QuantizedMeshWorkerLoader } from './quantized-mesh-loader';
export { TerrainWorkerLoader };
export declare const TerrainLoader: {
    parse: typeof loadTerrain;
    name: string;
    id: string;
    module: string;
    version: any;
    worker: boolean;
    extensions: string[];
    mimeTypes: string[];
    options: {
        terrain: {
            tesselator: string;
            bounds: null;
            meshMaxError: number;
            elevationDecoder: {
                rScaler: number;
                gScaler: number;
                bScaler: number;
                offset: number;
            };
            skirtHeight: null;
        };
    };
};
export declare const _typecheckTerrainLoader: LoaderWithParser;
export { QuantizedMeshWorkerLoader };
/**
 * Loader for quantized meshes
 */
export declare const QuantizedMeshLoader: {
    parseSync: typeof parseQuantizedMesh;
    parse: (arrayBuffer: any, options: any) => Promise<{
        loaderData: {
            header: {};
        };
        header: {
            vertexCount: any;
            boundingBox: [[number, number, number], [number, number, number]];
        };
        mode: number;
        indices: {
            value: any;
            size: number;
        };
        attributes: {
            POSITION: {
                value: Float32Array;
                size: number;
            };
            TEXCOORD_0: {
                value: Float32Array;
                size: number;
            };
        };
    } | null>;
    name: string;
    id: string;
    module: string;
    version: any;
    worker: boolean;
    extensions: string[];
    mimeTypes: string[];
    options: {
        'quantized-mesh': {
            bounds: number[];
            skirtHeight: null;
        };
    };
};
export declare const _typecheckQuantizedMeshLoader: LoaderWithParser;
//# sourceMappingURL=index.d.ts.map