(() => {
  var __defProp = Object.defineProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };

  // ../../node_modules/@math.gl/core/dist/esm/lib/assert.js
  function assert(condition, message) {
    if (!condition) {
      throw new Error("math.gl assertion ".concat(message));
    }
  }
  var init_assert = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/assert.js"() {
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/common.js
  function formatValue(value, {
    precision = config.precision
  } = {}) {
    value = round(value);
    return "".concat(parseFloat(value.toPrecision(precision)));
  }
  function isArray(value) {
    return Array.isArray(value) || ArrayBuffer.isView(value) && !(value instanceof DataView);
  }
  function toRadians(degrees2) {
    return radians(degrees2);
  }
  function toDegrees(radians2) {
    return degrees(radians2);
  }
  function radians(degrees2, result) {
    return map(degrees2, (degrees3) => degrees3 * DEGREES_TO_RADIANS, result);
  }
  function degrees(radians2, result) {
    return map(radians2, (radians3) => radians3 * RADIANS_TO_DEGREES, result);
  }
  function equals(a, b, epsilon) {
    const oldEpsilon = config.EPSILON;
    if (epsilon) {
      config.EPSILON = epsilon;
    }
    try {
      if (a === b) {
        return true;
      }
      if (isArray(a) && isArray(b)) {
        if (a.length !== b.length) {
          return false;
        }
        for (let i = 0; i < a.length; ++i) {
          if (!equals(a[i], b[i])) {
            return false;
          }
        }
        return true;
      }
      if (a && a.equals) {
        return a.equals(b);
      }
      if (b && b.equals) {
        return b.equals(a);
      }
      if (typeof a === "number" && typeof b === "number") {
        return Math.abs(a - b) <= config.EPSILON * Math.max(1, Math.abs(a), Math.abs(b));
      }
      return false;
    } finally {
      config.EPSILON = oldEpsilon;
    }
  }
  function round(value) {
    return Math.round(value / config.EPSILON) * config.EPSILON;
  }
  function duplicateArray(array) {
    return array.clone ? array.clone() : new Array(array.length);
  }
  function map(value, func, result) {
    if (isArray(value)) {
      const array = value;
      result = result || duplicateArray(array);
      for (let i = 0; i < result.length && i < array.length; ++i) {
        result[i] = func(value[i], i, result);
      }
      return result;
    }
    return func(value);
  }
  var RADIANS_TO_DEGREES, DEGREES_TO_RADIANS, config;
  var init_common = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/common.js"() {
      RADIANS_TO_DEGREES = 1 / Math.PI * 180;
      DEGREES_TO_RADIANS = 1 / 180 * Math.PI;
      config = {
        EPSILON: 1e-12,
        debug: false,
        precision: 4,
        printTypes: false,
        printDegrees: false,
        printRowMajor: true
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js
  function _extendableBuiltin(cls) {
    function ExtendableBuiltin() {
      var instance = Reflect.construct(cls, Array.from(arguments));
      Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
      return instance;
    }
    ExtendableBuiltin.prototype = Object.create(cls.prototype, {
      constructor: {
        value: cls,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(ExtendableBuiltin, cls);
    } else {
      ExtendableBuiltin.__proto__ = cls;
    }
    return ExtendableBuiltin;
  }
  var MathArray;
  var init_math_array = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js"() {
      init_common();
      MathArray = class extends _extendableBuiltin(Array) {
        clone() {
          return new this.constructor().copy(this);
        }
        fromArray(array, offset = 0) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = array[i + offset];
          }
          return this.check();
        }
        toArray(targetArray = [], offset = 0) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            targetArray[offset + i] = this[i];
          }
          return targetArray;
        }
        from(arrayOrObject) {
          return Array.isArray(arrayOrObject) ? this.copy(arrayOrObject) : this.fromObject(arrayOrObject);
        }
        to(arrayOrObject) {
          if (arrayOrObject === this) {
            return this;
          }
          return isArray(arrayOrObject) ? this.toArray(arrayOrObject) : this.toObject(arrayOrObject);
        }
        toTarget(target) {
          return target ? this.to(target) : this;
        }
        toFloat32Array() {
          return new Float32Array(this);
        }
        toString() {
          return this.formatString(config);
        }
        formatString(opts) {
          let string = "";
          for (let i = 0; i < this.ELEMENTS; ++i) {
            string += (i > 0 ? ", " : "") + formatValue(this[i], opts);
          }
          return "".concat(opts.printTypes ? this.constructor.name : "", "[").concat(string, "]");
        }
        equals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i = 0; i < this.ELEMENTS; ++i) {
            if (!equals(this[i], array[i])) {
              return false;
            }
          }
          return true;
        }
        exactEquals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i = 0; i < this.ELEMENTS; ++i) {
            if (this[i] !== array[i]) {
              return false;
            }
          }
          return true;
        }
        negate() {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = -this[i];
          }
          return this.check();
        }
        lerp(a, b, t) {
          if (t === void 0) {
            return this.lerp(this, a, b);
          }
          for (let i = 0; i < this.ELEMENTS; ++i) {
            const ai = a[i];
            this[i] = ai + t * (b[i] - ai);
          }
          return this.check();
        }
        min(vector) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = Math.min(vector[i], this[i]);
          }
          return this.check();
        }
        max(vector) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = Math.max(vector[i], this[i]);
          }
          return this.check();
        }
        clamp(minVector, maxVector) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = Math.min(Math.max(this[i], minVector[i]), maxVector[i]);
          }
          return this.check();
        }
        add(...vectors) {
          for (const vector of vectors) {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] += vector[i];
            }
          }
          return this.check();
        }
        subtract(...vectors) {
          for (const vector of vectors) {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] -= vector[i];
            }
          }
          return this.check();
        }
        scale(scale5) {
          if (typeof scale5 === "number") {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] *= scale5;
            }
          } else {
            for (let i = 0; i < this.ELEMENTS && i < scale5.length; ++i) {
              this[i] *= scale5[i];
            }
          }
          return this.check();
        }
        multiplyByScalar(scalar) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] *= scalar;
          }
          return this.check();
        }
        check() {
          if (config.debug && !this.validate()) {
            throw new Error("math.gl: ".concat(this.constructor.name, " some fields set to invalid numbers'"));
          }
          return this;
        }
        validate() {
          let valid = this.length === this.ELEMENTS;
          for (let i = 0; i < this.ELEMENTS; ++i) {
            valid = valid && Number.isFinite(this[i]);
          }
          return valid;
        }
        sub(a) {
          return this.subtract(a);
        }
        setScalar(a) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = a;
          }
          return this.check();
        }
        addScalar(a) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] += a;
          }
          return this.check();
        }
        subScalar(a) {
          return this.addScalar(-a);
        }
        multiplyScalar(scalar) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] *= scalar;
          }
          return this.check();
        }
        divideScalar(a) {
          return this.multiplyByScalar(1 / a);
        }
        clampScalar(min, max) {
          for (let i = 0; i < this.ELEMENTS; ++i) {
            this[i] = Math.min(Math.max(this[i], min), max);
          }
          return this.check();
        }
        get elements() {
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/validators.js
  function validateVector(v, length4) {
    if (v.length !== length4) {
      return false;
    }
    for (let i = 0; i < v.length; ++i) {
      if (!Number.isFinite(v[i])) {
        return false;
      }
    }
    return true;
  }
  function checkNumber(value) {
    if (!Number.isFinite(value)) {
      throw new Error("Invalid number ".concat(value));
    }
    return value;
  }
  function checkVector(v, length4, callerName = "") {
    if (config.debug && !validateVector(v, length4)) {
      throw new Error("math.gl: ".concat(callerName, " some fields set to invalid numbers'"));
    }
    return v;
  }
  var init_validators = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/validators.js"() {
      init_common();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js
  var Vector;
  var init_vector = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js"() {
      init_math_array();
      init_validators();
      init_assert();
      Vector = class extends MathArray {
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        len() {
          return Math.sqrt(this.lengthSquared());
        }
        magnitude() {
          return this.len();
        }
        lengthSquared() {
          let length4 = 0;
          for (let i = 0; i < this.ELEMENTS; ++i) {
            length4 += this[i] * this[i];
          }
          return length4;
        }
        magnitudeSquared() {
          return this.lengthSquared();
        }
        distance(mathArray) {
          return Math.sqrt(this.distanceSquared(mathArray));
        }
        distanceSquared(mathArray) {
          let length4 = 0;
          for (let i = 0; i < this.ELEMENTS; ++i) {
            const dist = this[i] - mathArray[i];
            length4 += dist * dist;
          }
          return checkNumber(length4);
        }
        dot(mathArray) {
          let product = 0;
          for (let i = 0; i < this.ELEMENTS; ++i) {
            product += this[i] * mathArray[i];
          }
          return checkNumber(product);
        }
        normalize() {
          const length4 = this.magnitude();
          if (length4 !== 0) {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] /= length4;
            }
          }
          return this.check();
        }
        multiply(...vectors) {
          for (const vector of vectors) {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] *= vector[i];
            }
          }
          return this.check();
        }
        divide(...vectors) {
          for (const vector of vectors) {
            for (let i = 0; i < this.ELEMENTS; ++i) {
              this[i] /= vector[i];
            }
          }
          return this.check();
        }
        lengthSq() {
          return this.lengthSquared();
        }
        distanceTo(vector) {
          return this.distance(vector);
        }
        distanceToSquared(vector) {
          return this.distanceSquared(vector);
        }
        getComponent(i) {
          assert(i >= 0 && i < this.ELEMENTS, "index is out of range");
          return checkNumber(this[i]);
        }
        setComponent(i, value) {
          assert(i >= 0 && i < this.ELEMENTS, "index is out of range");
          this[i] = value;
          return this.check();
        }
        addVectors(a, b) {
          return this.copy(a).add(b);
        }
        subVectors(a, b) {
          return this.copy(a).subtract(b);
        }
        multiplyVectors(a, b) {
          return this.copy(a).multiply(b);
        }
        addScaledVector(a, b) {
          return this.add(new this.constructor(a).multiplyScalar(b));
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/common.js
  var EPSILON, ARRAY_TYPE, degree;
  var init_common2 = __esm({
    "../../node_modules/gl-matrix/esm/common.js"() {
      EPSILON = 1e-6;
      ARRAY_TYPE = typeof Float32Array !== "undefined" ? Float32Array : Array;
      degree = Math.PI / 180;
      if (!Math.hypot)
        Math.hypot = function() {
          var y = 0, i = arguments.length;
          while (i--) {
            y += arguments[i] * arguments[i];
          }
          return Math.sqrt(y);
        };
    }
  });

  // ../../node_modules/gl-matrix/esm/vec2.js
  function create() {
    var out = new ARRAY_TYPE(2);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
    }
    return out;
  }
  function transformMat3(out, a, m) {
    var x = a[0], y = a[1];
    out[0] = m[0] * x + m[3] * y + m[6];
    out[1] = m[1] * x + m[4] * y + m[7];
    return out;
  }
  function transformMat4(out, a, m) {
    var x = a[0];
    var y = a[1];
    out[0] = m[0] * x + m[4] * y + m[12];
    out[1] = m[1] * x + m[5] * y + m[13];
    return out;
  }
  var forEach;
  var init_vec2 = __esm({
    "../../node_modules/gl-matrix/esm/vec2.js"() {
      init_common2();
      forEach = function() {
        var vec = create();
        return function(a, stride, offset, count, fn, arg) {
          var i, l;
          if (!stride) {
            stride = 2;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l = Math.min(count * stride + offset, a.length);
          } else {
            l = a.length;
          }
          for (i = offset; i < l; i += stride) {
            vec[0] = a[i];
            vec[1] = a[i + 1];
            fn(vec, vec, arg);
            a[i] = vec[0];
            a[i + 1] = vec[1];
          }
          return a;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js
  function vec2_transformMat4AsVector(out, a, m) {
    const x = a[0];
    const y = a[1];
    const w = m[3] * x + m[7] * y || 1;
    out[0] = (m[0] * x + m[4] * y) / w;
    out[1] = (m[1] * x + m[5] * y) / w;
    return out;
  }
  function vec3_transformMat4AsVector(out, a, m) {
    const x = a[0];
    const y = a[1];
    const z = a[2];
    const w = m[3] * x + m[7] * y + m[11] * z || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z) / w;
    return out;
  }
  function vec3_transformMat2(out, a, m) {
    const x = a[0];
    const y = a[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a[2];
    return out;
  }
  function vec4_transformMat2(out, a, m) {
    const x = a[0];
    const y = a[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a[2];
    out[3] = a[3];
    return out;
  }
  function vec4_transformMat3(out, a, m) {
    const x = a[0];
    const y = a[1];
    const z = a[2];
    out[0] = m[0] * x + m[3] * y + m[6] * z;
    out[1] = m[1] * x + m[4] * y + m[7] * z;
    out[2] = m[2] * x + m[5] * y + m[8] * z;
    out[3] = a[3];
    return out;
  }
  var init_gl_matrix_extras = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js"() {
    }
  });

  // ../../node_modules/gl-matrix/esm/vec3.js
  function create2() {
    var out = new ARRAY_TYPE(3);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    return out;
  }
  function length(a) {
    var x = a[0];
    var y = a[1];
    var z = a[2];
    return Math.hypot(x, y, z);
  }
  function fromValues(x, y, z) {
    var out = new ARRAY_TYPE(3);
    out[0] = x;
    out[1] = y;
    out[2] = z;
    return out;
  }
  function normalize(out, a) {
    var x = a[0];
    var y = a[1];
    var z = a[2];
    var len2 = x * x + y * y + z * z;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = a[0] * len2;
    out[1] = a[1] * len2;
    out[2] = a[2] * len2;
    return out;
  }
  function dot(a, b) {
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
  }
  function cross(out, a, b) {
    var ax = a[0], ay = a[1], az = a[2];
    var bx = b[0], by = b[1], bz = b[2];
    out[0] = ay * bz - az * by;
    out[1] = az * bx - ax * bz;
    out[2] = ax * by - ay * bx;
    return out;
  }
  function transformMat42(out, a, m) {
    var x = a[0], y = a[1], z = a[2];
    var w = m[3] * x + m[7] * y + m[11] * z + m[15];
    w = w || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z + m[12]) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z + m[13]) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z + m[14]) / w;
    return out;
  }
  function transformMat32(out, a, m) {
    var x = a[0], y = a[1], z = a[2];
    out[0] = x * m[0] + y * m[3] + z * m[6];
    out[1] = x * m[1] + y * m[4] + z * m[7];
    out[2] = x * m[2] + y * m[5] + z * m[8];
    return out;
  }
  function transformQuat(out, a, q) {
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var x = a[0], y = a[1], z = a[2];
    var uvx = qy * z - qz * y, uvy = qz * x - qx * z, uvz = qx * y - qy * x;
    var uuvx = qy * uvz - qz * uvy, uuvy = qz * uvx - qx * uvz, uuvz = qx * uvy - qy * uvx;
    var w2 = qw * 2;
    uvx *= w2;
    uvy *= w2;
    uvz *= w2;
    uuvx *= 2;
    uuvy *= 2;
    uuvz *= 2;
    out[0] = x + uvx + uuvx;
    out[1] = y + uvy + uuvy;
    out[2] = z + uvz + uuvz;
    return out;
  }
  function rotateX(out, a, b, rad) {
    var p = [], r = [];
    p[0] = a[0] - b[0];
    p[1] = a[1] - b[1];
    p[2] = a[2] - b[2];
    r[0] = p[0];
    r[1] = p[1] * Math.cos(rad) - p[2] * Math.sin(rad);
    r[2] = p[1] * Math.sin(rad) + p[2] * Math.cos(rad);
    out[0] = r[0] + b[0];
    out[1] = r[1] + b[1];
    out[2] = r[2] + b[2];
    return out;
  }
  function rotateY(out, a, b, rad) {
    var p = [], r = [];
    p[0] = a[0] - b[0];
    p[1] = a[1] - b[1];
    p[2] = a[2] - b[2];
    r[0] = p[2] * Math.sin(rad) + p[0] * Math.cos(rad);
    r[1] = p[1];
    r[2] = p[2] * Math.cos(rad) - p[0] * Math.sin(rad);
    out[0] = r[0] + b[0];
    out[1] = r[1] + b[1];
    out[2] = r[2] + b[2];
    return out;
  }
  function rotateZ(out, a, b, rad) {
    var p = [], r = [];
    p[0] = a[0] - b[0];
    p[1] = a[1] - b[1];
    p[2] = a[2] - b[2];
    r[0] = p[0] * Math.cos(rad) - p[1] * Math.sin(rad);
    r[1] = p[0] * Math.sin(rad) + p[1] * Math.cos(rad);
    r[2] = p[2];
    out[0] = r[0] + b[0];
    out[1] = r[1] + b[1];
    out[2] = r[2] + b[2];
    return out;
  }
  function angle(a, b) {
    var ax = a[0], ay = a[1], az = a[2], bx = b[0], by = b[1], bz = b[2], mag1 = Math.sqrt(ax * ax + ay * ay + az * az), mag2 = Math.sqrt(bx * bx + by * by + bz * bz), mag = mag1 * mag2, cosine = mag && dot(a, b) / mag;
    return Math.acos(Math.min(Math.max(cosine, -1), 1));
  }
  var len, forEach2;
  var init_vec3 = __esm({
    "../../node_modules/gl-matrix/esm/vec3.js"() {
      init_common2();
      len = length;
      forEach2 = function() {
        var vec = create2();
        return function(a, stride, offset, count, fn, arg) {
          var i, l;
          if (!stride) {
            stride = 3;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l = Math.min(count * stride + offset, a.length);
          } else {
            l = a.length;
          }
          for (i = offset; i < l; i += stride) {
            vec[0] = a[i];
            vec[1] = a[i + 1];
            vec[2] = a[i + 2];
            fn(vec, vec, arg);
            a[i] = vec[0];
            a[i + 1] = vec[1];
            a[i + 2] = vec[2];
          }
          return a;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector3.js
  var ORIGIN, ZERO, Vector3;
  var init_vector3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector3.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      ORIGIN = [0, 0, 0];
      Vector3 = class extends Vector {
        static get ZERO() {
          if (!ZERO) {
            ZERO = new Vector3(0, 0, 0);
            Object.freeze(ZERO);
          }
          return ZERO;
        }
        constructor(x = 0, y = 0, z = 0) {
          super(-0, -0, -0);
          if (arguments.length === 1 && isArray(x)) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
          }
        }
        set(x, y, z) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          return this.check();
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          return object;
        }
        get ELEMENTS() {
          return 3;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        angle(vector) {
          return angle(this, vector);
        }
        cross(vector) {
          cross(this, this, vector);
          return this.check();
        }
        rotateX({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateX(this, this, origin, radians2);
          return this.check();
        }
        rotateY({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateY(this, this, origin, radians2);
          return this.check();
        }
        rotateZ({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateZ(this, this, origin, radians2);
          return this.check();
        }
        transform(matrix4) {
          return this.transformAsPoint(matrix4);
        }
        transformAsPoint(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformAsVector(matrix4) {
          vec3_transformMat4AsVector(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          transformMat32(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec3_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector4.js
  var ZERO2, Vector4;
  var init_vector4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector4.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      Vector4 = class extends Vector {
        static get ZERO() {
          if (!ZERO2) {
            ZERO2 = new Vector4(0, 0, 0, 0);
            Object.freeze(ZERO2);
          }
          return ZERO2;
        }
        constructor(x = 0, y = 0, z = 0, w = 0) {
          super(-0, -0, -0, -0);
          if (isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
              checkNumber(w);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
            this[3] = w;
          }
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
            checkNumber(object.w);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this;
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          object.w = this[3];
          return object;
        }
        get ELEMENTS() {
          return 4;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        transform(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          vec4_transformMat3(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec4_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
        applyMatrix4(m) {
          m.transform(this, this);
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js
  var Matrix;
  var init_matrix = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js"() {
      init_math_array();
      init_validators();
      init_common();
      Matrix = class extends MathArray {
        toString() {
          let string = "[";
          if (config.printRowMajor) {
            string += "row-major:";
            for (let row = 0; row < this.RANK; ++row) {
              for (let col = 0; col < this.RANK; ++col) {
                string += " ".concat(this[col * this.RANK + row]);
              }
            }
          } else {
            string += "column-major:";
            for (let i = 0; i < this.ELEMENTS; ++i) {
              string += " ".concat(this[i]);
            }
          }
          string += "]";
          return string;
        }
        getElementIndex(row, col) {
          return col * this.RANK + row;
        }
        getElement(row, col) {
          return this[col * this.RANK + row];
        }
        setElement(row, col, value) {
          this[col * this.RANK + row] = checkNumber(value);
          return this;
        }
        getColumn(columnIndex, result = new Array(this.RANK).fill(-0)) {
          const firstIndex = columnIndex * this.RANK;
          for (let i = 0; i < this.RANK; ++i) {
            result[i] = this[firstIndex + i];
          }
          return result;
        }
        setColumn(columnIndex, columnVector) {
          const firstIndex = columnIndex * this.RANK;
          for (let i = 0; i < this.RANK; ++i) {
            this[firstIndex + i] = columnVector[i];
          }
          return this;
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat3.js
  function create3() {
    var out = new ARRAY_TYPE(9);
    if (ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[5] = 0;
      out[6] = 0;
      out[7] = 0;
    }
    out[0] = 1;
    out[4] = 1;
    out[8] = 1;
    return out;
  }
  function transpose(out, a) {
    if (out === a) {
      var a01 = a[1], a02 = a[2], a12 = a[5];
      out[1] = a[3];
      out[2] = a[6];
      out[3] = a01;
      out[5] = a[7];
      out[6] = a02;
      out[7] = a12;
    } else {
      out[0] = a[0];
      out[1] = a[3];
      out[2] = a[6];
      out[3] = a[1];
      out[4] = a[4];
      out[5] = a[7];
      out[6] = a[2];
      out[7] = a[5];
      out[8] = a[8];
    }
    return out;
  }
  function invert(out, a) {
    var a00 = a[0], a01 = a[1], a02 = a[2];
    var a10 = a[3], a11 = a[4], a12 = a[5];
    var a20 = a[6], a21 = a[7], a22 = a[8];
    var b01 = a22 * a11 - a12 * a21;
    var b11 = -a22 * a10 + a12 * a20;
    var b21 = a21 * a10 - a11 * a20;
    var det = a00 * b01 + a01 * b11 + a02 * b21;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = b01 * det;
    out[1] = (-a22 * a01 + a02 * a21) * det;
    out[2] = (a12 * a01 - a02 * a11) * det;
    out[3] = b11 * det;
    out[4] = (a22 * a00 - a02 * a20) * det;
    out[5] = (-a12 * a00 + a02 * a10) * det;
    out[6] = b21 * det;
    out[7] = (-a21 * a00 + a01 * a20) * det;
    out[8] = (a11 * a00 - a01 * a10) * det;
    return out;
  }
  function determinant(a) {
    var a00 = a[0], a01 = a[1], a02 = a[2];
    var a10 = a[3], a11 = a[4], a12 = a[5];
    var a20 = a[6], a21 = a[7], a22 = a[8];
    return a00 * (a22 * a11 - a12 * a21) + a01 * (-a22 * a10 + a12 * a20) + a02 * (a21 * a10 - a11 * a20);
  }
  function multiply(out, a, b) {
    var a00 = a[0], a01 = a[1], a02 = a[2];
    var a10 = a[3], a11 = a[4], a12 = a[5];
    var a20 = a[6], a21 = a[7], a22 = a[8];
    var b00 = b[0], b01 = b[1], b02 = b[2];
    var b10 = b[3], b11 = b[4], b12 = b[5];
    var b20 = b[6], b21 = b[7], b22 = b[8];
    out[0] = b00 * a00 + b01 * a10 + b02 * a20;
    out[1] = b00 * a01 + b01 * a11 + b02 * a21;
    out[2] = b00 * a02 + b01 * a12 + b02 * a22;
    out[3] = b10 * a00 + b11 * a10 + b12 * a20;
    out[4] = b10 * a01 + b11 * a11 + b12 * a21;
    out[5] = b10 * a02 + b11 * a12 + b12 * a22;
    out[6] = b20 * a00 + b21 * a10 + b22 * a20;
    out[7] = b20 * a01 + b21 * a11 + b22 * a21;
    out[8] = b20 * a02 + b21 * a12 + b22 * a22;
    return out;
  }
  function translate(out, a, v) {
    var a00 = a[0], a01 = a[1], a02 = a[2], a10 = a[3], a11 = a[4], a12 = a[5], a20 = a[6], a21 = a[7], a22 = a[8], x = v[0], y = v[1];
    out[0] = a00;
    out[1] = a01;
    out[2] = a02;
    out[3] = a10;
    out[4] = a11;
    out[5] = a12;
    out[6] = x * a00 + y * a10 + a20;
    out[7] = x * a01 + y * a11 + a21;
    out[8] = x * a02 + y * a12 + a22;
    return out;
  }
  function rotate(out, a, rad) {
    var a00 = a[0], a01 = a[1], a02 = a[2], a10 = a[3], a11 = a[4], a12 = a[5], a20 = a[6], a21 = a[7], a22 = a[8], s = Math.sin(rad), c = Math.cos(rad);
    out[0] = c * a00 + s * a10;
    out[1] = c * a01 + s * a11;
    out[2] = c * a02 + s * a12;
    out[3] = c * a10 - s * a00;
    out[4] = c * a11 - s * a01;
    out[5] = c * a12 - s * a02;
    out[6] = a20;
    out[7] = a21;
    out[8] = a22;
    return out;
  }
  function scale(out, a, v) {
    var x = v[0], y = v[1];
    out[0] = x * a[0];
    out[1] = x * a[1];
    out[2] = x * a[2];
    out[3] = y * a[3];
    out[4] = y * a[4];
    out[5] = y * a[5];
    out[6] = a[6];
    out[7] = a[7];
    out[8] = a[8];
    return out;
  }
  function fromQuat(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[3] = yx - wz;
    out[6] = zx + wy;
    out[1] = yx + wz;
    out[4] = 1 - xx - zz;
    out[7] = zy - wx;
    out[2] = zx - wy;
    out[5] = zy + wx;
    out[8] = 1 - xx - yy;
    return out;
  }
  var init_mat3 = __esm({
    "../../node_modules/gl-matrix/esm/mat3.js"() {
      init_common2();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js
  function getZeroMatrix() {
    if (!ZERO_MATRIX3) {
      ZERO_MATRIX3 = new Matrix3([0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO_MATRIX3);
    }
    return ZERO_MATRIX3;
  }
  function getIdentityMatrix() {
    if (!IDENTITY_MATRIX3) {
      IDENTITY_MATRIX3 = new Matrix3();
      Object.freeze(IDENTITY_MATRIX3);
    }
    return IDENTITY_MATRIX3;
  }
  var INDICES, IDENTITY_MATRIX, Matrix3, ZERO_MATRIX3, IDENTITY_MATRIX3;
  var init_matrix3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat3();
      init_vec2();
      init_vec3();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL1ROW0"] = 3] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 4] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 5] = "COL1ROW2";
        INDICES3[INDICES3["COL2ROW0"] = 6] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 7] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 8] = "COL2ROW2";
      })(INDICES || (INDICES = {}));
      IDENTITY_MATRIX = Object.freeze([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      Matrix3 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix();
        }
        static get ZERO() {
          return getZeroMatrix();
        }
        get ELEMENTS() {
          return 9;
        }
        get RANK() {
          return 3;
        }
        get INDICES() {
          return INDICES;
        }
        constructor(array, ...args) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else if (args.length > 0) {
            this.copy([array, ...args]);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          return this.check();
        }
        identity() {
          return this.copy(IDENTITY_MATRIX);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(q) {
          fromQuat(this, q);
          return this.check();
        }
        set(m00, m10, m20, m01, m11, m21, m02, m12, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        determinant() {
          return determinant(this);
        }
        transpose() {
          transpose(this, this);
          return this.check();
        }
        invert() {
          invert(this, this);
          return this.check();
        }
        multiplyLeft(a) {
          multiply(this, a, this);
          return this.check();
        }
        multiplyRight(a) {
          multiply(this, this, a);
          return this.check();
        }
        rotate(radians2) {
          rotate(this, this, radians2);
          return this.check();
        }
        scale(factor) {
          if (Array.isArray(factor)) {
            scale(this, this, factor);
          } else {
            scale(this, this, [factor, factor]);
          }
          return this.check();
        }
        translate(vec) {
          translate(this, this, vec);
          return this.check();
        }
        transform(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = transformMat3(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat32(result || [-0, -0, -0], vector, this);
              break;
            case 4:
              out = vec4_transformMat3(result || [-0, -0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformVector(vector, result) {
          return this.transform(vector, result);
        }
        transformVector2(vector, result) {
          return this.transform(vector, result);
        }
        transformVector3(vector, result) {
          return this.transform(vector, result);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat4.js
  function identity(out) {
    out[0] = 1;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = 1;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 1;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function transpose2(out, a) {
    if (out === a) {
      var a01 = a[1], a02 = a[2], a03 = a[3];
      var a12 = a[6], a13 = a[7];
      var a23 = a[11];
      out[1] = a[4];
      out[2] = a[8];
      out[3] = a[12];
      out[4] = a01;
      out[6] = a[9];
      out[7] = a[13];
      out[8] = a02;
      out[9] = a12;
      out[11] = a[14];
      out[12] = a03;
      out[13] = a13;
      out[14] = a23;
    } else {
      out[0] = a[0];
      out[1] = a[4];
      out[2] = a[8];
      out[3] = a[12];
      out[4] = a[1];
      out[5] = a[5];
      out[6] = a[9];
      out[7] = a[13];
      out[8] = a[2];
      out[9] = a[6];
      out[10] = a[10];
      out[11] = a[14];
      out[12] = a[3];
      out[13] = a[7];
      out[14] = a[11];
      out[15] = a[15];
    }
    return out;
  }
  function invert2(out, a) {
    var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3];
    var a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
    var a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
    var a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
    out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
    out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
    out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
    out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
    out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
    out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
    out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
    out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
    out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
    out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
    out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
    out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
    out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
    out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
    out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
    return out;
  }
  function determinant2(a) {
    var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3];
    var a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
    var a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
    var a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
  }
  function multiply2(out, a, b) {
    var a00 = a[0], a01 = a[1], a02 = a[2], a03 = a[3];
    var a10 = a[4], a11 = a[5], a12 = a[6], a13 = a[7];
    var a20 = a[8], a21 = a[9], a22 = a[10], a23 = a[11];
    var a30 = a[12], a31 = a[13], a32 = a[14], a33 = a[15];
    var b0 = b[0], b1 = b[1], b2 = b[2], b3 = b[3];
    out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[4];
    b1 = b[5];
    b2 = b[6];
    b3 = b[7];
    out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[8];
    b1 = b[9];
    b2 = b[10];
    b3 = b[11];
    out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[12];
    b1 = b[13];
    b2 = b[14];
    b3 = b[15];
    out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    return out;
  }
  function translate2(out, a, v) {
    var x = v[0], y = v[1], z = v[2];
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    if (a === out) {
      out[12] = a[0] * x + a[4] * y + a[8] * z + a[12];
      out[13] = a[1] * x + a[5] * y + a[9] * z + a[13];
      out[14] = a[2] * x + a[6] * y + a[10] * z + a[14];
      out[15] = a[3] * x + a[7] * y + a[11] * z + a[15];
    } else {
      a00 = a[0];
      a01 = a[1];
      a02 = a[2];
      a03 = a[3];
      a10 = a[4];
      a11 = a[5];
      a12 = a[6];
      a13 = a[7];
      a20 = a[8];
      a21 = a[9];
      a22 = a[10];
      a23 = a[11];
      out[0] = a00;
      out[1] = a01;
      out[2] = a02;
      out[3] = a03;
      out[4] = a10;
      out[5] = a11;
      out[6] = a12;
      out[7] = a13;
      out[8] = a20;
      out[9] = a21;
      out[10] = a22;
      out[11] = a23;
      out[12] = a00 * x + a10 * y + a20 * z + a[12];
      out[13] = a01 * x + a11 * y + a21 * z + a[13];
      out[14] = a02 * x + a12 * y + a22 * z + a[14];
      out[15] = a03 * x + a13 * y + a23 * z + a[15];
    }
    return out;
  }
  function scale2(out, a, v) {
    var x = v[0], y = v[1], z = v[2];
    out[0] = a[0] * x;
    out[1] = a[1] * x;
    out[2] = a[2] * x;
    out[3] = a[3] * x;
    out[4] = a[4] * y;
    out[5] = a[5] * y;
    out[6] = a[6] * y;
    out[7] = a[7] * y;
    out[8] = a[8] * z;
    out[9] = a[9] * z;
    out[10] = a[10] * z;
    out[11] = a[11] * z;
    out[12] = a[12];
    out[13] = a[13];
    out[14] = a[14];
    out[15] = a[15];
    return out;
  }
  function rotate2(out, a, rad, axis) {
    var x = axis[0], y = axis[1], z = axis[2];
    var len2 = Math.hypot(x, y, z);
    var s, c, t;
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    var b00, b01, b02;
    var b10, b11, b12;
    var b20, b21, b22;
    if (len2 < EPSILON) {
      return null;
    }
    len2 = 1 / len2;
    x *= len2;
    y *= len2;
    z *= len2;
    s = Math.sin(rad);
    c = Math.cos(rad);
    t = 1 - c;
    a00 = a[0];
    a01 = a[1];
    a02 = a[2];
    a03 = a[3];
    a10 = a[4];
    a11 = a[5];
    a12 = a[6];
    a13 = a[7];
    a20 = a[8];
    a21 = a[9];
    a22 = a[10];
    a23 = a[11];
    b00 = x * x * t + c;
    b01 = y * x * t + z * s;
    b02 = z * x * t - y * s;
    b10 = x * y * t - z * s;
    b11 = y * y * t + c;
    b12 = z * y * t + x * s;
    b20 = x * z * t + y * s;
    b21 = y * z * t - x * s;
    b22 = z * z * t + c;
    out[0] = a00 * b00 + a10 * b01 + a20 * b02;
    out[1] = a01 * b00 + a11 * b01 + a21 * b02;
    out[2] = a02 * b00 + a12 * b01 + a22 * b02;
    out[3] = a03 * b00 + a13 * b01 + a23 * b02;
    out[4] = a00 * b10 + a10 * b11 + a20 * b12;
    out[5] = a01 * b10 + a11 * b11 + a21 * b12;
    out[6] = a02 * b10 + a12 * b11 + a22 * b12;
    out[7] = a03 * b10 + a13 * b11 + a23 * b12;
    out[8] = a00 * b20 + a10 * b21 + a20 * b22;
    out[9] = a01 * b20 + a11 * b21 + a21 * b22;
    out[10] = a02 * b20 + a12 * b21 + a22 * b22;
    out[11] = a03 * b20 + a13 * b21 + a23 * b22;
    if (a !== out) {
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
    }
    return out;
  }
  function rotateX2(out, a, rad) {
    var s = Math.sin(rad);
    var c = Math.cos(rad);
    var a10 = a[4];
    var a11 = a[5];
    var a12 = a[6];
    var a13 = a[7];
    var a20 = a[8];
    var a21 = a[9];
    var a22 = a[10];
    var a23 = a[11];
    if (a !== out) {
      out[0] = a[0];
      out[1] = a[1];
      out[2] = a[2];
      out[3] = a[3];
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
    }
    out[4] = a10 * c + a20 * s;
    out[5] = a11 * c + a21 * s;
    out[6] = a12 * c + a22 * s;
    out[7] = a13 * c + a23 * s;
    out[8] = a20 * c - a10 * s;
    out[9] = a21 * c - a11 * s;
    out[10] = a22 * c - a12 * s;
    out[11] = a23 * c - a13 * s;
    return out;
  }
  function rotateY2(out, a, rad) {
    var s = Math.sin(rad);
    var c = Math.cos(rad);
    var a00 = a[0];
    var a01 = a[1];
    var a02 = a[2];
    var a03 = a[3];
    var a20 = a[8];
    var a21 = a[9];
    var a22 = a[10];
    var a23 = a[11];
    if (a !== out) {
      out[4] = a[4];
      out[5] = a[5];
      out[6] = a[6];
      out[7] = a[7];
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
    }
    out[0] = a00 * c - a20 * s;
    out[1] = a01 * c - a21 * s;
    out[2] = a02 * c - a22 * s;
    out[3] = a03 * c - a23 * s;
    out[8] = a00 * s + a20 * c;
    out[9] = a01 * s + a21 * c;
    out[10] = a02 * s + a22 * c;
    out[11] = a03 * s + a23 * c;
    return out;
  }
  function rotateZ2(out, a, rad) {
    var s = Math.sin(rad);
    var c = Math.cos(rad);
    var a00 = a[0];
    var a01 = a[1];
    var a02 = a[2];
    var a03 = a[3];
    var a10 = a[4];
    var a11 = a[5];
    var a12 = a[6];
    var a13 = a[7];
    if (a !== out) {
      out[8] = a[8];
      out[9] = a[9];
      out[10] = a[10];
      out[11] = a[11];
      out[12] = a[12];
      out[13] = a[13];
      out[14] = a[14];
      out[15] = a[15];
    }
    out[0] = a00 * c + a10 * s;
    out[1] = a01 * c + a11 * s;
    out[2] = a02 * c + a12 * s;
    out[3] = a03 * c + a13 * s;
    out[4] = a10 * c - a00 * s;
    out[5] = a11 * c - a01 * s;
    out[6] = a12 * c - a02 * s;
    out[7] = a13 * c - a03 * s;
    return out;
  }
  function getScaling(out, mat) {
    var m11 = mat[0];
    var m12 = mat[1];
    var m13 = mat[2];
    var m21 = mat[4];
    var m22 = mat[5];
    var m23 = mat[6];
    var m31 = mat[8];
    var m32 = mat[9];
    var m33 = mat[10];
    out[0] = Math.hypot(m11, m12, m13);
    out[1] = Math.hypot(m21, m22, m23);
    out[2] = Math.hypot(m31, m32, m33);
    return out;
  }
  function fromQuat2(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[1] = yx + wz;
    out[2] = zx - wy;
    out[3] = 0;
    out[4] = yx - wz;
    out[5] = 1 - xx - zz;
    out[6] = zy + wx;
    out[7] = 0;
    out[8] = zx + wy;
    out[9] = zy - wx;
    out[10] = 1 - xx - yy;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function frustum(out, left, right, bottom, top, near, far) {
    var rl = 1 / (right - left);
    var tb = 1 / (top - bottom);
    var nf = 1 / (near - far);
    out[0] = near * 2 * rl;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = near * 2 * tb;
    out[6] = 0;
    out[7] = 0;
    out[8] = (right + left) * rl;
    out[9] = (top + bottom) * tb;
    out[10] = (far + near) * nf;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[14] = far * near * 2 * nf;
    out[15] = 0;
    return out;
  }
  function perspectiveNO(out, fovy, aspect, near, far) {
    var f = 1 / Math.tan(fovy / 2), nf;
    out[0] = f / aspect;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = f;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[15] = 0;
    if (far != null && far !== Infinity) {
      nf = 1 / (near - far);
      out[10] = (far + near) * nf;
      out[14] = 2 * far * near * nf;
    } else {
      out[10] = -1;
      out[14] = -2 * near;
    }
    return out;
  }
  function orthoNO(out, left, right, bottom, top, near, far) {
    var lr = 1 / (left - right);
    var bt = 1 / (bottom - top);
    var nf = 1 / (near - far);
    out[0] = -2 * lr;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = -2 * bt;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 2 * nf;
    out[11] = 0;
    out[12] = (left + right) * lr;
    out[13] = (top + bottom) * bt;
    out[14] = (far + near) * nf;
    out[15] = 1;
    return out;
  }
  function lookAt(out, eye, center, up) {
    var x0, x1, x2, y0, y1, y2, z0, z1, z2, len2;
    var eyex = eye[0];
    var eyey = eye[1];
    var eyez = eye[2];
    var upx = up[0];
    var upy = up[1];
    var upz = up[2];
    var centerx = center[0];
    var centery = center[1];
    var centerz = center[2];
    if (Math.abs(eyex - centerx) < EPSILON && Math.abs(eyey - centery) < EPSILON && Math.abs(eyez - centerz) < EPSILON) {
      return identity(out);
    }
    z0 = eyex - centerx;
    z1 = eyey - centery;
    z2 = eyez - centerz;
    len2 = 1 / Math.hypot(z0, z1, z2);
    z0 *= len2;
    z1 *= len2;
    z2 *= len2;
    x0 = upy * z2 - upz * z1;
    x1 = upz * z0 - upx * z2;
    x2 = upx * z1 - upy * z0;
    len2 = Math.hypot(x0, x1, x2);
    if (!len2) {
      x0 = 0;
      x1 = 0;
      x2 = 0;
    } else {
      len2 = 1 / len2;
      x0 *= len2;
      x1 *= len2;
      x2 *= len2;
    }
    y0 = z1 * x2 - z2 * x1;
    y1 = z2 * x0 - z0 * x2;
    y2 = z0 * x1 - z1 * x0;
    len2 = Math.hypot(y0, y1, y2);
    if (!len2) {
      y0 = 0;
      y1 = 0;
      y2 = 0;
    } else {
      len2 = 1 / len2;
      y0 *= len2;
      y1 *= len2;
      y2 *= len2;
    }
    out[0] = x0;
    out[1] = y0;
    out[2] = z0;
    out[3] = 0;
    out[4] = x1;
    out[5] = y1;
    out[6] = z1;
    out[7] = 0;
    out[8] = x2;
    out[9] = y2;
    out[10] = z2;
    out[11] = 0;
    out[12] = -(x0 * eyex + x1 * eyey + x2 * eyez);
    out[13] = -(y0 * eyex + y1 * eyey + y2 * eyez);
    out[14] = -(z0 * eyex + z1 * eyey + z2 * eyez);
    out[15] = 1;
    return out;
  }
  var perspective, ortho;
  var init_mat4 = __esm({
    "../../node_modules/gl-matrix/esm/mat4.js"() {
      init_common2();
      perspective = perspectiveNO;
      ortho = orthoNO;
    }
  });

  // ../../node_modules/gl-matrix/esm/vec4.js
  function create4() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
    }
    return out;
  }
  function add(out, a, b) {
    out[0] = a[0] + b[0];
    out[1] = a[1] + b[1];
    out[2] = a[2] + b[2];
    out[3] = a[3] + b[3];
    return out;
  }
  function scale3(out, a, b) {
    out[0] = a[0] * b;
    out[1] = a[1] * b;
    out[2] = a[2] * b;
    out[3] = a[3] * b;
    return out;
  }
  function length2(a) {
    var x = a[0];
    var y = a[1];
    var z = a[2];
    var w = a[3];
    return Math.hypot(x, y, z, w);
  }
  function squaredLength(a) {
    var x = a[0];
    var y = a[1];
    var z = a[2];
    var w = a[3];
    return x * x + y * y + z * z + w * w;
  }
  function normalize2(out, a) {
    var x = a[0];
    var y = a[1];
    var z = a[2];
    var w = a[3];
    var len2 = x * x + y * y + z * z + w * w;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = x * len2;
    out[1] = y * len2;
    out[2] = z * len2;
    out[3] = w * len2;
    return out;
  }
  function dot2(a, b) {
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
  }
  function lerp(out, a, b, t) {
    var ax = a[0];
    var ay = a[1];
    var az = a[2];
    var aw = a[3];
    out[0] = ax + t * (b[0] - ax);
    out[1] = ay + t * (b[1] - ay);
    out[2] = az + t * (b[2] - az);
    out[3] = aw + t * (b[3] - aw);
    return out;
  }
  function transformMat43(out, a, m) {
    var x = a[0], y = a[1], z = a[2], w = a[3];
    out[0] = m[0] * x + m[4] * y + m[8] * z + m[12] * w;
    out[1] = m[1] * x + m[5] * y + m[9] * z + m[13] * w;
    out[2] = m[2] * x + m[6] * y + m[10] * z + m[14] * w;
    out[3] = m[3] * x + m[7] * y + m[11] * z + m[15] * w;
    return out;
  }
  function transformQuat2(out, a, q) {
    var x = a[0], y = a[1], z = a[2];
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var ix = qw * x + qy * z - qz * y;
    var iy = qw * y + qz * x - qx * z;
    var iz = qw * z + qx * y - qy * x;
    var iw = -qx * x - qy * y - qz * z;
    out[0] = ix * qw + iw * -qx + iy * -qz - iz * -qy;
    out[1] = iy * qw + iw * -qy + iz * -qx - ix * -qz;
    out[2] = iz * qw + iw * -qz + ix * -qy - iy * -qx;
    out[3] = a[3];
    return out;
  }
  var forEach3;
  var init_vec4 = __esm({
    "../../node_modules/gl-matrix/esm/vec4.js"() {
      init_common2();
      forEach3 = function() {
        var vec = create4();
        return function(a, stride, offset, count, fn, arg) {
          var i, l;
          if (!stride) {
            stride = 4;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l = Math.min(count * stride + offset, a.length);
          } else {
            l = a.length;
          }
          for (i = offset; i < l; i += stride) {
            vec[0] = a[i];
            vec[1] = a[i + 1];
            vec[2] = a[i + 2];
            vec[3] = a[i + 3];
            fn(vec, vec, arg);
            a[i] = vec[0];
            a[i + 1] = vec[1];
            a[i + 2] = vec[2];
            a[i + 3] = vec[3];
          }
          return a;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js
  function getZeroMatrix2() {
    if (!ZERO3) {
      ZERO3 = new Matrix4([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO3);
    }
    return ZERO3;
  }
  function getIdentityMatrix2() {
    if (!IDENTITY) {
      IDENTITY = new Matrix4();
      Object.freeze(IDENTITY);
    }
    return IDENTITY;
  }
  function checkRadians(possiblyDegrees) {
    if (possiblyDegrees > Math.PI * 2) {
      throw Error("expected radians");
    }
  }
  function computeInfinitePerspectiveOffCenter(result, left, right, bottom, top, near) {
    const column0Row0 = 2 * near / (right - left);
    const column1Row1 = 2 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -1;
    const column2Row3 = -1;
    const column3Row2 = -2 * near;
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  }
  var INDICES2, DEFAULT_FOVY, DEFAULT_ASPECT, DEFAULT_NEAR, DEFAULT_FAR, IDENTITY_MATRIX2, Matrix4, ZERO3, IDENTITY;
  var init_matrix4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat4();
      init_vec2();
      init_vec3();
      init_vec4();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL0ROW3"] = 3] = "COL0ROW3";
        INDICES3[INDICES3["COL1ROW0"] = 4] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 5] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 6] = "COL1ROW2";
        INDICES3[INDICES3["COL1ROW3"] = 7] = "COL1ROW3";
        INDICES3[INDICES3["COL2ROW0"] = 8] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 9] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 10] = "COL2ROW2";
        INDICES3[INDICES3["COL2ROW3"] = 11] = "COL2ROW3";
        INDICES3[INDICES3["COL3ROW0"] = 12] = "COL3ROW0";
        INDICES3[INDICES3["COL3ROW1"] = 13] = "COL3ROW1";
        INDICES3[INDICES3["COL3ROW2"] = 14] = "COL3ROW2";
        INDICES3[INDICES3["COL3ROW3"] = 15] = "COL3ROW3";
      })(INDICES2 || (INDICES2 = {}));
      DEFAULT_FOVY = 45 * Math.PI / 180;
      DEFAULT_ASPECT = 1;
      DEFAULT_NEAR = 0.1;
      DEFAULT_FAR = 500;
      IDENTITY_MATRIX2 = Object.freeze([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
      Matrix4 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix2();
        }
        static get ZERO() {
          return getZeroMatrix2();
        }
        get ELEMENTS() {
          return 16;
        }
        get RANK() {
          return 4;
        }
        get INDICES() {
          return INDICES2;
        }
        constructor(array) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          this[9] = array[9];
          this[10] = array[10];
          this[11] = array[11];
          this[12] = array[12];
          this[13] = array[13];
          this[14] = array[14];
          this[15] = array[15];
          return this.check();
        }
        set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        toRowMajor(result) {
          result[0] = this[0];
          result[1] = this[4];
          result[2] = this[8];
          result[3] = this[12];
          result[4] = this[1];
          result[5] = this[5];
          result[6] = this[9];
          result[7] = this[13];
          result[8] = this[2];
          result[9] = this[6];
          result[10] = this[10];
          result[11] = this[14];
          result[12] = this[3];
          result[13] = this[7];
          result[14] = this[11];
          result[15] = this[15];
          return result;
        }
        identity() {
          return this.copy(IDENTITY_MATRIX2);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(quaternion) {
          fromQuat2(this, quaternion);
          return this.check();
        }
        frustum(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          if (far === Infinity) {
            computeInfinitePerspectiveOffCenter(this, left, right, bottom, top, near);
          } else {
            frustum(this, left, right, bottom, top, near, far);
          }
          return this.check();
        }
        lookAt(view) {
          const {
            eye,
            center = [0, 0, 0],
            up = [0, 1, 0]
          } = view;
          lookAt(this, eye, center, up);
          return this.check();
        }
        ortho(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          ortho(this, left, right, bottom, top, near, far);
          return this.check();
        }
        orthographic(view) {
          const {
            fovy = DEFAULT_FOVY,
            aspect = DEFAULT_ASPECT,
            focalDistance = 1,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          checkRadians(fovy);
          const halfY = fovy / 2;
          const top = focalDistance * Math.tan(halfY);
          const right = top * aspect;
          return this.ortho({
            left: -right,
            right,
            bottom: -top,
            top,
            near,
            far
          });
        }
        perspective(view) {
          const {
            fovy = 45 * Math.PI / 180,
            aspect = 1,
            near = 0.1,
            far = 500
          } = view;
          checkRadians(fovy);
          perspective(this, fovy, aspect, near, far);
          return this.check();
        }
        determinant() {
          return determinant2(this);
        }
        getScale(result = [-0, -0, -0]) {
          result[0] = Math.sqrt(this[0] * this[0] + this[1] * this[1] + this[2] * this[2]);
          result[1] = Math.sqrt(this[4] * this[4] + this[5] * this[5] + this[6] * this[6]);
          result[2] = Math.sqrt(this[8] * this[8] + this[9] * this[9] + this[10] * this[10]);
          return result;
        }
        getTranslation(result = [-0, -0, -0]) {
          result[0] = this[12];
          result[1] = this[13];
          result[2] = this[14];
          return result;
        }
        getRotation(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = 0;
          result[4] = this[4] * inverseScale0;
          result[5] = this[5] * inverseScale1;
          result[6] = this[6] * inverseScale2;
          result[7] = 0;
          result[8] = this[8] * inverseScale0;
          result[9] = this[9] * inverseScale1;
          result[10] = this[10] * inverseScale2;
          result[11] = 0;
          result[12] = 0;
          result[13] = 0;
          result[14] = 0;
          result[15] = 1;
          return result;
        }
        getRotationMatrix3(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = this[4] * inverseScale0;
          result[4] = this[5] * inverseScale1;
          result[5] = this[6] * inverseScale2;
          result[6] = this[8] * inverseScale0;
          result[7] = this[9] * inverseScale1;
          result[8] = this[10] * inverseScale2;
          return result;
        }
        transpose() {
          transpose2(this, this);
          return this.check();
        }
        invert() {
          invert2(this, this);
          return this.check();
        }
        multiplyLeft(a) {
          multiply2(this, a, this);
          return this.check();
        }
        multiplyRight(a) {
          multiply2(this, this, a);
          return this.check();
        }
        rotateX(radians2) {
          rotateX2(this, this, radians2);
          return this.check();
        }
        rotateY(radians2) {
          rotateY2(this, this, radians2);
          return this.check();
        }
        rotateZ(radians2) {
          rotateZ2(this, this, radians2);
          return this.check();
        }
        rotateXYZ(angleXYZ) {
          return this.rotateX(angleXYZ[0]).rotateY(angleXYZ[1]).rotateZ(angleXYZ[2]);
        }
        rotateAxis(radians2, axis) {
          rotate2(this, this, radians2, axis);
          return this.check();
        }
        scale(factor) {
          scale2(this, this, Array.isArray(factor) ? factor : [factor, factor, factor]);
          return this.check();
        }
        translate(vector) {
          translate2(this, this, vector);
          return this.check();
        }
        transform(vector, result) {
          if (vector.length === 4) {
            result = transformMat43(result || [-0, -0, -0, -0], vector, this);
            checkVector(result, 4);
            return result;
          }
          return this.transformAsPoint(vector, result);
        }
        transformAsPoint(vector, result) {
          const {
            length: length4
          } = vector;
          let out;
          switch (length4) {
            case 2:
              out = transformMat4(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat42(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformAsVector(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = vec2_transformMat4AsVector(result || [-0, -0], vector, this);
              break;
            case 3:
              out = vec3_transformMat4AsVector(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformPoint(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformVector(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformDirection(vector, result) {
          return this.transformAsVector(vector, result);
        }
        makeRotationX(radians2) {
          return this.identity().rotateX(radians2);
        }
        makeTranslation(x, y, z) {
          return this.identity().translate([x, y, z]);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/quat.js
  function create5() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    out[3] = 1;
    return out;
  }
  function identity2(out) {
    out[0] = 0;
    out[1] = 0;
    out[2] = 0;
    out[3] = 1;
    return out;
  }
  function setAxisAngle(out, axis, rad) {
    rad = rad * 0.5;
    var s = Math.sin(rad);
    out[0] = s * axis[0];
    out[1] = s * axis[1];
    out[2] = s * axis[2];
    out[3] = Math.cos(rad);
    return out;
  }
  function multiply3(out, a, b) {
    var ax = a[0], ay = a[1], az = a[2], aw = a[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    out[0] = ax * bw + aw * bx + ay * bz - az * by;
    out[1] = ay * bw + aw * by + az * bx - ax * bz;
    out[2] = az * bw + aw * bz + ax * by - ay * bx;
    out[3] = aw * bw - ax * bx - ay * by - az * bz;
    return out;
  }
  function rotateX3(out, a, rad) {
    rad *= 0.5;
    var ax = a[0], ay = a[1], az = a[2], aw = a[3];
    var bx = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + aw * bx;
    out[1] = ay * bw + az * bx;
    out[2] = az * bw - ay * bx;
    out[3] = aw * bw - ax * bx;
    return out;
  }
  function rotateY3(out, a, rad) {
    rad *= 0.5;
    var ax = a[0], ay = a[1], az = a[2], aw = a[3];
    var by = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw - az * by;
    out[1] = ay * bw + aw * by;
    out[2] = az * bw + ax * by;
    out[3] = aw * bw - ay * by;
    return out;
  }
  function rotateZ3(out, a, rad) {
    rad *= 0.5;
    var ax = a[0], ay = a[1], az = a[2], aw = a[3];
    var bz = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + ay * bz;
    out[1] = ay * bw - ax * bz;
    out[2] = az * bw + aw * bz;
    out[3] = aw * bw - az * bz;
    return out;
  }
  function calculateW(out, a) {
    var x = a[0], y = a[1], z = a[2];
    out[0] = x;
    out[1] = y;
    out[2] = z;
    out[3] = Math.sqrt(Math.abs(1 - x * x - y * y - z * z));
    return out;
  }
  function slerp(out, a, b, t) {
    var ax = a[0], ay = a[1], az = a[2], aw = a[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    var omega, cosom, sinom, scale0, scale1;
    cosom = ax * bx + ay * by + az * bz + aw * bw;
    if (cosom < 0) {
      cosom = -cosom;
      bx = -bx;
      by = -by;
      bz = -bz;
      bw = -bw;
    }
    if (1 - cosom > EPSILON) {
      omega = Math.acos(cosom);
      sinom = Math.sin(omega);
      scale0 = Math.sin((1 - t) * omega) / sinom;
      scale1 = Math.sin(t * omega) / sinom;
    } else {
      scale0 = 1 - t;
      scale1 = t;
    }
    out[0] = scale0 * ax + scale1 * bx;
    out[1] = scale0 * ay + scale1 * by;
    out[2] = scale0 * az + scale1 * bz;
    out[3] = scale0 * aw + scale1 * bw;
    return out;
  }
  function invert3(out, a) {
    var a0 = a[0], a1 = a[1], a2 = a[2], a3 = a[3];
    var dot4 = a0 * a0 + a1 * a1 + a2 * a2 + a3 * a3;
    var invDot = dot4 ? 1 / dot4 : 0;
    out[0] = -a0 * invDot;
    out[1] = -a1 * invDot;
    out[2] = -a2 * invDot;
    out[3] = a3 * invDot;
    return out;
  }
  function conjugate(out, a) {
    out[0] = -a[0];
    out[1] = -a[1];
    out[2] = -a[2];
    out[3] = a[3];
    return out;
  }
  function fromMat3(out, m) {
    var fTrace = m[0] + m[4] + m[8];
    var fRoot;
    if (fTrace > 0) {
      fRoot = Math.sqrt(fTrace + 1);
      out[3] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[0] = (m[5] - m[7]) * fRoot;
      out[1] = (m[6] - m[2]) * fRoot;
      out[2] = (m[1] - m[3]) * fRoot;
    } else {
      var i = 0;
      if (m[4] > m[0])
        i = 1;
      if (m[8] > m[i * 3 + i])
        i = 2;
      var j = (i + 1) % 3;
      var k = (i + 2) % 3;
      fRoot = Math.sqrt(m[i * 3 + i] - m[j * 3 + j] - m[k * 3 + k] + 1);
      out[i] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[3] = (m[j * 3 + k] - m[k * 3 + j]) * fRoot;
      out[j] = (m[j * 3 + i] + m[i * 3 + j]) * fRoot;
      out[k] = (m[k * 3 + i] + m[i * 3 + k]) * fRoot;
    }
    return out;
  }
  var add2, scale4, dot3, lerp2, length3, squaredLength2, normalize3, rotationTo, sqlerp, setAxes;
  var init_quat = __esm({
    "../../node_modules/gl-matrix/esm/quat.js"() {
      init_common2();
      init_mat3();
      init_vec3();
      init_vec4();
      add2 = add;
      scale4 = scale3;
      dot3 = dot2;
      lerp2 = lerp;
      length3 = length2;
      squaredLength2 = squaredLength;
      normalize3 = normalize2;
      rotationTo = function() {
        var tmpvec3 = create2();
        var xUnitVec3 = fromValues(1, 0, 0);
        var yUnitVec3 = fromValues(0, 1, 0);
        return function(out, a, b) {
          var dot4 = dot(a, b);
          if (dot4 < -0.999999) {
            cross(tmpvec3, xUnitVec3, a);
            if (len(tmpvec3) < 1e-6)
              cross(tmpvec3, yUnitVec3, a);
            normalize(tmpvec3, tmpvec3);
            setAxisAngle(out, tmpvec3, Math.PI);
            return out;
          } else if (dot4 > 0.999999) {
            out[0] = 0;
            out[1] = 0;
            out[2] = 0;
            out[3] = 1;
            return out;
          } else {
            cross(tmpvec3, a, b);
            out[0] = tmpvec3[0];
            out[1] = tmpvec3[1];
            out[2] = tmpvec3[2];
            out[3] = 1 + dot4;
            return normalize3(out, out);
          }
        };
      }();
      sqlerp = function() {
        var temp1 = create5();
        var temp2 = create5();
        return function(out, a, b, c, d, t) {
          slerp(temp1, a, d, t);
          slerp(temp2, b, c, t);
          slerp(out, temp1, temp2, 2 * t * (1 - t));
          return out;
        };
      }();
      setAxes = function() {
        var matr = create3();
        return function(out, view, right, up) {
          matr[0] = right[0];
          matr[3] = right[1];
          matr[6] = right[2];
          matr[1] = up[0];
          matr[4] = up[1];
          matr[7] = up[2];
          matr[2] = -view[0];
          matr[5] = -view[1];
          matr[8] = -view[2];
          return normalize3(out, fromMat3(out, matr));
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js
  var IDENTITY_QUATERNION, Quaternion;
  var init_quaternion = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js"() {
      init_math_array();
      init_validators();
      init_vector4();
      init_quat();
      init_vec4();
      IDENTITY_QUATERNION = [0, 0, 0, 1];
      Quaternion = class extends MathArray {
        constructor(x = 0, y = 0, z = 0, w = 1) {
          super(-0, -0, -0, -0);
          if (Array.isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            this.set(x, y, z, w);
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        fromObject(object) {
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this.check();
        }
        fromMatrix3(m) {
          fromMat3(this, m);
          return this.check();
        }
        fromAxisRotation(axis, rad) {
          setAxisAngle(this, axis, rad);
          return this.check();
        }
        identity() {
          identity2(this);
          return this.check();
        }
        setAxisAngle(axis, rad) {
          return this.fromAxisRotation(axis, rad);
        }
        get ELEMENTS() {
          return 4;
        }
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        len() {
          return length3(this);
        }
        lengthSquared() {
          return squaredLength2(this);
        }
        dot(a) {
          return dot3(this, a);
        }
        rotationTo(vectorA, vectorB) {
          rotationTo(this, vectorA, vectorB);
          return this.check();
        }
        add(a) {
          add2(this, this, a);
          return this.check();
        }
        calculateW() {
          calculateW(this, this);
          return this.check();
        }
        conjugate() {
          conjugate(this, this);
          return this.check();
        }
        invert() {
          invert3(this, this);
          return this.check();
        }
        lerp(a, b, t) {
          if (t === void 0) {
            return this.lerp(this, a, b);
          }
          lerp2(this, a, b, t);
          return this.check();
        }
        multiplyRight(a) {
          multiply3(this, this, a);
          return this.check();
        }
        multiplyLeft(a) {
          multiply3(this, a, this);
          return this.check();
        }
        normalize() {
          const length4 = this.len();
          const l = length4 > 0 ? 1 / length4 : 0;
          this[0] = this[0] * l;
          this[1] = this[1] * l;
          this[2] = this[2] * l;
          this[3] = this[3] * l;
          if (length4 === 0) {
            this[3] = 1;
          }
          return this.check();
        }
        rotateX(rad) {
          rotateX3(this, this, rad);
          return this.check();
        }
        rotateY(rad) {
          rotateY3(this, this, rad);
          return this.check();
        }
        rotateZ(rad) {
          rotateZ3(this, this, rad);
          return this.check();
        }
        scale(b) {
          scale4(this, this, b);
          return this.check();
        }
        slerp(arg0, arg1, arg2) {
          let start;
          let target;
          let ratio;
          switch (arguments.length) {
            case 1:
              ({
                start = IDENTITY_QUATERNION,
                target,
                ratio
              } = arg0);
              break;
            case 2:
              start = this;
              target = arg0;
              ratio = arg1;
              break;
            default:
              start = arg0;
              target = arg1;
              ratio = arg2;
          }
          slerp(this, start, target, ratio);
          return this.check();
        }
        transformVector4(vector, result = new Vector4()) {
          transformQuat2(result, vector, this);
          return checkVector(result, 4);
        }
        lengthSq() {
          return this.lengthSquared();
        }
        setFromAxisAngle(axis, rad) {
          return this.setAxisAngle(axis, rad);
        }
        premultiply(a) {
          return this.multiplyLeft(a);
        }
        multiply(a) {
          return this.multiplyRight(a);
        }
      };
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/typeof.js
  function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && typeof Symbol == "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof(obj);
  }
  var init_typeof = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/typeof.js"() {
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js
  function _toPrimitive(input, hint) {
    if (_typeof(input) !== "object" || input === null)
      return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== void 0) {
      var res = prim.call(input, hint || "default");
      if (_typeof(res) !== "object")
        return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  var init_toPrimitive = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js"() {
      init_typeof();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return _typeof(key) === "symbol" ? key : String(key);
  }
  var init_toPropertyKey = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js"() {
      init_typeof();
      init_toPrimitive();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/defineProperty.js
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var init_defineProperty = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/defineProperty.js"() {
      init_toPropertyKey();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js
  var math_utils_default;
  var init_math_utils = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js"() {
      math_utils_default = {
        EPSILON1: 0.1,
        EPSILON2: 0.01,
        EPSILON3: 1e-3,
        EPSILON4: 1e-4,
        EPSILON5: 1e-5,
        EPSILON6: 1e-6,
        EPSILON7: 1e-7,
        EPSILON8: 1e-8,
        EPSILON9: 1e-9,
        EPSILON10: 1e-10,
        EPSILON11: 1e-11,
        EPSILON12: 1e-12,
        EPSILON13: 1e-13,
        EPSILON14: 1e-14,
        EPSILON15: 1e-15,
        EPSILON16: 1e-16,
        EPSILON17: 1e-17,
        EPSILON18: 1e-18,
        EPSILON19: 1e-19,
        EPSILON20: 1e-20,
        PI_OVER_TWO: Math.PI / 2,
        PI_OVER_FOUR: Math.PI / 4,
        PI_OVER_SIX: Math.PI / 6,
        TWO_PI: Math.PI * 2
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/index.js
  var init_esm = __esm({
    "../../node_modules/@math.gl/core/dist/esm/index.js"() {
      init_vector3();
      init_matrix3();
      init_matrix4();
      init_quaternion();
      init_math_utils();
      init_assert();
      init_common();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/constants.js
  var WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z, WGS84_CONSTANTS;
  var init_constants = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/constants.js"() {
      WGS84_RADIUS_X = 6378137;
      WGS84_RADIUS_Y = 6378137;
      WGS84_RADIUS_Z = 6356752314245179e-9;
      WGS84_CONSTANTS = {
        radii: [WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z],
        radiiSquared: [WGS84_RADIUS_X * WGS84_RADIUS_X, WGS84_RADIUS_Y * WGS84_RADIUS_Y, WGS84_RADIUS_Z * WGS84_RADIUS_Z],
        oneOverRadii: [1 / WGS84_RADIUS_X, 1 / WGS84_RADIUS_Y, 1 / WGS84_RADIUS_Z],
        oneOverRadiiSquared: [1 / (WGS84_RADIUS_X * WGS84_RADIUS_X), 1 / (WGS84_RADIUS_Y * WGS84_RADIUS_Y), 1 / (WGS84_RADIUS_Z * WGS84_RADIUS_Z)],
        maximumRadius: Math.max(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z),
        centerToleranceSquared: 0.1
      };
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js
  function identity3(x) {
    return x;
  }
  function fromCartographic(cartographic, result = [], map2 = identity3) {
    if ("longitude" in cartographic) {
      result[0] = map2(cartographic.longitude);
      result[1] = map2(cartographic.latitude);
      result[2] = cartographic.height;
    } else if ("x" in cartographic) {
      result[0] = map2(cartographic.x);
      result[1] = map2(cartographic.y);
      result[2] = cartographic.z;
    } else {
      result[0] = map2(cartographic[0]);
      result[1] = map2(cartographic[1]);
      result[2] = cartographic[2];
    }
    return result;
  }
  function fromCartographicToRadians(cartographic, vector = []) {
    return fromCartographic(cartographic, vector, config._cartographicRadians ? identity3 : toRadians);
  }
  function toCartographic(vector, cartographic, map2 = identity3) {
    if ("longitude" in cartographic) {
      cartographic.longitude = map2(vector[0]);
      cartographic.latitude = map2(vector[1]);
      cartographic.height = vector[2];
    } else if ("x" in cartographic) {
      cartographic.x = map2(vector[0]);
      cartographic.y = map2(vector[1]);
      cartographic.z = vector[2];
    } else {
      cartographic[0] = map2(vector[0]);
      cartographic[1] = map2(vector[1]);
      cartographic[2] = vector[2];
    }
    return cartographic;
  }
  function toCartographicFromRadians(vector, cartographic) {
    return toCartographic(vector, cartographic, config._cartographicRadians ? identity3 : toDegrees);
  }
  var scratchVector;
  var init_type_utils = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js"() {
      init_esm();
      init_constants();
      scratchVector = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js
  function scaleToGeodeticSurface(cartesian, ellipsoid, result = []) {
    const {
      oneOverRadii,
      oneOverRadiiSquared,
      centerToleranceSquared
    } = ellipsoid;
    scratchVector2.from(cartesian);
    const positionX = scratchVector2.x;
    const positionY = scratchVector2.y;
    const positionZ = scratchVector2.z;
    const oneOverRadiiX = oneOverRadii.x;
    const oneOverRadiiY = oneOverRadii.y;
    const oneOverRadiiZ = oneOverRadii.z;
    const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
    const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
    const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
    const squaredNorm = x2 + y2 + z2;
    const ratio = Math.sqrt(1 / squaredNorm);
    if (!Number.isFinite(ratio)) {
      return void 0;
    }
    const intersection = scaleToGeodeticSurfaceIntersection;
    intersection.copy(cartesian).scale(ratio);
    if (squaredNorm < centerToleranceSquared) {
      return intersection.to(result);
    }
    const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
    const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
    const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
    const gradient = scaleToGeodeticSurfaceGradient;
    gradient.set(intersection.x * oneOverRadiiSquaredX * 2, intersection.y * oneOverRadiiSquaredY * 2, intersection.z * oneOverRadiiSquaredZ * 2);
    let lambda = (1 - ratio) * scratchVector2.len() / (0.5 * gradient.len());
    let correction = 0;
    let xMultiplier;
    let yMultiplier;
    let zMultiplier;
    let func;
    do {
      lambda -= correction;
      xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
      yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
      zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
      const xMultiplier2 = xMultiplier * xMultiplier;
      const yMultiplier2 = yMultiplier * yMultiplier;
      const zMultiplier2 = zMultiplier * zMultiplier;
      const xMultiplier3 = xMultiplier2 * xMultiplier;
      const yMultiplier3 = yMultiplier2 * yMultiplier;
      const zMultiplier3 = zMultiplier2 * zMultiplier;
      func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
      const denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
      const derivative = -2 * denominator;
      correction = func / derivative;
    } while (Math.abs(func) > math_utils_default.EPSILON12);
    return scratchVector2.scale([xMultiplier, yMultiplier, zMultiplier]).to(result);
  }
  var scratchVector2, scaleToGeodeticSurfaceIntersection, scaleToGeodeticSurfaceGradient;
  var init_scale_to_geodetic_surface = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js"() {
      init_esm();
      scratchVector2 = new Vector3();
      scaleToGeodeticSurfaceIntersection = new Vector3();
      scaleToGeodeticSurfaceGradient = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js
  function localFrameToFixedFrame(ellipsoid, firstAxis, secondAxis, thirdAxis, cartesianOrigin, result) {
    const thirdAxisInferred = VECTOR_PRODUCT_LOCAL_FRAME[firstAxis] && VECTOR_PRODUCT_LOCAL_FRAME[firstAxis][secondAxis];
    assert(thirdAxisInferred && (!thirdAxis || thirdAxis === thirdAxisInferred));
    let firstAxisVector;
    let secondAxisVector;
    let thirdAxisVector;
    const origin = scratchOrigin.copy(cartesianOrigin);
    const atPole = equals(origin.x, 0, EPSILON14) && equals(origin.y, 0, EPSILON14);
    if (atPole) {
      const sign = Math.sign(origin.z);
      firstAxisVector = scratchVector1.fromArray(degeneratePositionLocalFrame[firstAxis]);
      if (firstAxis !== "east" && firstAxis !== "west") {
        firstAxisVector.scale(sign);
      }
      secondAxisVector = scratchVector22.fromArray(degeneratePositionLocalFrame[secondAxis]);
      if (secondAxis !== "east" && secondAxis !== "west") {
        secondAxisVector.scale(sign);
      }
      thirdAxisVector = scratchVector3.fromArray(degeneratePositionLocalFrame[thirdAxis]);
      if (thirdAxis !== "east" && thirdAxis !== "west") {
        thirdAxisVector.scale(sign);
      }
    } else {
      const {
        up,
        east,
        north
      } = scratchAxisVectors;
      east.set(-origin.y, origin.x, 0).normalize();
      ellipsoid.geodeticSurfaceNormal(origin, up);
      north.copy(up).cross(east);
      const {
        down,
        west,
        south
      } = scratchAxisVectors;
      down.copy(up).scale(-1);
      west.copy(east).scale(-1);
      south.copy(north).scale(-1);
      firstAxisVector = scratchAxisVectors[firstAxis];
      secondAxisVector = scratchAxisVectors[secondAxis];
      thirdAxisVector = scratchAxisVectors[thirdAxis];
    }
    result[0] = firstAxisVector.x;
    result[1] = firstAxisVector.y;
    result[2] = firstAxisVector.z;
    result[3] = 0;
    result[4] = secondAxisVector.x;
    result[5] = secondAxisVector.y;
    result[6] = secondAxisVector.z;
    result[7] = 0;
    result[8] = thirdAxisVector.x;
    result[9] = thirdAxisVector.y;
    result[10] = thirdAxisVector.z;
    result[11] = 0;
    result[12] = origin.x;
    result[13] = origin.y;
    result[14] = origin.z;
    result[15] = 1;
    return result;
  }
  var EPSILON14, scratchOrigin, VECTOR_PRODUCT_LOCAL_FRAME, degeneratePositionLocalFrame, scratchAxisVectors, scratchVector1, scratchVector22, scratchVector3;
  var init_ellipsoid_transform = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js"() {
      init_esm();
      EPSILON14 = 1e-14;
      scratchOrigin = new Vector3();
      VECTOR_PRODUCT_LOCAL_FRAME = {
        up: {
          south: "east",
          north: "west",
          west: "south",
          east: "north"
        },
        down: {
          south: "west",
          north: "east",
          west: "north",
          east: "south"
        },
        south: {
          up: "west",
          down: "east",
          west: "down",
          east: "up"
        },
        north: {
          up: "east",
          down: "west",
          west: "up",
          east: "down"
        },
        west: {
          up: "north",
          down: "south",
          north: "down",
          south: "up"
        },
        east: {
          up: "south",
          down: "north",
          north: "up",
          south: "down"
        }
      };
      degeneratePositionLocalFrame = {
        north: [-1, 0, 0],
        east: [0, 1, 0],
        up: [0, 0, 1],
        south: [1, 0, 0],
        west: [0, -1, 0],
        down: [0, 0, -1]
      };
      scratchAxisVectors = {
        east: new Vector3(),
        north: new Vector3(),
        up: new Vector3(),
        west: new Vector3(),
        south: new Vector3(),
        down: new Vector3()
      };
      scratchVector1 = new Vector3();
      scratchVector22 = new Vector3();
      scratchVector3 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js
  var scratchVector4, scratchNormal, scratchK, scratchPosition, scratchHeight, scratchCartesian, Ellipsoid;
  var init_ellipsoid = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js"() {
      init_defineProperty();
      init_esm();
      init_vec3();
      init_constants();
      init_type_utils();
      init_scale_to_geodetic_surface();
      init_ellipsoid_transform();
      scratchVector4 = new Vector3();
      scratchNormal = new Vector3();
      scratchK = new Vector3();
      scratchPosition = new Vector3();
      scratchHeight = new Vector3();
      scratchCartesian = new Vector3();
      Ellipsoid = class {
        constructor(x = 0, y = 0, z = 0) {
          _defineProperty(this, "radii", void 0);
          _defineProperty(this, "radiiSquared", void 0);
          _defineProperty(this, "radiiToTheFourth", void 0);
          _defineProperty(this, "oneOverRadii", void 0);
          _defineProperty(this, "oneOverRadiiSquared", void 0);
          _defineProperty(this, "minimumRadius", void 0);
          _defineProperty(this, "maximumRadius", void 0);
          _defineProperty(this, "centerToleranceSquared", math_utils_default.EPSILON1);
          _defineProperty(this, "squaredXOverSquaredZ", void 0);
          assert(x >= 0);
          assert(y >= 0);
          assert(z >= 0);
          this.radii = new Vector3(x, y, z);
          this.radiiSquared = new Vector3(x * x, y * y, z * z);
          this.radiiToTheFourth = new Vector3(x * x * x * x, y * y * y * y, z * z * z * z);
          this.oneOverRadii = new Vector3(x === 0 ? 0 : 1 / x, y === 0 ? 0 : 1 / y, z === 0 ? 0 : 1 / z);
          this.oneOverRadiiSquared = new Vector3(x === 0 ? 0 : 1 / (x * x), y === 0 ? 0 : 1 / (y * y), z === 0 ? 0 : 1 / (z * z));
          this.minimumRadius = Math.min(x, y, z);
          this.maximumRadius = Math.max(x, y, z);
          if (this.radiiSquared.z !== 0) {
            this.squaredXOverSquaredZ = this.radiiSquared.x / this.radiiSquared.z;
          }
          Object.freeze(this);
        }
        equals(right) {
          return this === right || Boolean(right && this.radii.equals(right.radii));
        }
        toString() {
          return this.radii.toString();
        }
        cartographicToCartesian(cartographic, result = [0, 0, 0]) {
          const normal = scratchNormal;
          const k = scratchK;
          const [, , height] = cartographic;
          this.geodeticSurfaceNormalCartographic(cartographic, normal);
          k.copy(this.radiiSquared).scale(normal);
          const gamma = Math.sqrt(normal.dot(k));
          k.scale(1 / gamma);
          normal.scale(height);
          k.add(normal);
          return k.to(result);
        }
        cartesianToCartographic(cartesian, result = [0, 0, 0]) {
          scratchCartesian.from(cartesian);
          const point = this.scaleToGeodeticSurface(scratchCartesian, scratchPosition);
          if (!point) {
            return void 0;
          }
          const normal = this.geodeticSurfaceNormal(point, scratchNormal);
          const h = scratchHeight;
          h.copy(scratchCartesian).subtract(point);
          const longitude = Math.atan2(normal.y, normal.x);
          const latitude = Math.asin(normal.z);
          const height = Math.sign(dot(h, scratchCartesian)) * length(h);
          return toCartographicFromRadians([longitude, latitude, height], result);
        }
        eastNorthUpToFixedFrame(origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, "east", "north", "up", origin, result);
        }
        localFrameToFixedFrame(firstAxis, secondAxis, thirdAxis, origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, firstAxis, secondAxis, thirdAxis, origin, result);
        }
        geocentricSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).normalize().to(result);
        }
        geodeticSurfaceNormalCartographic(cartographic, result = [0, 0, 0]) {
          const cartographicVectorRadians = fromCartographicToRadians(cartographic);
          const longitude = cartographicVectorRadians[0];
          const latitude = cartographicVectorRadians[1];
          const cosLatitude = Math.cos(latitude);
          scratchVector4.set(cosLatitude * Math.cos(longitude), cosLatitude * Math.sin(longitude), Math.sin(latitude)).normalize();
          return scratchVector4.to(result);
        }
        geodeticSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).scale(this.oneOverRadiiSquared).normalize().to(result);
        }
        scaleToGeodeticSurface(cartesian, result) {
          return scaleToGeodeticSurface(cartesian, this, result);
        }
        scaleToGeocentricSurface(cartesian, result = [0, 0, 0]) {
          scratchPosition.from(cartesian);
          const positionX = scratchPosition.x;
          const positionY = scratchPosition.y;
          const positionZ = scratchPosition.z;
          const oneOverRadiiSquared = this.oneOverRadiiSquared;
          const beta = 1 / Math.sqrt(positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z);
          return scratchPosition.multiplyScalar(beta).to(result);
        }
        transformPositionToScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.oneOverRadii).to(result);
        }
        transformPositionFromScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.radii).to(result);
        }
        getSurfaceNormalIntersectionWithZAxis(position, buffer = 0, result = [0, 0, 0]) {
          assert(equals(this.radii.x, this.radii.y, math_utils_default.EPSILON15));
          assert(this.radii.z > 0);
          scratchPosition.from(position);
          const z = scratchPosition.z * (1 - this.squaredXOverSquaredZ);
          if (Math.abs(z) >= this.radii.z - buffer) {
            return void 0;
          }
          return scratchPosition.set(0, 0, z).to(result);
        }
      };
      _defineProperty(Ellipsoid, "WGS84", new Ellipsoid(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z));
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/index.js
  var init_esm2 = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/index.js"() {
      init_ellipsoid();
      init_type_utils();
    }
  });

  // ../../node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js
  function getHiResTimestamp() {
    let timestamp;
    if (typeof window !== "undefined" && window.performance) {
      timestamp = window.performance.now();
    } else if (typeof process !== "undefined" && process.hrtime) {
      const timeParts = process.hrtime();
      timestamp = timeParts[0] * 1e3 + timeParts[1] / 1e6;
    } else {
      timestamp = Date.now();
    }
    return timestamp;
  }
  var init_hi_res_timestamp = __esm({
    "../../node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js"() {
    }
  });

  // ../../node_modules/@probe.gl/stats/dist/esm/lib/stat.js
  var Stat;
  var init_stat = __esm({
    "../../node_modules/@probe.gl/stats/dist/esm/lib/stat.js"() {
      init_defineProperty();
      init_hi_res_timestamp();
      Stat = class {
        constructor(name, type) {
          _defineProperty(this, "name", void 0);
          _defineProperty(this, "type", void 0);
          _defineProperty(this, "sampleSize", 1);
          _defineProperty(this, "time", void 0);
          _defineProperty(this, "count", void 0);
          _defineProperty(this, "samples", void 0);
          _defineProperty(this, "lastTiming", void 0);
          _defineProperty(this, "lastSampleTime", void 0);
          _defineProperty(this, "lastSampleCount", void 0);
          _defineProperty(this, "_count", 0);
          _defineProperty(this, "_time", 0);
          _defineProperty(this, "_samples", 0);
          _defineProperty(this, "_startTime", 0);
          _defineProperty(this, "_timerPending", false);
          this.name = name;
          this.type = type;
          this.reset();
        }
        setSampleSize(samples) {
          this.sampleSize = samples;
          return this;
        }
        incrementCount() {
          this.addCount(1);
          return this;
        }
        decrementCount() {
          this.subtractCount(1);
          return this;
        }
        addCount(value) {
          this._count += value;
          this._samples++;
          this._checkSampling();
          return this;
        }
        subtractCount(value) {
          this._count -= value;
          this._samples++;
          this._checkSampling();
          return this;
        }
        addTime(time) {
          this._time += time;
          this.lastTiming = time;
          this._samples++;
          this._checkSampling();
          return this;
        }
        timeStart() {
          this._startTime = getHiResTimestamp();
          this._timerPending = true;
          return this;
        }
        timeEnd() {
          if (!this._timerPending) {
            return this;
          }
          this.addTime(getHiResTimestamp() - this._startTime);
          this._timerPending = false;
          this._checkSampling();
          return this;
        }
        getSampleAverageCount() {
          return this.sampleSize > 0 ? this.lastSampleCount / this.sampleSize : 0;
        }
        getSampleAverageTime() {
          return this.sampleSize > 0 ? this.lastSampleTime / this.sampleSize : 0;
        }
        getSampleHz() {
          return this.lastSampleTime > 0 ? this.sampleSize / (this.lastSampleTime / 1e3) : 0;
        }
        getAverageCount() {
          return this.samples > 0 ? this.count / this.samples : 0;
        }
        getAverageTime() {
          return this.samples > 0 ? this.time / this.samples : 0;
        }
        getHz() {
          return this.time > 0 ? this.samples / (this.time / 1e3) : 0;
        }
        reset() {
          this.time = 0;
          this.count = 0;
          this.samples = 0;
          this.lastTiming = 0;
          this.lastSampleTime = 0;
          this.lastSampleCount = 0;
          this._count = 0;
          this._time = 0;
          this._samples = 0;
          this._startTime = 0;
          this._timerPending = false;
          return this;
        }
        _checkSampling() {
          if (this._samples === this.sampleSize) {
            this.lastSampleTime = this._time;
            this.lastSampleCount = this._count;
            this.count += this._count;
            this.time += this._time;
            this.samples += this._samples;
            this._time = 0;
            this._count = 0;
            this._samples = 0;
          }
        }
      };
    }
  });

  // ../../node_modules/@probe.gl/stats/dist/esm/lib/stats.js
  var Stats;
  var init_stats = __esm({
    "../../node_modules/@probe.gl/stats/dist/esm/lib/stats.js"() {
      init_defineProperty();
      init_stat();
      Stats = class {
        constructor(options) {
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "stats", {});
          this.id = options.id;
          this.stats = {};
          this._initializeStats(options.stats);
          Object.seal(this);
        }
        get(name) {
          let type = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "count";
          return this._getOrCreate({
            name,
            type
          });
        }
        get size() {
          return Object.keys(this.stats).length;
        }
        reset() {
          for (const key in this.stats) {
            this.stats[key].reset();
          }
          return this;
        }
        forEach(fn) {
          for (const key in this.stats) {
            fn(this.stats[key]);
          }
        }
        getTable() {
          const table = {};
          this.forEach((stat) => {
            table[stat.name] = {
              time: stat.time || 0,
              count: stat.count || 0,
              average: stat.getAverageTime() || 0,
              hz: stat.getHz() || 0
            };
          });
          return table;
        }
        _initializeStats() {
          let stats = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
          stats.forEach((stat) => this._getOrCreate(stat));
        }
        _getOrCreate(stat) {
          if (!stat || !stat.name) {
            return null;
          }
          const {
            name,
            type
          } = stat;
          if (!this.stats[name]) {
            if (stat instanceof Stat) {
              this.stats[name] = stat;
            } else {
              this.stats[name] = new Stat(name, type);
            }
          }
          return this.stats[name];
        }
      };
    }
  });

  // ../../node_modules/@probe.gl/stats/dist/esm/index.js
  var init_esm3 = __esm({
    "../../node_modules/@probe.gl/stats/dist/esm/index.js"() {
      init_stats();
      init_stat();
      init_hi_res_timestamp();
    }
  });

  // ../loader-utils/src/lib/env-utils/assert.ts
  function assert2(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert2 = __esm({
    "../loader-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../loader-utils/src/lib/env-utils/globals.ts
  var globals, self_, window_, global_, document_, isBrowser, matches, nodeVersion;
  var init_globals = __esm({
    "../loader-utils/src/lib/env-utils/globals.ts"() {
      globals = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_ = globals.self || globals.window || globals.global || {};
      window_ = globals.window || globals.self || globals.global || {};
      global_ = globals.global || globals.self || globals.window || {};
      document_ = globals.document || {};
      isBrowser = Boolean(typeof process !== "object" || String(process) !== "[object process]" || process.browser);
      matches = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion = matches && parseFloat(matches[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/env-utils/version.ts
  var DEFAULT_VERSION, VERSION;
  var init_version = __esm({
    "../worker-utils/src/lib/env-utils/version.ts"() {
      DEFAULT_VERSION = "latest";
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : DEFAULT_VERSION;
      if (typeof __VERSION__ === "undefined") {
        console.error("loaders.gl: The __VERSION__ variable is not injected using babel plugin. Latest unstable workers would be fetched from the CDN.");
      }
    }
  });

  // ../worker-utils/src/lib/env-utils/assert.ts
  function assert3(condition, message) {
    if (!condition) {
      throw new Error(message || "loaders.gl assertion failed.");
    }
  }
  var init_assert3 = __esm({
    "../worker-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../worker-utils/src/lib/env-utils/globals.ts
  var globals2, self_2, window_2, global_2, document_2, isBrowser2, isMobile, matches2, nodeVersion2;
  var init_globals2 = __esm({
    "../worker-utils/src/lib/env-utils/globals.ts"() {
      globals2 = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_2 = globals2.self || globals2.window || globals2.global || {};
      window_2 = globals2.window || globals2.self || globals2.global || {};
      global_2 = globals2.global || globals2.self || globals2.window || {};
      document_2 = globals2.document || {};
      isBrowser2 = typeof process !== "object" || String(process) !== "[object process]" || process.browser;
      isMobile = typeof window !== "undefined" && typeof window.orientation !== "undefined";
      matches2 = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion2 = matches2 && parseFloat(matches2[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-job.ts
  var WorkerJob;
  var init_worker_job = __esm({
    "../worker-utils/src/lib/worker-farm/worker-job.ts"() {
      init_assert3();
      WorkerJob = class {
        constructor(jobName, workerThread) {
          this.isRunning = true;
          this._resolve = () => {
          };
          this._reject = () => {
          };
          this.name = jobName;
          this.workerThread = workerThread;
          this.result = new Promise((resolve2, reject) => {
            this._resolve = resolve2;
            this._reject = reject;
          });
        }
        postMessage(type, payload) {
          this.workerThread.postMessage({
            source: "loaders.gl",
            type,
            payload
          });
        }
        done(value) {
          assert3(this.isRunning);
          this.isRunning = false;
          this._resolve(value);
        }
        error(error) {
          assert3(this.isRunning);
          this.isRunning = false;
          this._reject(error);
        }
      };
    }
  });

  // ../worker-utils/src/lib/node/worker_threads-browser.ts
  var Worker2;
  var init_worker_threads_browser = __esm({
    "../worker-utils/src/lib/node/worker_threads-browser.ts"() {
      Worker2 = class {
        terminate() {
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts
  function getLoadableWorkerURL(props) {
    assert3(props.source && !props.url || !props.source && props.url);
    let workerURL = workerURLCache.get(props.source || props.url);
    if (!workerURL) {
      if (props.url) {
        workerURL = getLoadableWorkerURLFromURL(props.url);
        workerURLCache.set(props.url, workerURL);
      }
      if (props.source) {
        workerURL = getLoadableWorkerURLFromSource(props.source);
        workerURLCache.set(props.source, workerURL);
      }
    }
    assert3(workerURL);
    return workerURL;
  }
  function getLoadableWorkerURLFromURL(url) {
    if (!url.startsWith("http")) {
      return url;
    }
    const workerSource = buildScriptSource(url);
    return getLoadableWorkerURLFromSource(workerSource);
  }
  function getLoadableWorkerURLFromSource(workerSource) {
    const blob = new Blob([workerSource], { type: "application/javascript" });
    return URL.createObjectURL(blob);
  }
  function buildScriptSource(workerUrl) {
    return `try {
  importScripts('${workerUrl}');
} catch (error) {
  console.error(error);
  throw error;
}`;
  }
  var workerURLCache;
  var init_get_loadable_worker_url = __esm({
    "../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts"() {
      init_assert3();
      workerURLCache = new Map();
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-transfer-list.ts
  function getTransferList(object, recursive = true, transfers) {
    const transfersSet = transfers || new Set();
    if (!object) {
    } else if (isTransferable(object)) {
      transfersSet.add(object);
    } else if (isTransferable(object.buffer)) {
      transfersSet.add(object.buffer);
    } else if (ArrayBuffer.isView(object)) {
    } else if (recursive && typeof object === "object") {
      for (const key in object) {
        getTransferList(object[key], recursive, transfersSet);
      }
    }
    return transfers === void 0 ? Array.from(transfersSet) : [];
  }
  function isTransferable(object) {
    if (!object) {
      return false;
    }
    if (object instanceof ArrayBuffer) {
      return true;
    }
    if (typeof MessagePort !== "undefined" && object instanceof MessagePort) {
      return true;
    }
    if (typeof ImageBitmap !== "undefined" && object instanceof ImageBitmap) {
      return true;
    }
    if (typeof OffscreenCanvas !== "undefined" && object instanceof OffscreenCanvas) {
      return true;
    }
    return false;
  }
  var init_get_transfer_list = __esm({
    "../worker-utils/src/lib/worker-utils/get-transfer-list.ts"() {
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-thread.ts
  var NOOP, WorkerThread;
  var init_worker_thread = __esm({
    "../worker-utils/src/lib/worker-farm/worker-thread.ts"() {
      init_worker_threads_browser();
      init_globals2();
      init_assert3();
      init_get_loadable_worker_url();
      init_get_transfer_list();
      NOOP = () => {
      };
      WorkerThread = class {
        constructor(props) {
          this.terminated = false;
          this._loadableURL = "";
          const { name, source, url } = props;
          assert3(source || url);
          this.name = name;
          this.source = source;
          this.url = url;
          this.onMessage = NOOP;
          this.onError = (error) => console.log(error);
          this.worker = isBrowser2 ? this._createBrowserWorker() : this._createNodeWorker();
        }
        static isSupported() {
          return typeof Worker !== "undefined" && isBrowser2 || typeof Worker2 !== "undefined" && !isBrowser2;
        }
        destroy() {
          this.onMessage = NOOP;
          this.onError = NOOP;
          this.worker.terminate();
          this.terminated = true;
        }
        get isRunning() {
          return Boolean(this.onMessage);
        }
        postMessage(data, transferList) {
          transferList = transferList || getTransferList(data);
          this.worker.postMessage(data, transferList);
        }
        _getErrorFromErrorEvent(event) {
          let message = "Failed to load ";
          message += `worker ${this.name} from ${this.url}. `;
          if (event.message) {
            message += `${event.message} in `;
          }
          if (event.lineno) {
            message += `:${event.lineno}:${event.colno}`;
          }
          return new Error(message);
        }
        _createBrowserWorker() {
          this._loadableURL = getLoadableWorkerURL({ source: this.source, url: this.url });
          const worker = new Worker(this._loadableURL, { name: this.name });
          worker.onmessage = (event) => {
            if (!event.data) {
              this.onError(new Error("No data received"));
            } else {
              this.onMessage(event.data);
            }
          };
          worker.onerror = (error) => {
            this.onError(this._getErrorFromErrorEvent(error));
            this.terminated = true;
          };
          worker.onmessageerror = (event) => console.error(event);
          return worker;
        }
        _createNodeWorker() {
          let worker;
          if (this.url) {
            const absolute = this.url.includes(":/") || this.url.startsWith("/");
            const url = absolute ? this.url : `./${this.url}`;
            worker = new Worker2(url, { eval: false });
          } else if (this.source) {
            worker = new Worker2(this.source, { eval: true });
          } else {
            throw new Error("no worker");
          }
          worker.on("message", (data) => {
            this.onMessage(data);
          });
          worker.on("error", (error) => {
            this.onError(error);
          });
          worker.on("exit", (code) => {
          });
          return worker;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-pool.ts
  var WorkerPool;
  var init_worker_pool = __esm({
    "../worker-utils/src/lib/worker-farm/worker-pool.ts"() {
      init_globals2();
      init_worker_thread();
      init_worker_job();
      WorkerPool = class {
        constructor(props) {
          this.name = "unnamed";
          this.maxConcurrency = 1;
          this.maxMobileConcurrency = 1;
          this.onDebug = () => {
          };
          this.reuseWorkers = true;
          this.props = {};
          this.jobQueue = [];
          this.idleQueue = [];
          this.count = 0;
          this.isDestroyed = false;
          this.source = props.source;
          this.url = props.url;
          this.setProps(props);
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        destroy() {
          this.idleQueue.forEach((worker) => worker.destroy());
          this.isDestroyed = true;
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          if (props.name !== void 0) {
            this.name = props.name;
          }
          if (props.maxConcurrency !== void 0) {
            this.maxConcurrency = props.maxConcurrency;
          }
          if (props.maxMobileConcurrency !== void 0) {
            this.maxMobileConcurrency = props.maxMobileConcurrency;
          }
          if (props.reuseWorkers !== void 0) {
            this.reuseWorkers = props.reuseWorkers;
          }
          if (props.onDebug !== void 0) {
            this.onDebug = props.onDebug;
          }
        }
        async startJob(name, onMessage2 = (job, type, data) => job.done(data), onError = (job, error) => job.error(error)) {
          const startPromise = new Promise((onStart) => {
            this.jobQueue.push({ name, onMessage: onMessage2, onError, onStart });
            return this;
          });
          this._startQueuedJob();
          return await startPromise;
        }
        async _startQueuedJob() {
          if (!this.jobQueue.length) {
            return;
          }
          const workerThread = this._getAvailableWorker();
          if (!workerThread) {
            return;
          }
          const queuedJob = this.jobQueue.shift();
          if (queuedJob) {
            this.onDebug({
              message: "Starting job",
              name: queuedJob.name,
              workerThread,
              backlog: this.jobQueue.length
            });
            const job = new WorkerJob(queuedJob.name, workerThread);
            workerThread.onMessage = (data) => queuedJob.onMessage(job, data.type, data.payload);
            workerThread.onError = (error) => queuedJob.onError(job, error);
            queuedJob.onStart(job);
            try {
              await job.result;
            } finally {
              this.returnWorkerToQueue(workerThread);
            }
          }
        }
        returnWorkerToQueue(worker) {
          const shouldDestroyWorker = this.isDestroyed || !this.reuseWorkers || this.count > this._getMaxConcurrency();
          if (shouldDestroyWorker) {
            worker.destroy();
            this.count--;
          } else {
            this.idleQueue.push(worker);
          }
          if (!this.isDestroyed) {
            this._startQueuedJob();
          }
        }
        _getAvailableWorker() {
          if (this.idleQueue.length > 0) {
            return this.idleQueue.shift() || null;
          }
          if (this.count < this._getMaxConcurrency()) {
            this.count++;
            const name = `${this.name.toLowerCase()} (#${this.count} of ${this.maxConcurrency})`;
            return new WorkerThread({ name, source: this.source, url: this.url });
          }
          return null;
        }
        _getMaxConcurrency() {
          return isMobile ? this.maxMobileConcurrency : this.maxConcurrency;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-farm.ts
  var DEFAULT_PROPS, WorkerFarm;
  var init_worker_farm = __esm({
    "../worker-utils/src/lib/worker-farm/worker-farm.ts"() {
      init_worker_pool();
      init_worker_thread();
      DEFAULT_PROPS = {
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: true,
        onDebug: () => {
        }
      };
      WorkerFarm = class {
        constructor(props) {
          this.workerPools = new Map();
          this.props = { ...DEFAULT_PROPS };
          this.setProps(props);
          this.workerPools = new Map();
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        static getWorkerFarm(props = {}) {
          WorkerFarm._workerFarm = WorkerFarm._workerFarm || new WorkerFarm({});
          WorkerFarm._workerFarm.setProps(props);
          return WorkerFarm._workerFarm;
        }
        destroy() {
          for (const workerPool of this.workerPools.values()) {
            workerPool.destroy();
          }
          this.workerPools = new Map();
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          for (const workerPool of this.workerPools.values()) {
            workerPool.setProps(this._getWorkerPoolProps());
          }
        }
        getWorkerPool(options) {
          const { name, source, url } = options;
          let workerPool = this.workerPools.get(name);
          if (!workerPool) {
            workerPool = new WorkerPool({
              name,
              source,
              url
            });
            workerPool.setProps(this._getWorkerPoolProps());
            this.workerPools.set(name, workerPool);
          }
          return workerPool;
        }
        _getWorkerPoolProps() {
          return {
            maxConcurrency: this.props.maxConcurrency,
            maxMobileConcurrency: this.props.maxMobileConcurrency,
            reuseWorkers: this.props.reuseWorkers,
            onDebug: this.props.onDebug
          };
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-api/get-worker-url.ts
  function getWorkerURL(worker, options = {}) {
    const workerOptions = options[worker.id] || {};
    const workerFile = `${worker.id}-worker.js`;
    let url = workerOptions.workerUrl;
    if (!url && worker.id === "compression") {
      url = options.workerUrl;
    }
    if (options._workerType === "test") {
      url = `modules/${worker.module}/dist/${workerFile}`;
    }
    if (!url) {
      let version = worker.version;
      if (version === "latest") {
        version = NPM_TAG;
      }
      const versionTag = version ? `@${version}` : "";
      url = `https://unpkg.com/@loaders.gl/${worker.module}${versionTag}/dist/${workerFile}`;
    }
    assert3(url);
    return url;
  }
  var NPM_TAG;
  var init_get_worker_url = __esm({
    "../worker-utils/src/lib/worker-api/get-worker-url.ts"() {
      init_assert3();
      NPM_TAG = "latest";
    }
  });

  // ../worker-utils/src/lib/worker-api/validate-worker-version.ts
  function validateWorkerVersion(worker, coreVersion = VERSION) {
    assert3(worker, "no worker provided");
    const workerVersion = worker.version;
    if (!coreVersion || !workerVersion) {
      return false;
    }
    return true;
  }
  var init_validate_worker_version = __esm({
    "../worker-utils/src/lib/worker-api/validate-worker-version.ts"() {
      init_assert3();
      init_version();
    }
  });

  // ../worker-utils/src/index.ts
  var init_src = __esm({
    "../worker-utils/src/index.ts"() {
      init_assert3();
      init_globals2();
      init_worker_farm();
      init_get_worker_url();
      init_validate_worker_version();
    }
  });

  // ../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts
  function canParseWithWorker(loader, options) {
    if (!WorkerFarm.isSupported()) {
      return false;
    }
    if (!isBrowser2 && !options?._nodeWorkers) {
      return false;
    }
    return loader.worker && options?.worker;
  }
  async function parseWithWorker(loader, data, options, context, parseOnMainThread) {
    const name = loader.id;
    const url = getWorkerURL(loader, options);
    const workerFarm = WorkerFarm.getWorkerFarm(options);
    const workerPool = workerFarm.getWorkerPool({ name, url });
    options = JSON.parse(JSON.stringify(options));
    context = JSON.parse(JSON.stringify(context || {}));
    const job = await workerPool.startJob("process-on-worker", onMessage.bind(null, parseOnMainThread));
    job.postMessage("process", {
      input: data,
      options,
      context
    });
    const result = await job.result;
    return await result.result;
  }
  async function onMessage(parseOnMainThread, job, type, payload) {
    switch (type) {
      case "done":
        job.done(payload);
        break;
      case "error":
        job.error(new Error(payload.error));
        break;
      case "process":
        const { id, input, options } = payload;
        try {
          const result = await parseOnMainThread(input, options);
          job.postMessage("done", { id, result });
        } catch (error) {
          const message = error instanceof Error ? error.message : "unknown error";
          job.postMessage("error", { id, error: message });
        }
        break;
      default:
        console.warn(`parse-with-worker unknown message ${type}`);
    }
  }
  var init_parse_with_worker = __esm({
    "../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts"() {
      init_src();
      init_src();
    }
  });

  // ../loader-utils/src/lib/binary-utils/array-buffer-utils.ts
  function compareArrayBuffers(arrayBuffer1, arrayBuffer2, byteLength) {
    byteLength = byteLength || arrayBuffer1.byteLength;
    if (arrayBuffer1.byteLength < byteLength || arrayBuffer2.byteLength < byteLength) {
      return false;
    }
    const array1 = new Uint8Array(arrayBuffer1);
    const array2 = new Uint8Array(arrayBuffer2);
    for (let i = 0; i < array1.length; ++i) {
      if (array1[i] !== array2[i]) {
        return false;
      }
    }
    return true;
  }
  function concatenateArrayBuffers(...sources) {
    const sourceArrays = sources.map((source2) => source2 instanceof ArrayBuffer ? new Uint8Array(source2) : source2);
    const byteLength = sourceArrays.reduce((length4, typedArray) => length4 + typedArray.byteLength, 0);
    const result = new Uint8Array(byteLength);
    let offset = 0;
    for (const sourceArray of sourceArrays) {
      result.set(sourceArray, offset);
      offset += sourceArray.byteLength;
    }
    return result.buffer;
  }
  var init_array_buffer_utils = __esm({
    "../loader-utils/src/lib/binary-utils/array-buffer-utils.ts"() {
    }
  });

  // ../loader-utils/src/lib/iterators/async-iteration.ts
  async function concatenateArrayBuffersAsync(asyncIterator) {
    const arrayBuffers = [];
    for await (const chunk of asyncIterator) {
      arrayBuffers.push(chunk);
    }
    return concatenateArrayBuffers(...arrayBuffers);
  }
  var init_async_iteration = __esm({
    "../loader-utils/src/lib/iterators/async-iteration.ts"() {
      init_array_buffer_utils();
    }
  });

  // ../loader-utils/src/lib/request-utils/request-scheduler.ts
  var STAT_QUEUED_REQUESTS, STAT_ACTIVE_REQUESTS, STAT_CANCELLED_REQUESTS, STAT_QUEUED_REQUESTS_EVER, STAT_ACTIVE_REQUESTS_EVER, DEFAULT_PROPS2, RequestScheduler;
  var init_request_scheduler = __esm({
    "../loader-utils/src/lib/request-utils/request-scheduler.ts"() {
      init_esm3();
      STAT_QUEUED_REQUESTS = "Queued Requests";
      STAT_ACTIVE_REQUESTS = "Active Requests";
      STAT_CANCELLED_REQUESTS = "Cancelled Requests";
      STAT_QUEUED_REQUESTS_EVER = "Queued Requests Ever";
      STAT_ACTIVE_REQUESTS_EVER = "Active Requests Ever";
      DEFAULT_PROPS2 = {
        id: "request-scheduler",
        throttleRequests: true,
        maxRequests: 6
      };
      RequestScheduler = class {
        constructor(props = {}) {
          this.activeRequestCount = 0;
          this.requestQueue = [];
          this.requestMap = new Map();
          this.deferredUpdate = null;
          this.props = { ...DEFAULT_PROPS2, ...props };
          this.stats = new Stats({ id: this.props.id });
          this.stats.get(STAT_QUEUED_REQUESTS);
          this.stats.get(STAT_ACTIVE_REQUESTS);
          this.stats.get(STAT_CANCELLED_REQUESTS);
          this.stats.get(STAT_QUEUED_REQUESTS_EVER);
          this.stats.get(STAT_ACTIVE_REQUESTS_EVER);
        }
        scheduleRequest(handle, getPriority = () => 0) {
          if (!this.props.throttleRequests) {
            return Promise.resolve({ done: () => {
            } });
          }
          if (this.requestMap.has(handle)) {
            return this.requestMap.get(handle);
          }
          const request = { handle, priority: 0, getPriority };
          const promise = new Promise((resolve2) => {
            request.resolve = resolve2;
            return request;
          });
          this.requestQueue.push(request);
          this.requestMap.set(handle, promise);
          this._issueNewRequests();
          return promise;
        }
        _issueRequest(request) {
          const { handle, resolve: resolve2 } = request;
          let isDone = false;
          const done = () => {
            if (!isDone) {
              isDone = true;
              this.requestMap.delete(handle);
              this.activeRequestCount--;
              this._issueNewRequests();
            }
          };
          this.activeRequestCount++;
          return resolve2 ? resolve2({ done }) : Promise.resolve({ done });
        }
        _issueNewRequests() {
          if (!this.deferredUpdate) {
            this.deferredUpdate = setTimeout(() => this._issueNewRequestsAsync(), 0);
          }
        }
        _issueNewRequestsAsync() {
          this.deferredUpdate = null;
          const freeSlots = Math.max(this.props.maxRequests - this.activeRequestCount, 0);
          if (freeSlots === 0) {
            return;
          }
          this._updateAllRequests();
          for (let i = 0; i < freeSlots; ++i) {
            const request = this.requestQueue.shift();
            if (request) {
              this._issueRequest(request);
            }
          }
        }
        _updateAllRequests() {
          const requestQueue = this.requestQueue;
          for (let i = 0; i < requestQueue.length; ++i) {
            const request = requestQueue[i];
            if (!this._updateRequest(request)) {
              requestQueue.splice(i, 1);
              this.requestMap.delete(request.handle);
              i--;
            }
          }
          requestQueue.sort((a, b) => a.priority - b.priority);
        }
        _updateRequest(request) {
          request.priority = request.getPriority(request.handle);
          if (request.priority < 0) {
            request.resolve(null);
            return false;
          }
          return true;
        }
      };
    }
  });

  // ../loader-utils/src/lib/path-utils/file-aliases.ts
  function resolvePath(filename2) {
    for (const alias in fileAliases) {
      if (filename2.startsWith(alias)) {
        const replacement = fileAliases[alias];
        filename2 = filename2.replace(alias, replacement);
      }
    }
    if (!filename2.startsWith("http://") && !filename2.startsWith("https://")) {
      filename2 = `${pathPrefix}${filename2}`;
    }
    return filename2;
  }
  var pathPrefix, fileAliases;
  var init_file_aliases = __esm({
    "../loader-utils/src/lib/path-utils/file-aliases.ts"() {
      pathPrefix = "";
      fileAliases = {};
    }
  });

  // ../loader-utils/src/lib/node/buffer.browser.ts
  function toArrayBuffer(buffer) {
    return buffer;
  }
  var init_buffer_browser = __esm({
    "../loader-utils/src/lib/node/buffer.browser.ts"() {
    }
  });

  // ../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts
  function isBuffer(value) {
    return value && typeof value === "object" && value.isBuffer;
  }
  function toArrayBuffer2(data) {
    if (isBuffer(data)) {
      return toArrayBuffer(data);
    }
    if (data instanceof ArrayBuffer) {
      return data;
    }
    if (ArrayBuffer.isView(data)) {
      if (data.byteOffset === 0 && data.byteLength === data.buffer.byteLength) {
        return data.buffer;
      }
      return data.buffer.slice(data.byteOffset, data.byteOffset + data.byteLength);
    }
    if (typeof data === "string") {
      const text = data;
      const uint8Array = new TextEncoder().encode(text);
      return uint8Array.buffer;
    }
    if (data && typeof data === "object" && data._toArrayBuffer) {
      return data._toArrayBuffer();
    }
    throw new Error("toArrayBuffer");
  }
  var init_memory_conversion_utils = __esm({
    "../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts"() {
      init_buffer_browser();
    }
  });

  // ../loader-utils/src/lib/path-utils/get-cwd.ts
  function getCWD() {
    if (typeof process !== "undefined" && typeof process.cwd !== "undefined") {
      return process.cwd();
    }
    const pathname = window.location?.pathname;
    return pathname?.slice(0, pathname.lastIndexOf("/") + 1) || "";
  }
  var init_get_cwd = __esm({
    "../loader-utils/src/lib/path-utils/get-cwd.ts"() {
    }
  });

  // ../loader-utils/src/lib/path-utils/path.ts
  var path_exports = {};
  __export(path_exports, {
    dirname: () => dirname,
    filename: () => filename,
    join: () => join,
    resolve: () => resolve
  });
  function filename(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(slashIndex + 1) : "";
  }
  function dirname(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(0, slashIndex) : "";
  }
  function join(...parts) {
    const separator = "/";
    parts = parts.map((part, index) => {
      if (index) {
        part = part.replace(new RegExp(`^${separator}`), "");
      }
      if (index !== parts.length - 1) {
        part = part.replace(new RegExp(`${separator}$`), "");
      }
      return part;
    });
    return parts.join(separator);
  }
  function resolve(...components) {
    const paths = [];
    for (let _i = 0; _i < components.length; _i++) {
      paths[_i] = components[_i];
    }
    let resolvedPath = "";
    let resolvedAbsolute = false;
    let cwd;
    for (let i = paths.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      let path;
      if (i >= 0) {
        path = paths[i];
      } else {
        if (cwd === void 0) {
          cwd = getCWD();
        }
        path = cwd;
      }
      if (path.length === 0) {
        continue;
      }
      resolvedPath = `${path}/${resolvedPath}`;
      resolvedAbsolute = path.charCodeAt(0) === SLASH;
    }
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      return `/${resolvedPath}`;
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    }
    return ".";
  }
  function normalizeStringPosix(path, allowAboveRoot) {
    let res = "";
    let lastSlash = -1;
    let dots = 0;
    let code;
    let isAboveRoot = false;
    for (let i = 0; i <= path.length; ++i) {
      if (i < path.length) {
        code = path.charCodeAt(i);
      } else if (code === SLASH) {
        break;
      } else {
        code = SLASH;
      }
      if (code === SLASH) {
        if (lastSlash === i - 1 || dots === 1) {
        } else if (lastSlash !== i - 1 && dots === 2) {
          if (res.length < 2 || !isAboveRoot || res.charCodeAt(res.length - 1) !== DOT || res.charCodeAt(res.length - 2) !== DOT) {
            if (res.length > 2) {
              const start = res.length - 1;
              let j = start;
              for (; j >= 0; --j) {
                if (res.charCodeAt(j) === SLASH) {
                  break;
                }
              }
              if (j !== start) {
                res = j === -1 ? "" : res.slice(0, j);
                lastSlash = i;
                dots = 0;
                isAboveRoot = false;
                continue;
              }
            } else if (res.length === 2 || res.length === 1) {
              res = "";
              lastSlash = i;
              dots = 0;
              isAboveRoot = false;
              continue;
            }
          }
          if (allowAboveRoot) {
            if (res.length > 0) {
              res += "/..";
            } else {
              res = "..";
            }
            isAboveRoot = true;
          }
        } else {
          const slice = path.slice(lastSlash + 1, i);
          if (res.length > 0) {
            res += `/${slice}`;
          } else {
            res = slice;
          }
          isAboveRoot = false;
        }
        lastSlash = i;
        dots = 0;
      } else if (code === DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  var SLASH, DOT;
  var init_path = __esm({
    "../loader-utils/src/lib/path-utils/path.ts"() {
      init_get_cwd();
      SLASH = 47;
      DOT = 46;
    }
  });

  // ../loader-utils/src/index.ts
  var init_src2 = __esm({
    "../loader-utils/src/index.ts"() {
      init_assert2();
      init_globals();
      init_parse_with_worker();
      init_array_buffer_utils();
      init_async_iteration();
      init_request_scheduler();
      init_file_aliases();
      init_memory_conversion_utils();
      init_path();
    }
  });

  // src/utils/doubly-linked-list-node.ts
  var DoublyLinkedListNode;
  var init_doubly_linked_list_node = __esm({
    "src/utils/doubly-linked-list-node.ts"() {
      DoublyLinkedListNode = class {
        constructor(item, previous, next) {
          this.item = item;
          this.previous = previous;
          this.next = next;
        }
      };
    }
  });

  // src/utils/doubly-linked-list.ts
  var DoublyLinkedList;
  var init_doubly_linked_list = __esm({
    "src/utils/doubly-linked-list.ts"() {
      init_doubly_linked_list_node();
      DoublyLinkedList = class {
        constructor() {
          this.head = null;
          this.tail = null;
          this._length = 0;
        }
        get length() {
          return this._length;
        }
        add(item) {
          const node2 = new DoublyLinkedListNode(item, this.tail, null);
          if (this.tail) {
            this.tail.next = node2;
            this.tail = node2;
          } else {
            this.head = node2;
            this.tail = node2;
          }
          ++this._length;
          return node2;
        }
        remove(node2) {
          if (!node2) {
            return;
          }
          if (node2.previous && node2.next) {
            node2.previous.next = node2.next;
            node2.next.previous = node2.previous;
          } else if (node2.previous) {
            node2.previous.next = null;
            this.tail = node2.previous;
          } else if (node2.next) {
            node2.next.previous = null;
            this.head = node2.next;
          } else {
            this.head = null;
            this.tail = null;
          }
          node2.next = null;
          node2.previous = null;
          --this._length;
        }
        splice(node2, nextNode) {
          if (node2 === nextNode) {
            return;
          }
          this.remove(nextNode);
          this._insert(node2, nextNode);
        }
        _insert(node2, nextNode) {
          const oldNodeNext = node2.next;
          node2.next = nextNode;
          if (this.tail === node2) {
            this.tail = nextNode;
          } else {
            oldNodeNext.previous = nextNode;
          }
          nextNode.next = oldNodeNext;
          nextNode.previous = node2;
          ++this._length;
        }
      };
    }
  });

  // src/tileset/tileset-cache.ts
  var TilesetCache;
  var init_tileset_cache = __esm({
    "src/tileset/tileset-cache.ts"() {
      init_doubly_linked_list();
      TilesetCache = class {
        constructor() {
          this._list = new DoublyLinkedList();
          this._sentinel = this._list.add("sentinel");
          this._trimTiles = false;
        }
        reset() {
          this._list.splice(this._list.tail, this._sentinel);
        }
        touch(tile) {
          const node2 = tile._cacheNode;
          if (node2) {
            this._list.splice(this._sentinel, node2);
          }
        }
        add(tileset, tile, addCallback) {
          if (!tile._cacheNode) {
            tile._cacheNode = this._list.add(tile);
            if (addCallback) {
              addCallback(tileset, tile);
            }
          }
        }
        unloadTile(tileset, tile, unloadCallback) {
          const node2 = tile._cacheNode;
          if (!node2) {
            return;
          }
          this._list.remove(node2);
          tile._cacheNode = null;
          if (unloadCallback) {
            unloadCallback(tileset, tile);
          }
        }
        unloadTiles(tileset, unloadCallback) {
          const trimTiles = this._trimTiles;
          this._trimTiles = false;
          const list = this._list;
          const maximumMemoryUsageInBytes = tileset.maximumMemoryUsage * 1024 * 1024;
          const sentinel = this._sentinel;
          let node2 = list.head;
          while (node2 !== sentinel && (tileset.gpuMemoryUsageInBytes > maximumMemoryUsageInBytes || trimTiles)) {
            const tile = node2.item;
            node2 = node2.next;
            this.unloadTile(tileset, tile, unloadCallback);
          }
        }
        trim() {
          this._trimTiles = true;
        }
      };
    }
  });

  // src/tileset/helpers/transform-utils.ts
  function calculateTransformProps(tileHeader, tile) {
    assert2(tileHeader);
    assert2(tile);
    const { rtcCenter, gltfUpAxis } = tile;
    const {
      computedTransform,
      boundingVolume: { center }
    } = tileHeader;
    let modelMatrix = new Matrix4(computedTransform);
    if (rtcCenter) {
      modelMatrix.translate(rtcCenter);
    }
    switch (gltfUpAxis) {
      case "Z":
        break;
      case "Y":
        const rotationY = new Matrix4().rotateX(Math.PI / 2);
        modelMatrix = modelMatrix.multiplyRight(rotationY);
        break;
      case "X":
        const rotationX = new Matrix4().rotateY(-Math.PI / 2);
        modelMatrix = modelMatrix.multiplyRight(rotationX);
        break;
      default:
        break;
    }
    if (tile.isQuantized) {
      modelMatrix.translate(tile.quantizedVolumeOffset).scale(tile.quantizedVolumeScale);
    }
    const cartesianOrigin = new Vector3(center);
    tile.cartesianModelMatrix = modelMatrix;
    tile.cartesianOrigin = cartesianOrigin;
    const cartographicOrigin = Ellipsoid.WGS84.cartesianToCartographic(cartesianOrigin, new Vector3());
    const fromFixedFrameMatrix = Ellipsoid.WGS84.eastNorthUpToFixedFrame(cartesianOrigin);
    const toFixedFrameMatrix = fromFixedFrameMatrix.invert();
    tile.cartographicModelMatrix = toFixedFrameMatrix.multiplyRight(modelMatrix);
    tile.cartographicOrigin = cartographicOrigin;
    if (!tile.coordinateSystem) {
      tile.modelMatrix = tile.cartographicModelMatrix;
    }
  }
  var init_transform_utils = __esm({
    "src/tileset/helpers/transform-utils.ts"() {
      init_esm2();
      init_esm();
      init_src2();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/constants.js
  var INTERSECTION;
  var init_constants2 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/constants.js"() {
      INTERSECTION = {
        OUTSIDE: -1,
        INTERSECTING: 0,
        INSIDE: 1
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js
  var scratchVector5, scratchNormal2;
  var init_axis_aligned_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_constants2();
      scratchVector5 = new Vector3();
      scratchNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js
  var scratchVector6, scratchVector23, BoundingSphere;
  var init_bounding_sphere = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js"() {
      init_defineProperty();
      init_esm();
      init_mat4();
      init_constants2();
      scratchVector6 = new Vector3();
      scratchVector23 = new Vector3();
      BoundingSphere = class {
        constructor(center = [0, 0, 0], radius = 0) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "radius", void 0);
          this.radius = -0;
          this.center = new Vector3();
          this.fromCenterRadius(center, radius);
        }
        fromCenterRadius(center, radius) {
          this.center.from(center);
          this.radius = radius;
          return this;
        }
        fromCornerPoints(corner, oppositeCorner) {
          oppositeCorner = scratchVector6.from(oppositeCorner);
          this.center = new Vector3().from(corner).add(oppositeCorner).scale(0.5);
          this.radius = this.center.distance(oppositeCorner);
          return this;
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.radius === right.radius;
        }
        clone() {
          return new BoundingSphere(this.center, this.radius);
        }
        union(boundingSphere) {
          const leftCenter = this.center;
          const leftRadius = this.radius;
          const rightCenter = boundingSphere.center;
          const rightRadius = boundingSphere.radius;
          const toRightCenter = scratchVector6.copy(rightCenter).subtract(leftCenter);
          const centerSeparation = toRightCenter.magnitude();
          if (leftRadius >= centerSeparation + rightRadius) {
            return this.clone();
          }
          if (rightRadius >= centerSeparation + leftRadius) {
            return boundingSphere.clone();
          }
          const halfDistanceBetweenTangentPoints = (leftRadius + centerSeparation + rightRadius) * 0.5;
          scratchVector23.copy(toRightCenter).scale((-leftRadius + halfDistanceBetweenTangentPoints) / centerSeparation).add(leftCenter);
          this.center.copy(scratchVector23);
          this.radius = halfDistanceBetweenTangentPoints;
          return this;
        }
        expand(point) {
          const scratchPoint2 = scratchVector6.from(point);
          const radius = scratchPoint2.subtract(this.center).magnitude();
          if (radius > this.radius) {
            this.radius = radius;
          }
          return this;
        }
        transform(transform) {
          this.center.transform(transform);
          const scale5 = getScaling(scratchVector6, transform);
          this.radius = Math.max(scale5[0], Math.max(scale5[1], scale5[2])) * this.radius;
          return this;
        }
        distanceSquaredTo(point) {
          const d = this.distanceTo(point);
          return d * d;
        }
        distanceTo(point) {
          const scratchPoint2 = scratchVector6.from(point);
          const delta = scratchPoint2.subtract(this.center);
          return Math.max(0, delta.len() - this.radius);
        }
        intersectPlane(plane) {
          const center = this.center;
          const radius = this.radius;
          const normal = plane.normal;
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane < -radius) {
            return INTERSECTION.OUTSIDE;
          }
          if (distanceToPlane < radius) {
            return INTERSECTION.INTERSECTING;
          }
          return INTERSECTION.INSIDE;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js
  var scratchVector32, scratchOffset, scratchVectorU, scratchVectorV, scratchVectorW, scratchCorner, scratchToCenter, MATRIX3, OrientedBoundingBox;
  var init_oriented_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_bounding_sphere();
      init_constants2();
      scratchVector32 = new Vector3();
      scratchOffset = new Vector3();
      scratchVectorU = new Vector3();
      scratchVectorV = new Vector3();
      scratchVectorW = new Vector3();
      scratchCorner = new Vector3();
      scratchToCenter = new Vector3();
      MATRIX3 = {
        COLUMN0ROW0: 0,
        COLUMN0ROW1: 1,
        COLUMN0ROW2: 2,
        COLUMN1ROW0: 3,
        COLUMN1ROW1: 4,
        COLUMN1ROW2: 5,
        COLUMN2ROW0: 6,
        COLUMN2ROW1: 7,
        COLUMN2ROW2: 8
      };
      OrientedBoundingBox = class {
        constructor(center = [0, 0, 0], halfAxes = [0, 0, 0, 0, 0, 0, 0, 0, 0]) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "halfAxes", void 0);
          this.center = new Vector3().from(center);
          this.halfAxes = new Matrix3(halfAxes);
        }
        get halfSize() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          return [new Vector3(xAxis).len(), new Vector3(yAxis).len(), new Vector3(zAxis).len()];
        }
        get quaternion() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          const normXAxis = new Vector3(xAxis).normalize();
          const normYAxis = new Vector3(yAxis).normalize();
          const normZAxis = new Vector3(zAxis).normalize();
          return new Quaternion().fromMatrix3(new Matrix3([...normXAxis, ...normYAxis, ...normZAxis]));
        }
        fromCenterHalfSizeQuaternion(center, halfSize, quaternion) {
          const quaternionObject = new Quaternion(quaternion);
          const directionsMatrix = new Matrix3().fromQuaternion(quaternionObject);
          directionsMatrix[0] = directionsMatrix[0] * halfSize[0];
          directionsMatrix[1] = directionsMatrix[1] * halfSize[0];
          directionsMatrix[2] = directionsMatrix[2] * halfSize[0];
          directionsMatrix[3] = directionsMatrix[3] * halfSize[1];
          directionsMatrix[4] = directionsMatrix[4] * halfSize[1];
          directionsMatrix[5] = directionsMatrix[5] * halfSize[1];
          directionsMatrix[6] = directionsMatrix[6] * halfSize[2];
          directionsMatrix[7] = directionsMatrix[7] * halfSize[2];
          directionsMatrix[8] = directionsMatrix[8] * halfSize[2];
          this.center = new Vector3().from(center);
          this.halfAxes = directionsMatrix;
          return this;
        }
        clone() {
          return new OrientedBoundingBox(this.center, this.halfAxes);
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.halfAxes.equals(right.halfAxes);
        }
        getBoundingSphere(result = new BoundingSphere()) {
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const cornerVector = scratchVector32.copy(u).add(v).add(w);
          result.center.copy(this.center);
          result.radius = cornerVector.magnitude();
          return result;
        }
        intersectPlane(plane) {
          const center = this.center;
          const normal = plane.normal;
          const halfAxes = this.halfAxes;
          const normalX = normal.x;
          const normalY = normal.y;
          const normalZ = normal.z;
          const radEffective = Math.abs(normalX * halfAxes[MATRIX3.COLUMN0ROW0] + normalY * halfAxes[MATRIX3.COLUMN0ROW1] + normalZ * halfAxes[MATRIX3.COLUMN0ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN1ROW0] + normalY * halfAxes[MATRIX3.COLUMN1ROW1] + normalZ * halfAxes[MATRIX3.COLUMN1ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN2ROW0] + normalY * halfAxes[MATRIX3.COLUMN2ROW1] + normalZ * halfAxes[MATRIX3.COLUMN2ROW2]);
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane <= -radEffective) {
            return INTERSECTION.OUTSIDE;
          } else if (distanceToPlane >= radEffective) {
            return INTERSECTION.INSIDE;
          }
          return INTERSECTION.INTERSECTING;
        }
        distanceTo(point) {
          return Math.sqrt(this.distanceSquaredTo(point));
        }
        distanceSquaredTo(point) {
          const offset = scratchOffset.from(point).subtract(this.center);
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const uHalf = u.magnitude();
          const vHalf = v.magnitude();
          const wHalf = w.magnitude();
          u.normalize();
          v.normalize();
          w.normalize();
          let distanceSquared = 0;
          let d;
          d = Math.abs(offset.dot(u)) - uHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(v)) - vHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(w)) - wHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          return distanceSquared;
        }
        computePlaneDistances(position, direction, result = [-0, -0]) {
          let minDist = Number.POSITIVE_INFINITY;
          let maxDist = Number.NEGATIVE_INFINITY;
          const center = this.center;
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const corner = scratchCorner.copy(u).add(v).add(w).add(center);
          const toCenter = scratchToCenter.copy(corner).subtract(position);
          let mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          result[0] = minDist;
          result[1] = maxDist;
          return result;
        }
        transform(transformation) {
          this.center.transformAsPoint(transformation);
          const xAxis = this.halfAxes.getColumn(0, scratchVectorU);
          xAxis.transformAsPoint(transformation);
          const yAxis = this.halfAxes.getColumn(1, scratchVectorV);
          yAxis.transformAsPoint(transformation);
          const zAxis = this.halfAxes.getColumn(2, scratchVectorW);
          zAxis.transformAsPoint(transformation);
          this.halfAxes = new Matrix3([...xAxis, ...yAxis, ...zAxis]);
          return this;
        }
        getTransform() {
          throw new Error("not implemented");
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/plane.js
  var scratchPosition2, scratchNormal3, Plane;
  var init_plane = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/plane.js"() {
      init_defineProperty();
      init_esm();
      scratchPosition2 = new Vector3();
      scratchNormal3 = new Vector3();
      Plane = class {
        constructor(normal = [0, 0, 1], distance = 0) {
          _defineProperty(this, "normal", void 0);
          _defineProperty(this, "distance", void 0);
          this.normal = new Vector3();
          this.distance = -0;
          this.fromNormalDistance(normal, distance);
        }
        fromNormalDistance(normal, distance) {
          assert(Number.isFinite(distance));
          this.normal.from(normal).normalize();
          this.distance = distance;
          return this;
        }
        fromPointNormal(point, normal) {
          point = scratchPosition2.from(point);
          this.normal.from(normal).normalize();
          const distance = -this.normal.dot(point);
          this.distance = distance;
          return this;
        }
        fromCoefficients(a, b, c, d) {
          this.normal.set(a, b, c);
          assert(equals(this.normal.len(), 1));
          this.distance = d;
          return this;
        }
        clone() {
          return new Plane(this.normal, this.distance);
        }
        equals(right) {
          return equals(this.distance, right.distance) && equals(this.normal, right.normal);
        }
        getPointDistance(point) {
          return this.normal.dot(point) + this.distance;
        }
        transform(matrix4) {
          const normal = scratchNormal3.copy(this.normal).transformAsVector(matrix4).normalize();
          const point = this.normal.scale(-this.distance).transform(matrix4);
          return this.fromPointNormal(point, normal);
        }
        projectPointOntoPlane(point, result = [0, 0, 0]) {
          point = scratchPosition2.from(point);
          const pointDistance = this.getPointDistance(point);
          const scaledNormal = scratchNormal3.copy(this.normal).scale(pointDistance);
          return point.subtract(scaledNormal).to(result);
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js
  var faces, scratchPlaneCenter, scratchPlaneNormal, scratchPlane, CullingVolume;
  var init_culling_volume = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js"() {
      init_defineProperty();
      init_esm();
      init_constants2();
      init_plane();
      faces = [new Vector3([1, 0, 0]), new Vector3([0, 1, 0]), new Vector3([0, 0, 1])];
      scratchPlaneCenter = new Vector3();
      scratchPlaneNormal = new Vector3();
      scratchPlane = new Plane(new Vector3(1, 0, 0), 0);
      CullingVolume = class {
        constructor(planes = []) {
          _defineProperty(this, "planes", void 0);
          this.planes = planes;
        }
        fromBoundingSphere(boundingSphere) {
          this.planes.length = 2 * faces.length;
          const center = boundingSphere.center;
          const radius = boundingSphere.radius;
          let planeIndex = 0;
          for (const faceNormal of faces) {
            let plane0 = this.planes[planeIndex];
            let plane1 = this.planes[planeIndex + 1];
            if (!plane0) {
              plane0 = this.planes[planeIndex] = new Plane();
            }
            if (!plane1) {
              plane1 = this.planes[planeIndex + 1] = new Plane();
            }
            const plane0Center = scratchPlaneCenter.copy(faceNormal).scale(-radius).add(center);
            const plane0Distance = -faceNormal.dot(plane0Center);
            plane0.fromPointNormal(plane0Center, faceNormal);
            const plane1Center = scratchPlaneCenter.copy(faceNormal).scale(radius).add(center);
            const negatedFaceNormal = scratchPlaneNormal.copy(faceNormal).negate();
            const plane1Distance = -negatedFaceNormal.dot(plane1Center);
            plane1.fromPointNormal(plane1Center, negatedFaceNormal);
            planeIndex += 2;
          }
          return this;
        }
        computeVisibility(boundingVolume) {
          let intersect = INTERSECTION.INSIDE;
          for (const plane of this.planes) {
            const result = boundingVolume.intersectPlane(plane);
            switch (result) {
              case INTERSECTION.OUTSIDE:
                return INTERSECTION.OUTSIDE;
              case INTERSECTION.INTERSECTING:
                intersect = INTERSECTION.INTERSECTING;
                break;
              default:
            }
          }
          return intersect;
        }
        computeVisibilityWithPlaneMask(boundingVolume, parentPlaneMask) {
          assert(Number.isFinite(parentPlaneMask), "parentPlaneMask is required.");
          if (parentPlaneMask === CullingVolume.MASK_OUTSIDE || parentPlaneMask === CullingVolume.MASK_INSIDE) {
            return parentPlaneMask;
          }
          let mask = CullingVolume.MASK_INSIDE;
          const planes = this.planes;
          for (let k = 0; k < this.planes.length; ++k) {
            const flag = k < 31 ? 1 << k : 0;
            if (k < 31 && (parentPlaneMask & flag) === 0) {
              continue;
            }
            const plane = planes[k];
            const result = boundingVolume.intersectPlane(plane);
            if (result === INTERSECTION.OUTSIDE) {
              return CullingVolume.MASK_OUTSIDE;
            } else if (result === INTERSECTION.INTERSECTING) {
              mask |= flag;
            }
          }
          return mask;
        }
      };
      _defineProperty(CullingVolume, "MASK_OUTSIDE", 4294967295);
      _defineProperty(CullingVolume, "MASK_INSIDE", 0);
      _defineProperty(CullingVolume, "MASK_INDETERMINATE", 2147483647);
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js
  var scratchPlaneUpVector, scratchPlaneRightVector, scratchPlaneNearCenter, scratchPlaneFarCenter, scratchPlaneNormal2;
  var init_perspective_off_center_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js"() {
      init_defineProperty();
      init_esm();
      init_culling_volume();
      init_plane();
      scratchPlaneUpVector = new Vector3();
      scratchPlaneRightVector = new Vector3();
      scratchPlaneNearCenter = new Vector3();
      scratchPlaneFarCenter = new Vector3();
      scratchPlaneNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js
  var init_perspective_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js"() {
      init_defineProperty();
      init_perspective_off_center_frustum();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js
  var fromPointsXMin, fromPointsYMin, fromPointsZMin, fromPointsXMax, fromPointsYMax, fromPointsZMax, fromPointsCurrentPos, fromPointsScratch, fromPointsRitterCenter, fromPointsMinBoxPt, fromPointsMaxBoxPt, fromPointsNaiveCenterScratch, volumeConstant;
  var init_bounding_sphere_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js"() {
      init_esm();
      init_bounding_sphere();
      fromPointsXMin = new Vector3();
      fromPointsYMin = new Vector3();
      fromPointsZMin = new Vector3();
      fromPointsXMax = new Vector3();
      fromPointsYMax = new Vector3();
      fromPointsZMax = new Vector3();
      fromPointsCurrentPos = new Vector3();
      fromPointsScratch = new Vector3();
      fromPointsRitterCenter = new Vector3();
      fromPointsMinBoxPt = new Vector3();
      fromPointsMaxBoxPt = new Vector3();
      fromPointsNaiveCenterScratch = new Vector3();
      volumeConstant = 4 / 3 * Math.PI;
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js
  var scratchMatrix, scratchUnitary, scratchDiagonal, jMatrix, jMatrixTranspose;
  var init_compute_eigen_decomposition = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js"() {
      init_esm();
      scratchMatrix = new Matrix3();
      scratchUnitary = new Matrix3();
      scratchDiagonal = new Matrix3();
      jMatrix = new Matrix3();
      jMatrixTranspose = new Matrix3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js
  var scratchVector24, scratchVector33, scratchVector42, scratchVector52, scratchVector62, scratchCovarianceResult, scratchEigenResult;
  var init_bounding_box_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js"() {
      init_esm();
      init_compute_eigen_decomposition();
      init_oriented_bounding_box();
      init_axis_aligned_bounding_box();
      scratchVector24 = new Vector3();
      scratchVector33 = new Vector3();
      scratchVector42 = new Vector3();
      scratchVector52 = new Vector3();
      scratchVector62 = new Vector3();
      scratchCovarianceResult = new Matrix3();
      scratchEigenResult = {
        diagonal: new Matrix3(),
        unitary: new Matrix3()
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/index.js
  var init_esm4 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/index.js"() {
      init_constants2();
      init_axis_aligned_bounding_box();
      init_bounding_sphere();
      init_oriented_bounding_box();
      init_culling_volume();
      init_plane();
      init_perspective_off_center_frustum();
      init_perspective_frustum();
      init_bounding_sphere_from_points();
      init_bounding_box_from_points();
      init_compute_eigen_decomposition();
    }
  });

  // src/tileset/helpers/frame-state.ts
  function getFrameState(viewport, frameNumber) {
    const { cameraDirection, cameraUp, height } = viewport;
    const { metersPerUnit } = viewport.distanceScales;
    const viewportCenterCartesian = worldToCartesian(viewport, viewport.center);
    const enuToFixedTransform = Ellipsoid.WGS84.eastNorthUpToFixedFrame(viewportCenterCartesian);
    const cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);
    const cameraPositionCartesian2 = Ellipsoid.WGS84.cartographicToCartesian(cameraPositionCartographic, new Vector3());
    const cameraDirectionCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraDirection).scale(metersPerUnit))).normalize();
    const cameraUpCartesian = new Vector3(enuToFixedTransform.transformAsVector(new Vector3(cameraUp).scale(metersPerUnit))).normalize();
    commonSpacePlanesToWGS84(viewport);
    const ViewportClass = viewport.constructor;
    const { longitude, latitude, width, bearing, zoom } = viewport;
    const topDownViewport = new ViewportClass({
      longitude,
      latitude,
      height,
      width,
      bearing,
      zoom,
      pitch: 0
    });
    return {
      camera: {
        position: cameraPositionCartesian2,
        direction: cameraDirectionCartesian,
        up: cameraUpCartesian
      },
      viewport,
      topDownViewport,
      height,
      cullingVolume,
      frameNumber,
      sseDenominator: 1.15
    };
  }
  function limitSelectedTiles(tiles, frameState, maximumTilesSelected) {
    if (maximumTilesSelected === 0 || tiles.length <= maximumTilesSelected) {
      return [tiles, []];
    }
    const tuples = [];
    const { longitude: viewportLongitude, latitude: viewportLatitude } = frameState.viewport;
    for (const [index, tile] of tiles.entries()) {
      const [longitude, latitude] = tile.header.mbs;
      const deltaLon = Math.abs(viewportLongitude - longitude);
      const deltaLat = Math.abs(viewportLatitude - latitude);
      const distance = Math.sqrt(deltaLat * deltaLat + deltaLon * deltaLon);
      tuples.push([index, distance]);
    }
    const tuplesSorted = tuples.sort((a, b) => a[1] - b[1]);
    const selectedTiles = [];
    for (let i = 0; i < maximumTilesSelected; i++) {
      selectedTiles.push(tiles[tuplesSorted[i][0]]);
    }
    const unselectedTiles = [];
    for (let i = maximumTilesSelected; i < tuplesSorted.length; i++) {
      unselectedTiles.push(tiles[tuplesSorted[i][0]]);
    }
    return [selectedTiles, unselectedTiles];
  }
  function commonSpacePlanesToWGS84(viewport) {
    const frustumPlanes = viewport.getFrustumPlanes();
    const nearCenterCommon = closestPointOnPlane(frustumPlanes.near, viewport.cameraPosition);
    const nearCenterCartesian = worldToCartesian(viewport, nearCenterCommon);
    const cameraCartesian = worldToCartesian(viewport, viewport.cameraPosition, scratchPosition3);
    let i = 0;
    cullingVolume.planes[i++].fromPointNormal(nearCenterCartesian, scratchVector7.copy(nearCenterCartesian).subtract(cameraCartesian));
    for (const dir in frustumPlanes) {
      if (dir === "near") {
        continue;
      }
      const plane = frustumPlanes[dir];
      const posCommon = closestPointOnPlane(plane, nearCenterCommon, scratchPosition3);
      const cartesianPos = worldToCartesian(viewport, posCommon, scratchPosition3);
      cullingVolume.planes[i++].fromPointNormal(cartesianPos, scratchVector7.copy(nearCenterCartesian).subtract(cartesianPos));
    }
  }
  function closestPointOnPlane(plane, refPoint, out = new Vector3()) {
    const distanceToRef = plane.normal.dot(refPoint);
    out.copy(plane.normal).scale(plane.distance - distanceToRef).add(refPoint);
    return out;
  }
  function worldToCartesian(viewport, point, out = new Vector3()) {
    const cartographicPos = viewport.unprojectPosition(point);
    return Ellipsoid.WGS84.cartographicToCartesian(cartographicPos, out);
  }
  var scratchVector7, scratchPosition3, cullingVolume;
  var init_frame_state = __esm({
    "src/tileset/helpers/frame-state.ts"() {
      init_esm();
      init_esm4();
      init_esm2();
      scratchVector7 = new Vector3();
      scratchPosition3 = new Vector3();
      cullingVolume = new CullingVolume([
        new Plane(),
        new Plane(),
        new Plane(),
        new Plane(),
        new Plane(),
        new Plane()
      ]);
    }
  });

  // src/tileset/helpers/zoom.ts
  function getZoomFromBoundingVolume(boundingVolume, cartorgraphicCenter) {
    if (boundingVolume instanceof OrientedBoundingBox) {
      const { halfAxes } = boundingVolume;
      const obbSize = getObbSize(halfAxes);
      return Math.log2(WGS84_RADIUS_Z2 / (obbSize + cartorgraphicCenter[2]));
    } else if (boundingVolume instanceof BoundingSphere) {
      const { radius } = boundingVolume;
      return Math.log2(WGS84_RADIUS_Z2 / (radius + cartorgraphicCenter[2]));
    } else if (boundingVolume.width && boundingVolume.height) {
      const { width, height } = boundingVolume;
      const zoomX = Math.log2(WGS84_RADIUS_X2 / width);
      const zoomY = Math.log2(WGS84_RADIUS_Y2 / height);
      return (zoomX + zoomY) / 2;
    }
    return 1;
  }
  function getZoomFromFullExtent(fullExtent, cartorgraphicCenter, cartesianCenter) {
    const extentVertex = Ellipsoid.WGS84.cartographicToCartesian([fullExtent.xmax, fullExtent.ymax, fullExtent.zmax], new Vector3());
    const extentSize = Math.sqrt(Math.pow(extentVertex[0] - cartesianCenter[0], 2) + Math.pow(extentVertex[1] - cartesianCenter[1], 2) + Math.pow(extentVertex[2] - cartesianCenter[2], 2));
    return Math.log2(WGS84_RADIUS_Z2 / (extentSize + cartorgraphicCenter[2]));
  }
  function getZoomFromExtent(extent, cartorgraphicCenter, cartesianCenter) {
    const [xmin, ymin, xmax, ymax] = extent;
    return getZoomFromFullExtent({ xmin, xmax, ymin, ymax, zmin: 0, zmax: 0 }, cartorgraphicCenter, cartesianCenter);
  }
  function getObbSize(halfAxes) {
    halfAxes.getColumn(0, scratchVector8);
    const axeY = halfAxes.getColumn(1);
    const axeZ = halfAxes.getColumn(2);
    const farthestVertex = scratchVector8.add(axeY).add(axeZ);
    const size = farthestVertex.len();
    return size;
  }
  var WGS84_RADIUS_X2, WGS84_RADIUS_Y2, WGS84_RADIUS_Z2, scratchVector8;
  var init_zoom = __esm({
    "src/tileset/helpers/zoom.ts"() {
      init_esm();
      init_esm4();
      init_esm2();
      WGS84_RADIUS_X2 = 6378137;
      WGS84_RADIUS_Y2 = 6378137;
      WGS84_RADIUS_Z2 = 6356752314245179e-9;
      scratchVector8 = new Vector3();
    }
  });

  // ../core/src/javascript-utils/is-type.ts
  var isBoolean, isFunction, isObject, isPureObject, isIterable, isAsyncIterable, isResponse, isBlob, isBuffer2, isReadableDOMStream, isReadableNodeStream, isReadableStream;
  var init_is_type = __esm({
    "../core/src/javascript-utils/is-type.ts"() {
      isBoolean = (x) => typeof x === "boolean";
      isFunction = (x) => typeof x === "function";
      isObject = (x) => x !== null && typeof x === "object";
      isPureObject = (x) => isObject(x) && x.constructor === {}.constructor;
      isIterable = (x) => x && typeof x[Symbol.iterator] === "function";
      isAsyncIterable = (x) => x && typeof x[Symbol.asyncIterator] === "function";
      isResponse = (x) => typeof Response !== "undefined" && x instanceof Response || x && x.arrayBuffer && x.text && x.json;
      isBlob = (x) => typeof Blob !== "undefined" && x instanceof Blob;
      isBuffer2 = (x) => x && typeof x === "object" && x.isBuffer;
      isReadableDOMStream = (x) => typeof ReadableStream !== "undefined" && x instanceof ReadableStream || isObject(x) && isFunction(x.tee) && isFunction(x.cancel) && isFunction(x.getReader);
      isReadableNodeStream = (x) => isObject(x) && isFunction(x.read) && isFunction(x.pipe) && isBoolean(x.readable);
      isReadableStream = (x) => isReadableDOMStream(x) || isReadableNodeStream(x);
    }
  });

  // ../core/src/lib/utils/mime-type-utils.ts
  function parseMIMEType(mimeString) {
    const matches3 = MIME_TYPE_PATTERN.exec(mimeString);
    if (matches3) {
      return matches3[1];
    }
    return mimeString;
  }
  function parseMIMETypeFromURL(url) {
    const matches3 = DATA_URL_PATTERN.exec(url);
    if (matches3) {
      return matches3[1];
    }
    return "";
  }
  var DATA_URL_PATTERN, MIME_TYPE_PATTERN;
  var init_mime_type_utils = __esm({
    "../core/src/lib/utils/mime-type-utils.ts"() {
      DATA_URL_PATTERN = /^data:([-\w.]+\/[-\w.+]+)(;|,)/;
      MIME_TYPE_PATTERN = /^([-\w.]+\/[-\w.+]+)/;
    }
  });

  // ../core/src/lib/utils/url-utils.ts
  function extractQueryString(url) {
    const matches3 = url.match(QUERY_STRING_PATTERN);
    return matches3 && matches3[0];
  }
  function stripQueryString(url) {
    return url.replace(QUERY_STRING_PATTERN, "");
  }
  var QUERY_STRING_PATTERN;
  var init_url_utils = __esm({
    "../core/src/lib/utils/url-utils.ts"() {
      QUERY_STRING_PATTERN = /\?.*/;
    }
  });

  // ../core/src/lib/utils/resource-utils.ts
  function getResourceUrl(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.url;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.name || "";
    }
    if (typeof resource === "string") {
      return resource;
    }
    return "";
  }
  function getResourceMIMEType(resource) {
    if (isResponse(resource)) {
      const response = resource;
      const contentTypeHeader = response.headers.get("content-type") || "";
      const noQueryUrl = stripQueryString(response.url);
      return parseMIMEType(contentTypeHeader) || parseMIMETypeFromURL(noQueryUrl);
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.type || "";
    }
    if (typeof resource === "string") {
      return parseMIMETypeFromURL(resource);
    }
    return "";
  }
  function getResourceContentLength(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.headers["content-length"] || -1;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.size;
    }
    if (typeof resource === "string") {
      return resource.length;
    }
    if (resource instanceof ArrayBuffer) {
      return resource.byteLength;
    }
    if (ArrayBuffer.isView(resource)) {
      return resource.byteLength;
    }
    return -1;
  }
  var init_resource_utils = __esm({
    "../core/src/lib/utils/resource-utils.ts"() {
      init_is_type();
      init_mime_type_utils();
      init_url_utils();
    }
  });

  // ../core/src/lib/utils/response-utils.ts
  async function makeResponse(resource) {
    if (isResponse(resource)) {
      return resource;
    }
    const headers = {};
    const contentLength = getResourceContentLength(resource);
    if (contentLength >= 0) {
      headers["content-length"] = String(contentLength);
    }
    const url = getResourceUrl(resource);
    const type = getResourceMIMEType(resource);
    if (type) {
      headers["content-type"] = type;
    }
    const initialDataUrl = await getInitialDataUrl(resource);
    if (initialDataUrl) {
      headers["x-first-bytes"] = initialDataUrl;
    }
    if (typeof resource === "string") {
      resource = new TextEncoder().encode(resource);
    }
    const response = new Response(resource, { headers });
    Object.defineProperty(response, "url", { value: url });
    return response;
  }
  async function checkResponse(response) {
    if (!response.ok) {
      const message = await getResponseError(response);
      throw new Error(message);
    }
  }
  async function getResponseError(response) {
    let message = `Failed to fetch resource ${response.url} (${response.status}): `;
    try {
      const contentType = response.headers.get("Content-Type");
      let text = response.statusText;
      if (contentType.includes("application/json")) {
        text += ` ${await response.text()}`;
      }
      message += text;
      message = message.length > 60 ? `${message.slice(0, 60)}...` : message;
    } catch (error) {
    }
    return message;
  }
  async function getInitialDataUrl(resource) {
    const INITIAL_DATA_LENGTH = 5;
    if (typeof resource === "string") {
      return `data:,${resource.slice(0, INITIAL_DATA_LENGTH)}`;
    }
    if (resource instanceof Blob) {
      const blobSlice = resource.slice(0, 5);
      return await new Promise((resolve2) => {
        const reader = new FileReader();
        reader.onload = (event) => resolve2(event?.target?.result);
        reader.readAsDataURL(blobSlice);
      });
    }
    if (resource instanceof ArrayBuffer) {
      const slice = resource.slice(0, INITIAL_DATA_LENGTH);
      const base64 = arrayBufferToBase64(slice);
      return `data:base64,${base64}`;
    }
    return null;
  }
  function arrayBufferToBase64(buffer) {
    let binary = "";
    const bytes = new Uint8Array(buffer);
    for (let i = 0; i < bytes.byteLength; i++) {
      binary += String.fromCharCode(bytes[i]);
    }
    return btoa(binary);
  }
  var init_response_utils = __esm({
    "../core/src/lib/utils/response-utils.ts"() {
      init_is_type();
      init_resource_utils();
    }
  });

  // ../core/src/lib/fetch/fetch-file.ts
  async function fetchFile(url, options) {
    if (typeof url === "string") {
      url = resolvePath(url);
      let fetchOptions = options;
      if (options?.fetch && typeof options?.fetch !== "function") {
        fetchOptions = options.fetch;
      }
      return await fetch(url, fetchOptions);
    }
    return await makeResponse(url);
  }
  var init_fetch_file = __esm({
    "../core/src/lib/fetch/fetch-file.ts"() {
      init_src2();
      init_response_utils();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/is-electron.js
  function isElectron(mockUserAgent) {
    if (typeof window !== "undefined" && typeof window.process === "object" && window.process.type === "renderer") {
      return true;
    }
    if (typeof process !== "undefined" && typeof process.versions === "object" && Boolean(process.versions["electron"])) {
      return true;
    }
    const realUserAgent = typeof navigator === "object" && typeof navigator.userAgent === "string" && navigator.userAgent;
    const userAgent = mockUserAgent || realUserAgent;
    if (userAgent && userAgent.indexOf("Electron") >= 0) {
      return true;
    }
    return false;
  }
  var init_is_electron = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/is-electron.js"() {
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/is-browser.js
  function isBrowser3() {
    const isNode = typeof process === "object" && String(process) === "[object process]" && !process.browser;
    return !isNode || isElectron();
  }
  var init_is_browser = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/is-browser.js"() {
      init_is_electron();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/globals.js
  var globals3, self_3, window_3, document_3, process_;
  var init_globals3 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/globals.js"() {
      globals3 = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document,
        process: typeof process === "object" && process
      };
      self_3 = globals3.self || globals3.window || globals3.global;
      window_3 = globals3.window || globals3.self || globals3.global;
      document_3 = globals3.document || {};
      process_ = globals3.process || {};
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/utils/globals.js
  var VERSION2, isBrowser4;
  var init_globals4 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/utils/globals.js"() {
      init_is_browser();
      VERSION2 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "untranspiled source";
      isBrowser4 = isBrowser3();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/index.js
  var init_esm5 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/index.js"() {
      init_globals4();
      init_globals3();
      init_is_browser();
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/local-storage.js
  function getStorage(type) {
    try {
      const storage = window[type];
      const x = "__storage_test__";
      storage.setItem(x, x);
      storage.removeItem(x);
      return storage;
    } catch (e) {
      return null;
    }
  }
  var LocalStorage;
  var init_local_storage = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/local-storage.js"() {
      init_defineProperty();
      LocalStorage = class {
        constructor(id, defaultConfig) {
          let type = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "sessionStorage";
          _defineProperty(this, "storage", void 0);
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "config", void 0);
          this.storage = getStorage(type);
          this.id = id;
          this.config = defaultConfig;
          this._loadConfiguration();
        }
        getConfiguration() {
          return this.config;
        }
        setConfiguration(configuration) {
          Object.assign(this.config, configuration);
          if (this.storage) {
            const serialized = JSON.stringify(this.config);
            this.storage.setItem(this.id, serialized);
          }
        }
        _loadConfiguration() {
          let configuration = {};
          if (this.storage) {
            const serializedConfiguration = this.storage.getItem(this.id);
            configuration = serializedConfiguration ? JSON.parse(serializedConfiguration) : {};
          }
          Object.assign(this.config, configuration);
          return this;
        }
      };
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/formatters.js
  function formatTime(ms) {
    let formatted;
    if (ms < 10) {
      formatted = "".concat(ms.toFixed(2), "ms");
    } else if (ms < 100) {
      formatted = "".concat(ms.toFixed(1), "ms");
    } else if (ms < 1e3) {
      formatted = "".concat(ms.toFixed(0), "ms");
    } else {
      formatted = "".concat((ms / 1e3).toFixed(2), "s");
    }
    return formatted;
  }
  function leftPad(string) {
    let length4 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 8;
    const padLength = Math.max(length4 - string.length, 0);
    return "".concat(" ".repeat(padLength)).concat(string);
  }
  function formatImage(image, message, scale5) {
    let maxWidth = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 600;
    const imageUrl = image.src.replace(/\(/g, "%28").replace(/\)/g, "%29");
    if (image.width > maxWidth) {
      scale5 = Math.min(scale5, maxWidth / image.width);
    }
    const width = image.width * scale5;
    const height = image.height * scale5;
    const style = ["font-size:1px;", "padding:".concat(Math.floor(height / 2), "px ").concat(Math.floor(width / 2), "px;"), "line-height:".concat(height, "px;"), "background:url(".concat(imageUrl, ");"), "background-size:".concat(width, "px ").concat(height, "px;"), "color:transparent;"].join("");
    return ["".concat(message, " %c+"), style];
  }
  var init_formatters = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/formatters.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/color.js
  function getColor(color) {
    return typeof color === "string" ? COLOR[color.toUpperCase()] || COLOR.WHITE : color;
  }
  function addColor(string, color, background) {
    if (!isBrowser3 && typeof string === "string") {
      if (color) {
        color = getColor(color);
        string = "[".concat(color, "m").concat(string, "[39m");
      }
      if (background) {
        color = getColor(background);
        string = "[".concat(background + 10, "m").concat(string, "[49m");
      }
    }
    return string;
  }
  var COLOR;
  var init_color = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/color.js"() {
      init_esm5();
      (function(COLOR2) {
        COLOR2[COLOR2["BLACK"] = 30] = "BLACK";
        COLOR2[COLOR2["RED"] = 31] = "RED";
        COLOR2[COLOR2["GREEN"] = 32] = "GREEN";
        COLOR2[COLOR2["YELLOW"] = 33] = "YELLOW";
        COLOR2[COLOR2["BLUE"] = 34] = "BLUE";
        COLOR2[COLOR2["MAGENTA"] = 35] = "MAGENTA";
        COLOR2[COLOR2["CYAN"] = 36] = "CYAN";
        COLOR2[COLOR2["WHITE"] = 37] = "WHITE";
        COLOR2[COLOR2["BRIGHT_BLACK"] = 90] = "BRIGHT_BLACK";
        COLOR2[COLOR2["BRIGHT_RED"] = 91] = "BRIGHT_RED";
        COLOR2[COLOR2["BRIGHT_GREEN"] = 92] = "BRIGHT_GREEN";
        COLOR2[COLOR2["BRIGHT_YELLOW"] = 93] = "BRIGHT_YELLOW";
        COLOR2[COLOR2["BRIGHT_BLUE"] = 94] = "BRIGHT_BLUE";
        COLOR2[COLOR2["BRIGHT_MAGENTA"] = 95] = "BRIGHT_MAGENTA";
        COLOR2[COLOR2["BRIGHT_CYAN"] = 96] = "BRIGHT_CYAN";
        COLOR2[COLOR2["BRIGHT_WHITE"] = 97] = "BRIGHT_WHITE";
      })(COLOR || (COLOR = {}));
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/autobind.js
  function autobind(obj) {
    let predefined = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : ["constructor"];
    const proto = Object.getPrototypeOf(obj);
    const propNames = Object.getOwnPropertyNames(proto);
    for (const key of propNames) {
      if (typeof obj[key] === "function") {
        if (!predefined.find((name) => key === name)) {
          obj[key] = obj[key].bind(obj);
        }
      }
    }
  }
  var init_autobind = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/autobind.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/assert.js
  function assert4(condition, message) {
    if (!condition) {
      throw new Error(message || "Assertion failed");
    }
  }
  var init_assert4 = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/assert.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/hi-res-timestamp.js
  function getHiResTimestamp2() {
    let timestamp;
    if (isBrowser3 && "performance" in window_3) {
      var _window$performance, _window$performance$n;
      timestamp = window_3 === null || window_3 === void 0 ? void 0 : (_window$performance = window_3.performance) === null || _window$performance === void 0 ? void 0 : (_window$performance$n = _window$performance.now) === null || _window$performance$n === void 0 ? void 0 : _window$performance$n.call(_window$performance);
    } else if ("hrtime" in process_) {
      var _process$hrtime;
      const timeParts = process_ === null || process_ === void 0 ? void 0 : (_process$hrtime = process_.hrtime) === null || _process$hrtime === void 0 ? void 0 : _process$hrtime.call(process_);
      timestamp = timeParts[0] * 1e3 + timeParts[1] / 1e6;
    } else {
      timestamp = Date.now();
    }
    return timestamp;
  }
  var init_hi_res_timestamp2 = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/hi-res-timestamp.js"() {
      init_esm5();
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/log.js
  function noop() {
  }
  function normalizeLogLevel(logLevel) {
    if (!logLevel) {
      return 0;
    }
    let resolvedLevel;
    switch (typeof logLevel) {
      case "number":
        resolvedLevel = logLevel;
        break;
      case "object":
        resolvedLevel = logLevel.logLevel || logLevel.priority || 0;
        break;
      default:
        return 0;
    }
    assert4(Number.isFinite(resolvedLevel) && resolvedLevel >= 0);
    return resolvedLevel;
  }
  function normalizeArguments(opts) {
    const {
      logLevel,
      message
    } = opts;
    opts.logLevel = normalizeLogLevel(logLevel);
    const args = opts.args ? Array.from(opts.args) : [];
    while (args.length && args.shift() !== message) {
    }
    switch (typeof logLevel) {
      case "string":
      case "function":
        if (message !== void 0) {
          args.unshift(message);
        }
        opts.message = logLevel;
        break;
      case "object":
        Object.assign(opts, logLevel);
        break;
      default:
    }
    if (typeof opts.message === "function") {
      opts.message = opts.message();
    }
    const messageType = typeof opts.message;
    assert4(messageType === "string" || messageType === "object");
    return Object.assign(opts, {
      args
    }, opts.opts);
  }
  function decorateMessage(id, message, opts) {
    if (typeof message === "string") {
      const time = opts.time ? leftPad(formatTime(opts.total)) : "";
      message = opts.time ? "".concat(id, ": ").concat(time, "  ").concat(message) : "".concat(id, ": ").concat(message);
      message = addColor(message, opts.color, opts.background);
    }
    return message;
  }
  function logImageInNode(_ref2) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref2;
    console.warn("removed");
    return noop;
  }
  function logImageInBrowser(_ref3) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref3;
    if (typeof image === "string") {
      const img = new Image();
      img.onload = () => {
        const args = formatImage(img, message, scale5);
        console.log(...args);
      };
      img.src = image;
      return noop;
    }
    const element = image.nodeName || "";
    if (element.toLowerCase() === "img") {
      console.log(...formatImage(image, message, scale5));
      return noop;
    }
    if (element.toLowerCase() === "canvas") {
      const img = new Image();
      img.onload = () => console.log(...formatImage(img, message, scale5));
      img.src = image.toDataURL();
      return noop;
    }
    return noop;
  }
  function getTableHeader(table) {
    for (const key in table) {
      for (const title in table[key]) {
        return title || "untitled";
      }
    }
    return "empty";
  }
  var originalConsole, DEFAULT_SETTINGS, cache, ONCE, Log;
  var init_log = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/log.js"() {
      init_defineProperty();
      init_esm5();
      init_local_storage();
      init_formatters();
      init_color();
      init_autobind();
      init_assert4();
      init_hi_res_timestamp2();
      originalConsole = {
        debug: isBrowser3 ? console.debug || console.log : console.log,
        log: console.log,
        info: console.info,
        warn: console.warn,
        error: console.error
      };
      DEFAULT_SETTINGS = {
        enabled: true,
        level: 0
      };
      cache = {};
      ONCE = {
        once: true
      };
      Log = class {
        constructor() {
          let {
            id
          } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {
            id: ""
          };
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "VERSION", VERSION2);
          _defineProperty(this, "_startTs", getHiResTimestamp2());
          _defineProperty(this, "_deltaTs", getHiResTimestamp2());
          _defineProperty(this, "_storage", void 0);
          _defineProperty(this, "userData", {});
          _defineProperty(this, "LOG_THROTTLE_TIMEOUT", 0);
          this.id = id;
          this.userData = {};
          this._storage = new LocalStorage("__probe-".concat(this.id, "__"), DEFAULT_SETTINGS);
          this.timeStamp("".concat(this.id, " started"));
          autobind(this);
          Object.seal(this);
        }
        set level(newLevel) {
          this.setLevel(newLevel);
        }
        get level() {
          return this.getLevel();
        }
        isEnabled() {
          return this._storage.config.enabled;
        }
        getLevel() {
          return this._storage.config.level;
        }
        getTotal() {
          return Number((getHiResTimestamp2() - this._startTs).toPrecision(10));
        }
        getDelta() {
          return Number((getHiResTimestamp2() - this._deltaTs).toPrecision(10));
        }
        set priority(newPriority) {
          this.level = newPriority;
        }
        get priority() {
          return this.level;
        }
        getPriority() {
          return this.level;
        }
        enable() {
          let enabled = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
          this._storage.setConfiguration({
            enabled
          });
          return this;
        }
        setLevel(level) {
          this._storage.setConfiguration({
            level
          });
          return this;
        }
        get(setting) {
          return this._storage.config[setting];
        }
        set(setting, value) {
          this._storage.setConfiguration({
            [setting]: value
          });
        }
        settings() {
          if (console.table) {
            console.table(this._storage.config);
          } else {
            console.log(this._storage.config);
          }
        }
        assert(condition, message) {
          assert4(condition, message);
        }
        warn(message) {
          return this._getLogFunction(0, message, originalConsole.warn, arguments, ONCE);
        }
        error(message) {
          return this._getLogFunction(0, message, originalConsole.error, arguments);
        }
        deprecated(oldUsage, newUsage) {
          return this.warn("`".concat(oldUsage, "` is deprecated and will be removed in a later version. Use `").concat(newUsage, "` instead"));
        }
        removed(oldUsage, newUsage) {
          return this.error("`".concat(oldUsage, "` has been removed. Use `").concat(newUsage, "` instead"));
        }
        probe(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.log, arguments, {
            time: true,
            once: true
          });
        }
        log(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.debug, arguments);
        }
        info(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.info, arguments);
        }
        once(logLevel, message) {
          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }
          return this._getLogFunction(logLevel, message, originalConsole.debug || originalConsole.info, arguments, ONCE);
        }
        table(logLevel, table, columns) {
          if (table) {
            return this._getLogFunction(logLevel, table, console.table || noop, columns && [columns], {
              tag: getTableHeader(table)
            });
          }
          return noop;
        }
        image(_ref) {
          let {
            logLevel,
            priority,
            image,
            message = "",
            scale: scale5 = 1
          } = _ref;
          if (!this._shouldLog(logLevel || priority)) {
            return noop;
          }
          return isBrowser3 ? logImageInBrowser({
            image,
            message,
            scale: scale5
          }) : logImageInNode({
            image,
            message,
            scale: scale5
          });
        }
        time(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.time ? console.time : console.info);
        }
        timeEnd(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeEnd ? console.timeEnd : console.info);
        }
        timeStamp(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeStamp || noop);
        }
        group(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {
            collapsed: false
          };
          const options = normalizeArguments({
            logLevel,
            message,
            opts
          });
          const {
            collapsed
          } = opts;
          options.method = (collapsed ? console.groupCollapsed : console.group) || console.info;
          return this._getLogFunction(options);
        }
        groupCollapsed(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
          return this.group(logLevel, message, Object.assign({}, opts, {
            collapsed: true
          }));
        }
        groupEnd(logLevel) {
          return this._getLogFunction(logLevel, "", console.groupEnd || noop);
        }
        withGroup(logLevel, message, func) {
          this.group(logLevel, message)();
          try {
            func();
          } finally {
            this.groupEnd(logLevel)();
          }
        }
        trace() {
          if (console.trace) {
            console.trace();
          }
        }
        _shouldLog(logLevel) {
          return this.isEnabled() && this.getLevel() >= normalizeLogLevel(logLevel);
        }
        _getLogFunction(logLevel, message, method, args, opts) {
          if (this._shouldLog(logLevel)) {
            opts = normalizeArguments({
              logLevel,
              message,
              args,
              opts
            });
            method = method || opts.method;
            assert4(method);
            opts.total = this.getTotal();
            opts.delta = this.getDelta();
            this._deltaTs = getHiResTimestamp2();
            const tag = opts.tag || opts.message;
            if (opts.once) {
              if (!cache[tag]) {
                cache[tag] = getHiResTimestamp2();
              } else {
                return noop;
              }
            }
            message = decorateMessage(this.id, opts.message, opts);
            return method.bind(console, message, ...opts.args);
          }
          return noop;
        }
      };
      _defineProperty(Log, "VERSION", VERSION2);
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/index.js
  var esm_default;
  var init_esm6 = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/index.js"() {
      init_log();
      init_log();
      esm_default = new Log({
        id: "@probe.gl/log"
      });
    }
  });

  // ../core/src/lib/loader-utils/loggers.ts
  var probeLog, NullLog, ConsoleLog;
  var init_loggers = __esm({
    "../core/src/lib/loader-utils/loggers.ts"() {
      init_esm6();
      probeLog = new Log({ id: "loaders.gl" });
      NullLog = class {
        log() {
          return () => {
          };
        }
        info() {
          return () => {
          };
        }
        warn() {
          return () => {
          };
        }
        error() {
          return () => {
          };
        }
      };
      ConsoleLog = class {
        constructor() {
          this.console = console;
        }
        log(...args) {
          return this.console.log.bind(this.console, ...args);
        }
        info(...args) {
          return this.console.info.bind(this.console, ...args);
        }
        warn(...args) {
          return this.console.warn.bind(this.console, ...args);
        }
        error(...args) {
          return this.console.error.bind(this.console, ...args);
        }
      };
    }
  });

  // ../core/src/lib/loader-utils/option-defaults.ts
  var DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS;
  var init_option_defaults = __esm({
    "../core/src/lib/loader-utils/option-defaults.ts"() {
      init_src2();
      init_loggers();
      DEFAULT_LOADER_OPTIONS = {
        fetch: null,
        mimeType: void 0,
        nothrow: false,
        log: new ConsoleLog(),
        CDN: "https://unpkg.com/@loaders.gl",
        worker: true,
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: isBrowser,
        _nodeWorkers: false,
        _workerType: "",
        limit: 0,
        _limitMB: 0,
        batchSize: "auto",
        batchDebounceMs: 0,
        metadata: false,
        transforms: []
      };
      REMOVED_LOADER_OPTIONS = {
        throws: "nothrow",
        dataType: "(no longer used)",
        uri: "baseUri",
        method: "fetch.method",
        headers: "fetch.headers",
        body: "fetch.body",
        mode: "fetch.mode",
        credentials: "fetch.credentials",
        cache: "fetch.cache",
        redirect: "fetch.redirect",
        referrer: "fetch.referrer",
        referrerPolicy: "fetch.referrerPolicy",
        integrity: "fetch.integrity",
        keepalive: "fetch.keepalive",
        signal: "fetch.signal"
      };
    }
  });

  // ../core/src/lib/loader-utils/option-utils.ts
  function getGlobalLoaderState() {
    globalThis.loaders = globalThis.loaders || {};
    const { loaders } = globalThis;
    loaders._state = loaders._state || {};
    return loaders._state;
  }
  function normalizeOptions(options, loader, loaders, url) {
    loaders = loaders || [];
    loaders = Array.isArray(loaders) ? loaders : [loaders];
    validateOptions(options, loaders);
    return normalizeOptionsInternal(loader, options, url);
  }
  function validateOptions(options, loaders) {
    validateOptionsObject(options, null, DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS, loaders);
    for (const loader of loaders) {
      const idOptions = options && options[loader.id] || {};
      const loaderOptions = loader.options && loader.options[loader.id] || {};
      const deprecatedOptions = loader.deprecatedOptions && loader.deprecatedOptions[loader.id] || {};
      validateOptionsObject(idOptions, loader.id, loaderOptions, deprecatedOptions, loaders);
    }
  }
  function validateOptionsObject(options, id, defaultOptions, deprecatedOptions, loaders) {
    const loaderName = id || "Top level";
    const prefix = id ? `${id}.` : "";
    for (const key in options) {
      const isSubOptions = !id && isObject(options[key]);
      const isBaseUriOption = key === "baseUri" && !id;
      const isWorkerUrlOption = key === "workerUrl" && id;
      if (!(key in defaultOptions) && !isBaseUriOption && !isWorkerUrlOption) {
        if (key in deprecatedOptions) {
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' no longer supported, use '${deprecatedOptions[key]}'`)();
        } else if (!isSubOptions) {
          const suggestion = findSimilarOption(key, loaders);
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' not recognized. ${suggestion}`)();
        }
      }
    }
  }
  function findSimilarOption(optionKey, loaders) {
    const lowerCaseOptionKey = optionKey.toLowerCase();
    let bestSuggestion = "";
    for (const loader of loaders) {
      for (const key in loader.options) {
        if (optionKey === key) {
          return `Did you mean '${loader.id}.${key}'?`;
        }
        const lowerCaseKey = key.toLowerCase();
        const isPartialMatch = lowerCaseOptionKey.startsWith(lowerCaseKey) || lowerCaseKey.startsWith(lowerCaseOptionKey);
        if (isPartialMatch) {
          bestSuggestion = bestSuggestion || `Did you mean '${loader.id}.${key}'?`;
        }
      }
    }
    return bestSuggestion;
  }
  function normalizeOptionsInternal(loader, options, url) {
    const loaderDefaultOptions = loader.options || {};
    const mergedOptions = { ...loaderDefaultOptions };
    addUrlOptions(mergedOptions, url);
    if (mergedOptions.log === null) {
      mergedOptions.log = new NullLog();
    }
    mergeNestedFields(mergedOptions, getGlobalLoaderOptions());
    mergeNestedFields(mergedOptions, options);
    return mergedOptions;
  }
  function mergeNestedFields(mergedOptions, options) {
    for (const key in options) {
      if (key in options) {
        const value = options[key];
        if (isPureObject(value) && isPureObject(mergedOptions[key])) {
          mergedOptions[key] = {
            ...mergedOptions[key],
            ...options[key]
          };
        } else {
          mergedOptions[key] = options[key];
        }
      }
    }
  }
  function addUrlOptions(options, url) {
    if (url && !("baseUri" in options)) {
      options.baseUri = url;
    }
  }
  var getGlobalLoaderOptions;
  var init_option_utils = __esm({
    "../core/src/lib/loader-utils/option-utils.ts"() {
      init_is_type();
      init_loggers();
      init_option_defaults();
      getGlobalLoaderOptions = () => {
        const state = getGlobalLoaderState();
        state.globalOptions = state.globalOptions || { ...DEFAULT_LOADER_OPTIONS };
        return state.globalOptions;
      };
    }
  });

  // ../core/src/lib/loader-utils/normalize-loader.ts
  function isLoaderObject(loader) {
    if (!loader) {
      return false;
    }
    if (Array.isArray(loader)) {
      loader = loader[0];
    }
    const hasExtensions = Array.isArray(loader?.extensions);
    return hasExtensions;
  }
  function normalizeLoader(loader) {
    assert2(loader, "null loader");
    assert2(isLoaderObject(loader), "invalid loader");
    let options;
    if (Array.isArray(loader)) {
      options = loader[1];
      loader = loader[0];
      loader = {
        ...loader,
        options: { ...loader.options, ...options }
      };
    }
    if (loader?.parseTextSync || loader?.parseText) {
      loader.text = true;
    }
    if (!loader.text) {
      loader.binary = true;
    }
    return loader;
  }
  var init_normalize_loader = __esm({
    "../core/src/lib/loader-utils/normalize-loader.ts"() {
      init_src2();
    }
  });

  // ../core/src/lib/api/register-loaders.ts
  function getRegisteredLoaders() {
    return getGlobalLoaderRegistry();
  }
  var getGlobalLoaderRegistry;
  var init_register_loaders = __esm({
    "../core/src/lib/api/register-loaders.ts"() {
      init_option_utils();
      getGlobalLoaderRegistry = () => {
        const state = getGlobalLoaderState();
        state.loaderRegistry = state.loaderRegistry || [];
        return state.loaderRegistry;
      };
    }
  });

  // ../core/src/lib/utils/log.ts
  var log;
  var init_log2 = __esm({
    "../core/src/lib/utils/log.ts"() {
      init_esm6();
      log = new Log({ id: "loaders.gl" });
    }
  });

  // ../core/src/lib/api/select-loader.ts
  async function selectLoader(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    let loader = selectLoaderSync(data, loaders, { ...options, nothrow: true }, context);
    if (loader) {
      return loader;
    }
    if (isBlob(data)) {
      data = await data.slice(0, 10).arrayBuffer();
      loader = selectLoaderSync(data, loaders, options, context);
    }
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderSync(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    if (loaders && !Array.isArray(loaders)) {
      return normalizeLoader(loaders);
    }
    let candidateLoaders = [];
    if (loaders) {
      candidateLoaders = candidateLoaders.concat(loaders);
    }
    if (!options?.ignoreRegisteredLoaders) {
      candidateLoaders.push(...getRegisteredLoaders());
    }
    normalizeLoaders(candidateLoaders);
    const loader = selectLoaderInternal(data, candidateLoaders, options, context);
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderInternal(data, loaders, options, context) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    const testUrl = stripQueryString(url) || context?.url;
    let loader = null;
    let reason = "";
    if (options?.mimeType) {
      loader = findLoaderByMIMEType(loaders, options?.mimeType);
      reason = `match forced by supplied MIME type ${options?.mimeType}`;
    }
    loader = loader || findLoaderByUrl(loaders, testUrl);
    reason = reason || (loader ? `matched url ${testUrl}` : "");
    loader = loader || findLoaderByMIMEType(loaders, type);
    reason = reason || (loader ? `matched MIME type ${type}` : "");
    loader = loader || findLoaderByInitialBytes(loaders, data);
    reason = reason || (loader ? `matched initial data ${getFirstCharacters(data)}` : "");
    loader = loader || findLoaderByMIMEType(loaders, options?.fallbackMimeType);
    reason = reason || (loader ? `matched fallback MIME type ${type}` : "");
    if (reason) {
      log.log(1, `selectLoader selected ${loader?.name}: ${reason}.`);
    }
    return loader;
  }
  function validHTTPResponse(data) {
    if (data instanceof Response) {
      if (data.status === 204) {
        return false;
      }
    }
    return true;
  }
  function getNoValidLoaderMessage(data) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    let message = "No valid loader found (";
    message += url ? `${path_exports.filename(url)}, ` : "no url provided, ";
    message += `MIME type: ${type ? `"${type}"` : "not provided"}, `;
    const firstCharacters = data ? getFirstCharacters(data) : "";
    message += firstCharacters ? ` first bytes: "${firstCharacters}"` : "first bytes: not available";
    message += ")";
    return message;
  }
  function normalizeLoaders(loaders) {
    for (const loader of loaders) {
      normalizeLoader(loader);
    }
  }
  function findLoaderByUrl(loaders, url) {
    const match = url && EXT_PATTERN.exec(url);
    const extension = match && match[1];
    return extension ? findLoaderByExtension(loaders, extension) : null;
  }
  function findLoaderByExtension(loaders, extension) {
    extension = extension.toLowerCase();
    for (const loader of loaders) {
      for (const loaderExtension of loader.extensions) {
        if (loaderExtension.toLowerCase() === extension) {
          return loader;
        }
      }
    }
    return null;
  }
  function findLoaderByMIMEType(loaders, mimeType) {
    for (const loader of loaders) {
      if (loader.mimeTypes && loader.mimeTypes.includes(mimeType)) {
        return loader;
      }
      if (mimeType === `application/x.${loader.id}`) {
        return loader;
      }
    }
    return null;
  }
  function findLoaderByInitialBytes(loaders, data) {
    if (!data) {
      return null;
    }
    for (const loader of loaders) {
      if (typeof data === "string") {
        if (testDataAgainstText(data, loader)) {
          return loader;
        }
      } else if (ArrayBuffer.isView(data)) {
        if (testDataAgainstBinary(data.buffer, data.byteOffset, loader)) {
          return loader;
        }
      } else if (data instanceof ArrayBuffer) {
        const byteOffset = 0;
        if (testDataAgainstBinary(data, byteOffset, loader)) {
          return loader;
        }
      }
    }
    return null;
  }
  function testDataAgainstText(data, loader) {
    if (loader.testText) {
      return loader.testText(data);
    }
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => data.startsWith(test));
  }
  function testDataAgainstBinary(data, byteOffset, loader) {
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => testBinary(data, byteOffset, loader, test));
  }
  function testBinary(data, byteOffset, loader, test) {
    if (test instanceof ArrayBuffer) {
      return compareArrayBuffers(test, data, test.byteLength);
    }
    switch (typeof test) {
      case "function":
        return test(data, loader);
      case "string":
        const magic = getMagicString(data, byteOffset, test.length);
        return test === magic;
      default:
        return false;
    }
  }
  function getFirstCharacters(data, length4 = 5) {
    if (typeof data === "string") {
      return data.slice(0, length4);
    } else if (ArrayBuffer.isView(data)) {
      return getMagicString(data.buffer, data.byteOffset, length4);
    } else if (data instanceof ArrayBuffer) {
      const byteOffset = 0;
      return getMagicString(data, byteOffset, length4);
    }
    return "";
  }
  function getMagicString(arrayBuffer, byteOffset, length4) {
    if (arrayBuffer.byteLength < byteOffset + length4) {
      return "";
    }
    const dataView = new DataView(arrayBuffer);
    let magic = "";
    for (let i = 0; i < length4; i++) {
      magic += String.fromCharCode(dataView.getUint8(byteOffset + i));
    }
    return magic;
  }
  var EXT_PATTERN;
  var init_select_loader = __esm({
    "../core/src/lib/api/select-loader.ts"() {
      init_src2();
      init_normalize_loader();
      init_log2();
      init_resource_utils();
      init_register_loaders();
      init_is_type();
      init_url_utils();
      EXT_PATTERN = /\.([^.]+)$/;
    }
  });

  // ../core/src/iterators/make-iterator/make-string-iterator.ts
  function* makeStringIterator(string, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE;
    let offset = 0;
    const textEncoder = new TextEncoder();
    while (offset < string.length) {
      const chunkLength = Math.min(string.length - offset, chunkSize);
      const chunk = string.slice(offset, offset + chunkLength);
      offset += chunkLength;
      yield textEncoder.encode(chunk);
    }
  }
  var DEFAULT_CHUNK_SIZE;
  var init_make_string_iterator = __esm({
    "../core/src/iterators/make-iterator/make-string-iterator.ts"() {
      DEFAULT_CHUNK_SIZE = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-array-buffer-iterator.ts
  function* makeArrayBufferIterator(arrayBuffer, options = {}) {
    const { chunkSize = DEFAULT_CHUNK_SIZE2 } = options;
    let byteOffset = 0;
    while (byteOffset < arrayBuffer.byteLength) {
      const chunkByteLength = Math.min(arrayBuffer.byteLength - byteOffset, chunkSize);
      const chunk = new ArrayBuffer(chunkByteLength);
      const sourceArray = new Uint8Array(arrayBuffer, byteOffset, chunkByteLength);
      const chunkArray = new Uint8Array(chunk);
      chunkArray.set(sourceArray);
      byteOffset += chunkByteLength;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE2;
  var init_make_array_buffer_iterator = __esm({
    "../core/src/iterators/make-iterator/make-array-buffer-iterator.ts"() {
      DEFAULT_CHUNK_SIZE2 = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-blob-iterator.ts
  async function* makeBlobIterator(blob, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE3;
    let offset = 0;
    while (offset < blob.size) {
      const end = offset + chunkSize;
      const chunk = await blob.slice(offset, end).arrayBuffer();
      offset = end;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE3;
  var init_make_blob_iterator = __esm({
    "../core/src/iterators/make-iterator/make-blob-iterator.ts"() {
      DEFAULT_CHUNK_SIZE3 = 1024 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-stream-iterator.ts
  function makeStreamIterator(stream, options) {
    return isBrowser ? makeBrowserStreamIterator(stream, options) : makeNodeStreamIterator(stream, options);
  }
  async function* makeBrowserStreamIterator(stream, options) {
    const reader = stream.getReader();
    let nextBatchPromise;
    try {
      while (true) {
        const currentBatchPromise = nextBatchPromise || reader.read();
        if (options?._streamReadAhead) {
          nextBatchPromise = reader.read();
        }
        const { done, value } = await currentBatchPromise;
        if (done) {
          return;
        }
        yield toArrayBuffer2(value);
      }
    } catch (error) {
      reader.releaseLock();
    }
  }
  async function* makeNodeStreamIterator(stream, options) {
    for await (const chunk of stream) {
      yield toArrayBuffer2(chunk);
    }
  }
  var init_make_stream_iterator = __esm({
    "../core/src/iterators/make-iterator/make-stream-iterator.ts"() {
      init_src2();
    }
  });

  // ../core/src/iterators/make-iterator/make-iterator.ts
  function makeIterator(data, options) {
    if (typeof data === "string") {
      return makeStringIterator(data, options);
    }
    if (data instanceof ArrayBuffer) {
      return makeArrayBufferIterator(data, options);
    }
    if (isBlob(data)) {
      return makeBlobIterator(data, options);
    }
    if (isReadableStream(data)) {
      return makeStreamIterator(data, options);
    }
    if (isResponse(data)) {
      const response = data;
      return makeStreamIterator(response.body, options);
    }
    throw new Error("makeIterator");
  }
  var init_make_iterator = __esm({
    "../core/src/iterators/make-iterator/make-iterator.ts"() {
      init_make_string_iterator();
      init_make_array_buffer_iterator();
      init_make_blob_iterator();
      init_make_stream_iterator();
      init_is_type();
    }
  });

  // ../core/src/lib/loader-utils/get-data.ts
  function getArrayBufferOrStringFromDataSync(data, loader, options) {
    if (loader.text && typeof data === "string") {
      return data;
    }
    if (isBuffer2(data)) {
      data = data.buffer;
    }
    if (data instanceof ArrayBuffer) {
      const arrayBuffer = data;
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(arrayBuffer);
      }
      return arrayBuffer;
    }
    if (ArrayBuffer.isView(data)) {
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(data);
      }
      let arrayBuffer = data.buffer;
      const byteLength = data.byteLength || data.length;
      if (data.byteOffset !== 0 || byteLength !== arrayBuffer.byteLength) {
        arrayBuffer = arrayBuffer.slice(data.byteOffset, data.byteOffset + byteLength);
      }
      return arrayBuffer;
    }
    throw new Error(ERR_DATA);
  }
  async function getArrayBufferOrStringFromData(data, loader, options) {
    const isArrayBuffer = data instanceof ArrayBuffer || ArrayBuffer.isView(data);
    if (typeof data === "string" || isArrayBuffer) {
      return getArrayBufferOrStringFromDataSync(data, loader, options);
    }
    if (isBlob(data)) {
      data = await makeResponse(data);
    }
    if (isResponse(data)) {
      const response = data;
      await checkResponse(response);
      return loader.binary ? await response.arrayBuffer() : await response.text();
    }
    if (isReadableStream(data)) {
      data = makeIterator(data, options);
    }
    if (isIterable(data) || isAsyncIterable(data)) {
      return concatenateArrayBuffersAsync(data);
    }
    throw new Error(ERR_DATA);
  }
  var ERR_DATA;
  var init_get_data = __esm({
    "../core/src/lib/loader-utils/get-data.ts"() {
      init_src2();
      init_is_type();
      init_make_iterator();
      init_response_utils();
      ERR_DATA = "Cannot convert supplied data type";
    }
  });

  // ../core/src/lib/loader-utils/get-fetch-function.ts
  function getFetchFunction(options, context) {
    const globalOptions = getGlobalLoaderOptions();
    const fetchOptions = options || globalOptions;
    if (typeof fetchOptions.fetch === "function") {
      return fetchOptions.fetch;
    }
    if (isObject(fetchOptions.fetch)) {
      return (url) => fetchFile(url, fetchOptions);
    }
    if (context?.fetch) {
      return context?.fetch;
    }
    return fetchFile;
  }
  var init_get_fetch_function = __esm({
    "../core/src/lib/loader-utils/get-fetch-function.ts"() {
      init_is_type();
      init_fetch_file();
      init_option_utils();
    }
  });

  // ../core/src/lib/loader-utils/loader-context.ts
  function getLoaderContext(context, options, parentContext) {
    if (parentContext) {
      return parentContext;
    }
    const newContext = {
      fetch: getFetchFunction(options, context),
      ...context
    };
    if (newContext.url) {
      const baseUrl = stripQueryString(newContext.url);
      newContext.baseUrl = baseUrl;
      newContext.queryString = extractQueryString(newContext.url);
      newContext.filename = path_exports.filename(baseUrl);
      newContext.baseUrl = path_exports.dirname(baseUrl);
    }
    if (!Array.isArray(newContext.loaders)) {
      newContext.loaders = null;
    }
    return newContext;
  }
  function getLoadersFromContext(loaders, context) {
    if (!context && loaders && !Array.isArray(loaders)) {
      return loaders;
    }
    let candidateLoaders;
    if (loaders) {
      candidateLoaders = Array.isArray(loaders) ? loaders : [loaders];
    }
    if (context && context.loaders) {
      const contextLoaders = Array.isArray(context.loaders) ? context.loaders : [context.loaders];
      candidateLoaders = candidateLoaders ? [...candidateLoaders, ...contextLoaders] : contextLoaders;
    }
    return candidateLoaders && candidateLoaders.length ? candidateLoaders : null;
  }
  var init_loader_context = __esm({
    "../core/src/lib/loader-utils/loader-context.ts"() {
      init_get_fetch_function();
      init_url_utils();
      init_src2();
    }
  });

  // ../core/src/lib/api/parse.ts
  async function parse(data, loaders, options, context) {
    assert3(!context || typeof context === "object");
    if (loaders && !Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    data = await data;
    options = options || {};
    const url = getResourceUrl(data);
    const typedLoaders = loaders;
    const candidateLoaders = getLoadersFromContext(typedLoaders, context);
    const loader = await selectLoader(data, candidateLoaders, options);
    if (!loader) {
      return null;
    }
    options = normalizeOptions(options, loader, candidateLoaders, url);
    context = getLoaderContext({ url, parse, loaders: candidateLoaders }, options, context || null);
    return await parseWithLoader(loader, data, options, context);
  }
  async function parseWithLoader(loader, data, options, context) {
    validateWorkerVersion(loader);
    if (isResponse(data)) {
      const response = data;
      const { ok, redirected, status, statusText, type, url } = response;
      const headers = Object.fromEntries(response.headers.entries());
      context.response = { headers, ok, redirected, status, statusText, type, url };
    }
    data = await getArrayBufferOrStringFromData(data, loader, options);
    if (loader.parseTextSync && typeof data === "string") {
      options.dataType = "text";
      return loader.parseTextSync(data, options, context, loader);
    }
    if (canParseWithWorker(loader, options)) {
      return await parseWithWorker(loader, data, options, context, parse);
    }
    if (loader.parseText && typeof data === "string") {
      return await loader.parseText(data, options, context, loader);
    }
    if (loader.parse) {
      return await loader.parse(data, options, context, loader);
    }
    assert3(!loader.parseSync);
    throw new Error(`${loader.id} loader - no parser found and worker is disabled`);
  }
  var init_parse = __esm({
    "../core/src/lib/api/parse.ts"() {
      init_src();
      init_src2();
      init_normalize_loader();
      init_is_type();
      init_option_utils();
      init_get_data();
      init_loader_context();
      init_resource_utils();
      init_select_loader();
    }
  });

  // ../core/src/lib/api/load.ts
  async function load(url, loaders, options, context) {
    if (!Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    const fetch2 = getFetchFunction(options);
    let data = url;
    if (typeof url === "string") {
      data = await fetch2(url);
    }
    if (isBlob(url)) {
      data = await fetch2(url);
    }
    return await parse(data, loaders, options);
  }
  var init_load = __esm({
    "../core/src/lib/api/load.ts"() {
      init_is_type();
      init_normalize_loader();
      init_get_fetch_function();
      init_parse();
    }
  });

  // ../core/src/index.ts
  var init_src3 = __esm({
    "../core/src/index.ts"() {
      init_load();
    }
  });

  // src/constants.ts
  var TILE_CONTENT_STATE, TILE_REFINEMENT, TILE_TYPE, TILESET_TYPE, LOD_METRIC_TYPE, TILE3D_OPTIMIZATION_HINT;
  var init_constants3 = __esm({
    "src/constants.ts"() {
      TILE_CONTENT_STATE = {
        UNLOADED: 0,
        LOADING: 1,
        PROCESSING: 2,
        READY: 3,
        EXPIRED: 4,
        FAILED: 5
      };
      TILE_REFINEMENT = {
        ADD: 1,
        REPLACE: 2
      };
      TILE_TYPE = {
        EMPTY: "empty",
        SCENEGRAPH: "scenegraph",
        POINTCLOUD: "pointcloud",
        MESH: "mesh"
      };
      TILESET_TYPE = {
        I3S: "I3S",
        TILES3D: "TILES3D"
      };
      LOD_METRIC_TYPE = {
        GEOMETRIC_ERROR: "geometricError",
        MAX_SCREEN_THRESHOLD: "maxScreenThreshold"
      };
      TILE3D_OPTIMIZATION_HINT = {
        NOT_COMPUTED: -1,
        USE_OPTIMIZATION: 1,
        SKIP_OPTIMIZATION: 0
      };
    }
  });

  // src/tileset/helpers/bounding-volume.ts
  function defined(x) {
    return x !== void 0 && x !== null;
  }
  function createBoundingVolume(boundingVolumeHeader, transform, result) {
    assert2(boundingVolumeHeader, "3D Tile: boundingVolume must be defined");
    if (boundingVolumeHeader.box) {
      return createBox(boundingVolumeHeader.box, transform, result);
    }
    if (boundingVolumeHeader.region) {
      const [west, south, east, north, minHeight, maxHeight] = boundingVolumeHeader.region;
      const northWest = Ellipsoid.WGS84.cartographicToCartesian([degrees(west), degrees(north), minHeight], scratchNorthWest);
      const southEast = Ellipsoid.WGS84.cartographicToCartesian([degrees(east), degrees(south), maxHeight], scratchSouthEast);
      const centerInCartesian = new Vector3().addVectors(northWest, southEast).multiplyScalar(0.5);
      const radius = new Vector3().subVectors(northWest, southEast).len() / 2;
      return createSphere([centerInCartesian[0], centerInCartesian[1], centerInCartesian[2], radius], new Matrix4());
    }
    if (boundingVolumeHeader.sphere) {
      return createSphere(boundingVolumeHeader.sphere, transform, result);
    }
    throw new Error("3D Tile: boundingVolume must contain a sphere, region, or box");
  }
  function getCartographicBounds(boundingVolumeHeader, boundingVolume) {
    if (boundingVolumeHeader.box) {
      return orientedBoundingBoxToCartographicBounds(boundingVolume);
    }
    if (boundingVolumeHeader.region) {
      const [west, south, east, north, minHeight, maxHeight] = boundingVolumeHeader.region;
      return [
        [degrees(west), degrees(south), minHeight],
        [degrees(east), degrees(north), maxHeight]
      ];
    }
    if (boundingVolumeHeader.sphere) {
      return boundingSphereToCartographicBounds(boundingVolume);
    }
    throw new Error("Unkown boundingVolume type");
  }
  function createBox(box, transform, result) {
    const center = new Vector3(box[0], box[1], box[2]);
    transform.transform(center, center);
    let origin = [];
    if (box.length === 10) {
      const halfSize = box.slice(3, 6);
      const quaternion = new Quaternion();
      quaternion.fromArray(box, 6);
      const x = new Vector3([1, 0, 0]);
      const y = new Vector3([0, 1, 0]);
      const z = new Vector3([0, 0, 1]);
      x.transformByQuaternion(quaternion);
      x.scale(halfSize[0]);
      y.transformByQuaternion(quaternion);
      y.scale(halfSize[1]);
      z.transformByQuaternion(quaternion);
      z.scale(halfSize[2]);
      origin = [...x.toArray(), ...y.toArray(), ...z.toArray()];
    } else {
      origin = [...box.slice(3, 6), ...box.slice(6, 9), ...box.slice(9, 12)];
    }
    const xAxis = transform.transformAsVector(origin.slice(0, 3));
    const yAxis = transform.transformAsVector(origin.slice(3, 6));
    const zAxis = transform.transformAsVector(origin.slice(6, 9));
    const halfAxes = new Matrix3([
      xAxis[0],
      xAxis[1],
      xAxis[2],
      yAxis[0],
      yAxis[1],
      yAxis[2],
      zAxis[0],
      zAxis[1],
      zAxis[2]
    ]);
    if (defined(result)) {
      result.center = center;
      result.halfAxes = halfAxes;
      return result;
    }
    return new OrientedBoundingBox(center, halfAxes);
  }
  function createSphere(sphere, transform, result) {
    const center = new Vector3(sphere[0], sphere[1], sphere[2]);
    transform.transform(center, center);
    const scale5 = transform.getScale(scratchScale);
    const uniformScale = Math.max(Math.max(scale5[0], scale5[1]), scale5[2]);
    const radius = sphere[3] * uniformScale;
    if (defined(result)) {
      result.center = center;
      result.radius = radius;
      return result;
    }
    return new BoundingSphere(center, radius);
  }
  function orientedBoundingBoxToCartographicBounds(boundingVolume) {
    const result = emptyCartographicBounds();
    const { halfAxes } = boundingVolume;
    const xAxis = new Vector3(halfAxes.getColumn(0));
    const yAxis = new Vector3(halfAxes.getColumn(1));
    const zAxis = new Vector3(halfAxes.getColumn(2));
    for (let x = 0; x < 2; x++) {
      for (let y = 0; y < 2; y++) {
        for (let z = 0; z < 2; z++) {
          scratchPoint.copy(boundingVolume.center);
          scratchPoint.add(xAxis);
          scratchPoint.add(yAxis);
          scratchPoint.add(zAxis);
          addToCartographicBounds(result, scratchPoint);
          zAxis.negate();
        }
        yAxis.negate();
      }
      xAxis.negate();
    }
    return result;
  }
  function boundingSphereToCartographicBounds(boundingVolume) {
    const result = emptyCartographicBounds();
    const { center, radius } = boundingVolume;
    const point = Ellipsoid.WGS84.scaleToGeodeticSurface(center, scratchPoint);
    let zAxis;
    if (point) {
      zAxis = Ellipsoid.WGS84.geodeticSurfaceNormal(point);
    } else {
      zAxis = new Vector3(0, 0, 1);
    }
    let xAxis = new Vector3(zAxis[2], -zAxis[1], 0);
    if (xAxis.len() > 0) {
      xAxis.normalize();
    } else {
      xAxis = new Vector3(0, 1, 0);
    }
    const yAxis = xAxis.clone().cross(zAxis);
    for (const axis of [xAxis, yAxis, zAxis]) {
      scratchScale.copy(axis).scale(radius);
      for (let dir = 0; dir < 2; dir++) {
        scratchPoint.copy(center);
        scratchPoint.add(scratchScale);
        addToCartographicBounds(result, scratchPoint);
        scratchScale.negate();
      }
    }
    return result;
  }
  function emptyCartographicBounds() {
    return [
      [Infinity, Infinity, Infinity],
      [-Infinity, -Infinity, -Infinity]
    ];
  }
  function addToCartographicBounds(target, cartesian) {
    Ellipsoid.WGS84.cartesianToCartographic(cartesian, scratchPoint);
    target[0][0] = Math.min(target[0][0], scratchPoint[0]);
    target[0][1] = Math.min(target[0][1], scratchPoint[1]);
    target[0][2] = Math.min(target[0][2], scratchPoint[2]);
    target[1][0] = Math.max(target[1][0], scratchPoint[0]);
    target[1][1] = Math.max(target[1][1], scratchPoint[1]);
    target[1][2] = Math.max(target[1][2], scratchPoint[2]);
  }
  var scratchPoint, scratchScale, scratchNorthWest, scratchSouthEast;
  var init_bounding_volume = __esm({
    "src/tileset/helpers/bounding-volume.ts"() {
      init_esm();
      init_esm4();
      init_esm2();
      init_src2();
      scratchPoint = new Vector3();
      scratchScale = new Vector3();
      scratchNorthWest = new Vector3();
      scratchSouthEast = new Vector3();
    }
  });

  // src/tileset/helpers/tiles-3d-lod.ts
  function fog(distanceToCamera, density) {
    const scalar = distanceToCamera * density;
    return 1 - Math.exp(-(scalar * scalar));
  }
  function getDynamicScreenSpaceError(tileset, distanceToCamera) {
    if (tileset.dynamicScreenSpaceError && tileset.dynamicScreenSpaceErrorComputedDensity) {
      const density = tileset.dynamicScreenSpaceErrorComputedDensity;
      const factor = tileset.dynamicScreenSpaceErrorFactor;
      const dynamicError = fog(distanceToCamera, density) * factor;
      return dynamicError;
    }
    return 0;
  }
  function getTiles3DScreenSpaceError(tile, frameState, useParentLodMetric) {
    const tileset = tile.tileset;
    const parentLodMetricValue = tile.parent && tile.parent.lodMetricValue || tile.lodMetricValue;
    const lodMetricValue = useParentLodMetric ? parentLodMetricValue : tile.lodMetricValue;
    if (lodMetricValue === 0) {
      return 0;
    }
    const distance = Math.max(tile._distanceToCamera, 1e-7);
    const { height, sseDenominator } = frameState;
    const { viewDistanceScale } = tileset.options;
    let error = lodMetricValue * height * (viewDistanceScale || 1) / (distance * sseDenominator);
    error -= getDynamicScreenSpaceError(tileset, distance);
    return error;
  }
  var scratchPositionNormal, scratchCartographic, scratchMatrix2, scratchCenter, scratchPosition4, scratchDirection;
  var init_tiles_3d_lod = __esm({
    "src/tileset/helpers/tiles-3d-lod.ts"() {
      init_esm();
      scratchPositionNormal = new Vector3();
      scratchCartographic = new Vector3();
      scratchMatrix2 = new Matrix4();
      scratchCenter = new Vector3();
      scratchPosition4 = new Vector3();
      scratchDirection = new Vector3();
    }
  });

  // src/tileset/helpers/i3s-lod.ts
  function getLodStatus(tile, frameState) {
    if (tile.lodMetricValue === 0 || isNaN(tile.lodMetricValue)) {
      return "DIG";
    }
    const screenSize = 2 * getProjectedRadius(tile, frameState);
    if (screenSize < 2) {
      return "OUT";
    }
    if (!tile.header.children || screenSize <= tile.lodMetricValue) {
      return "DRAW";
    } else if (tile.header.children) {
      return "DIG";
    }
    return "OUT";
  }
  function getProjectedRadius(tile, frameState) {
    const { topDownViewport: viewport } = frameState;
    const mbsLat = tile.header.mbs[1];
    const mbsLon = tile.header.mbs[0];
    const mbsZ = tile.header.mbs[2];
    const mbsR = tile.header.mbs[3];
    const mbsCenterCartesian = [...tile.boundingVolume.center];
    const cameraPositionCartographic = viewport.unprojectPosition(viewport.cameraPosition);
    Ellipsoid.WGS84.cartographicToCartesian(cameraPositionCartographic, cameraPositionCartesian);
    toEye.copy(cameraPositionCartesian).subtract(mbsCenterCartesian).normalize();
    Ellipsoid.WGS84.eastNorthUpToFixedFrame(mbsCenterCartesian, enuToCartesianMatrix);
    cartesianToEnuMatrix.copy(enuToCartesianMatrix).invert();
    cameraPositionEnu.copy(cameraPositionCartesian).transform(cartesianToEnuMatrix);
    const projection = Math.sqrt(cameraPositionEnu[0] * cameraPositionEnu[0] + cameraPositionEnu[1] * cameraPositionEnu[1]);
    const extraZ = projection * projection / cameraPositionEnu[2];
    extraVertexEnu.copy([cameraPositionEnu[0], cameraPositionEnu[1], extraZ]);
    const extraVertexCartesian = extraVertexEnu.transform(enuToCartesianMatrix);
    const extraVectorCartesian = extraVertexCartesian.subtract(mbsCenterCartesian).normalize();
    const radiusVector = toEye.cross(extraVectorCartesian).normalize().scale(mbsR);
    const sphereMbsBorderVertexCartesian = radiusVector.add(mbsCenterCartesian);
    const sphereMbsBorderVertexCartographic = Ellipsoid.WGS84.cartesianToCartographic(sphereMbsBorderVertexCartesian);
    const projectedOrigin = viewport.project([mbsLon, mbsLat, mbsZ]);
    const projectedMbsBorderVertex = viewport.project(sphereMbsBorderVertexCartographic);
    const projectedRadius = projectedOriginVector.copy(projectedOrigin).subtract(projectedMbsBorderVertex).magnitude();
    return projectedRadius;
  }
  var cameraPositionCartesian, toEye, cameraPositionEnu, extraVertexEnu, projectedOriginVector, enuToCartesianMatrix, cartesianToEnuMatrix;
  var init_i3s_lod = __esm({
    "src/tileset/helpers/i3s-lod.ts"() {
      init_esm();
      init_esm2();
      cameraPositionCartesian = new Vector3();
      toEye = new Vector3();
      cameraPositionEnu = new Vector3();
      extraVertexEnu = new Vector3();
      projectedOriginVector = new Vector3();
      enuToCartesianMatrix = new Matrix4();
      cartesianToEnuMatrix = new Matrix4();
    }
  });

  // src/tileset/helpers/3d-tiles-options.ts
  function get3dTilesOptions(tileset) {
    return {
      assetGltfUpAxis: tileset.asset && tileset.asset.gltfUpAxis || "Y"
    };
  }
  var init_d_tiles_options = __esm({
    "src/tileset/helpers/3d-tiles-options.ts"() {
    }
  });

  // src/utils/managed-array.ts
  var ManagedArray;
  var init_managed_array = __esm({
    "src/utils/managed-array.ts"() {
      init_src2();
      ManagedArray = class {
        constructor(length4 = 0) {
          this._map = new Map();
          this._array = new Array(length4);
          this._length = length4;
        }
        get length() {
          return this._length;
        }
        set length(length4) {
          this._length = length4;
          if (length4 > this._array.length) {
            this._array.length = length4;
          }
        }
        get values() {
          return this._array;
        }
        get(index) {
          assert2(index < this._array.length);
          return this._array[index];
        }
        set(index, element) {
          assert2(index >= 0);
          if (index >= this.length) {
            this.length = index + 1;
          }
          if (this._map.has(this._array[index])) {
            this._map.delete(this._array[index]);
          }
          this._array[index] = element;
          this._map.set(element, index);
        }
        delete(element) {
          const index = this._map.get(element);
          if (index >= 0) {
            this._array.splice(index, 1);
            this._map.delete(element);
            this.length--;
          }
        }
        peek() {
          return this._array[this._length - 1];
        }
        push(element) {
          if (!this._map.has(element)) {
            const index = this.length++;
            this._array[index] = element;
            this._map.set(element, index);
          }
        }
        pop() {
          const element = this._array[--this.length];
          this._map.delete(element);
          return element;
        }
        reserve(length4) {
          assert2(length4 >= 0);
          if (length4 > this._array.length) {
            this._array.length = length4;
          }
        }
        resize(length4) {
          assert2(length4 >= 0);
          this.length = length4;
        }
        trim(length4) {
          if (length4 === null || length4 === void 0) {
            length4 = this.length;
          }
          this._array.length = length4;
        }
        reset() {
          this._array = [];
          this._map = new Map();
          this._length = 0;
        }
        find(target) {
          return this._map.has(target);
        }
      };
    }
  });

  // src/tileset/tileset-traverser.ts
  var DEFAULT_PROPS3, TilesetTraverser;
  var init_tileset_traverser = __esm({
    "src/tileset/tileset-traverser.ts"() {
      init_managed_array();
      init_constants3();
      DEFAULT_PROPS3 = {
        loadSiblings: false,
        skipLevelOfDetail: false,
        maximumScreenSpaceError: 2,
        updateTransforms: true,
        onTraversalEnd: () => {
        },
        viewportTraversersMap: {},
        basePath: ""
      };
      TilesetTraverser = class {
        constructor(options) {
          this.root = null;
          this.selectedTiles = {};
          this.requestedTiles = {};
          this.emptyTiles = {};
          this.lastUpdate = new Date().getTime();
          this.updateDebounceTime = 1e3;
          this._traversalStack = new ManagedArray();
          this._emptyTraversalStack = new ManagedArray();
          this._frameNumber = null;
          this.options = { ...DEFAULT_PROPS3, ...options };
        }
        traversalFinished(frameState) {
          return true;
        }
        traverse(root, frameState, options) {
          this.root = root;
          this.options = { ...this.options, ...options };
          this.reset();
          this.updateTile(root, frameState);
          this._frameNumber = frameState.frameNumber;
          this.executeTraversal(root, frameState);
        }
        reset() {
          this.requestedTiles = {};
          this.selectedTiles = {};
          this.emptyTiles = {};
          this._traversalStack.reset();
          this._emptyTraversalStack.reset();
        }
        executeTraversal(root, frameState) {
          const stack = this._traversalStack;
          root._selectionDepth = 1;
          stack.push(root);
          while (stack.length > 0) {
            const tile = stack.pop();
            let shouldRefine = false;
            if (this.canTraverse(tile, frameState)) {
              this.updateChildTiles(tile, frameState);
              shouldRefine = this.updateAndPushChildren(tile, frameState, stack, tile.hasRenderContent ? tile._selectionDepth + 1 : tile._selectionDepth);
            }
            const parent = tile.parent;
            const parentRefines = Boolean(!parent || parent._shouldRefine);
            const stoppedRefining = !shouldRefine;
            if (!tile.hasRenderContent) {
              this.emptyTiles[tile.id] = tile;
              this.loadTile(tile, frameState);
              if (stoppedRefining) {
                this.selectTile(tile, frameState);
              }
            } else if (tile.refine === TILE_REFINEMENT.ADD) {
              this.loadTile(tile, frameState);
              this.selectTile(tile, frameState);
            } else if (tile.refine === TILE_REFINEMENT.REPLACE) {
              this.loadTile(tile, frameState);
              if (stoppedRefining) {
                this.selectTile(tile, frameState);
              }
            }
            this.touchTile(tile, frameState);
            tile._shouldRefine = shouldRefine && parentRefines;
          }
          const newTime = new Date().getTime();
          if (this.traversalFinished(frameState) || newTime - this.lastUpdate > this.updateDebounceTime) {
            this.lastUpdate = newTime;
            this.options.onTraversalEnd(frameState);
          }
        }
        updateChildTiles(tile, frameState) {
          const children = tile.children;
          for (const child of children) {
            this.updateTile(child, frameState);
          }
        }
        updateAndPushChildren(tile, frameState, stack, depth) {
          const { loadSiblings, skipLevelOfDetail } = this.options;
          const children = tile.children;
          children.sort(this.compareDistanceToCamera.bind(this));
          const checkRefines = tile.refine === TILE_REFINEMENT.REPLACE && tile.hasRenderContent && !skipLevelOfDetail;
          let hasVisibleChild = false;
          let refines = true;
          for (const child of children) {
            child._selectionDepth = depth;
            if (child.isVisibleAndInRequestVolume) {
              if (stack.find(child)) {
                stack.delete(child);
              }
              stack.push(child);
              hasVisibleChild = true;
            } else if (checkRefines || loadSiblings) {
              this.loadTile(child, frameState);
              this.touchTile(child, frameState);
            }
            if (checkRefines) {
              let childRefines;
              if (!child._inRequestVolume) {
                childRefines = false;
              } else if (!child.hasRenderContent) {
                childRefines = this.executeEmptyTraversal(child, frameState);
              } else {
                childRefines = child.contentAvailable;
              }
              refines = refines && childRefines;
              if (!refines) {
                return false;
              }
            }
          }
          if (!hasVisibleChild) {
            refines = false;
          }
          return refines;
        }
        updateTile(tile, frameState) {
          this.updateTileVisibility(tile, frameState);
        }
        selectTile(tile, frameState) {
          if (this.shouldSelectTile(tile)) {
            tile._selectedFrame = frameState.frameNumber;
            this.selectedTiles[tile.id] = tile;
          }
        }
        loadTile(tile, frameState) {
          if (this.shouldLoadTile(tile)) {
            tile._requestedFrame = frameState.frameNumber;
            tile._priority = tile._getPriority();
            this.requestedTiles[tile.id] = tile;
          }
        }
        touchTile(tile, frameState) {
          tile.tileset._cache.touch(tile);
          tile._touchedFrame = frameState.frameNumber;
        }
        canTraverse(tile, frameState, useParentMetric = false, ignoreVisibility = false) {
          if (!tile.hasChildren) {
            return false;
          }
          if (tile.hasTilesetContent) {
            return !tile.contentExpired;
          }
          if (!ignoreVisibility && !tile.isVisibleAndInRequestVolume) {
            return false;
          }
          return this.shouldRefine(tile, frameState, useParentMetric);
        }
        shouldLoadTile(tile) {
          return tile.hasUnloadedContent || tile.contentExpired;
        }
        shouldSelectTile(tile) {
          return tile.contentAvailable && !this.options.skipLevelOfDetail;
        }
        shouldRefine(tile, frameState, useParentMetric = false) {
          let screenSpaceError = tile._screenSpaceError;
          if (useParentMetric) {
            screenSpaceError = tile.getScreenSpaceError(frameState, true);
          }
          return screenSpaceError > this.options.maximumScreenSpaceError;
        }
        updateTileVisibility(tile, frameState) {
          const viewportIds = [];
          if (this.options.viewportTraversersMap) {
            for (const key in this.options.viewportTraversersMap) {
              const value = this.options.viewportTraversersMap[key];
              if (value === frameState.viewport.id) {
                viewportIds.push(key);
              }
            }
          } else {
            viewportIds.push(frameState.viewport.id);
          }
          tile.updateVisibility(frameState, viewportIds);
        }
        compareDistanceToCamera(b, a) {
          return b._distanceToCamera - a._distanceToCamera;
        }
        anyChildrenVisible(tile, frameState) {
          let anyVisible = false;
          for (const child of tile.children) {
            child.updateVisibility(frameState);
            anyVisible = anyVisible || child.isVisibleAndInRequestVolume;
          }
          return anyVisible;
        }
        executeEmptyTraversal(root, frameState) {
          let allDescendantsLoaded = true;
          const stack = this._emptyTraversalStack;
          stack.push(root);
          while (stack.length > 0 && allDescendantsLoaded) {
            const tile = stack.pop();
            this.updateTile(tile, frameState);
            if (!tile.isVisibleAndInRequestVolume) {
              this.loadTile(tile, frameState);
            }
            this.touchTile(tile, frameState);
            const traverse = !tile.hasRenderContent && this.canTraverse(tile, frameState, false, true);
            if (traverse) {
              const children = tile.children;
              for (const child of children) {
                if (stack.find(child)) {
                  stack.delete(child);
                }
                stack.push(child);
              }
            } else if (!tile.contentAvailable && !tile.hasEmptyContent) {
              allDescendantsLoaded = false;
            }
          }
          return allDescendantsLoaded;
        }
      };
    }
  });

  // src/tileset/tile-3d.ts
  function defined2(x) {
    return x !== void 0 && x !== null;
  }
  var scratchVector9, Tile3D;
  var init_tile_3d = __esm({
    "src/tileset/tile-3d.ts"() {
      init_esm();
      init_esm4();
      init_src3();
      init_constants3();
      init_bounding_volume();
      init_tiles_3d_lod();
      init_i3s_lod();
      init_d_tiles_options();
      init_tileset_traverser();
      scratchVector9 = new Vector3();
      Tile3D = class {
        constructor(tileset, header, parentHeader, extendedId = "") {
          this.lodMetricType = "geometricError";
          this.lodMetricValue = 0;
          this.boundingVolume = null;
          this.content = null;
          this.contentState = TILE_CONTENT_STATE.UNLOADED;
          this.gpuMemoryUsageInBytes = 0;
          this.children = [];
          this.depth = 0;
          this.viewportIds = [];
          this.transform = new Matrix4();
          this.extensions = null;
          this.implicitTiling = null;
          this.userData = {};
          this.hasEmptyContent = false;
          this.hasTilesetContent = false;
          this.traverser = new TilesetTraverser({});
          this._cacheNode = null;
          this._frameNumber = null;
          this._expireDate = null;
          this._expiredContent = null;
          this._distanceToCamera = 0;
          this._screenSpaceError = 0;
          this._visible = void 0;
          this._initialTransform = new Matrix4();
          this._priority = 0;
          this._selectedFrame = 0;
          this._requestedFrame = 0;
          this._selectionDepth = 0;
          this._touchedFrame = 0;
          this._centerZDepth = 0;
          this._shouldRefine = false;
          this._stackLength = 0;
          this._visitedFrame = 0;
          this._inRequestVolume = false;
          this._lodJudge = null;
          this.header = header;
          this.tileset = tileset;
          this.id = extendedId || header.id;
          this.url = header.url;
          this.parent = parentHeader;
          this.refine = this._getRefine(header.refine);
          this.type = header.type;
          this.contentUrl = header.contentUrl;
          this._initializeLodMetric(header);
          this._initializeTransforms(header);
          this._initializeBoundingVolumes(header);
          this._initializeContent(header);
          this._initializeRenderingState(header);
          Object.seal(this);
        }
        destroy() {
          this.header = null;
        }
        isDestroyed() {
          return this.header === null;
        }
        get selected() {
          return this._selectedFrame === this.tileset._frameNumber;
        }
        get isVisible() {
          return this._visible;
        }
        get isVisibleAndInRequestVolume() {
          return this._visible && this._inRequestVolume;
        }
        get hasRenderContent() {
          return !this.hasEmptyContent && !this.hasTilesetContent;
        }
        get hasChildren() {
          return this.children.length > 0 || this.header.children && this.header.children.length > 0;
        }
        get contentReady() {
          return this.contentState === TILE_CONTENT_STATE.READY || this.hasEmptyContent;
        }
        get contentAvailable() {
          return Boolean(this.contentReady && this.hasRenderContent || this._expiredContent && !this.contentFailed);
        }
        get hasUnloadedContent() {
          return this.hasRenderContent && this.contentUnloaded;
        }
        get contentUnloaded() {
          return this.contentState === TILE_CONTENT_STATE.UNLOADED;
        }
        get contentExpired() {
          return this.contentState === TILE_CONTENT_STATE.EXPIRED;
        }
        get contentFailed() {
          return this.contentState === TILE_CONTENT_STATE.FAILED;
        }
        get distanceToCamera() {
          return this._distanceToCamera;
        }
        get screenSpaceError() {
          return this._screenSpaceError;
        }
        get boundingBox() {
          if (!this._boundingBox) {
            this._boundingBox = getCartographicBounds(this.header.boundingVolume, this.boundingVolume);
          }
          return this._boundingBox;
        }
        getScreenSpaceError(frameState, useParentLodMetric) {
          switch (this.tileset.type) {
            case TILESET_TYPE.I3S:
              return getProjectedRadius(this, frameState);
            case TILESET_TYPE.TILES3D:
              return getTiles3DScreenSpaceError(this, frameState, useParentLodMetric);
            default:
              throw new Error("Unsupported tileset type");
          }
        }
        unselect() {
          this._selectedFrame = 0;
        }
        _getGpuMemoryUsageInBytes() {
          return this.content.gpuMemoryUsageInBytes || this.content.byteLength || 0;
        }
        _getPriority() {
          const traverser = this.tileset._traverser;
          const { skipLevelOfDetail } = traverser.options;
          const maySkipTile = this.refine === TILE_REFINEMENT.ADD || skipLevelOfDetail;
          if (maySkipTile && !this.isVisible && this._visible !== void 0) {
            return -1;
          }
          if (this.tileset._frameNumber - this._touchedFrame >= 1) {
            return -1;
          }
          if (this.contentState === TILE_CONTENT_STATE.UNLOADED) {
            return -1;
          }
          const parent = this.parent;
          const useParentScreenSpaceError = parent && (!maySkipTile || this._screenSpaceError === 0 || parent.hasTilesetContent);
          const screenSpaceError = useParentScreenSpaceError ? parent._screenSpaceError : this._screenSpaceError;
          const rootScreenSpaceError = traverser.root ? traverser.root._screenSpaceError : 0;
          return Math.max(rootScreenSpaceError - screenSpaceError, 0);
        }
        async loadContent() {
          if (this.hasEmptyContent) {
            return false;
          }
          if (this.content) {
            return true;
          }
          const expired = this.contentExpired;
          if (expired) {
            this._expireDate = null;
          }
          this.contentState = TILE_CONTENT_STATE.LOADING;
          const requestToken = await this.tileset._requestScheduler.scheduleRequest(this.id, this._getPriority.bind(this));
          if (!requestToken) {
            this.contentState = TILE_CONTENT_STATE.UNLOADED;
            return false;
          }
          try {
            const contentUrl = this.tileset.getTileUrl(this.contentUrl);
            const loader = this.tileset.loader;
            const options = {
              ...this.tileset.loadOptions,
              [loader.id]: {
                ...this.tileset.loadOptions[loader.id],
                isTileset: this.type === "json",
                ...this._getLoaderSpecificOptions(loader.id)
              }
            };
            this.content = await load(contentUrl, loader, options);
            if (this.tileset.options.contentLoader) {
              await this.tileset.options.contentLoader(this);
            }
            if (this._isTileset()) {
              this.tileset._initializeTileHeaders(this.content, this);
            }
            this.contentState = TILE_CONTENT_STATE.READY;
            this._onContentLoaded();
            return true;
          } catch (error) {
            this.contentState = TILE_CONTENT_STATE.FAILED;
            throw error;
          } finally {
            requestToken.done();
          }
        }
        unloadContent() {
          if (this.content && this.content.destroy) {
            this.content.destroy();
          }
          this.content = null;
          if (this.header.content && this.header.content.destroy) {
            this.header.content.destroy();
          }
          this.header.content = null;
          this.contentState = TILE_CONTENT_STATE.UNLOADED;
          return true;
        }
        updateVisibility(frameState, viewportIds) {
          if (this._frameNumber === frameState.frameNumber) {
            return;
          }
          const parent = this.parent;
          const parentVisibilityPlaneMask = parent ? parent._visibilityPlaneMask : CullingVolume.MASK_INDETERMINATE;
          if (this.tileset._traverser.options.updateTransforms) {
            const parentTransform = parent ? parent.computedTransform : this.tileset.modelMatrix;
            this._updateTransform(parentTransform);
          }
          this._distanceToCamera = this.distanceToTile(frameState);
          this._screenSpaceError = this.getScreenSpaceError(frameState, false);
          this._visibilityPlaneMask = this.visibility(frameState, parentVisibilityPlaneMask);
          this._visible = this._visibilityPlaneMask !== CullingVolume.MASK_OUTSIDE;
          this._inRequestVolume = this.insideViewerRequestVolume(frameState);
          this._frameNumber = frameState.frameNumber;
          this.viewportIds = viewportIds;
        }
        visibility(frameState, parentVisibilityPlaneMask) {
          const { cullingVolume: cullingVolume2 } = frameState;
          const { boundingVolume } = this;
          return cullingVolume2.computeVisibilityWithPlaneMask(boundingVolume, parentVisibilityPlaneMask);
        }
        contentVisibility() {
          return true;
        }
        distanceToTile(frameState) {
          const boundingVolume = this.boundingVolume;
          return Math.sqrt(Math.max(boundingVolume.distanceSquaredTo(frameState.camera.position), 0));
        }
        cameraSpaceZDepth({ camera }) {
          const boundingVolume = this.boundingVolume;
          scratchVector9.subVectors(boundingVolume.center, camera.position);
          return camera.direction.dot(scratchVector9);
        }
        insideViewerRequestVolume(frameState) {
          const viewerRequestVolume = this._viewerRequestVolume;
          return !viewerRequestVolume || viewerRequestVolume.distanceSquaredTo(frameState.camera.position) <= 0;
        }
        updateExpiration() {
          if (defined2(this._expireDate) && this.contentReady && !this.hasEmptyContent) {
            const now = Date.now();
            if (Date.lessThan(this._expireDate, now)) {
              this.contentState = TILE_CONTENT_STATE.EXPIRED;
              this._expiredContent = this.content;
            }
          }
        }
        get extras() {
          return this.header.extras;
        }
        _initializeLodMetric(header) {
          if ("lodMetricType" in header) {
            this.lodMetricType = header.lodMetricType;
          } else {
            this.lodMetricType = this.parent && this.parent.lodMetricType || this.tileset.lodMetricType;
            console.warn(`3D Tile: Required prop lodMetricType is undefined. Using parent lodMetricType`);
          }
          if ("lodMetricValue" in header) {
            this.lodMetricValue = header.lodMetricValue;
          } else {
            this.lodMetricValue = this.parent && this.parent.lodMetricValue || this.tileset.lodMetricValue;
            console.warn("3D Tile: Required prop lodMetricValue is undefined. Using parent lodMetricValue");
          }
        }
        _initializeTransforms(tileHeader) {
          this.transform = tileHeader.transform ? new Matrix4(tileHeader.transform) : new Matrix4();
          const parent = this.parent;
          const tileset = this.tileset;
          const parentTransform = parent && parent.computedTransform ? parent.computedTransform.clone() : tileset.modelMatrix.clone();
          this.computedTransform = new Matrix4(parentTransform).multiplyRight(this.transform);
          const parentInitialTransform = parent && parent._initialTransform ? parent._initialTransform.clone() : new Matrix4();
          this._initialTransform = new Matrix4(parentInitialTransform).multiplyRight(this.transform);
        }
        _initializeBoundingVolumes(tileHeader) {
          this._contentBoundingVolume = null;
          this._viewerRequestVolume = null;
          this._updateBoundingVolume(tileHeader);
        }
        _initializeContent(tileHeader) {
          this.content = { _tileset: this.tileset, _tile: this };
          this.hasEmptyContent = true;
          this.contentState = TILE_CONTENT_STATE.UNLOADED;
          this.hasTilesetContent = false;
          if (tileHeader.contentUrl) {
            this.content = null;
            this.hasEmptyContent = false;
          }
        }
        _initializeRenderingState(header) {
          this.depth = header.level || (this.parent ? this.parent.depth + 1 : 0);
          this._shouldRefine = false;
          this._distanceToCamera = 0;
          this._centerZDepth = 0;
          this._screenSpaceError = 0;
          this._visibilityPlaneMask = CullingVolume.MASK_INDETERMINATE;
          this._visible = void 0;
          this._inRequestVolume = false;
          this._stackLength = 0;
          this._selectionDepth = 0;
          this._frameNumber = 0;
          this._touchedFrame = 0;
          this._visitedFrame = 0;
          this._selectedFrame = 0;
          this._requestedFrame = 0;
          this._priority = 0;
        }
        _getRefine(refine) {
          return refine || this.parent && this.parent.refine || TILE_REFINEMENT.REPLACE;
        }
        _isTileset() {
          return this.contentUrl.indexOf(".json") !== -1;
        }
        _onContentLoaded() {
          switch (this.content && this.content.type) {
            case "vctr":
            case "geom":
              this.tileset._traverser.disableSkipLevelOfDetail = true;
              break;
            default:
          }
          if (this._isTileset()) {
            this.hasTilesetContent = true;
          } else {
            this.gpuMemoryUsageInBytes = this._getGpuMemoryUsageInBytes();
          }
        }
        _updateBoundingVolume(header) {
          this.boundingVolume = createBoundingVolume(header.boundingVolume, this.computedTransform, this.boundingVolume);
          const content = header.content;
          if (!content) {
            return;
          }
          if (content.boundingVolume) {
            this._contentBoundingVolume = createBoundingVolume(content.boundingVolume, this.computedTransform, this._contentBoundingVolume);
          }
          if (header.viewerRequestVolume) {
            this._viewerRequestVolume = createBoundingVolume(header.viewerRequestVolume, this.computedTransform, this._viewerRequestVolume);
          }
        }
        _updateTransform(parentTransform = new Matrix4()) {
          const computedTransform = parentTransform.clone().multiplyRight(this.transform);
          const didTransformChange = !computedTransform.equals(this.computedTransform);
          if (!didTransformChange) {
            return;
          }
          this.computedTransform = computedTransform;
          this._updateBoundingVolume(this.header);
        }
        _getLoaderSpecificOptions(loaderId) {
          switch (loaderId) {
            case "i3s":
              return {
                ...this.tileset.options.i3s,
                _tileOptions: {
                  attributeUrls: this.header.attributeUrls,
                  textureUrl: this.header.textureUrl,
                  textureFormat: this.header.textureFormat,
                  textureLoaderOptions: this.header.textureLoaderOptions,
                  materialDefinition: this.header.materialDefinition,
                  isDracoGeometry: this.header.isDracoGeometry,
                  mbs: this.header.mbs
                },
                _tilesetOptions: {
                  store: this.tileset.tileset.store,
                  attributeStorageInfo: this.tileset.tileset.attributeStorageInfo,
                  fields: this.tileset.tileset.fields
                },
                isTileHeader: false
              };
            case "3d-tiles":
            case "cesium-ion":
            default:
              return get3dTilesOptions(this.tileset.tileset);
          }
        }
      };
    }
  });

  // src/tileset/format-3d-tiles/tileset-3d-traverser.ts
  var Tileset3DTraverser;
  var init_tileset_3d_traverser = __esm({
    "src/tileset/format-3d-tiles/tileset-3d-traverser.ts"() {
      init_constants3();
      init_tileset_traverser();
      Tileset3DTraverser = class extends TilesetTraverser {
        compareDistanceToCamera(a, b) {
          return b._distanceToCamera === 0 && a._distanceToCamera === 0 ? b._centerZDepth - a._centerZDepth : b._distanceToCamera - a._distanceToCamera;
        }
        updateTileVisibility(tile, frameState) {
          super.updateTileVisibility(tile, frameState);
          if (!tile.isVisibleAndInRequestVolume) {
            return;
          }
          const hasChildren = tile.children.length > 0;
          if (tile.hasTilesetContent && hasChildren) {
            const firstChild = tile.children[0];
            this.updateTileVisibility(firstChild, frameState);
            tile._visible = firstChild._visible;
            return;
          }
          if (this.meetsScreenSpaceErrorEarly(tile, frameState)) {
            tile._visible = false;
            return;
          }
          const replace = tile.refine === TILE_REFINEMENT.REPLACE;
          const useOptimization = tile._optimChildrenWithinParent === TILE3D_OPTIMIZATION_HINT.USE_OPTIMIZATION;
          if (replace && useOptimization && hasChildren) {
            if (!this.anyChildrenVisible(tile, frameState)) {
              tile._visible = false;
              return;
            }
          }
        }
        meetsScreenSpaceErrorEarly(tile, frameState) {
          const { parent } = tile;
          if (!parent || parent.hasTilesetContent || parent.refine !== TILE_REFINEMENT.ADD) {
            return false;
          }
          return !this.shouldRefine(tile, frameState, true);
        }
      };
    }
  });

  // src/tileset/format-i3s/i3s-pending-tiles-register.ts
  var I3SPendingTilesRegister;
  var init_i3s_pending_tiles_register = __esm({
    "src/tileset/format-i3s/i3s-pending-tiles-register.ts"() {
      I3SPendingTilesRegister = class {
        constructor() {
          this.frameNumberMap = new Map();
        }
        register(viewportId, frameNumber) {
          const viewportMap = this.frameNumberMap.get(viewportId) || new Map();
          const oldCount = viewportMap.get(frameNumber) || 0;
          viewportMap.set(frameNumber, oldCount + 1);
          this.frameNumberMap.set(viewportId, viewportMap);
        }
        deregister(viewportId, frameNumber) {
          const viewportMap = this.frameNumberMap.get(viewportId);
          if (!viewportMap) {
            return;
          }
          const oldCount = viewportMap.get(frameNumber) || 1;
          viewportMap.set(frameNumber, oldCount - 1);
        }
        isZero(viewportId, frameNumber) {
          const count = this.frameNumberMap.get(viewportId)?.get(frameNumber) || 0;
          return count === 0;
        }
      };
    }
  });

  // src/tileset/format-i3s/i3s-tile-manager.ts
  var STATUS, I3STileManager;
  var init_i3s_tile_manager = __esm({
    "src/tileset/format-i3s/i3s-tile-manager.ts"() {
      init_i3s_pending_tiles_register();
      STATUS = {
        REQUESTED: "REQUESTED",
        COMPLETED: "COMPLETED",
        ERROR: "ERROR"
      };
      I3STileManager = class {
        constructor() {
          this.pendingTilesRegister = new I3SPendingTilesRegister();
          this._statusMap = {};
        }
        add(request, key, callback, frameState) {
          if (!this._statusMap[key]) {
            const {
              frameNumber,
              viewport: { id }
            } = frameState;
            this._statusMap[key] = { request, callback, key, frameState, status: STATUS.REQUESTED };
            this.pendingTilesRegister.register(id, frameNumber);
            request().then((data) => {
              this._statusMap[key].status = STATUS.COMPLETED;
              const {
                frameNumber: actualFrameNumber,
                viewport: { id: id2 }
              } = this._statusMap[key].frameState;
              this.pendingTilesRegister.deregister(id2, actualFrameNumber);
              this._statusMap[key].callback(data, frameState);
            }).catch((error) => {
              this._statusMap[key].status = STATUS.ERROR;
              const {
                frameNumber: actualFrameNumber,
                viewport: { id: id2 }
              } = this._statusMap[key].frameState;
              this.pendingTilesRegister.deregister(id2, actualFrameNumber);
              callback(error);
            });
          }
        }
        update(key, frameState) {
          if (this._statusMap[key]) {
            const {
              frameNumber,
              viewport: { id }
            } = this._statusMap[key].frameState;
            this.pendingTilesRegister.deregister(id, frameNumber);
            const {
              frameNumber: newFrameNumber,
              viewport: { id: newViewportId }
            } = frameState;
            this.pendingTilesRegister.register(newViewportId, newFrameNumber);
            this._statusMap[key].frameState = frameState;
          }
        }
        find(key) {
          return this._statusMap[key];
        }
        hasPendingTiles(viewportId, frameNumber) {
          return !this.pendingTilesRegister.isZero(viewportId, frameNumber);
        }
      };
    }
  });

  // src/tileset/format-i3s/i3s-tileset-traverser.ts
  var I3STilesetTraverser;
  var init_i3s_tileset_traverser = __esm({
    "src/tileset/format-i3s/i3s-tileset-traverser.ts"() {
      init_src3();
      init_tileset_traverser();
      init_i3s_lod();
      init_tile_3d();
      init_i3s_tile_manager();
      I3STilesetTraverser = class extends TilesetTraverser {
        constructor(options) {
          super(options);
          this._tileManager = new I3STileManager();
        }
        traversalFinished(frameState) {
          return !this._tileManager.hasPendingTiles(frameState.viewport.id, this._frameNumber || 0);
        }
        shouldRefine(tile, frameState) {
          tile._lodJudge = getLodStatus(tile, frameState);
          return tile._lodJudge === "DIG";
        }
        updateChildTiles(tile, frameState) {
          const children = tile.header.children || [];
          const childTiles = tile.children;
          const tileset = tile.tileset;
          for (const child of children) {
            const extendedId = `${child.id}-${frameState.viewport.id}`;
            const childTile = childTiles && childTiles.find((t) => t.id === extendedId);
            if (!childTile) {
              let request = () => this._loadTile(child.id, tileset);
              const cachedRequest = this._tileManager.find(extendedId);
              if (!cachedRequest) {
                if (tileset.tileset.nodePages) {
                  request = () => tileset.tileset.nodePagesTile.formTileFromNodePages(child.id);
                }
                this._tileManager.add(request, extendedId, (header) => this._onTileLoad(header, tile, extendedId), frameState);
              } else {
                this._tileManager.update(extendedId, frameState);
              }
            } else if (childTile) {
              this.updateTile(childTile, frameState);
            }
          }
          return false;
        }
        async _loadTile(nodeId, tileset) {
          const { loader } = tileset;
          const nodeUrl = tileset.getTileUrl(`${tileset.url}/nodes/${nodeId}`);
          const options = {
            ...tileset.loadOptions,
            i3s: {
              ...tileset.loadOptions.i3s,
              isTileHeader: true
            }
          };
          return await load(nodeUrl, loader, options);
        }
        _onTileLoad(header, tile, extendedId) {
          const childTile = new Tile3D(tile.tileset, header, tile, extendedId);
          tile.children.push(childTile);
          const frameState = this._tileManager.find(childTile.id).frameState;
          this.updateTile(childTile, frameState);
          if (this._frameNumber === frameState.frameNumber && (this.traversalFinished(frameState) || new Date().getTime() - this.lastUpdate > this.updateDebounceTime)) {
            this.executeTraversal(childTile, frameState);
          }
        }
      };
    }
  });

  // src/tileset/tileset-3d.ts
  var DEFAULT_PROPS4, TILES_TOTAL, TILES_IN_MEMORY, TILES_IN_VIEW, TILES_RENDERABLE, TILES_LOADED, TILES_LOADING, TILES_UNLOADED, TILES_LOAD_FAILED, POINTS_COUNT, TILES_GPU_MEMORY, Tileset3D;
  var init_tileset_3d = __esm({
    "src/tileset/tileset-3d.ts"() {
      init_esm();
      init_esm2();
      init_esm3();
      init_src2();
      init_tileset_cache();
      init_transform_utils();
      init_frame_state();
      init_zoom();
      init_tile_3d();
      init_constants3();
      init_tileset_traverser();
      init_tileset_3d_traverser();
      init_i3s_tileset_traverser();
      DEFAULT_PROPS4 = {
        description: "",
        ellipsoid: Ellipsoid.WGS84,
        modelMatrix: new Matrix4(),
        throttleRequests: true,
        maxRequests: 64,
        maximumMemoryUsage: 32,
        maximumTilesSelected: 0,
        debounceTime: 0,
        onTileLoad: () => {
        },
        onTileUnload: () => {
        },
        onTileError: () => {
        },
        onTraversalComplete: (selectedTiles) => selectedTiles,
        contentLoader: void 0,
        viewDistanceScale: 1,
        maximumScreenSpaceError: 8,
        loadTiles: true,
        updateTransforms: true,
        viewportTraversersMap: null,
        loadOptions: { fetch: {} },
        attributions: [],
        basePath: "",
        i3s: {}
      };
      TILES_TOTAL = "Tiles In Tileset(s)";
      TILES_IN_MEMORY = "Tiles In Memory";
      TILES_IN_VIEW = "Tiles In View";
      TILES_RENDERABLE = "Tiles To Render";
      TILES_LOADED = "Tiles Loaded";
      TILES_LOADING = "Tiles Loading";
      TILES_UNLOADED = "Tiles Unloaded";
      TILES_LOAD_FAILED = "Failed Tile Loads";
      POINTS_COUNT = "Points/Vertices";
      TILES_GPU_MEMORY = "Tile Memory Use";
      Tileset3D = class {
        constructor(tileset, options) {
          this.root = null;
          this.roots = {};
          this.asset = {};
          this.description = "";
          this.extras = null;
          this.attributions = {};
          this.credits = {};
          this.contentFormats = { draco: false, meshopt: false, dds: false, ktx2: false };
          this.cartographicCenter = null;
          this.cartesianCenter = null;
          this.zoom = 1;
          this.boundingVolume = null;
          this.dynamicScreenSpaceErrorComputedDensity = 0;
          this.maximumMemoryUsage = 32;
          this.gpuMemoryUsageInBytes = 0;
          this._frameNumber = 0;
          this._queryParams = {};
          this._extensionsUsed = [];
          this._tiles = {};
          this._pendingCount = 0;
          this.selectedTiles = [];
          this.traverseCounter = 0;
          this.geometricError = 0;
          this.lastUpdatedVieports = null;
          this._requestedTiles = [];
          this._emptyTiles = [];
          this.frameStateData = {};
          this._cache = new TilesetCache();
          this.updatePromise = null;
          this.options = { ...DEFAULT_PROPS4, ...options };
          this.tileset = tileset;
          this.loader = tileset.loader;
          this.type = tileset.type;
          this.url = tileset.url;
          this.basePath = tileset.basePath || path_exports.dirname(this.url);
          this.modelMatrix = this.options.modelMatrix;
          this.ellipsoid = this.options.ellipsoid;
          this.lodMetricType = tileset.lodMetricType;
          this.lodMetricValue = tileset.lodMetricValue;
          this.refine = tileset.root.refine;
          this.loadOptions = this.options.loadOptions || {};
          this._traverser = this._initializeTraverser();
          this._requestScheduler = new RequestScheduler({
            throttleRequests: this.options.throttleRequests,
            maxRequests: this.options.maxRequests
          });
          this.stats = new Stats({ id: this.url });
          this._initializeStats();
          this.tilesetInitializationPromise = this._initializeTileSet(tileset);
        }
        destroy() {
          this._destroy();
        }
        isLoaded() {
          return this._pendingCount === 0 && this._frameNumber !== 0 && this._requestedTiles.length === 0;
        }
        get tiles() {
          return Object.values(this._tiles);
        }
        get frameNumber() {
          return this._frameNumber;
        }
        get queryParams() {
          return new URLSearchParams(this._queryParams).toString();
        }
        setProps(props) {
          this.options = { ...this.options, ...props };
        }
        setOptions(options) {
          this.options = { ...this.options, ...options };
        }
        getTileUrl(tilePath) {
          const isDataUrl = tilePath.startsWith("data:");
          if (isDataUrl) {
            return tilePath;
          }
          return `${tilePath}${tilePath.includes("?") ? "&" : "?"}${this.queryParams}`;
        }
        hasExtension(extensionName) {
          return Boolean(this._extensionsUsed.indexOf(extensionName) > -1);
        }
        update(viewports = null) {
          this.tilesetInitializationPromise.then(() => {
            if (!viewports && this.lastUpdatedVieports) {
              viewports = this.lastUpdatedVieports;
            } else {
              this.lastUpdatedVieports = viewports;
            }
            if (viewports) {
              this.doUpdate(viewports);
            }
          });
        }
        async selectTiles(viewports = null) {
          await this.tilesetInitializationPromise;
          if (viewports) {
            this.lastUpdatedVieports = viewports;
          }
          if (!this.updatePromise) {
            this.updatePromise = new Promise((resolve2) => {
              setTimeout(() => {
                if (this.lastUpdatedVieports) {
                  this.doUpdate(this.lastUpdatedVieports);
                }
                resolve2(this._frameNumber);
                this.updatePromise = null;
              }, this.options.debounceTime);
            });
          }
          return this.updatePromise;
        }
        doUpdate(viewports) {
          if ("loadTiles" in this.options && !this.options.loadTiles) {
            return;
          }
          if (this.traverseCounter > 0) {
            return;
          }
          const preparedViewports = viewports instanceof Array ? viewports : [viewports];
          this._cache.reset();
          this._frameNumber++;
          this.traverseCounter = preparedViewports.length;
          const viewportsToTraverse = [];
          for (const viewport of preparedViewports) {
            const id = viewport.id;
            if (this._needTraverse(id)) {
              viewportsToTraverse.push(id);
            } else {
              this.traverseCounter--;
            }
          }
          for (const viewport of preparedViewports) {
            const id = viewport.id;
            if (!this.roots[id]) {
              this.roots[id] = this._initializeTileHeaders(this.tileset, null);
            }
            if (!viewportsToTraverse.includes(id)) {
              continue;
            }
            const frameState = getFrameState(viewport, this._frameNumber);
            this._traverser.traverse(this.roots[id], frameState, this.options);
          }
        }
        _needTraverse(viewportId) {
          let traverserId = viewportId;
          if (this.options.viewportTraversersMap) {
            traverserId = this.options.viewportTraversersMap[viewportId];
          }
          if (traverserId !== viewportId) {
            return false;
          }
          return true;
        }
        _onTraversalEnd(frameState) {
          const id = frameState.viewport.id;
          if (!this.frameStateData[id]) {
            this.frameStateData[id] = { selectedTiles: [], _requestedTiles: [], _emptyTiles: [] };
          }
          const currentFrameStateData = this.frameStateData[id];
          const selectedTiles = Object.values(this._traverser.selectedTiles);
          const [filteredSelectedTiles, unselectedTiles] = limitSelectedTiles(selectedTiles, frameState, this.options.maximumTilesSelected);
          currentFrameStateData.selectedTiles = filteredSelectedTiles;
          for (const tile of unselectedTiles) {
            tile.unselect();
          }
          currentFrameStateData._requestedTiles = Object.values(this._traverser.requestedTiles);
          currentFrameStateData._emptyTiles = Object.values(this._traverser.emptyTiles);
          this.traverseCounter--;
          if (this.traverseCounter > 0) {
            return;
          }
          this._updateTiles();
        }
        _updateTiles() {
          this.selectedTiles = [];
          this._requestedTiles = [];
          this._emptyTiles = [];
          for (const frameStateKey in this.frameStateData) {
            const frameStateDataValue = this.frameStateData[frameStateKey];
            this.selectedTiles = this.selectedTiles.concat(frameStateDataValue.selectedTiles);
            this._requestedTiles = this._requestedTiles.concat(frameStateDataValue._requestedTiles);
            this._emptyTiles = this._emptyTiles.concat(frameStateDataValue._emptyTiles);
          }
          this.selectedTiles = this.options.onTraversalComplete(this.selectedTiles);
          for (const tile of this.selectedTiles) {
            this._tiles[tile.id] = tile;
          }
          this._loadTiles();
          this._unloadTiles();
          this._updateStats();
        }
        _tilesChanged(oldSelectedTiles, selectedTiles) {
          if (oldSelectedTiles.length !== selectedTiles.length) {
            return true;
          }
          const set1 = new Set(oldSelectedTiles.map((t) => t.id));
          const set2 = new Set(selectedTiles.map((t) => t.id));
          let changed = oldSelectedTiles.filter((x) => !set2.has(x.id)).length > 0;
          changed = changed || selectedTiles.filter((x) => !set1.has(x.id)).length > 0;
          return changed;
        }
        _loadTiles() {
          for (const tile of this._requestedTiles) {
            if (tile.contentUnloaded) {
              this._loadTile(tile);
            }
          }
        }
        _unloadTiles() {
          this._cache.unloadTiles(this, (tileset, tile) => tileset._unloadTile(tile));
        }
        _updateStats() {
          let tilesRenderable = 0;
          let pointsRenderable = 0;
          for (const tile of this.selectedTiles) {
            if (tile.contentAvailable && tile.content) {
              tilesRenderable++;
              if (tile.content.pointCount) {
                pointsRenderable += tile.content.pointCount;
              } else {
                pointsRenderable += tile.content.vertexCount;
              }
            }
          }
          this.stats.get(TILES_IN_VIEW).count = this.selectedTiles.length;
          this.stats.get(TILES_RENDERABLE).count = tilesRenderable;
          this.stats.get(POINTS_COUNT).count = pointsRenderable;
        }
        async _initializeTileSet(tilesetJson) {
          if (this.type === TILESET_TYPE.I3S) {
            this.calculateViewPropsI3S();
            tilesetJson.root = await tilesetJson.root;
          }
          this.root = this._initializeTileHeaders(tilesetJson, null);
          if (this.type === TILESET_TYPE.TILES3D) {
            this._initializeTiles3DTileset(tilesetJson);
            this.calculateViewPropsTiles3D();
          }
          if (this.type === TILESET_TYPE.I3S) {
            this._initializeI3STileset();
          }
        }
        calculateViewPropsI3S() {
          const fullExtent = this.tileset.fullExtent;
          if (fullExtent) {
            const { xmin, xmax, ymin, ymax, zmin, zmax } = fullExtent;
            this.cartographicCenter = new Vector3(xmin + (xmax - xmin) / 2, ymin + (ymax - ymin) / 2, zmin + (zmax - zmin) / 2);
            this.cartesianCenter = Ellipsoid.WGS84.cartographicToCartesian(this.cartographicCenter, new Vector3());
            this.zoom = getZoomFromFullExtent(fullExtent, this.cartographicCenter, this.cartesianCenter);
            return;
          }
          const extent = this.tileset.store?.extent;
          if (extent) {
            const [xmin, ymin, xmax, ymax] = extent;
            this.cartographicCenter = new Vector3(xmin + (xmax - xmin) / 2, ymin + (ymax - ymin) / 2, 0);
            this.cartesianCenter = Ellipsoid.WGS84.cartographicToCartesian(this.cartographicCenter, new Vector3());
            this.zoom = getZoomFromExtent(extent, this.cartographicCenter, this.cartesianCenter);
            return;
          }
          console.warn("Extent is not defined in the tileset header");
          this.cartographicCenter = new Vector3();
          this.zoom = 1;
          return;
        }
        calculateViewPropsTiles3D() {
          const root = this.root;
          const { center } = root.boundingVolume;
          if (!center) {
            console.warn("center was not pre-calculated for the root tile");
            this.cartographicCenter = new Vector3();
            this.zoom = 1;
            return;
          }
          if (center[0] !== 0 || center[1] !== 0 || center[2] !== 0) {
            this.cartographicCenter = Ellipsoid.WGS84.cartesianToCartographic(center, new Vector3());
          } else {
            this.cartographicCenter = new Vector3(0, 0, -Ellipsoid.WGS84.radii[0]);
          }
          this.cartesianCenter = center;
          this.zoom = getZoomFromBoundingVolume(root.boundingVolume, this.cartographicCenter);
        }
        _initializeStats() {
          this.stats.get(TILES_TOTAL);
          this.stats.get(TILES_LOADING);
          this.stats.get(TILES_IN_MEMORY);
          this.stats.get(TILES_IN_VIEW);
          this.stats.get(TILES_RENDERABLE);
          this.stats.get(TILES_LOADED);
          this.stats.get(TILES_UNLOADED);
          this.stats.get(TILES_LOAD_FAILED);
          this.stats.get(POINTS_COUNT);
          this.stats.get(TILES_GPU_MEMORY, "memory");
        }
        _initializeTileHeaders(tilesetJson, parentTileHeader) {
          const rootTile = new Tile3D(this, tilesetJson.root, parentTileHeader);
          if (parentTileHeader) {
            parentTileHeader.children.push(rootTile);
            rootTile.depth = parentTileHeader.depth + 1;
          }
          if (this.type === TILESET_TYPE.TILES3D) {
            const stack = [];
            stack.push(rootTile);
            while (stack.length > 0) {
              const tile = stack.pop();
              this.stats.get(TILES_TOTAL).incrementCount();
              const children = tile.header.children || [];
              for (const childHeader of children) {
                const childTile = new Tile3D(this, childHeader, tile);
                if (childTile.contentUrl?.includes("?session=")) {
                  const url = new URL(childTile.contentUrl);
                  const session = url.searchParams.get("session");
                  if (session) {
                    this._queryParams.session = session;
                  }
                }
                tile.children.push(childTile);
                childTile.depth = tile.depth + 1;
                stack.push(childTile);
              }
            }
          }
          return rootTile;
        }
        _initializeTraverser() {
          let TraverserClass;
          const type = this.type;
          switch (type) {
            case TILESET_TYPE.TILES3D:
              TraverserClass = Tileset3DTraverser;
              break;
            case TILESET_TYPE.I3S:
              TraverserClass = I3STilesetTraverser;
              break;
            default:
              TraverserClass = TilesetTraverser;
          }
          return new TraverserClass({
            basePath: this.basePath,
            onTraversalEnd: this._onTraversalEnd.bind(this)
          });
        }
        _destroyTileHeaders(parentTile) {
          this._destroySubtree(parentTile);
        }
        async _loadTile(tile) {
          let loaded;
          try {
            this._onStartTileLoading();
            loaded = await tile.loadContent();
          } catch (error) {
            this._onTileLoadError(tile, error instanceof Error ? error : new Error("load failed"));
          } finally {
            this._onEndTileLoading();
            this._onTileLoad(tile, loaded);
          }
        }
        _onTileLoadError(tile, error) {
          this.stats.get(TILES_LOAD_FAILED).incrementCount();
          const message = error.message || error.toString();
          const url = tile.url;
          console.error(`A 3D tile failed to load: ${tile.url} ${message}`);
          this.options.onTileError(tile, message, url);
        }
        _onTileLoad(tile, loaded) {
          if (!loaded) {
            return;
          }
          if (this.type === TILESET_TYPE.I3S) {
            const nodesInNodePages = this.tileset?.nodePagesTile?.nodesInNodePages || 0;
            this.stats.get(TILES_TOTAL).reset();
            this.stats.get(TILES_TOTAL).addCount(nodesInNodePages);
          }
          if (tile && tile.content) {
            calculateTransformProps(tile, tile.content);
          }
          this.updateContentTypes(tile);
          this._addTileToCache(tile);
          this.options.onTileLoad(tile);
        }
        updateContentTypes(tile) {
          if (this.type === TILESET_TYPE.I3S) {
            if (tile.header.isDracoGeometry) {
              this.contentFormats.draco = true;
            }
            switch (tile.header.textureFormat) {
              case "dds":
                this.contentFormats.dds = true;
                break;
              case "ktx2":
                this.contentFormats.ktx2 = true;
                break;
              default:
            }
          } else if (this.type === TILESET_TYPE.TILES3D) {
            const { extensionsRemoved = [] } = tile.content?.gltf || {};
            if (extensionsRemoved.includes("KHR_draco_mesh_compression")) {
              this.contentFormats.draco = true;
            }
            if (extensionsRemoved.includes("EXT_meshopt_compression")) {
              this.contentFormats.meshopt = true;
            }
            if (extensionsRemoved.includes("KHR_texture_basisu")) {
              this.contentFormats.ktx2 = true;
            }
          }
        }
        _onStartTileLoading() {
          this._pendingCount++;
          this.stats.get(TILES_LOADING).incrementCount();
        }
        _onEndTileLoading() {
          this._pendingCount--;
          this.stats.get(TILES_LOADING).decrementCount();
        }
        _addTileToCache(tile) {
          this._cache.add(this, tile, (tileset) => tileset._updateCacheStats(tile));
        }
        _updateCacheStats(tile) {
          this.stats.get(TILES_LOADED).incrementCount();
          this.stats.get(TILES_IN_MEMORY).incrementCount();
          this.gpuMemoryUsageInBytes += tile.gpuMemoryUsageInBytes || 0;
          this.stats.get(TILES_GPU_MEMORY).count = this.gpuMemoryUsageInBytes;
        }
        _unloadTile(tile) {
          this.gpuMemoryUsageInBytes -= tile.gpuMemoryUsageInBytes || 0;
          this.stats.get(TILES_IN_MEMORY).decrementCount();
          this.stats.get(TILES_UNLOADED).incrementCount();
          this.stats.get(TILES_GPU_MEMORY).count = this.gpuMemoryUsageInBytes;
          this.options.onTileUnload(tile);
          tile.unloadContent();
        }
        _destroy() {
          const stack = [];
          if (this.root) {
            stack.push(this.root);
          }
          while (stack.length > 0) {
            const tile = stack.pop();
            for (const child of tile.children) {
              stack.push(child);
            }
            this._destroyTile(tile);
          }
          this.root = null;
        }
        _destroySubtree(tile) {
          const root = tile;
          const stack = [];
          stack.push(root);
          while (stack.length > 0) {
            tile = stack.pop();
            for (const child of tile.children) {
              stack.push(child);
            }
            if (tile !== root) {
              this._destroyTile(tile);
            }
          }
          root.children = [];
        }
        _destroyTile(tile) {
          this._cache.unloadTile(this, tile);
          this._unloadTile(tile);
          tile.destroy();
        }
        _initializeTiles3DTileset(tilesetJson) {
          if (tilesetJson.queryString) {
            const searchParams = new URLSearchParams(tilesetJson.queryString);
            const queryParams = Object.fromEntries(searchParams.entries());
            this._queryParams = { ...this._queryParams, ...queryParams };
          }
          this.asset = tilesetJson.asset;
          if (!this.asset) {
            throw new Error("Tileset must have an asset property.");
          }
          if (this.asset.version !== "0.0" && this.asset.version !== "1.0") {
            throw new Error("The tileset must be 3D Tiles version 0.0 or 1.0.");
          }
          if ("tilesetVersion" in this.asset) {
            this._queryParams.v = this.asset.tilesetVersion;
          }
          this.credits = {
            attributions: this.options.attributions || []
          };
          this.description = this.options.description || "";
          this.properties = tilesetJson.properties;
          this.geometricError = tilesetJson.geometricError;
          this._extensionsUsed = tilesetJson.extensionsUsed || [];
          this.extras = tilesetJson.extras;
        }
        _initializeI3STileset() {
          if (this.loadOptions.i3s && "token" in this.loadOptions.i3s) {
            this._queryParams.token = this.loadOptions.i3s.token;
          }
        }
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    LOD_METRIC_TYPE: () => LOD_METRIC_TYPE,
    TILESET_TYPE: () => TILESET_TYPE,
    TILE_CONTENT_STATE: () => TILE_CONTENT_STATE,
    TILE_REFINEMENT: () => TILE_REFINEMENT,
    TILE_TYPE: () => TILE_TYPE,
    Tile3D: () => Tile3D,
    Tileset3D: () => Tileset3D,
    TilesetCache: () => TilesetCache,
    TilesetTraverser: () => TilesetTraverser,
    calculateTransformProps: () => calculateTransformProps,
    createBoundingVolume: () => createBoundingVolume,
    getFrameState: () => getFrameState,
    getLodStatus: () => getLodStatus
  });
  var init_src4 = __esm({
    "src/index.ts"() {
      init_tileset_3d();
      init_tile_3d();
      init_tileset_traverser();
      init_tileset_cache();
      init_bounding_volume();
      init_transform_utils();
      init_frame_state();
      init_i3s_lod();
      init_constants3();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src4(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
