"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I3STilesetTraverser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _core = require("@loaders.gl/core");
var _tilesetTraverser = require("../tileset-traverser");
var _i3sLod = require("../helpers/i3s-lod");
var _tile3d = require("../tile-3d");
var _i3sTileManager = require("./i3s-tile-manager");
class I3STilesetTraverser extends _tilesetTraverser.TilesetTraverser {
  constructor(options) {
    super(options);
    (0, _defineProperty2.default)(this, "_tileManager", void 0);
    this._tileManager = new _i3sTileManager.I3STileManager();
  }
  traversalFinished(frameState) {
    return !this._tileManager.hasPendingTiles(frameState.viewport.id, this._frameNumber || 0);
  }
  shouldRefine(tile, frameState) {
    tile._lodJudge = (0, _i3sLod.getLodStatus)(tile, frameState);
    return tile._lodJudge === 'DIG';
  }
  updateChildTiles(tile, frameState) {
    const children = tile.header.children || [];
    const childTiles = tile.children;
    const tileset = tile.tileset;
    for (const child of children) {
      const extendedId = "".concat(child.id, "-").concat(frameState.viewport.id);
      const childTile = childTiles && childTiles.find(t => t.id === extendedId);
      if (!childTile) {
        let request = () => this._loadTile(child.id, tileset);
        const cachedRequest = this._tileManager.find(extendedId);
        if (!cachedRequest) {
          if (tileset.tileset.nodePages) {
            request = () => tileset.tileset.nodePagesTile.formTileFromNodePages(child.id);
          }
          this._tileManager.add(request, extendedId, header => this._onTileLoad(header, tile, extendedId), frameState);
        } else {
          this._tileManager.update(extendedId, frameState);
        }
      } else if (childTile) {
        this.updateTile(childTile, frameState);
      }
    }
    return false;
  }
  async _loadTile(nodeId, tileset) {
    const {
      loader
    } = tileset;
    const nodeUrl = tileset.getTileUrl("".concat(tileset.url, "/nodes/").concat(nodeId));
    const options = {
      ...tileset.loadOptions,
      i3s: {
        ...tileset.loadOptions.i3s,
        isTileHeader: true
      }
    };
    return await (0, _core.load)(nodeUrl, loader, options);
  }
  _onTileLoad(header, tile, extendedId) {
    const childTile = new _tile3d.Tile3D(tile.tileset, header, tile, extendedId);
    tile.children.push(childTile);
    const frameState = this._tileManager.find(childTile.id).frameState;
    this.updateTile(childTile, frameState);
    if (this._frameNumber === frameState.frameNumber && (this.traversalFinished(frameState) || new Date().getTime() - this.lastUpdate > this.updateDebounceTime)) {
      this.executeTraversal(childTile, frameState);
    }
  }
}
exports.I3STilesetTraverser = I3STilesetTraverser;
//# sourceMappingURL=i3s-tileset-traverser.js.map