"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateTransformProps = calculateTransformProps;
var _geospatial = require("@math.gl/geospatial");
var _core = require("@math.gl/core");
var _loaderUtils = require("@loaders.gl/loader-utils");
function calculateTransformProps(tileHeader, tile) {
  (0, _loaderUtils.assert)(tileHeader);
  (0, _loaderUtils.assert)(tile);
  const {
    rtcCenter,
    gltfUpAxis
  } = tile;
  const {
    computedTransform,
    boundingVolume: {
      center
    }
  } = tileHeader;
  let modelMatrix = new _core.Matrix4(computedTransform);
  if (rtcCenter) {
    modelMatrix.translate(rtcCenter);
  }
  switch (gltfUpAxis) {
    case 'Z':
      break;
    case 'Y':
      const rotationY = new _core.Matrix4().rotateX(Math.PI / 2);
      modelMatrix = modelMatrix.multiplyRight(rotationY);
      break;
    case 'X':
      const rotationX = new _core.Matrix4().rotateY(-Math.PI / 2);
      modelMatrix = modelMatrix.multiplyRight(rotationX);
      break;
    default:
      break;
  }
  if (tile.isQuantized) {
    modelMatrix.translate(tile.quantizedVolumeOffset).scale(tile.quantizedVolumeScale);
  }
  const cartesianOrigin = new _core.Vector3(center);
  tile.cartesianModelMatrix = modelMatrix;
  tile.cartesianOrigin = cartesianOrigin;
  const cartographicOrigin = _geospatial.Ellipsoid.WGS84.cartesianToCartographic(cartesianOrigin, new _core.Vector3());
  const fromFixedFrameMatrix = _geospatial.Ellipsoid.WGS84.eastNorthUpToFixedFrame(cartesianOrigin);
  const toFixedFrameMatrix = fromFixedFrameMatrix.invert();
  tile.cartographicModelMatrix = toFixedFrameMatrix.multiplyRight(modelMatrix);
  tile.cartographicOrigin = cartographicOrigin;
  if (!tile.coordinateSystem) {
    tile.modelMatrix = tile.cartographicModelMatrix;
  }
}
//# sourceMappingURL=transform-utils.js.map