"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DoublyLinkedList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _doublyLinkedListNode = require("./doubly-linked-list-node");
class DoublyLinkedList {
  constructor() {
    (0, _defineProperty2.default)(this, "head", null);
    (0, _defineProperty2.default)(this, "tail", null);
    (0, _defineProperty2.default)(this, "_length", 0);
  }
  get length() {
    return this._length;
  }
  add(item) {
    const node = new _doublyLinkedListNode.DoublyLinkedListNode(item, this.tail, null);
    if (this.tail) {
      this.tail.next = node;
      this.tail = node;
    } else {
      this.head = node;
      this.tail = node;
    }
    ++this._length;
    return node;
  }
  remove(node) {
    if (!node) {
      return;
    }
    if (node.previous && node.next) {
      node.previous.next = node.next;
      node.next.previous = node.previous;
    } else if (node.previous) {
      node.previous.next = null;
      this.tail = node.previous;
    } else if (node.next) {
      node.next.previous = null;
      this.head = node.next;
    } else {
      this.head = null;
      this.tail = null;
    }
    node.next = null;
    node.previous = null;
    --this._length;
  }
  splice(node, nextNode) {
    if (node === nextNode) {
      return;
    }
    this.remove(nextNode);
    this._insert(node, nextNode);
  }
  _insert(node, nextNode) {
    const oldNodeNext = node.next;
    node.next = nextNode;
    if (this.tail === node) {
      this.tail = nextNode;
    } else {
      oldNodeNext.previous = nextNode;
    }
    nextNode.next = oldNodeNext;
    nextNode.previous = node;
    ++this._length;
  }
}
exports.DoublyLinkedList = DoublyLinkedList;
//# sourceMappingURL=doubly-linked-list.js.map