const stores = {};
/** @internal */
export class Store {
    constructor(kp) {
        this.kp = kp;
        this.data = {};
    }
    static resolve(kp) {
        if (!stores[kp]) {
            stores[kp] = new Store(kp);
        }
        return stores[kp];
    }
    clear() {
        this.data = {};
    }
    drop() {
        this.clear();
        delete stores[this.kp];
    }
    get(key) {
        return this.data[key];
    }
    key(idx) {
        return this.keys()[idx];
    }
    keys() {
        return Object.keys(this.data);
    }
    rm(k) {
        delete this.data[k];
    }
    set(k, v) {
        this.data[k] = v;
    }
}
//# sourceMappingURL=Store.js.map