import { clone, getKeyPrefix, serialiser } from 'localforage-driver-commons';
import { Store } from './Store';
export function _initStorage(options) {
    const opts = options ? clone(options) : {};
    const kp = getKeyPrefix(opts, this._defaultConfig);
    const store = Store.resolve(kp);
    this._dbInfo = opts;
    this._dbInfo.serializer = serialiser;
    this._dbInfo.keyPrefix = kp;
    this._dbInfo.mStore = store;
    return Promise.resolve();
}
//# sourceMappingURL=_initStorage.js.map