import { executeCallback, normaliseKey } from 'localforage-driver-commons';
export function getItem(key$, callback) {
    key$ = normaliseKey(key$);
    const promise = this.ready().then(() => {
        const result = this._dbInfo.mStore.get(key$);
        // Deserialise if the result is not null or undefined
        return result == null ? null : this._dbInfo.serializer.deserialize(result); //tslint:disable-line:triple-equals
    });
    executeCallback(promise, callback);
    return promise;
}
//# sourceMappingURL=getItem.js.map