import { executeCallback } from 'localforage-driver-commons';
export function iterate(iterator, callback) {
    const promise = this.ready().then(() => {
        const store = this._dbInfo.mStore;
        const keys = store.keys();
        for (let i = 0; i < keys.length; i++) {
            let value = store.get(keys[i]);
            // If a result was found, parse it from the serialized
            // string into a JS object. If result isn't truthy, the
            // key is likely undefined and we'll pass it straight
            // to the iterator.
            if (value) {
                value = this._dbInfo.serializer.deserialize(value);
            }
            value = iterator(value, keys[i], i + 1);
            if (value !== undefined) {
                return value;
            }
        }
    });
    executeCallback(promise, callback);
    return promise;
}
//# sourceMappingURL=iterate.js.map