import { executeCallback, normaliseKey } from 'localforage-driver-commons';
export function setItem(key$, value, callback) {
    key$ = normaliseKey(key$);
    const promise = this.ready().then(() => {
        if (value === undefined) {
            value = null;
        }
        // Save the original value to pass to the callback.
        const originalValue = value;
        return new Promise((resolve, reject) => {
            this._dbInfo.serializer.serialize(value, (value$, error) => {
                if (error) {
                    reject(error);
                }
                else {
                    try {
                        this._dbInfo.mStore.set(key$, value$);
                        resolve(originalValue);
                    }
                    catch (e) {
                        reject(e);
                    }
                }
            });
        });
    });
    executeCallback(promise, callback);
    return promise;
}
//# sourceMappingURL=setItem.js.map