var stores = {};
/** @internal */
var Store = /** @class */ (function () {
    function Store(kp) {
        this.kp = kp;
        this.data = {};
    }
    Store.resolve = function (kp) {
        if (!stores[kp]) {
            stores[kp] = new Store(kp);
        }
        return stores[kp];
    };
    Store.prototype.clear = function () {
        this.data = {};
    };
    Store.prototype.drop = function () {
        this.clear();
        delete stores[this.kp];
    };
    Store.prototype.get = function (key) {
        return this.data[key];
    };
    Store.prototype.key = function (idx) {
        return this.keys()[idx];
    };
    Store.prototype.keys = function () {
        return Object.keys(this.data);
    };
    Store.prototype.rm = function (k) {
        delete this.data[k];
    };
    Store.prototype.set = function (k, v) {
        this.data[k] = v;
    };
    return Store;
}());
export { Store };
//# sourceMappingURL=Store.js.map