import { executeCallback, normaliseKey } from 'localforage-driver-commons';
export function setItem(key$, value, callback) {
    var _this = this;
    key$ = normaliseKey(key$);
    var promise = this.ready().then(function () {
        if (value === undefined) {
            value = null;
        }
        // Save the original value to pass to the callback.
        var originalValue = value;
        return new Promise(function (resolve, reject) {
            _this._dbInfo.serializer.serialize(value, function (value$, error) {
                if (error) {
                    reject(error);
                }
                else {
                    try {
                        _this._dbInfo.mStore.set(key$, value$);
                        resolve(originalValue);
                    }
                    catch (e) {
                        reject(e);
                    }
                }
            });
        });
    });
    executeCallback(promise, callback);
    return promise;
}
//# sourceMappingURL=setItem.js.map