/*!
MIT License

Copyright (c) 2018 Arturas Molcanovas <a.molcanovas@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

*/


(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define('localforage-driver-memory', ['exports'], factory) :
    factory(global.LocalforageDriverMemory = {});
}(typeof self !== 'undefined' ? self : this, function (exports) { 'use strict';

    var _driver = 'localforage-driver-memory';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    /*!
    MIT License

    Copyright (c) 2018 Arturas Molcanovas <a.molcanovas@gmail.com>

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.

    */

    /**
     * Abstracts constructing a Blob object, so it also works in older
     * browsers that don't support the native Blob constructor. (i.e.
     * old QtWebKit versions, at least).
     * Abstracts constructing a Blob object, so it also works in older
     * browsers that don't support the native Blob constructor. (i.e.
     * old QtWebKit versions, at least).
     *
     * @param parts
     * @param properties
     */
    function createBlob(parts, properties) {
        /* global BlobBuilder,MSBlobBuilder,MozBlobBuilder,WebKitBlobBuilder */
        parts = parts || [];
        properties = properties || {};
        try {
            return new Blob(parts, properties);
        }
        catch (e) {
            if (e.name !== 'TypeError') {
                throw e;
            }
            //tslint:disable-next-line:variable-name
            var Builder = typeof BlobBuilder !== 'undefined' ? BlobBuilder
                : typeof MSBlobBuilder !== 'undefined' ? MSBlobBuilder
                    : typeof MozBlobBuilder !== 'undefined' ? MozBlobBuilder
                        : WebKitBlobBuilder;
            var builder = new Builder();
            for (var i = 0; i < parts.length; i += 1) {
                builder.append(parts[i]);
            }
            return builder.getBlob(properties.type);
        }
    }

    var BLOB_TYPE_PREFIX_REGEX = /^~~local_forage_type~([^~]+)~/;
    var SERIALIZED_MARKER_LENGTH = "__lfsc__:" /* SERIALIZED_MARKER */.length;
    var TYPE_SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER_LENGTH + "arbf" /* TYPE_ARRAYBUFFER */.length;
    //tslint:disable:no-magic-numbers no-bitwise prefer-switch no-unbound-method
    var toString = Object.prototype.toString;
    function stringToBuffer(serializedString) {
        // Fill the string into a ArrayBuffer.
        var bufferLength = serializedString.length * 0.75;
        var len = serializedString.length;
        if (serializedString[serializedString.length - 1] === '=') {
            bufferLength--;
            if (serializedString[serializedString.length - 2] === '=') {
                bufferLength--;
            }
        }
        var buffer = new ArrayBuffer(bufferLength);
        var bytes = new Uint8Array(buffer);
        for (var i = 0, p = 0; i < len; i += 4) {
            var encoded1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */.indexOf(serializedString[i]);
            var encoded2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */.indexOf(serializedString[i + 1]);
            var encoded3 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */.indexOf(serializedString[i + 2]);
            var encoded4 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */.indexOf(serializedString[i + 3]);
            bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
            bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
            bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
        }
        return buffer;
    }
    /**
     * Converts a buffer to a string to store, serialized, in the backend
     * storage library.
     */
    function bufferToString(buffer) {
        // base64-arraybuffer
        var bytes = new Uint8Array(buffer);
        var base64String = '';
        for (var i = 0; i < bytes.length; i += 3) {
            /*jslint bitwise: true */
            base64String += "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */[bytes[i] >> 2];
            base64String += "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
            base64String +=
                "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
            base64String += "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" /* BASE_CHARS */[bytes[i + 2] & 63];
        }
        if (bytes.length % 3 === 2) {
            base64String = base64String.substring(0, base64String.length - 1) + '=';
        }
        else if (bytes.length % 3 === 1) {
            base64String = base64String.substring(0, base64String.length - 2) + '==';
        }
        return base64String;
    }
    /**
     * Serialize a value, afterwards executing a callback (which usually
     * instructs the `setItem()` callback/promise to be executed). This is how
     * we store binary data with localStorage.
     * @param value
     * @param callback
     */
    function serialize(value, callback) {
        var valueType = '';
        if (value) {
            valueType = toString.call(value);
        }
        // Cannot use `value instanceof ArrayBuffer` or such here, as these
        // checks fail when running the tests using casper.js...
        if (value && (valueType === '[object ArrayBuffer]' ||
            (value.buffer && toString.call(value.buffer) === '[object ArrayBuffer]'))) {
            // Convert binary arrays to a string and prefix the string with
            // a special marker.
            var buffer = void 0;
            var marker = "__lfsc__:" /* SERIALIZED_MARKER */;
            if (value instanceof ArrayBuffer) {
                buffer = value;
                marker += "arbf" /* TYPE_ARRAYBUFFER */;
            }
            else {
                buffer = value.buffer;
                if (valueType === '[object Int8Array]') {
                    marker += "si08" /* TYPE_INT8ARRAY */;
                }
                else if (valueType === '[object Uint8Array]') {
                    marker += "ui08" /* TYPE_UINT8ARRAY */;
                }
                else if (valueType === '[object Uint8ClampedArray]') {
                    marker += "uic8" /* TYPE_UINT8CLAMPEDARRAY */;
                }
                else if (valueType === '[object Int16Array]') {
                    marker += "si16" /* TYPE_INT16ARRAY */;
                }
                else if (valueType === '[object Uint16Array]') {
                    marker += "ur16" /* TYPE_UINT16ARRAY */;
                }
                else if (valueType === '[object Int32Array]') {
                    marker += "si32" /* TYPE_INT32ARRAY */;
                }
                else if (valueType === '[object Uint32Array]') {
                    marker += "ui32" /* TYPE_UINT32ARRAY */;
                }
                else if (valueType === '[object Float32Array]') {
                    marker += "fl32" /* TYPE_FLOAT32ARRAY */;
                }
                else if (valueType === '[object Float64Array]') {
                    marker += "fl64" /* TYPE_FLOAT64ARRAY */;
                }
                else {
                    callback(new Error('Failed to get type for BinaryArray'));
                }
            }
            callback(marker + bufferToString(buffer));
        }
        else if (valueType === '[object Blob]') {
            // Convert the blob to a binaryArray and then to a string.
            var fileReader = new FileReader();
            fileReader.onload = function () {
                // Backwards-compatible prefix for the blob type.
                //tslint:disable-next-line:restrict-plus-operands
                var str = "~~local_forage_type~" /* BLOB_TYPE_PREFIX */ + value.type + "~" + bufferToString(this.result);
                callback("__lfsc__:" /* SERIALIZED_MARKER */ + "blob" /* TYPE_BLOB */ + str);
            };
            fileReader.readAsArrayBuffer(value);
        }
        else {
            try {
                callback(JSON.stringify(value));
            }
            catch (e) {
                console.error('Couldn\'t convert value into a JSON string: ', value);
                callback(null, e);
            }
        }
    }
    /**
     * Deserialize data we've inserted into a value column/field. We place
     * special markers into our strings to mark them as encoded; this isn't
     * as nice as a meta field, but it's the only sane thing we can do whilst
     * keeping localStorage support intact.
     *
     * Oftentimes this will just deserialize JSON content, but if we have a
     * special marker (SERIALIZED_MARKER, defined above), we will extract
     * some kind of arraybuffer/binary data/typed array out of the string.
     * @param value
     */
    function deserialize(value) {
        // If we haven't marked this string as being specially serialized (i.e.
        // something other than serialized JSON), we can just return it and be
        // done with it.
        if (value.substring(0, SERIALIZED_MARKER_LENGTH) !== "__lfsc__:" /* SERIALIZED_MARKER */) {
            return JSON.parse(value);
        }
        // The following code deals with deserializing some kind of Blob or
        // TypedArray. First we separate out the type of data we're dealing
        // with from the data itself.
        var serializedString = value.substring(TYPE_SERIALIZED_MARKER_LENGTH);
        var type = value.substring(SERIALIZED_MARKER_LENGTH, TYPE_SERIALIZED_MARKER_LENGTH);
        var blobType;
        // Backwards-compatible blob type serialization strategy.
        // DBs created with older versions of localForage will simply not have the blob type.
        if (type === "blob" /* TYPE_BLOB */ && BLOB_TYPE_PREFIX_REGEX.test(serializedString)) {
            var matcher = serializedString.match(BLOB_TYPE_PREFIX_REGEX);
            blobType = matcher[1];
            serializedString = serializedString.substring(matcher[0].length);
        }
        var buffer = stringToBuffer(serializedString);
        // Return the right type based on the code/type set during
        // serialization.
        switch (type) {
            case "arbf" /* TYPE_ARRAYBUFFER */:
                return buffer;
            case "blob" /* TYPE_BLOB */:
                return createBlob([buffer], { type: blobType });
            case "si08" /* TYPE_INT8ARRAY */:
                return new Int8Array(buffer);
            case "ui08" /* TYPE_UINT8ARRAY */:
                return new Uint8Array(buffer);
            case "uic8" /* TYPE_UINT8CLAMPEDARRAY */:
                return new Uint8ClampedArray(buffer);
            case "si16" /* TYPE_INT16ARRAY */:
                return new Int16Array(buffer);
            case "ur16" /* TYPE_UINT16ARRAY */:
                return new Uint16Array(buffer);
            case "si32" /* TYPE_INT32ARRAY */:
                return new Int32Array(buffer);
            case "ui32" /* TYPE_UINT32ARRAY */:
                return new Uint32Array(buffer);
            case "fl32" /* TYPE_FLOAT32ARRAY */:
                return new Float32Array(buffer);
            case "fl64" /* TYPE_FLOAT64ARRAY */:
                return new Float64Array(buffer);
            default:
                throw new Error('Unkown type: ' + type);
        }
    }

    function clone(obj) {
        var e_1, _a;
        if (obj === null || typeof (obj) !== 'object' || 'isActiveClone' in obj) {
            return obj;
        }
        var temp = obj instanceof Date ? new Date(obj) : (obj.constructor());
        try {
            for (var _b = __values(Object.keys(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    obj['isActiveClone'] = null;
                    temp[key] = clone(obj[key]);
                    delete obj['isActiveClone'];
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return temp;
    }

    function getKeyPrefix(options, defaultConfig) {
        return (options.name || defaultConfig.name) + "/" + (options.storeName || defaultConfig.storeName) + "/";
    }

    function executeCallback(promise, callback) {
        if (callback) {
            promise.then(function (result) {
                callback(null, result);
            }, function (error) {
                callback(error);
            });
        }
    }

    function getCallback() {
        var _args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            _args[_i] = arguments[_i];
        }
        if (arguments.length && typeof arguments[arguments.length - 1] === 'function') {
            return arguments[arguments.length - 1];
        }
    }

    //tslint:disable-next-line:no-ignored-initial-value
    function dropInstanceCommon(options, callback) {
        var _this = this;
        callback = getCallback.apply(this, arguments);
        options = (typeof options !== 'function' && options) || {};
        if (!options.name) {
            var currentConfig = this.config();
            options.name = options.name || currentConfig.name;
            options.storeName = options.storeName || currentConfig.storeName;
        }
        var promise;
        if (!options.name) {
            promise = Promise.reject('Invalid arguments');
        }
        else {
            promise = new Promise(function (resolve) {
                if (!options.storeName) {
                    resolve(options.name + "/");
                }
                else {
                    resolve(getKeyPrefix(options, _this._defaultConfig));
                }
            });
        }
        return { promise: promise, callback: callback };
    }

    function normaliseKey(key) {
        // Cast the key to a string, as that's all we can set as a key.
        if (typeof key !== 'string') {
            console.warn(key + " used as a key, but it is not a string.");
            key = String(key);
        }
        return key;
    }

    var serialiser = {
        bufferToString: bufferToString,
        deserialize: deserialize,
        serialize: serialize,
        stringToBuffer: stringToBuffer
    };

    var stores = {};
    /** @internal */
    var Store = /** @class */ (function () {
        function Store(kp) {
            this.kp = kp;
            this.data = {};
        }
        Store.resolve = function (kp) {
            if (!stores[kp]) {
                stores[kp] = new Store(kp);
            }
            return stores[kp];
        };
        Store.prototype.clear = function () {
            this.data = {};
        };
        Store.prototype.drop = function () {
            this.clear();
            delete stores[this.kp];
        };
        Store.prototype.get = function (key) {
            return this.data[key];
        };
        Store.prototype.key = function (idx) {
            return this.keys()[idx];
        };
        Store.prototype.keys = function () {
            return Object.keys(this.data);
        };
        Store.prototype.rm = function (k) {
            delete this.data[k];
        };
        Store.prototype.set = function (k, v) {
            this.data[k] = v;
        };
        return Store;
    }());

    function _initStorage(options) {
        var opts = options ? clone(options) : {};
        var kp = getKeyPrefix(opts, this._defaultConfig);
        var store = Store.resolve(kp);
        this._dbInfo = opts;
        this._dbInfo.serializer = serialiser;
        this._dbInfo.keyPrefix = kp;
        this._dbInfo.mStore = store;
        return Promise.resolve();
    }

    function clear(callback) {
        var _this = this;
        var promise = this.ready().then(function () {
            _this._dbInfo.mStore.clear();
        });
        executeCallback(promise, callback);
        return promise;
    }

    function dropInstance(_options, _cb) {
        var _a = dropInstanceCommon.apply(this, arguments), promise = _a.promise, callback = _a.callback;
        var outPromise = promise.then(function (keyPrefix) {
            Store.resolve(keyPrefix).drop();
        });
        executeCallback(outPromise, callback);
        return promise;
    }

    function getItem(key$, callback) {
        var _this = this;
        key$ = normaliseKey(key$);
        var promise = this.ready().then(function () {
            var result = _this._dbInfo.mStore.get(key$);
            // Deserialise if the result is not null or undefined
            return result == null ? null : _this._dbInfo.serializer.deserialize(result); //tslint:disable-line:triple-equals
        });
        executeCallback(promise, callback);
        return promise;
    }

    function iterate(iterator, callback) {
        var _this = this;
        var promise = this.ready().then(function () {
            var store = _this._dbInfo.mStore;
            var keys = store.keys();
            for (var i = 0; i < keys.length; i++) {
                var value = store.get(keys[i]);
                // If a result was found, parse it from the serialized
                // string into a JS object. If result isn't truthy, the
                // key is likely undefined and we'll pass it straight
                // to the iterator.
                if (value) {
                    value = _this._dbInfo.serializer.deserialize(value);
                }
                value = iterator(value, keys[i], i + 1);
                if (value !== undefined) {
                    return value;
                }
            }
        });
        executeCallback(promise, callback);
        return promise;
    }

    function key(idx, callback) {
        var _this = this;
        var promise = this.ready().then(function () {
            var result;
            try {
                result = _this._dbInfo.mStore.key(idx);
                if (result === undefined) {
                    result = null;
                }
            }
            catch (_a) {
                result = null;
            }
            return result;
        });
        executeCallback(promise, callback);
        return promise;
    }

    function keys(callback) {
        var _this = this;
        var promise = this.ready().then(function () {
            return _this._dbInfo.mStore.keys();
        });
        executeCallback(promise, callback);
        return promise;
    }

    function length(callback) {
        var promise = this.keys().then(function (keys$) { return keys$.length; });
        executeCallback(promise, callback);
        return promise;
    }

    function removeItem(key$, callback) {
        var _this = this;
        key$ = normaliseKey(key$);
        var promise = this.ready().then(function () {
            _this._dbInfo.mStore.rm(key$);
        });
        executeCallback(promise, callback);
        return promise;
    }

    function setItem(key$, value, callback) {
        var _this = this;
        key$ = normaliseKey(key$);
        var promise = this.ready().then(function () {
            if (value === undefined) {
                value = null;
            }
            // Save the original value to pass to the callback.
            var originalValue = value;
            return new Promise(function (resolve, reject) {
                _this._dbInfo.serializer.serialize(value, function (value$, error) {
                    if (error) {
                        reject(error);
                    }
                    else {
                        try {
                            _this._dbInfo.mStore.set(key$, value$);
                            resolve(originalValue);
                        }
                        catch (e) {
                            reject(e);
                        }
                    }
                });
            });
        });
        executeCallback(promise, callback);
        return promise;
    }

    var _support = true;

    exports._support = _support;
    exports._driver = _driver;
    exports._initStorage = _initStorage;
    exports.clear = clear;
    exports.dropInstance = dropInstance;
    exports.getItem = getItem;
    exports.iterate = iterate;
    exports.key = key;
    exports.keys = keys;
    exports.length = length;
    exports.removeItem = removeItem;
    exports.setItem = setItem;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=umd.js.map
