"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var localforage_driver_commons_1 = require("localforage-driver-commons");
function iterate(iterator, callback) {
    var _this = this;
    var promise = this.ready().then(function () {
        var store = _this._dbInfo.mStore;
        var keys = store.keys();
        for (var i = 0; i < keys.length; i++) {
            var value = store.get(keys[i]);
            // If a result was found, parse it from the serialized
            // string into a JS object. If result isn't truthy, the
            // key is likely undefined and we'll pass it straight
            // to the iterator.
            if (value) {
                value = _this._dbInfo.serializer.deserialize(value);
            }
            value = iterator(value, keys[i], i + 1);
            if (value !== undefined) {
                return value;
            }
        }
    });
    localforage_driver_commons_1.executeCallback(promise, callback);
    return promise;
}
exports.iterate = iterate;
//# sourceMappingURL=iterate.js.map