"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var localforage_driver_commons_1 = require("localforage-driver-commons");
function setItem(key$, value, callback) {
    var _this = this;
    key$ = localforage_driver_commons_1.normaliseKey(key$);
    var promise = this.ready().then(function () {
        if (value === undefined) {
            value = null;
        }
        // Save the original value to pass to the callback.
        var originalValue = value;
        return new Promise(function (resolve, reject) {
            _this._dbInfo.serializer.serialize(value, function (value$, error) {
                if (error) {
                    reject(error);
                }
                else {
                    try {
                        _this._dbInfo.mStore.set(key$, value$);
                        resolve(originalValue);
                    }
                    catch (e) {
                        reject(e);
                    }
                }
            });
        });
    });
    localforage_driver_commons_1.executeCallback(promise, callback);
    return promise;
}
exports.setItem = setItem;
//# sourceMappingURL=setItem.js.map