import baseRandom from './_baseRandom';
import isArrayLike from './isArrayLike';
import values from './values';

/**
 * Gets a random element from `collection`.
 *
 * @static
 * @memberOf _
 * @category Collection
 * @param {Array|Object} collection The collection to sample.
 * @returns {*} Returns the random element.
 * @example
 *
 * _.sample([1, 2, 3, 4]);
 * // => 2
 */
function sample(collection) {
  var array = isArrayLike(collection) ? collection : values(collection),
      length = array.length;

  return length > 0 ? array[baseRandom(0, length - 1)] : undefined;
}

export default sample;
