import type { Reviver } from './types';
/**
 * Revive a json object.
 * Applies the reviver function recursively on all values in the JSON object.
 * @param json   A JSON Object, Array, or value
 * @param reviver
 *              A reviver function invoked with arguments `key` and `value`,
 *              which must return a replacement value. The function context
 *              (`this`) is the Object or Array that contains the currently
 *              handled value.
 */
export declare function revive(json: unknown, reviver: Reviver): unknown;
//# sourceMappingURL=revive.d.ts.map