<p align="center">
  <a href="https://github.com/lucide-icons/lucide">
    <img src="https://lucide.dev/package-logos/lucide-static.svg" alt="Lucide icon library with static assets for web applications" width="540">
  </a>
</p>

<p align="center">
Lucide icon library with static assets for web applications.
</p>

<div align="center">

  [![npm](https://img.shields.io/npm/v/lucide-static?color=blue)](https://www.npmjs.com/package/lucide-static)
  ![NPM Downloads](https://img.shields.io/npm/dw/lucide-static)
  [![GitHub](https://img.shields.io/github/license/lucide-icons/lucide)](https://lucide.dev/license)
</div>

<p align="center">
  <a href="https://lucide.dev/guide/">About</a>
  ·
  <a href="https://lucide.dev/icons/">Icons</a>
  ·
  <a href="https://lucide.dev/guide/packages/lucide-static">Documentation</a>
  ·
  <a href="https://lucide.dev/license">License</a>
</p>

# Lucide Static

This package include the following lucide implementations:

- All svg files
- Javascript library containing strings of svgs.
- Icon fonts
- Svg sprite

> What is lucide? Read it [here](https://github.com/lucide-icons/lucide#what-is-lucide).

## Why lucide-static?

This package is suitable for very specific use cases for example if you want to use icon fonts, svg sprites, normal svgs or Common.js Svg strings in your javascript project.

> [!WARNING]
> It is not recommended to use this package for svg sprites or icon fonts for web pages/applications, for prototyping it is ok. We recommend to bundlers for web applications to make sure you only bundle the used icons from this icon library (Threeshaking). Otherwise it will load all the icons, making you webpage loading slower. Threeshaking is only available in the packages: [lucide](https://github.com/lucide-icons/lucide/tree/main/packages/lucide), [lucide-react](https://github.com/lucide-icons/lucide/tree/main/packages/lucide-react), [lucide-vue](https://github.com/lucide-icons/lucide/tree/main/packages/lucide-vue), [lucide-vue-next](https://github.com/lucide-icons/lucide/tree/main/packages/lucide-vue-next), [lucide-angular](https://github.com/lucide-icons/lucide/tree/main/packages/lucide-angular), [lucide-preact](https://github.com/lucide-icons/lucide/tree/main/packages/lucide-preact)

## Installation

```sh
pnpm add lucide-static
```

```sh
npm install lucide-static
```

```sh
yarn add lucide-static
```

```sh
bun add lucide-static
```

## Documentation

For full documentation, visit [lucide.dev](https://lucide.dev/guide/packages/lucide-static)

## Community

Join the [Discord server](https://discord.gg/EH6nSts) to chat with the maintainers and other users.

## License

Lucide is licensed under the ISC license. See [LICENSE](https://lucide.dev/license).

## Sponsors

<a href="https://vercel.com?utm_source=lucide&utm_campaign=oss">
  <img src="https://lucide.dev/vercel.svg" alt="Powered by Vercel" width="200" />
</a>

<a href="https://www.digitalocean.com/?refcode=b0877a2caebd&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=badge"><img src="https://lucide.dev/digitalocean.svg" width="200" alt="DigitalOcean Referral Badge" /></a>

### Awesome backers 🍺

<a href="https://www.scipress.io?utm_source=lucide"><img src="https://lucide.dev/sponsors/scipress.svg" width="180" alt="Scipress sponsor badge" /></a>
<a href="https://github.com/pdfme/pdfme"><img src="https://lucide.dev/sponsors/pdfme.svg" width="180" alt="pdfme sponsor badge" /></a>
