// media has utility functions for image, video and audio manipulation (and
// maybe others like device, etc).

/* eslint-disable */ // TODO - this file needs cleanup
import { Program } from '../webgl';
import { Plane } from '../models';
import { PerspectiveCamera } from '../core/camera';
import Scene from '../deprecated/scenegraph';
import { splat } from '../utils';

// length given a 45 fov angle, and 0.2 distance to camera
var length = 0.16568542494923805;
var camera = new PerspectiveCamera({
  fov: 45,
  aspect: 1,
  near: 0.1,
  far: 500,
  position: [0, 0, 0.2]
});

// post process an image by setting it to a texture with a specified fragment
// and vertex shader.
export function postProcessImage() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      program = _ref.program,
      fromTexture = _ref.fromTexture,
      toFrameBuffer = _ref.toFrameBuffer,
      toScreen = _ref.toScreen,
      width = _ref.width,
      height = _ref.height,
      _ref$viewportX = _ref.viewportX,
      viewportX = _ref$viewportX === undefined ? 0 : _ref$viewportX,
      _ref$viewportY = _ref.viewportY,
      viewportY = _ref$viewportY === undefined ? 0 : _ref$viewportY,
      _ref$aspectRatio = _ref.aspectRatio,
      aspectRatio = _ref$aspectRatio === undefined ? Math.max(height / width, width / height) : _ref$aspectRatio;

  var textures = opt.fromTexture ? splat(opt.fromTexture) : [];
  var framebuffer = opt.toFrameBuffer;
  var screen = !!opt.toScreen;
  var width = opt.width || app.canvas.width;
  var height = opt.height || app.canvas.height;
  var x = opt.viewportX;
  var y = opt.viewportY;

  var plane = new Plane({
    program: program,
    type: 'x,y',
    xlen: length,
    ylen: length,
    offset: 0
  });
  plane.textures = textures;
  plane.program = program;

  camera.aspect = opt.aspectRatio;
  camera.update();

  var scene = new Scene(app, program, camera);
  scene.program = program;

  if (!scene.models.length) {
    scene.add(plane);
  }

  var fbo = new FrameBuffer(framebuffer, {
    width: width,
    height: height,
    bindToTexture: {
      parameters: [{
        name: 'TEXTURE_MAG_FILTER',
        value: 'LINEAR'
      }, {
        name: 'TEXTURE_MIN_FILTER',
        value: 'LINEAR',
        generateMipmap: false
      }]
    },
    bindToRenderBuffer: false
  });

  fbo.bind();
  gl.viewport(x, y, width, height);
  gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
  program.setUniforms(opt.uniforms || {});
  scene.renderToTexture(framebuffer);
  app.setFrameBuffer(framebuffer, false);

  if (screen) {
    program.use();
    gl.viewport(x, y, width, height);
    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
    program.setUniforms(opt.uniforms || {});
    scene.render();
  }

  return this;
}
//# sourceMappingURL=data:application/json;base64,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