var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* eslint-disable */
// An adaptation of the THREE.js stats helpers (MIT licensed)
// https://github.com/mrdoob/stats.js
// https://github.com/jeromeetienne/threex.rendererstats

/**
 * @author mrdoob / http://mrdoob.com/
 */

/* global document, window */
var PR = Math.round(window.devicePixelRatio || 1);

var WIDTH = 80 * PR;
var HEIGHT = 48 * PR;
var TEXT_X = 3 * PR;
var TEXT_Y = 2 * PR;
var GRAPH_X = 3 * PR;
var GRAPH_Y = 15 * PR;
var GRAPH_WIDTH = 74 * PR;
var GRAPH_HEIGHT = 30 * PR;

export var Panel = function () {

  /* eslint-disable max-statements */
  function Panel(name, fg, bg) {
    _classCallCheck(this, Panel);

    var canvas = document.createElement('canvas');
    canvas.width = WIDTH;
    canvas.height = HEIGHT;
    canvas.style.cssText = 'width:80px;height:48px';

    var context = canvas.getContext('2d');
    context.font = 'bold ' + 9 * PR + 'px Helvetica,Arial,sans-serif';
    context.textBaseline = 'top';

    context.fillStyle = bg;
    context.fillRect(0, 0, WIDTH, HEIGHT);

    context.fillStyle = fg;
    context.fillText(name, TEXT_X, TEXT_Y);
    context.fillRect(GRAPH_X, GRAPH_Y, GRAPH_WIDTH, GRAPH_HEIGHT);

    context.fillStyle = bg;
    context.globalAlpha = 0.9;
    context.fillRect(GRAPH_X, GRAPH_Y, GRAPH_WIDTH, GRAPH_HEIGHT);

    this.name = name;
    this.fg = fg;
    this.bg = bg;
    this.context = context;
    this.dom = canvas;
  }
  /* eslint-enable max-statements */

  _createClass(Panel, [{
    key: 'update',
    value: function update(_ref) {
      var value = _ref.value,
          maxValue = _ref.maxValue;

      var min = Math.min(min, value);
      var max = Math.max(max, value);

      this.context.fillStyle = this.bg;
      this.context.globalAlpha = 1;
      this.context.fillRect(0, 0, WIDTH, GRAPH_Y);
      this.context.fillStyle = this.fg;

      var round = Math.round;
      this.context.fillText(round(value) + ' ' + this.name + ' (' + round(min) + '-' + round(max) + ')', TEXT_X, TEXT_Y);

      this.context.drawImage(this.canvas, GRAPH_X + PR, GRAPH_Y, GRAPH_WIDTH - PR, GRAPH_HEIGHT, GRAPH_X, GRAPH_Y, GRAPH_WIDTH - PR, GRAPH_HEIGHT);

      this.context.fillRect(GRAPH_X + GRAPH_WIDTH - PR, GRAPH_Y, PR, GRAPH_HEIGHT);

      this.context.fillStyle = this.bg;
      this.context.globalAlpha = 0.9;
      this.context.fillRect(GRAPH_X + GRAPH_WIDTH - PR, GRAPH_Y, PR, Math.round((1 - value / maxValue) * GRAPH_HEIGHT));
    }
  }]);

  return Panel;
}();

var Stats = function () {
  function Stats() {
    var _this = this;

    _classCallCheck(this, Stats);

    this.performance = window.performance;

    this.mode = 0;

    var container = document.createElement('div');
    container.style.cssText = 'position:fixed;top:0;left:0;cursor:pointer;opacity:0.9;z-index:10000';

    container.addEventListener('click', function (event) {
      event.preventDefault();
      _this.showPanel(++_this.mode % _this.container.children.length);
    }, false);

    //
    this.beginTime = (this.performance || Date).now();
    this.prevTime = this.beginTime;
    this.frames = 0;

    this.fpsPanel = this.addPanel(new Stats.Panel('FPS', '#0ff', '#002'));
    this.msPanel = this.addPanel(new Stats.Panel('MS', '#0f0', '#020'));
    if (this.performance && this.performance.memory) {
      this.memPanel = this.addPanel(new Stats.Panel('MB', '#f08', '#201'));
    }

    this.showPanel(0);

    this.dom = container;
  }

  _createClass(Stats, [{
    key: 'addPanel',
    value: function addPanel(panel) {
      this.container.appendChild(panel.dom);
      return panel;
    }

    // Shows selected panel and hides all others

  }, {
    key: 'showPanel',
    value: function showPanel(id) {
      this.container.children.forEach(function (child, i) {
        return child.display = i === id ? 'block' : 'none';
      });
      this.mode = id;
    }
  }, {
    key: 'setMode',
    value: function setMode(id) {
      this.showPanel(id);
    }
  }, {
    key: 'beginFrame',
    value: function beginFrame() {
      this.beginTime = (this.performance || Date).now();
    }
  }, {
    key: 'endFrame',
    value: function endFrame() {
      this.frames++;

      var time = (this.performance || Date).now();

      this.msPanel.update(time - this.beginTime, 200);

      var deltaTime = time - this.prevTime;
      if (deltaTime > 1000) {
        this.fpsPanel.update({
          value: this.frames * deltaTime / 1000,
          maxValue: 100
        });

        this.prevTime = time;
        this.frames = 0;

        if (this.memPanel) {
          var memory = this.performance.memory;
          this.memPanel.update({
            value: memory.usedJSHeapSize / 1048576,
            maxValue: memory.jsHeapSizeLimit / 1048576
          });
        }
      }

      return time;
    }
  }, {
    key: 'update',
    value: function update() {
      this.beginTime = this.end();
    }
  }]);

  return Stats;
}();

/**
 * @author mrdoob / http://mrdoob.com/
 * @author jetienne / http://jetienne.com/
 */
/** global document */

export { Stats as default };
export var RendererStats = function () {
  /**
   * Provide info on THREE.WebGLRenderer
   *
   * @param {Object} renderer the renderer to update
   * @param {Object} Camera the camera to update
  */
  function RendererStats() {
    _classCallCheck(this, RendererStats);

    var container = document.createElement('div');
    container.style.cssText = 'width:80px;opacity:0.9;cursor:pointer';

    var msDiv = document.createElement('div');
    msDiv.style.cssText = 'padding:0 0 3px 3px;text-align:left;backgound-color:#200;';
    container.appendChild(msDiv);

    var msText = document.createElement('div');
    msText.style.cssText = 'color:#f00;font-family:Helvetica,Arial,sans-serif;font-size:9px;font-weight:bold;line-height:15px';
    msText.innerHTML = 'Render Stats';
    msDiv.appendChild(msText);

    this.msTexts = [];
    this.nLines = 9;
    for (var i = 0; i < this.nLines; i++) {
      this.msTexts[i] = document.createElement('div');
      this.msTexts[i].style.cssText = 'color:#f00;background-color:#311;font-family:Helvetica,Arial,sans-serif;font-size:9px;font-weight:bold;line-height:15px';
      this.msTexts[i].innerHTML = '-';
      msDiv.appendChild(this.msTexts[i]);
    }

    this.lastTime = Date.now();
    this.domElement = container;
  }

  _createClass(RendererStats, [{
    key: 'update',
    value: function update(info) {
      // refresh only 30time per second
      if (Date.now() - this.lastTime < 1000 / 30) {
        return;
      }
      this.lastTime = Date.now();

      var i = 0;
      this.msTexts[i++].textContent = '== Memory =====';
      this.msTexts[i++].textContent = 'Programs: ' + info.memory.programs;
      this.msTexts[i++].textContent = 'Geometries: ' + info.memory.geometries;
      this.msTexts[i++].textContent = 'Textures: ' + info.memory.textures;

      this.msTexts[i++].textContent = '== Render =====';
      this.msTexts[i++].textContent = 'Calls: ' + info.render.calls;
      this.msTexts[i++].textContent = 'Vertices: ' + info.render.vertices;
      this.msTexts[i++].textContent = 'Faces: ' + info.render.faces;
      this.msTexts[i++].textContent = 'Points: ' + info.render.points;
    }
  }]);

  return RendererStats;
}();
//# sourceMappingURL=data:application/json;base64,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