var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* global window, setTimeout, clearTimeout */
import { isBrowser, pageLoadPromise } from '../utils';
import { isWebGLContext } from '../webgl/webgl-checks';

// Node.js polyfills for requestAnimationFrame and cancelAnimationFrame
export var requestAnimationFrame = function requestAnimationFrame(callback) {
  return isBrowser ? window.requestAnimationFrame(callback) : setTimeout(callback, 1000 / 60);
};

export var cancelAnimationFrame = function cancelAnimationFrame(timerId) {
  return isBrowser ? window.cancelAnimationFrame(timerId) : clearTimeout(timerId);
};

var AnimationFrame = function () {
  /*
   * @param {HTMLCanvasElement} canvas - if provided, with and height will be
   *   passed to context
   */
  function AnimationFrame() {
    var _this = this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, AnimationFrame);

    var _opts$gl = opts.gl,
        gl = _opts$gl === undefined ? null : _opts$gl,
        _opts$width = opts.width,
        width = _opts$width === undefined ? null : _opts$width,
        _opts$height = opts.height,
        height = _opts$height === undefined ? null : _opts$height,
        _opts$autoResizeViewp = opts.autoResizeViewport,
        autoResizeViewport = _opts$autoResizeViewp === undefined ? true : _opts$autoResizeViewp,
        _opts$autoResizeCanva = opts.autoResizeCanvas,
        autoResizeCanvas = _opts$autoResizeCanva === undefined ? true : _opts$autoResizeCanva,
        _opts$autoResizeDrawi = opts.autoResizeDrawingBuffer,
        autoResizeDrawingBuffer = _opts$autoResizeDrawi === undefined ? true : _opts$autoResizeDrawi,
        _opts$useDevicePixelR = opts.useDevicePixelRatio,
        useDevicePixelRatio = _opts$useDevicePixelR === undefined ? true : _opts$useDevicePixelR;


    this.start = this.start.bind(this);
    this.stop = this.stop.bind(this);
    this._frame = this._frame.bind(this);

    this.update({
      autoResizeViewport: autoResizeViewport,
      autoResizeCanvas: autoResizeCanvas,
      autoResizeDrawingBuffer: autoResizeDrawingBuffer,
      useDevicePixelRatio: useDevicePixelRatio
    });

    this.width = width;
    this.height = height;

    // Don't do a
    this._startPromise = pageLoadPromise.then(function (page) {
      _this.gl = gl;
      return page;
    });
  }

  _createClass(AnimationFrame, [{
    key: 'update',
    value: function update(_ref) {
      var _ref$autoResizeDrawin = _ref.autoResizeDrawingBuffer,
          autoResizeDrawingBuffer = _ref$autoResizeDrawin === undefined ? true : _ref$autoResizeDrawin,
          _ref$autoResizeCanvas = _ref.autoResizeCanvas,
          autoResizeCanvas = _ref$autoResizeCanvas === undefined ? true : _ref$autoResizeCanvas,
          _ref$autoResizeViewpo = _ref.autoResizeViewport,
          autoResizeViewport = _ref$autoResizeViewpo === undefined ? true : _ref$autoResizeViewpo,
          _ref$useDevicePixelRa = _ref.useDevicePixelRatio,
          useDevicePixelRatio = _ref$useDevicePixelRa === undefined ? true : _ref$useDevicePixelRa;

      this.autoResizeViewport = autoResizeViewport;
      this.autoResizeCanvas = autoResizeCanvas;
      this.autoResizeDrawingBuffer = autoResizeDrawingBuffer;
      this.useDevicePixelRatio = useDevicePixelRatio;
      return this;
    }
  }, {
    key: 'context',
    value: function context(onCreateContext) {
      var _this2 = this;

      if (this.gl) {
        throw new Error('AnimationFrame.context - context already provided');
      }
      this._startPromise = this._startPromise.then(function () {
        _this2.gl = onCreateContext();
        if (!isWebGLContext(_this2.gl)) {
          throw new Error('AnimationFrame.context - illegal context returned');
        }
      });
      return this;
    }
  }, {
    key: 'init',
    value: function init(onInit) {
      var _this3 = this;

      this._startPromise = this._startPromise.then(function () {
        if (!_this3.gl) {
          throw new Error('AnimationFrame.context - no context provided');
        }
        _this3._initializeContext();
        return onInit(_this3._context) || {};
      });

      return this;
    }
  }, {
    key: 'setupFrame',
    value: function setupFrame(onSetupFrame) {
      this._onSetupFrame = onSetupFrame;
      return this;
    }

    /**
     * Starts a global render loop with the given frame function
     * @param {Function} onRenderFrame - application frame renderer function
     *  expected to take a context parameter
     * @param {Object} context - contains frame specific info
     *  (E.g. tick, width, height, etc)
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: 'frame',
    value: function frame(onRenderFrame) {
      this._onRenderFrame = onRenderFrame;
      return this;
    }

    /**
     * Starts a render loop if not already running
     */

  }, {
    key: 'start',
    value: function start() {
      var _this4 = this;

      // Wait for start promise before rendering frame
      this._startPromise.then(function () {
        var appContext = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this4._initializeContext(appContext);
        if (!_this4._animationFrameId) {
          _this4._animationFrameId = requestAnimationFrame(_this4._frame);
        }
      });
      return this;
    }

    /**
     * Stops a render loop if already running
     */

  }, {
    key: 'stop',
    value: function stop() {
      if (this._animationFrameId) {
        cancelAnimationFrame(this._animationFrameId);
        this._animationFrameId = null;
      }
      return this;
    }

    /**
     * Resize canvas in "CSS coordinates" (may be different from device coords)
     * NOTE: No effect on headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: 'resizeCanvas',
    value: function resizeCanvas(width, height) {
      this._resizeCanvas(width, height);
      return this;
    }

    // PRIVATE METHODS

  }, {
    key: '_initializeContext',
    value: function _initializeContext(appContext) {
      if (!this._context) {
        this._context = {
          gl: this.gl,
          canvas: this.gl.canvas,
          stop: this.stop,
          tick: 0,
          tock: 0
        };
      }
      this._updateContext();
      if ((typeof appContext === 'undefined' ? 'undefined' : _typeof(appContext)) === 'object' && appContext !== null) {
        this._context = Object.assign({}, appContext, this._context);
      }
    }
  }, {
    key: '_updateContext',
    value: function _updateContext() {
      // Context width and height represent drawing buffer width and height
      var canvas = this._context.canvas;

      this._context.width = canvas.width;
      this._context.height = canvas.height;
      this._context.aspect = canvas.width / canvas.height;
    }

    /**
     * @private
     * Handles a render loop frame- updates context and calls the application
     * callback
     */

  }, {
    key: '_frame',
    value: function _frame() {
      var canvas = this._context.canvas;


      if (this._onSetupFrame) {
        this._onSetupFrame(this._context);
      } else {
        this._resizeCanvasDrawingBuffer(canvas);
        // Default viewport setup
        if (this.autoResizeViewport) {
          this.gl.viewport(0, 0, canvas.width, canvas.height);
        }
      }

      this._updateContext();
      this._onRenderFrame(this._context);

      // Increment tick
      this._context.tick++;

      // Request another render frame (now )
      this._animationFrameId = requestAnimationFrame(this._frame);
    }

    /**
     * Resize canvas in "CSS coordinates" (may be different from device coords)
     * NOTE: No effect on headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: '_resizeCanvas',
    value: function _resizeCanvas(width, height) {
      var canvas = this._context.canvas;

      if (canvas) {
        if (this.autoResizeDrawingBuffer) {
          var cssToDevicePixels = this.useDevicePixelRatio ? window.devicePixelRatio || 1 : 1;

          // Lookup the size the browser is displaying the canvas in CSS pixels
          // and compute a size needed to make our drawingbuffer match it in
          // device pixels.
          var displayWidth = Math.floor(width * cssToDevicePixels);
          var displayHeight = Math.floor(height * cssToDevicePixels);

          // Check if the canvas is not the same size.
          if (canvas.width !== displayWidth || canvas.height !== displayHeight) {
            // Make the canvas the same size
            canvas.width = displayWidth;
            canvas.height = displayHeight;
          }
        }

        canvas.style.width = width + 'px';
        canvas.style.height = height + 'px';
      }
      return this;
    }

    // Resize the render buffer of the canvas to match canvas client size
    // multiplying with dpr (Optionally can be turned off)
    // http://webgl2fundamentals.org/webgl/lessons/webgl-resizing-the-canvas.html

  }, {
    key: '_resizeCanvasDrawingBuffer',
    value: function _resizeCanvasDrawingBuffer() {
      if (this.autoResizeDrawingBuffer) {
        var canvas = this._context.canvas;

        var cssToDevicePixels = this.useDevicePixelRatio ? window.devicePixelRatio || 1 : 1;

        // Lookup the size the browser is displaying the canvas in CSS pixels
        // and compute a size needed to make our drawingbuffer match it in
        // device pixels.
        var oldWidth = window.innerWidth;
        var oldHeight = window.innerHeight;
        var displayWidth = Math.floor(oldWidth * cssToDevicePixels);
        var displayHeight = Math.floor(oldHeight * cssToDevicePixels);

        // Check if the canvas is not the same size.
        if (oldWidth !== displayWidth || oldHeight !== displayHeight) {
          // Make the canvas the same size
          canvas.width = displayWidth;
          canvas.height = displayHeight;
          canvas.style.width = oldWidth;
          canvas.style.height = oldHeight;
        }
      }
    }

    /**
     * Resize canvas drawing buffer
     * NOTE: The drawing buffer will be scaled to the viewport
     * for best visual results, usually set to either:
     *  canvas CSS width x CSS height
     *  canvas CSS width * devicePixelRatio x CSS height * devicePixelRatio
     * TODO - add separate call for headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: '_resizeDrawingBuffer',
    value: function _resizeDrawingBuffer(width, height) {
      var canvas = this._context.canvas;

      if (canvas) {
        canvas.width = width;
        canvas.height = height;
        this.autoResizeDrawingBuffer = false;
      }
      return this;
    }
  }]);

  return AnimationFrame;
}();

export { AnimationFrame as default };
//# sourceMappingURL=data:application/json;base64,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