var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// camera.js
// Provides a Camera with ModelView and Projection matrices

import { Vec3, Mat4 } from '../deprecated';
import { merge } from '../utils';

export var Camera = function () {
  function Camera() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Camera);

    opts = merge({
      fov: 45,
      near: 0.1,
      far: 500,
      aspect: 1,
      position: new Vec3(0, 0, 0),
      target: new Vec3(0, 0, -1),
      up: new Vec3(0, 1, 0)
    }, opts);

    this.fov = opts.fov;
    this.near = opts.near;
    this.far = opts.far;
    this.aspect = opts.aspect;
    this.position = opts.position;
    this.target = opts.target;
    this.up = opts.up;
    this.view = new Mat4();
    this.uniforms = {};
    this.projection = new Mat4();
    Object.seal(this);

    this.update();
  }

  _createClass(Camera, [{
    key: 'project',
    value: function project() {
      return null;
    }
  }, {
    key: 'unproject',
    value: function unproject() {
      return null;
    }
  }, {
    key: 'getUniforms',
    value: function getUniforms() {
      return this.uniforms;
    }
  }, {
    key: '_updateUniforms',
    value: function _updateUniforms() {
      var viewProjection = this.view.mulMat4(this.projection);
      var viewProjectionInverse = viewProjection.invert();
      this.uniforms = {
        cameraPosition: this.position,
        projectionMatrix: this.projection,
        viewMatrix: this.view,
        viewProjectionMatrix: viewProjection,
        viewInverseMatrix: this.view.invert(),
        viewProjectionInverseMatrix: viewProjectionInverse
      };
    }
  }]);

  return Camera;
}();

export var PerspectiveCamera = function (_Camera) {
  _inherits(PerspectiveCamera, _Camera);

  function PerspectiveCamera() {
    _classCallCheck(this, PerspectiveCamera);

    return _possibleConstructorReturn(this, (PerspectiveCamera.__proto__ || Object.getPrototypeOf(PerspectiveCamera)).apply(this, arguments));
  }

  _createClass(PerspectiveCamera, [{
    key: 'update',
    value: function update() {
      this.projection = new Mat4().perspective(this.fov, this.aspect, this.near, this.far);
      this.view.lookAt(this.position, this.target, this.up);
      this._updateUniforms();
    }
  }]);

  return PerspectiveCamera;
}(Camera);

export var OrthoCamera = function () {
  function OrthoCamera() {
    _classCallCheck(this, OrthoCamera);
  }

  _createClass(OrthoCamera, [{
    key: 'update',
    value: function update() {
      var ymax = this.near * Math.tan(this.fov * Math.PI / 360);
      var ymin = -ymax;
      var xmin = ymin * this.aspect;
      var xmax = ymax * this.aspect;
      this.projection = new Mat4().ortho(xmin, xmax, ymin, ymax, this.near, this.far);
      this.view.lookAt(this.position, this.target, this.up);
      this._updateUniforms();
    }
  }]);

  return OrthoCamera;
}();
//# sourceMappingURL=data:application/json;base64,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