export { _stop as stop };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// event.js
// Handle keyboard/mouse/touch events in the Canvas
// TODO - this will not work under node

/* eslint-disable dot-notation, max-statements, no-loop-func */
/* global window, document */
import { noop } from '../utils';

var KEYS = {
  enter: 13,
  up: 38,
  down: 40,
  left: 37,
  right: 39,
  esc: 27,
  space: 32,
  backspace: 8,
  tab: 9,
  delete: 46
};

// returns an O3D object or false otherwise.
function toO3D(n) {
  return n !== true ? n : false;
}

// Returns an element position
function _getPos(elem) {
  var bbox = elem.getBoundingClientRect();
  return {
    x: bbox.left,
    y: bbox.top,
    bbox: bbox
  };
}

// event object wrapper
export function get(e, win) {
  win = win || window;
  return e || win.event;
}

export function getWheel(e) {
  return e.wheelDelta ? e.wheelDelta / 120 : -(e.detail || 0) / 3;
}

export function getKey(e) {
  var code = e.which || e.keyCode;
  var key = keyOf(code);
  // onkeydown
  var fKey = code - 111;
  if (fKey > 0 && fKey < 13) {
    key = 'f' + fKey;
  }
  key = key || String.fromCharCode(code).toLowerCase();

  return {
    code: code,
    key: key,
    shift: e.shiftKey,
    control: e.ctrlKey,
    alt: e.altKey,
    meta: e.metaKey
  };
}

export function isRightClick(e) {
  return e.which === 3 || e.button === 2;
}

export function getPos(e, win) {
  // get mouse position
  win = win || window;
  e = e || win.event;
  var doc = win.document;
  doc = doc.documentElement || doc.body;
  // TODO(nico): make touch event handling better
  if (e.touches && e.touches.length) {
    var touchesPos = [];
    var l = e.touches.length;
    var evt = void 0;
    for (var i = 0; i < l; ++i) {
      evt = e.touches[i];
      touchesPos.push({
        x: evt.pageX || evt.clientX + doc.scrollLeft,
        y: evt.pageY || evt.clientY + doc.scrollTop
      });
    }
    return touchesPos;
  }
  var page = {
    x: e.pageX || e.clientX + doc.scrollLeft,
    y: e.pageY || e.clientY + doc.scrollTop
  };
  return [page];
}

function _stop(e) {
  if (e.stopPropagation) {
    e.stopPropagation();
  }
  e.cancelBubble = true;
  if (e.preventDefault) {
    e.preventDefault();
  } else {
    e.returnValue = false;
  }
}

export var EventsProxy = function () {
  function EventsProxy(domElem, opt) {
    _classCallCheck(this, EventsProxy);

    this.scene = opt.scene;
    this.domElem = domElem;
    this.pos = _getPos(domElem);
    this.opt = this.callbacks = opt;

    this.size = {
      width: domElem.width || domElem.offsetWidth,
      height: domElem.height || domElem.offsetHeight
    };

    this.attachEvents();
  }

  _createClass(EventsProxy, [{
    key: 'attachEvents',
    value: function attachEvents() {
      var _this = this;

      var domElem = this.domElem;
      var opt = this.opt;

      if (opt.disableContextMenu) {
        domElem.oncontextmenu = function () {
          return false;
        };
      }

      if (opt.enableMouse) {
        ['mouseup', 'mousedown', 'mousemove', 'mouseover', 'mouseout'].forEach(function (action) {
          domElem.addEventListener(action, function (e, win) {
            _this[action](_this.eventInfo(action, e, win));
          }, false);
        });

        // "well, this is embarrassing..."
        var type = '';
        if (!document.getBoxObjectFor && window.mozInnerScreenX === null) {
          type = 'mousewheel';
        } else {
          type = 'DOMMouseScroll';
        }
        domElem.addEventListener(type, function (e, win) {
          _this['mousewheel'](_this.eventInfo('mousewheel', e, win));
        }, false);
      }

      if (opt.enableTouch) {
        ['touchstart', 'touchmove', 'touchend'].forEach(function (action) {
          domElem.addEventListener(action, function (e, win) {
            _this[action](_this.eventInfo(action, e, win));
          }, false);
        });
      }

      if (opt.enableKeyboard) {
        ['keydown', 'keyup'].forEach(function (action) {
          document.addEventListener(action, function (e, win) {
            _this[action](_this.eventInfo(action, e, win));
          }, false);
        });
      }
    }
  }, {
    key: 'eventInfo',
    value: function eventInfo(type, e, win) {
      var domElem = this.domElem;
      var scene = this.scene;
      var opt = this.opt;
      var size = this.getSize();
      var relative = opt.relative;
      var centerOrigin = opt.centerOrigin;
      var pos = opt.cachePosition && this.pos || _getPos(domElem);
      var ge = get(e, win);
      var epos = getPos(e, win);
      var origPos = { x: epos[0].x, y: epos[0].y };
      var evt = {};
      var x = void 0;
      var y = void 0;

      // get Position
      for (var i = 0, l = epos.length; i < l; ++i) {
        x = epos[i].x;
        y = epos[i].y;
        if (relative) {
          x -= pos.x;y -= pos.y;
          if (centerOrigin) {
            x -= size.width / 2;
            y -= size.height / 2;
            // y axis now points to the top of the screen
            y *= -1;
          }
        }
        epos[i].x = x;
        epos[i].y = y;
      }

      switch (type) {
        case 'mousewheel':
          evt.wheel = getWheel(ge);
          break;
        case 'keydown':
        case 'keyup':
          Object.assign(evt, getKey(ge));
          break;
        case 'mouseup':
          evt.isRightClick = isRightClick(ge);
          break;
        default:
          break;
      }

      var cacheTarget = void 0;

      Object.assign(evt, {
        x: epos[0].x,
        y: epos[0].y,
        posArray: epos,

        cache: false,
        // stop event propagation
        stop: function stop() {
          _stop(ge);
        },

        // get the target element of the event
        getTarget: function getTarget() {
          if (cacheTarget) {
            return cacheTarget;
          }
          return cacheTarget = opt.picking && scene.pick(origPos.x - pos.x, origPos.y - pos.y) || true;
        }
      });
      // wrap native event
      evt.event = ge;

      return evt;
    }
  }, {
    key: 'getSize',
    value: function getSize() {
      if (this.cacheSize) {
        return this.size;
      }
      var domElem = this.domElem;
      return {
        width: domElem.width || domElem.offsetWidth,
        height: domElem.height || domElem.offsetHeight
      };
    }
  }, {
    key: 'mouseup',
    value: function mouseup(e) {
      if (!this.moved) {
        if (e.isRightClick) {
          this.callbacks.onRightClick(e, this.hovered);
        } else {
          this.callbacks.onClick(e, toO3D(this.pressed));
        }
      }
      if (this.pressed) {
        if (this.moved) {
          this.callbacks.onDragEnd(e, toO3D(this.pressed));
        } else {
          this.callbacks.onDragCancel(e, toO3D(this.pressed));
        }
        this.pressed = this.moved = false;
      }
    }
  }, {
    key: 'mouseout',
    value: function mouseout(e) {
      // mouseout canvas
      var rt = e.relatedTarget;
      var domElem = this.domElem;
      while (rt && rt.parentNode) {
        if (domElem === rt.parentNode) {
          return;
        }
        rt = rt.parentNode;
      }
      if (this.hovered) {
        this.callbacks.onMouseLeave(e, this.hovered);
        this.hovered = false;
      }
      if (this.pressed && this.moved) {
        this.callbacks.onDragEnd(e);
        this.pressed = this.moved = false;
      }
    }
  }, {
    key: 'mouseover',
    value: function mouseover(e) {}
  }, {
    key: 'mousemove',
    value: function mousemove(e) {
      if (this.pressed) {
        this.moved = true;
        this.callbacks.onDragMove(e, toO3D(this.pressed));
        return;
      }
      if (this.hovered) {
        var target = toO3D(e.getTarget());
        if (!target || target.hash !== this.hash) {
          this.callbacks.onMouseLeave(e, this.hovered);
          this.hovered = target;
          this.hash = target;
          if (target) {
            this.hash = target.hash;
            this.callbacks.onMouseEnter(e, this.hovered);
          }
        } else {
          this.callbacks.onMouseMove(e, this.hovered);
        }
      } else {
        this.hovered = toO3D(e.getTarget());
        this.hash = this.hovered;
        if (this.hovered) {
          this.hash = this.hovered.hash;
          this.callbacks.onMouseEnter(e, this.hovered);
        }
      }
      if (!this.opt.picking) {
        this.callbacks.onMouseMove(e);
      }
    }
  }, {
    key: 'mousewheel',
    value: function mousewheel(e) {
      this.callbacks.onMouseWheel(e);
    }
  }, {
    key: 'mousedown',
    value: function mousedown(e) {
      this.pressed = e.getTarget();
      this.callbacks.onDragStart(e, toO3D(this.pressed));
    }
  }, {
    key: 'touchstart',
    value: function touchstart(e) {
      this.touched = e.getTarget();
      this.touchedLastPosition = { x: e.x, y: e.y };
      this.callbacks.onTouchStart(e, toO3D(this.touched));
    }
  }, {
    key: 'touchmove',
    value: function touchmove(e) {
      if (this.touched) {
        this.touchMoved = true;
        this.callbacks.onTouchMove(e, toO3D(this.touched));
      }
    }
  }, {
    key: 'touchend',
    value: function touchend(e) {
      if (this.touched) {
        if (this.touchMoved) {
          this.callbacks.onTouchEnd(e, toO3D(this.touched));
        } else {
          e.x = isNaN(e.x) ? this.touchedLastPosition.x : e.x;
          e.y = isNaN(e.y) ? this.touchedLastPosition.y : e.y;
          this.callbacks.onTap(e, toO3D(this.touched));
          this.callbacks.onTouchCancel(e, toO3D(this.touched));
        }
        this.touched = this.touchMoved = false;
      }
    }
  }, {
    key: 'keydown',
    value: function keydown(e) {
      this.callbacks.onKeyDown(e);
    }
  }, {
    key: 'keyup',
    value: function keyup(e) {
      this.callbacks.onKeyUp(e);
    }
  }]);

  return EventsProxy;
}();

Object.assign(EventsProxy.prototype, {
  hovered: false,
  pressed: false,
  touched: false,
  touchedLastPosition: { x: 0, y: 0 },
  touchMoved: false,
  moved: false
});

var DEFAULT_OPTS = {
  cachePosition: true,
  cacheSize: true,
  relative: true,
  centerOrigin: true,
  disableContextMenu: true,
  bind: false,
  picking: false,

  enableTouch: true,
  enableMouse: true,
  enableKeyboard: true,

  onClick: noop,
  onRightClick: noop,
  onDragStart: noop,
  onDragMove: noop,
  onDragEnd: noop,
  onDragCancel: noop,
  onTouchStart: noop,
  onTouchMove: noop,
  onTouchEnd: noop,
  onTouchCancel: noop,
  onTap: noop,
  onMouseMove: noop,
  onMouseEnter: noop,
  onMouseLeave: noop,
  onMouseWheel: noop,
  onKeyDown: noop,
  onKeyUp: noop
};

export var Keys = KEYS;

function keyOf(code) {
  var keyMap = Keys;
  for (var name in keyMap) {
    if (keyMap[name] === code) {
      return name;
    }
  }
  return null;
}

export function addEvents(domElement) {
  var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  opt = Object.assign({}, DEFAULT_OPTS, opt);

  var bind = opt.bind;
  if (bind) {
    for (var name in opt) {
      if (name.match(/^on[a-zA-Z0-9]+$/)) {
        (function (fname, fn) {
          opt[fname] = function f() {
            fn.apply(bind, Array.prototype.slice.call(arguments));
          };
        })(name, opt[name]);
      }
    }
  }

  return new EventsProxy(domElement, opt);
}
//# sourceMappingURL=data:application/json;base64,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