var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// A scenegraph object node
/* eslint-disable guard-for-in */

// Define some locals
import { GL, Buffer, Program, draw, checkUniformValues, getUniformsTable, isWebGLContext } from '../webgl';
import Object3D from '../deprecated/scenegraph/object-3d';
import { log, formatValue } from '../utils';
import { Geometry } from '../geometry';
import { SHADERS } from '../experimental/shaders';
import assert from 'assert';

var MSG_INSTANCED_PARAM_DEPRECATED = 'Warning: Model constructor: parameter "instanced" renamed to "isInstanced".\nThis will become a hard error in a future version of luma.gl.';

var MSG_TEXTURES_PARAM_REMOVED = 'Model: parameter "textures" removed. Use uniforms to set textures';

// TODO - experimental, not yet used
export var Material = function Material() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$shininess = _ref.shininess,
      shininess = _ref$shininess === undefined ? 0 : _ref$shininess,
      _ref$reflection = _ref.reflection,
      reflection = _ref$reflection === undefined ? 0 : _ref$reflection,
      _ref$refraction = _ref.refraction,
      refraction = _ref$refraction === undefined ? 0 : _ref$refraction;

  _classCallCheck(this, Material);

  this.shininess = shininess;
  this.reflection = reflection;
  this.refraction = refraction;
};

// Model abstract O3D Class

var Model = function (_Object3D) {
  _inherits(Model, _Object3D);

  function Model(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Model);

    opts = isWebGLContext(gl) ? Object.assign({}, opts, { gl: gl }) : gl;

    var _this = _possibleConstructorReturn(this, (Model.__proto__ || Object.getPrototypeOf(Model)).call(this, opts));

    _this.init(opts);
    return _this;
  }

  /* eslint-disable max-statements  */
  /* eslint-disable complexity  */


  _createClass(Model, [{
    key: 'init',
    value: function init() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          program = _ref2.program,
          _ref2$gl = _ref2.gl,
          gl = _ref2$gl === undefined ? null : _ref2$gl,
          _ref2$vs = _ref2.vs,
          vs = _ref2$vs === undefined ? SHADERS.vs : _ref2$vs,
          _ref2$fs = _ref2.fs,
          fs = _ref2$fs === undefined ? SHADERS.fs : _ref2$fs,
          defaultUniforms = _ref2.defaultUniforms,
          geometry = _ref2.geometry,
          _ref2$material = _ref2.material,
          material = _ref2$material === undefined ? null : _ref2$material,
          textures = _ref2.textures,
          _ref2$isInstanced = _ref2.isInstanced,
          isInstanced = _ref2$isInstanced === undefined ? false : _ref2$isInstanced,
          instanced = _ref2.instanced,
          _ref2$instanceCount = _ref2.instanceCount,
          instanceCount = _ref2$instanceCount === undefined ? 0 : _ref2$instanceCount,
          _ref2$vertexCount = _ref2.vertexCount,
          vertexCount = _ref2$vertexCount === undefined ? undefined : _ref2$vertexCount,
          _ref2$pickable = _ref2.pickable,
          pickable = _ref2$pickable === undefined ? true : _ref2$pickable,
          _ref2$pick = _ref2.pick,
          pick = _ref2$pick === undefined ? null : _ref2$pick,
          _ref2$uniforms = _ref2.uniforms,
          uniforms = _ref2$uniforms === undefined ? {} : _ref2$uniforms,
          _ref2$attributes = _ref2.attributes,
          attributes = _ref2$attributes === undefined ? {} : _ref2$attributes,
          _ref2$render = _ref2.render,
          render = _ref2$render === undefined ? null : _ref2$render,
          _ref2$onBeforeRender = _ref2.onBeforeRender,
          onBeforeRender = _ref2$onBeforeRender === undefined ? function () {} : _ref2$onBeforeRender,
          _ref2$onAfterRender = _ref2.onAfterRender,
          onAfterRender = _ref2$onAfterRender === undefined ? function () {} : _ref2$onAfterRender,
          _ref2$timerQueryEnabl = _ref2.timerQueryEnabled,
          timerQueryEnabled = _ref2$timerQueryEnabl === undefined ? false : _ref2$timerQueryEnabl;

      // assert(program || program instanceof Program);
      assert(geometry instanceof Geometry, 'Model needs a geometry');

      // Assign default uniforms if any of the default shaders is being used
      if (vs === SHADERS.vs || fs === SHADERS.fs && defaultUniforms === undefined) {
        defaultUniforms = SHADERS.defaultUniforms;
      }

      // set a custom program per o3d
      this.program = program || new Program(gl, { vs: vs, fs: fs });
      assert(this.program instanceof Program, 'Model needs a program');

      if (instanced) {
        /* global console */
        /* eslint-disable no-console */
        console.warn(MSG_INSTANCED_PARAM_DEPRECATED);
        isInstanced = isInstanced || instanced;
      }

      if (textures) {
        throw new Error(MSG_TEXTURES_PARAM_REMOVED);
      }

      // TODO - remove?
      this.buffers = {};
      this.userData = {};
      this.drawParams = {};
      this.dynamic = false;
      this.needsRedraw = true;

      this.material = material;

      // Attributes and buffers
      this.setGeometry(geometry);
      this.attributes = {};
      this.setAttributes(attributes);

      uniforms = Object.assign({}, this.program.defaultUniforms, uniforms);
      this.uniforms = {};
      this.setUniforms(uniforms);

      // instanced rendering
      this.isInstanced = isInstanced;
      this.instanceCount = instanceCount;
      this.vertexCount = vertexCount;

      // picking options
      this.pickable = Boolean(pickable);
      this.pick = pick || function () {
        return false;
      };

      this.onBeforeRender = onBeforeRender;
      this.onAfterRender = onAfterRender;

      this.timeElapsedQuery = undefined;
      this.ext = this.program.gl.getExtension('EXT_disjoint_timer_query');

      this.lastQueryReturned = true;
      this.accumulatedFrameTime = 0;
      this.averageFrameTime = 0;
      this.profileFrameCount = 0;

      this.timerQueryEnabled = timerQueryEnabled && this.ext !== null;
    }
    /* eslint-enable max-statements */
    /* eslint-enable complexity */

  }, {
    key: 'destroy',
    value: function destroy() {}
  }, {
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.needsRedraw = redraw;
      return this;
    }
  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref3$clearRedrawFlag = _ref3.clearRedrawFlags,
          clearRedrawFlags = _ref3$clearRedrawFlag === undefined ? false : _ref3$clearRedrawFlag;

      var redraw = false;
      redraw = redraw || this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !clearRedrawFlags;
      redraw = redraw || this.geometry.getNeedsRedraw({ clearRedrawFlags: clearRedrawFlags });
      return redraw;
    }
  }, {
    key: 'setInstanceCount',
    value: function setInstanceCount(instanceCount) {
      assert(instanceCount !== undefined);
      this.instanceCount = instanceCount;
      return this;
    }
  }, {
    key: 'getInstanceCount',
    value: function getInstanceCount() {
      return this.instanceCount;
    }
  }, {
    key: 'setVertexCount',
    value: function setVertexCount(vertexCount) {
      this.vertexCount = vertexCount;
      return this;
    }
  }, {
    key: 'getVertexCount',
    value: function getVertexCount() {
      return this.vertexCount === undefined ? this.geometry.getVertexCount() : this.vertexCount;
    }
  }, {
    key: 'isPickable',
    value: function isPickable() {
      return this.pickable;
    }
  }, {
    key: 'setPickable',
    value: function setPickable() {
      var pickable = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.pickable = Boolean(pickable);
      return this;
    }
  }, {
    key: 'getProgram',
    value: function getProgram() {
      return this.program;
    }
  }, {
    key: 'getGeometry',
    value: function getGeometry() {
      return this.geometry;
    }
  }, {
    key: 'setGeometry',
    value: function setGeometry(geometry) {
      this.geometry = geometry;
      this._createBuffersFromAttributeDescriptors(this.geometry.getAttributes());
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'getAttributes',
    value: function getAttributes() {
      return this.attributes;
    }
  }, {
    key: 'setAttributes',
    value: function setAttributes() {
      var attributes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      Object.assign(this.attributes, attributes);
      this._createBuffersFromAttributeDescriptors(attributes);
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'getUniforms',
    value: function getUniforms() {
      return this.uniforms;
    }
  }, {
    key: 'setUniforms',
    value: function setUniforms() {
      var uniforms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      checkUniformValues(uniforms, this.id);
      Object.assign(this.uniforms, uniforms);
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'draw',
    value: function draw() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$uniforms = _ref4.uniforms,
          uniforms = _ref4$uniforms === undefined ? {} : _ref4$uniforms,
          _ref4$attributes = _ref4.attributes,
          attributes = _ref4$attributes === undefined ? {} : _ref4$attributes,
          _ref4$settings = _ref4.settings,
          settings = _ref4$settings === undefined ? {} : _ref4$settings;

      return this.render(uniforms);
    }

    // TODO - uniform names are too strongly linked camera <=> default shaders
    // At least all special handling is collected here.

  }, {
    key: 'addViewUniforms',
    value: function addViewUniforms(uniforms) {
      // TODO - special treatment of these parameters should be removed
      var camera = uniforms.camera,
          viewMatrix = uniforms.viewMatrix,
          modelMatrix = uniforms.modelMatrix;
      // Camera exposes uniforms that can be used directly in shaders

      var cameraUniforms = camera ? camera.getUniforms() : {};

      var viewUniforms = viewMatrix ? this.getCoordinateUniforms(viewMatrix, modelMatrix) : {};

      return Object.assign({}, uniforms, cameraUniforms, viewUniforms);
    }

    /*
     * @param {Camera} opt.camera=
     * @param {Camera} opt.viewMatrix=
     */
    /* eslint-disable max-statements */

  }, {
    key: 'render',
    value: function render() {
      var uniforms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var resolvedUniforms = this.addViewUniforms(uniforms);

      this.setUniforms(resolvedUniforms);

      log.log(2, '>>> RENDERING MODEL ' + this.id, this);

      this.setProgramState();

      this._logAttributesAndUniforms(3, resolvedUniforms);

      this.onBeforeRender();

      var drawParams = this.drawParams;
      if (drawParams.isInstanced && !this.isInstanced) {
        log.warn(0, 'Found instanced attributes on non-instanced model');
      }
      var isIndexed = drawParams.isIndexed,
          indexType = drawParams.indexType;
      var geometry = this.geometry,
          isInstanced = this.isInstanced,
          instanceCount = this.instanceCount;


      if (this.timerQueryEnabled === true && this.lastQueryReturned === true) {
        this.program.gl.getParameter(this.ext.GPU_DISJOINT_EXT);
        this.timeElapsedQuery = this.ext.createQueryEXT();
        this.ext.beginQueryEXT(this.ext.TIME_ELAPSED_EXT, this.timeElapsedQuery);
      }

      draw(this.program.gl, {
        drawMode: geometry.drawMode,
        vertexCount: this.getVertexCount(),
        isIndexed: isIndexed,
        indexType: indexType,
        isInstanced: isInstanced,
        instanceCount: instanceCount
      });

      if (this.timerQueryEnabled === true) {
        if (this.lastQueryReturned === true) {
          this.ext.endQueryEXT(this.ext.TIME_ELAPSED_EXT);
          this.profileFrameCount++;
          this.lastQueryReturned = false;
        }
        // ...at some point in the future, after returning control to the browser and being called again:
        var disjoint = this.program.gl.getParameter(this.ext.GPU_DISJOINT_EXT);
        if (disjoint) {
          this.lastQueryReturned = true;
          // Have to redo all of the measurements.
        } else {
          var available = this.ext.getQueryObjectEXT(this.timeElapsedQuery, this.ext.QUERY_RESULT_AVAILABLE_EXT);

          if (available) {
            var timeElapsed = this.ext.getQueryObjectEXT(this.timeElapsedQuery, this.ext.QUERY_RESULT_EXT) / 1e6;
            this.accumulatedFrameTime += timeElapsed;
            this.averageFrameTime = this.accumulatedFrameTime / this.profileFrameCount;
            // Do something useful with the time.  Note that care should be
            // taken to use all significant bits of the result, not just the
            // least significant 32 bits.
            log.log(2, 'program.id: ', this.program.id);
            log.log(2, 'last frame time: ', timeElapsed, 'ms');
            log.log(2, 'average frame time: ', this.averageFrameTime, 'ms');
            log.log(2, 'accumulated frame time: ', this.accumulatedFrameTime, 'ms');
            log.log(2, 'profile frame count: ', this.profileFrameCount);
            this.lastQueryReturned = true;
          }
        }
      }
      this.onAfterRender();

      this.unsetProgramState();

      this.setNeedsRedraw(false);

      log.log(2, '<<< RENDERING MODEL ' + this.id + ' - complete');

      return this;
    }
  }, {
    key: 'setProgramState',
    value: function setProgramState() {
      var program = this.program;

      program.use();
      this.drawParams = {};
      program.setBuffers(this.buffers, { drawParams: this.drawParams });
      program.setUniforms(this.uniforms);
      return this;
    }
  }, {
    key: 'unsetProgramState',
    value: function unsetProgramState() {
      // Ensures all vertex attributes are disabled and ELEMENT_ARRAY_BUFFER
      // is unbound
      this.program.unsetBuffers();
      return this;
    }

    // Makes sure buffers are created for all attributes
    // and that the program is updated with those buffers
    // TODO - do we need the separation between "attributes" and "buffers"
    // couldn't apps just create buffers directly?

  }, {
    key: '_createBuffersFromAttributeDescriptors',
    value: function _createBuffersFromAttributeDescriptors(attributes) {
      var gl = this.program.gl;


      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        if (attribute instanceof Buffer) {
          this.buffers[attributeName] = attribute;
        } else {
          // Autocreate a buffer
          this.buffers[attributeName] = this.buffers[attributeName] || new Buffer(gl);

          var buffer = this.buffers[attributeName];
          buffer.setData(Object.assign({}, attribute, {
            data: attribute.value,
            target: attribute.isIndexed ? GL.ELEMENT_ARRAY_BUFFER : GL.ARRAY_BUFFER
          }));
        }
      }

      return this;
    }
  }, {
    key: '_logAttributesAndUniforms',
    value: function _logAttributesAndUniforms() {
      var priority = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 3;
      var uniforms = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (log.priority >= priority) {
        var attributeTable = this._getAttributesTable({
          header: 'Attributes ' + this.id,
          program: this.program,
          attributes: Object.assign({}, this.geometry.attributes, this.attributes)
        });
        log.table(priority, attributeTable);

        var _getUniformsTable = getUniformsTable({
          header: 'Uniforms ' + this.id,
          program: this.program,
          uniforms: Object.assign({}, this.uniforms, uniforms)
        }),
            table = _getUniformsTable.table,
            unusedTable = _getUniformsTable.unusedTable,
            unusedCount = _getUniformsTable.unusedCount;

        log.table(priority, table);
        log.log(priority, (unusedCount || 'No') + ' unused uniforms ', unusedTable);
      }
    }

    // Todo move to attributes manager

  }, {
    key: '_getAttributesTable',
    value: function _getAttributesTable() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          attributes = _ref5.attributes,
          _ref5$header = _ref5.header,
          header = _ref5$header === undefined ? 'Attributes' : _ref5$header,
          instanced = _ref5.instanced,
          program = _ref5.program;

      assert(program);
      var attributeLocations = program._attributeLocations;
      var table = _defineProperty({}, header, {});

      // Add used attributes
      for (var attributeName in attributeLocations) {
        var attribute = attributes[attributeName];
        var location = attributeLocations[attributeName];
        table[attributeName] = this._getAttributeEntry(attribute, location);
      }

      // Add any unused attributes
      for (var _attributeName in attributes) {
        var _attribute = attributes[_attributeName];
        if (!table[_attributeName]) {
          table[_attributeName] = this._getAttributeEntry(_attribute, null);
        }
      }

      return table;
    }
  }, {
    key: '_getAttributeEntry',
    value: function _getAttributeEntry(attribute, location) {
      var round = function round(num) {
        return Math.round(num * 10) / 10;
      };

      var type = 'NOT PROVIDED';
      var instanced = 0;
      var size = 'N/A';
      var verts = 'N/A';
      var bytes = 'N/A';
      var value = 'N/A';

      if (attribute && location === null) {
        location = attribute.isIndexed ? 'ELEMENT_ARRAY_BUFFER' : 'NOT USED';
      }

      if (attribute instanceof Buffer) {
        var buffer = attribute;
        type = buffer.layout.type;
        instanced = buffer.layout.instanced;
        size = buffer.layout.size;
        verts = round(buffer.data.length / buffer.layout.size);
        bytes = buffer.data.length * buffer.data.BYTES_PER_ELEMENT;
      } else if (attribute) {
        type = attribute.value.constructor.name;
        instanced = attribute.instanced;
        size = attribute.size;
        verts = round(attribute.value.length / attribute.size);
        bytes = attribute.value.length * attribute.value.BYTES_PER_ELEMENT;
        value = attribute.value;
      }

      // Generate a type name by dropping Array from Float32Array etc.
      type = String(type).replace('Array', '');
      // Look for 'nt' to detect integer types, e.g. Int32Array, Uint32Array
      var isInteger = type.indexOf('nt') !== -1;

      location = '' + location + (instanced ? ' [instanced]' : '');

      return {
        Location: location,
        'Type Size x Verts = Bytes': type + ' ' + size + ' x ' + verts + ' = ' + bytes,
        Value: formatValue(value, { size: size, isInteger: isInteger })
      };
    }

    // DEPRECATED / REMOVED

  }, {
    key: 'setTextures',
    value: function setTextures() {
      var textures = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

      throw new Error('model.setTextures replaced: setUniforms({sampler2D: new Texture2D})');
    }
  }, {
    key: 'hash',
    get: function get() {
      return this.id + ' ' + this.$pickingIndex;
    }
  }]);

  return Model;
}(Object3D);

export { Model as default };
//# sourceMappingURL=data:application/json;base64,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