'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('../webgl/webgl');

var _webglChecks = require('../webgl/webgl-checks');

var _framebuffer = require('../webgl/framebuffer');

var _framebuffer2 = _interopRequireDefault(_framebuffer);

var _renderbuffer = require('../webgl/renderbuffer');

var _renderbuffer2 = _interopRequireDefault(_renderbuffer);

var _texture2d = require('../webgl/texture-2d');

var _texture2d2 = _interopRequireDefault(_texture2d);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FramebufferObject = function () {

  /* eslint-disable max-statements */
  function FramebufferObject(gl) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$width = _ref.width,
        width = _ref$width === undefined ? 1 : _ref$width,
        _ref$height = _ref.height,
        height = _ref$height === undefined ? 1 : _ref$height,
        _ref$depth = _ref.depth,
        depth = _ref$depth === undefined ? true : _ref$depth,
        _ref$minFilter = _ref.minFilter,
        minFilter = _ref$minFilter === undefined ? _webgl.GL.NEAREST : _ref$minFilter,
        _ref$magFilter = _ref.magFilter,
        magFilter = _ref$magFilter === undefined ? _webgl.GL.NEAREST : _ref$magFilter,
        _ref$format = _ref.format,
        format = _ref$format === undefined ? _webgl.GL.RGBA : _ref$format,
        _ref$type = _ref.type,
        type = _ref$type === undefined ? _webgl.GL.UNSIGNED_BYTE : _ref$type;

    _classCallCheck(this, FramebufferObject);

    (0, _webglChecks.assertWebGLContext)(gl);

    this.gl = gl;
    this.depth = depth;
    this.minFilter = minFilter;
    this.magFilter = magFilter;
    this.format = format;
    this.type = type;

    this.resize(width, height);
  }

  _createClass(FramebufferObject, [{
    key: 'delete',
    value: function _delete() {}
  }, {
    key: 'resize',
    value: function resize(width, height) {
      (0, _assert2.default)(width >= 0 && height >= 0, 'Width and height need to be integers');
      if (width === this.width && height === this.height) {
        return;
      }

      var gl = this.gl;

      // TODO - do we need to reallocate the framebuffer?

      var fb = new _framebuffer2.default(gl);

      var colorBuffer = new _texture2d2.default(gl, {
        minFilter: this.minFilter,
        magFilter: this.magFilter
      })
      // TODO - should be handled by Texture2D constructor?
      .setImageData({
        data: null,
        width: width,
        height: height,
        type: this.type,
        format: this.format
      });

      fb.attachTexture({
        attachment: _webgl.GL.COLOR_ATTACHMENT0,
        texture: colorBuffer
      });

      if (this.colorBuffer) {
        this.colorBuffer.delete();
      }
      this.colorBuffer = colorBuffer;

      // Add a depth buffer if requested
      if (this.depth) {
        var depthBuffer = new _renderbuffer2.default(gl).storage({
          internalFormat: _webgl.GL.DEPTH_COMPONENT16,
          width: width,
          height: height
        });
        fb.attachRenderbuffer({
          attachment: _webgl.GL.DEPTH_ATTACHMENT,
          renderbuffer: depthBuffer
        });

        if (this.depthBuffer) {
          this.depthBuffer.delete();
        }
        this.depthBuffer = depthBuffer;
      }

      // Checks that framebuffer was properly set up,
      // if not, throws an explanatory error
      fb.checkStatus();

      this.width = width;
      this.height = height;

      // Immediately dispose of old buffer
      if (this.fb) {
        this.fb.delete();
      }
      this.fb = fb;
    }
    /* eslint-enable max-statements */

  }, {
    key: 'bind',
    value: function bind() {
      this.fb.bind();
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      this.fb.unbind();
    }
  }]);

  return FramebufferObject;
}();

exports.default = FramebufferObject;
//# sourceMappingURL=data:application/json;base64,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