'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _extendableBuiltin5(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
}

function _extendableBuiltin3(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _extendableBuiltin(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
}

// Vec3, Mat4 and Quat classes
// TODO - clean up linting and remove some of these exceptions
/* eslint-disable */
/* eslint-disable computed-property-spacing, brace-style, max-params, one-var */
/* eslint-disable indent, no-loop-func */

var sqrt = Math.sqrt;
var sin = Math.sin;
var cos = Math.cos;
var tan = Math.tan;
var pi = Math.PI;
var slice = Array.prototype.slice;

// Vec3 Class

var Vec3 = exports.Vec3 = function (_extendableBuiltin2) {
  _inherits(Vec3, _extendableBuiltin2);

  function Vec3() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Vec3);

    var _this = _possibleConstructorReturn(this, (Vec3.__proto__ || Object.getPrototypeOf(Vec3)).call(this, 3));

    _this[0] = x;
    _this[1] = y;
    _this[2] = z;
    return _this;
  }

  // fast Vec3 create.


  _createClass(Vec3, [{
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = value;
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = value;
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = value;
    }
  }], [{
    key: 'create',
    value: function create() {
      return new Vec3(3);
    }
  }]);

  return Vec3;
}(_extendableBuiltin(Array));

var generics = {
  setVec3: function setVec3(dest, vec) {
    dest[0] = vec[0];
    dest[1] = vec[1];
    dest[2] = vec[2];
    return dest;
  },
  set: function set(dest, x, y, z) {
    dest[0] = x;
    dest[1] = y;
    dest[2] = z;
    return dest;
  },
  add: function add(dest, vec) {
    return new Vec3(dest[0] + vec[0], dest[1] + vec[1], dest[2] + vec[2]);
  },
  $add: function $add(dest, vec) {
    dest[0] += vec[0];
    dest[1] += vec[1];
    dest[2] += vec[2];
    return dest;
  },
  add2: function add2(dest, a, b) {
    dest[0] = a[0] + b[0];
    dest[1] = a[1] + b[1];
    dest[2] = a[2] + b[2];
    return dest;
  },
  sub: function sub(dest, vec) {
    return new Vec3(dest[0] - vec[0], dest[1] - vec[1], dest[2] - vec[2]);
  },
  $sub: function $sub(dest, vec) {
    dest[0] -= vec[0];
    dest[1] -= vec[1];
    dest[2] -= vec[2];
    return dest;
  },
  sub2: function sub2(dest, a, b) {
    dest[0] = a[0] - b[0];
    dest[1] = a[1] - b[1];
    dest[2] = a[2] - b[2];
    return dest;
  },
  scale: function scale(dest, s) {
    return new Vec3(dest[0] * s, dest[1] * s, dest[2] * s);
  },
  $scale: function $scale(dest, s) {
    dest[0] *= s;
    dest[1] *= s;
    dest[2] *= s;
    return dest;
  },
  neg: function neg(dest) {
    return new Vec3(-dest[0], -dest[1], -dest[2]);
  },
  $neg: function $neg(dest) {
    dest[0] = -dest[0];
    dest[1] = -dest[1];
    dest[2] = -dest[2];
    return dest;
  },
  unit: function unit(dest) {
    var len = Vec3.norm(dest);

    if (len > 0) {
      return Vec3.scale(dest, 1 / len);
    }
    return Vec3.clone(dest);
  },
  $unit: function $unit(dest) {
    var len = Vec3.norm(dest);

    if (len > 0) {
      return Vec3.$scale(dest, 1 / len);
    }
    return dest;
  },
  cross: function cross(dest, vec) {
    var dx = dest[0],
        dy = dest[1],
        dz = dest[2],
        vx = vec[0],
        vy = vec[1],
        vz = vec[2];

    return new Vec3(dy * vz - dz * vy, dz * vx - dx * vz, dx * vy - dy * vx);
  },
  $cross: function $cross(dest, vec) {
    var dx = dest[0],
        dy = dest[1],
        dz = dest[2],
        vx = vec[0],
        vy = vec[1],
        vz = vec[2];

    dest[0] = dy * vz - dz * vy;
    dest[1] = dz * vx - dx * vz;
    dest[2] = dx * vy - dy * vx;
    return dest;
  },
  distTo: function distTo(dest, vec) {
    var dx = dest[0] - vec[0],
        dy = dest[1] - vec[1],
        dz = dest[2] - vec[2];

    return sqrt(dx * dx + dy * dy + dz * dz);
  },
  distToSq: function distToSq(dest, vec) {
    var dx = dest[0] - vec[0],
        dy = dest[1] - vec[1],
        dz = dest[2] - vec[2];

    return dx * dx + dy * dy + dz * dz;
  },
  norm: function norm(dest) {
    var dx = dest[0],
        dy = dest[1],
        dz = dest[2];

    return sqrt(dx * dx + dy * dy + dz * dz);
  },
  normSq: function normSq(dest) {
    var dx = dest[0],
        dy = dest[1],
        dz = dest[2];

    return dx * dx + dy * dy + dz * dz;
  },
  dot: function dot(dest, vec) {
    return dest[0] * vec[0] + dest[1] * vec[1] + dest[2] * vec[2];
  },
  clone: function clone(dest) {
    if (dest instanceof Vec3) {
      return new Vec3(dest[0], dest[1], dest[2]);
    }
    return Vec3.setVec3(new Float32Array(3), dest);
  },
  toFloat32Array: function toFloat32Array(dest) {
    var ans = dest.typedContainer;

    if (!ans) {
      return dest;
    }

    ans[0] = dest[0];
    ans[1] = dest[1];
    ans[2] = dest[2];

    return ans;
  }
};

// add generics and instance methods
var proto = Vec3.prototype;
for (var method in generics) {
  Vec3[method] = generics[method];
  proto[method] = function _(m) {
    return function () {
      var args = slice.call(arguments);
      args.unshift(this);
      return Vec3[m].apply(Vec3, args);
    };
  }(method);
}

// Mat4 Class

var Mat4 = exports.Mat4 = function (_extendableBuiltin4) {
  _inherits(Mat4, _extendableBuiltin4);

  function Mat4(n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44) {
    _classCallCheck(this, Mat4);

    var _this2 = _possibleConstructorReturn(this, (Mat4.__proto__ || Object.getPrototypeOf(Mat4)).call(this, 16));

    _this2.length = 16;

    if (typeof n11 === 'number') {

      _this2.set(n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44);
    } else {
      _this2.id();
    }

    _this2.typedContainer = new Float32Array(16);
    return _this2;
  }

  _createClass(Mat4, [{
    key: 'copy',
    value: function copy(src) {
      for (var i = 0; i < 16; ++i) {
        this[i] = src[i];
      }
      return this;
    }
  }, {
    key: 'n11',
    get: function get() {
      return this[0];
    },
    set: function set(val) {
      this[0] = val;
    }
  }, {
    key: 'n12',
    get: function get() {
      return this[4];
    },
    set: function set(val) {
      this[4] = val;
    }
  }, {
    key: 'n13',
    get: function get() {
      return this[8];
    },
    set: function set(val) {
      this[8] = val;
    }
  }, {
    key: 'n14',
    get: function get() {
      return this[12];
    },
    set: function set(val) {
      this[12] = val;
    }
  }, {
    key: 'n21',
    get: function get() {
      return this[1];
    },
    set: function set(val) {
      this[1] = val;
    }
  }, {
    key: 'n22',
    get: function get() {
      return this[5];
    },
    set: function set(val) {
      this[5] = val;
    }
  }, {
    key: 'n23',
    get: function get() {
      return this[9];
    },
    set: function set(val) {
      this[9] = val;
    }
  }, {
    key: 'n24',
    get: function get() {
      return this[13];
    },
    set: function set(val) {
      this[13] = val;
    }
  }, {
    key: 'n31',
    get: function get() {
      return this[2];
    },
    set: function set(val) {
      this[2] = val;
    }
  }, {
    key: 'n32',
    get: function get() {
      return this[6];
    },
    set: function set(val) {
      this[6] = val;
    }
  }, {
    key: 'n33',
    get: function get() {
      return this[10];
    },
    set: function set(val) {
      this[10] = val;
    }
  }, {
    key: 'n34',
    get: function get() {
      return this[14];
    },
    set: function set(val) {
      this[14] = val;
    }
  }, {
    key: 'n41',
    get: function get() {
      return this[3];
    },
    set: function set(val) {
      this[3] = val;
    }
  }, {
    key: 'n42',
    get: function get() {
      return this[7];
    },
    set: function set(val) {
      this[7] = val;
    }
  }, {
    key: 'n43',
    get: function get() {
      return this[11];
    },
    set: function set(val) {
      this[11] = val;
    }
  }, {
    key: 'n44',
    get: function get() {
      return this[15];
    },
    set: function set(val) {
      this[15] = val;
    }
  }], [{
    key: 'create',
    value: function create() {
      return new Array(16);
    }
  }]);

  return Mat4;
}(_extendableBuiltin3(Array));

generics = {
  id: function id(dest) {

    dest[0] = 1;
    dest[1] = 0;
    dest[2] = 0;
    dest[3] = 0;
    dest[4] = 0;
    dest[5] = 1;
    dest[6] = 0;
    dest[7] = 0;
    dest[8] = 0;
    dest[9] = 0;
    dest[10] = 1;
    dest[11] = 0;
    dest[12] = 0;
    dest[13] = 0;
    dest[14] = 0;
    dest[15] = 1;

    return dest;
  },
  clone: function clone(dest) {
    if (dest instanceof Mat4) {
      return new Mat4(dest[0], dest[4], dest[8], dest[12], dest[1], dest[5], dest[9], dest[13], dest[2], dest[6], dest[10], dest[14], dest[3], dest[7], dest[11], dest[15]);
    }
    return new typedArray(dest);
  },
  set: function set(dest, n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44) {

    dest[0] = n11;
    dest[4] = n12;
    dest[8] = n13;
    dest[12] = n14;
    dest[1] = n21;
    dest[5] = n22;
    dest[9] = n23;
    dest[13] = n24;
    dest[2] = n31;
    dest[6] = n32;
    dest[10] = n33;
    dest[14] = n34;
    dest[3] = n41;
    dest[7] = n42;
    dest[11] = n43;
    dest[15] = n44;

    return dest;
  },
  mulVec3: function mulVec3(dest, vec) {
    var ans = Vec3.clone(vec);
    return Mat4.$mulVec3(dest, ans);
  },
  $mulVec3: function $mulVec3(dest, vec) {
    var vx = vec[0],
        vy = vec[1],
        vz = vec[2],
        d = 1 / (dest[3] * vx + dest[7] * vy + dest[11] * vz + dest[15]);

    vec[0] = (dest[0] * vx + dest[4] * vy + dest[8] * vz + dest[12]) * d;
    vec[1] = (dest[1] * vx + dest[5] * vy + dest[9] * vz + dest[13]) * d;
    vec[2] = (dest[2] * vx + dest[6] * vy + dest[10] * vz + dest[14]) * d;

    return vec;
  },
  mulMat42: function mulMat42(dest, a, b) {
    var a11 = a[0],
        a12 = a[1],
        a13 = a[2],
        a14 = a[3],
        a21 = a[4],
        a22 = a[5],
        a23 = a[6],
        a24 = a[7],
        a31 = a[8],
        a32 = a[9],
        a33 = a[10],
        a34 = a[11],
        a41 = a[12],
        a42 = a[13],
        a43 = a[14],
        a44 = a[15],
        b11 = b[0],
        b12 = b[1],
        b13 = b[2],
        b14 = b[3],
        b21 = b[4],
        b22 = b[5],
        b23 = b[6],
        b24 = b[7],
        b31 = b[8],
        b32 = b[9],
        b33 = b[10],
        b34 = b[11],
        b41 = b[12],
        b42 = b[13],
        b43 = b[14],
        b44 = b[15];

    dest[0] = b11 * a11 + b12 * a21 + b13 * a31 + b14 * a41;
    dest[1] = b11 * a12 + b12 * a22 + b13 * a32 + b14 * a42;
    dest[2] = b11 * a13 + b12 * a23 + b13 * a33 + b14 * a43;
    dest[3] = b11 * a14 + b12 * a24 + b13 * a34 + b14 * a44;

    dest[4] = b21 * a11 + b22 * a21 + b23 * a31 + b24 * a41;
    dest[5] = b21 * a12 + b22 * a22 + b23 * a32 + b24 * a42;
    dest[6] = b21 * a13 + b22 * a23 + b23 * a33 + b24 * a43;
    dest[7] = b21 * a14 + b22 * a24 + b23 * a34 + b24 * a44;

    dest[8] = b31 * a11 + b32 * a21 + b33 * a31 + b34 * a41;
    dest[9] = b31 * a12 + b32 * a22 + b33 * a32 + b34 * a42;
    dest[10] = b31 * a13 + b32 * a23 + b33 * a33 + b34 * a43;
    dest[11] = b31 * a14 + b32 * a24 + b33 * a34 + b34 * a44;

    dest[12] = b41 * a11 + b42 * a21 + b43 * a31 + b44 * a41;
    dest[13] = b41 * a12 + b42 * a22 + b43 * a32 + b44 * a42;
    dest[14] = b41 * a13 + b42 * a23 + b43 * a33 + b44 * a43;
    dest[15] = b41 * a14 + b42 * a24 + b43 * a34 + b44 * a44;
    return dest;
  },
  mulMat4: function mulMat4(a, b) {
    var m = Mat4.clone(a);
    return Mat4.mulMat42(m, a, b);
  },
  $mulMat4: function $mulMat4(a, b) {
    return Mat4.mulMat42(a, a, b);
  },
  add: function add(dest, m) {
    var copy = Mat4.clone(dest);
    return Mat4.$add(copy, m);
  },
  $add: function $add(dest, m) {
    dest[0] += m[0];
    dest[1] += m[1];
    dest[2] += m[2];
    dest[3] += m[3];
    dest[4] += m[4];
    dest[5] += m[5];
    dest[6] += m[6];
    dest[7] += m[7];
    dest[8] += m[8];
    dest[9] += m[9];
    dest[10] += m[10];
    dest[11] += m[11];
    dest[12] += m[12];
    dest[13] += m[13];
    dest[14] += m[14];
    dest[15] += m[15];

    return dest;
  },
  transpose: function transpose(dest) {
    var m = Mat4.clone(dest);
    return Mat4.$transpose(m);
  },
  $transpose: function $transpose(dest) {
    var n4 = dest[4],
        n8 = dest[8],
        n12 = dest[12],
        n1 = dest[1],
        n9 = dest[9],
        n13 = dest[13],
        n2 = dest[2],
        n6 = dest[6],
        n14 = dest[14],
        n3 = dest[3],
        n7 = dest[7],
        n11 = dest[11];

    dest[1] = n4;
    dest[2] = n8;
    dest[3] = n12;
    dest[4] = n1;
    dest[6] = n9;
    dest[7] = n13;
    dest[8] = n2;
    dest[9] = n6;
    dest[11] = n14;
    dest[12] = n3;
    dest[13] = n7;
    dest[14] = n11;

    return dest;
  },
  rotateAxis: function rotateAxis(dest, theta, vec) {
    var m = Mat4.clone(dest);
    return Mat4.$rotateAxis(m, theta, vec);
  },
  $rotateAxis: function $rotateAxis(dest, theta, vec) {
    var s = sin(theta),
        c = cos(theta),
        nc = 1 - c,
        vx = vec[0],
        vy = vec[1],
        vz = vec[2],
        m11 = vx * vx * nc + c,
        m12 = vx * vy * nc + vz * s,
        m13 = vx * vz * nc - vy * s,
        m21 = vy * vx * nc - vz * s,
        m22 = vy * vy * nc + c,
        m23 = vy * vz * nc + vx * s,
        m31 = vx * vz * nc + vy * s,
        m32 = vy * vz * nc - vx * s,
        m33 = vz * vz * nc + c,
        d11 = dest[0],
        d12 = dest[1],
        d13 = dest[2],
        d14 = dest[3],
        d21 = dest[4],
        d22 = dest[5],
        d23 = dest[6],
        d24 = dest[7],
        d31 = dest[8],
        d32 = dest[9],
        d33 = dest[10],
        d34 = dest[11],
        d41 = dest[12],
        d42 = dest[13],
        d43 = dest[14],
        d44 = dest[15];

    dest[0] = d11 * m11 + d21 * m12 + d31 * m13;
    dest[1] = d12 * m11 + d22 * m12 + d32 * m13;
    dest[2] = d13 * m11 + d23 * m12 + d33 * m13;
    dest[3] = d14 * m11 + d24 * m12 + d34 * m13;

    dest[4] = d11 * m21 + d21 * m22 + d31 * m23;
    dest[5] = d12 * m21 + d22 * m22 + d32 * m23;
    dest[6] = d13 * m21 + d23 * m22 + d33 * m23;
    dest[7] = d14 * m21 + d24 * m22 + d34 * m23;

    dest[8] = d11 * m31 + d21 * m32 + d31 * m33;
    dest[9] = d12 * m31 + d22 * m32 + d32 * m33;
    dest[10] = d13 * m31 + d23 * m32 + d33 * m33;
    dest[11] = d14 * m31 + d24 * m32 + d34 * m33;

    return dest;
  },
  rotateXYZ: function rotateXYZ(dest, rx, ry, rz) {
    var ans = Mat4.clone(dest);
    return Mat4.$rotateXYZ(ans, rx, ry, rz);
  },
  $rotateXYZ: function $rotateXYZ(dest, rx, ry, rz) {
    var d11 = dest[0],
        d12 = dest[1],
        d13 = dest[2],
        d14 = dest[3],
        d21 = dest[4],
        d22 = dest[5],
        d23 = dest[6],
        d24 = dest[7],
        d31 = dest[8],
        d32 = dest[9],
        d33 = dest[10],
        d34 = dest[11],
        crx = cos(rx),
        cry = cos(ry),
        crz = cos(rz),
        srx = sin(rx),
        sry = sin(ry),
        srz = sin(rz),
        m11 = cry * crz,
        m21 = -crx * srz + srx * sry * crz,
        m31 = srx * srz + crx * sry * crz,
        m12 = cry * srz,
        m22 = crx * crz + srx * sry * srz,
        m32 = -srx * crz + crx * sry * srz,
        m13 = -sry,
        m23 = srx * cry,
        m33 = crx * cry;

    dest[0] = d11 * m11 + d21 * m12 + d31 * m13;
    dest[1] = d12 * m11 + d22 * m12 + d32 * m13;
    dest[2] = d13 * m11 + d23 * m12 + d33 * m13;
    dest[3] = d14 * m11 + d24 * m12 + d34 * m13;

    dest[4] = d11 * m21 + d21 * m22 + d31 * m23;
    dest[5] = d12 * m21 + d22 * m22 + d32 * m23;
    dest[6] = d13 * m21 + d23 * m22 + d33 * m23;
    dest[7] = d14 * m21 + d24 * m22 + d34 * m23;

    dest[8] = d11 * m31 + d21 * m32 + d31 * m33;
    dest[9] = d12 * m31 + d22 * m32 + d32 * m33;
    dest[10] = d13 * m31 + d23 * m32 + d33 * m33;
    dest[11] = d14 * m31 + d24 * m32 + d34 * m33;

    return dest;
  },
  translate: function translate(dest, x, y, z) {
    var m = Mat4.clone(dest);
    return Mat4.$translate(m, x, y, z);
  },
  $translate: function $translate(dest, x, y, z) {
    dest[12] = dest[0] * x + dest[4] * y + dest[8] * z + dest[12];
    dest[13] = dest[1] * x + dest[5] * y + dest[9] * z + dest[13];
    dest[14] = dest[2] * x + dest[6] * y + dest[10] * z + dest[14];
    dest[15] = dest[3] * x + dest[7] * y + dest[11] * z + dest[15];

    return dest;
  },
  scale: function scale(dest, x, y, z) {
    var m = Mat4.clone(dest);
    return Mat4.$scale(m, x, y, z);
  },
  $scale: function $scale(dest, x, y, z) {
    dest[0] *= x;
    dest[1] *= x;
    dest[2] *= x;
    dest[3] *= x;
    dest[4] *= y;
    dest[5] *= y;
    dest[6] *= y;
    dest[7] *= y;
    dest[8] *= z;
    dest[9] *= z;
    dest[10] *= z;
    dest[11] *= z;

    return dest;
  },


  // Method based on PreGL https:// github.com/deanm/pregl/ (c) Dean McNamee.
  invert: function invert(dest) {
    var m = Mat4.clone(dest);
    return Mat4.$invert(m);
  },
  $invert: function $invert(dest) {
    var x0 = dest[0],
        x1 = dest[1],
        x2 = dest[2],
        x3 = dest[3],
        x4 = dest[4],
        x5 = dest[5],
        x6 = dest[6],
        x7 = dest[7],
        x8 = dest[8],
        x9 = dest[9],
        x10 = dest[10],
        x11 = dest[11],
        x12 = dest[12],
        x13 = dest[13],
        x14 = dest[14],
        x15 = dest[15];

    var a0 = x0 * x5 - x1 * x4,
        a1 = x0 * x6 - x2 * x4,
        a2 = x0 * x7 - x3 * x4,
        a3 = x1 * x6 - x2 * x5,
        a4 = x1 * x7 - x3 * x5,
        a5 = x2 * x7 - x3 * x6,
        b0 = x8 * x13 - x9 * x12,
        b1 = x8 * x14 - x10 * x12,
        b2 = x8 * x15 - x11 * x12,
        b3 = x9 * x14 - x10 * x13,
        b4 = x9 * x15 - x11 * x13,
        b5 = x10 * x15 - x11 * x14;

    var invdet = 1 / (a0 * b5 - a1 * b4 + a2 * b3 + a3 * b2 - a4 * b1 + a5 * b0);

    dest[0] = (+x5 * b5 - x6 * b4 + x7 * b3) * invdet;
    dest[1] = (-x1 * b5 + x2 * b4 - x3 * b3) * invdet;
    dest[2] = (+x13 * a5 - x14 * a4 + x15 * a3) * invdet;
    dest[3] = (-x9 * a5 + x10 * a4 - x11 * a3) * invdet;
    dest[4] = (-x4 * b5 + x6 * b2 - x7 * b1) * invdet;
    dest[5] = (+x0 * b5 - x2 * b2 + x3 * b1) * invdet;
    dest[6] = (-x12 * a5 + x14 * a2 - x15 * a1) * invdet;
    dest[7] = (+x8 * a5 - x10 * a2 + x11 * a1) * invdet;
    dest[8] = (+x4 * b4 - x5 * b2 + x7 * b0) * invdet;
    dest[9] = (-x0 * b4 + x1 * b2 - x3 * b0) * invdet;
    dest[10] = (+x12 * a4 - x13 * a2 + x15 * a0) * invdet;
    dest[11] = (-x8 * a4 + x9 * a2 - x11 * a0) * invdet;
    dest[12] = (-x4 * b3 + x5 * b1 - x6 * b0) * invdet;
    dest[13] = (+x0 * b3 - x1 * b1 + x2 * b0) * invdet;
    dest[14] = (-x12 * a3 + x13 * a1 - x14 * a0) * invdet;
    dest[15] = (+x8 * a3 - x9 * a1 + x10 * a0) * invdet;

    return dest;
  },

  // TODO(nico) breaking convention here...
  // because I don't think it's useful to add
  // two methods for each of these.
  lookAt: function lookAt(dest, eye, center, up) {
    var z = Vec3.sub(eye, center);
    z.$unit();
    var x = Vec3.cross(up, z);
    x.$unit();
    var y = Vec3.cross(z, x);
    y.$unit();
    return Mat4.set(dest, x[0], x[1], x[2], -x.dot(eye), y[0], y[1], y[2], -y.dot(eye), z[0], z[1], z[2], -z.dot(eye), 0, 0, 0, 1);
  },
  frustum: function frustum(dest, left, right, bottom, top, near, far) {
    var rl = right - left,
        tb = top - bottom,
        fn = far - near;

    dest[0] = near * 2 / rl;
    dest[1] = 0;
    dest[2] = 0;
    dest[3] = 0;
    dest[4] = 0;
    dest[5] = near * 2 / tb;
    dest[6] = 0;
    dest[7] = 0;
    dest[8] = (right + left) / rl;
    dest[9] = (top + bottom) / tb;
    dest[10] = -(far + near) / fn;
    dest[11] = -1;
    dest[12] = 0;
    dest[13] = 0;
    dest[14] = -(far * near * 2) / fn;
    dest[15] = 0;

    return dest;
  },
  perspective: function perspective(dest, fov, aspect, near, far) {
    var ymax = near * tan(fov * pi / 360),
        ymin = -ymax,
        xmin = ymin * aspect,
        xmax = ymax * aspect;

    return Mat4.frustum(dest, xmin, xmax, ymin, ymax, near, far);
  },
  ortho: function ortho(dest, left, right, top, bottom, near, far) {
    var te = this.elements,
        w = right - left,
        h = top - bottom,
        p = far - near,
        x = (right + left) / w,
        y = (top + bottom) / h,
        z = (far + near) / p;

    dest[0] = 2 / w;dest[4] = 0;dest[8] = 0;dest[12] = -x;
    dest[1] = 0;dest[5] = 2 / h;dest[9] = 0;dest[13] = -y;
    dest[2] = 0;dest[6] = 0;dest[10] = -2 / p;dest[14] = -z;
    dest[3] = 0;dest[7] = 0;dest[11] = 0;dest[15] = 1;

    return dest;
  },
  toFloat32Array: function toFloat32Array(dest) {
    var ans = dest.typedContainer;

    if (!ans) {
      return dest;
    }

    ans[0] = dest[0];
    ans[1] = dest[1];
    ans[2] = dest[2];
    ans[3] = dest[3];
    ans[4] = dest[4];
    ans[5] = dest[5];
    ans[6] = dest[6];
    ans[7] = dest[7];
    ans[8] = dest[8];
    ans[9] = dest[9];
    ans[10] = dest[10];
    ans[11] = dest[11];
    ans[12] = dest[12];
    ans[13] = dest[13];
    ans[14] = dest[14];
    ans[15] = dest[15];

    return ans;
  }
};

// add generics and instance methods
proto = Mat4.prototype;
for (method in generics) {
  Mat4[method] = generics[method];
  proto[method] = function (m) {
    return function () {
      var args = slice.call(arguments);

      args.unshift(this);
      return Mat4[m].apply(Mat4, args);
    };
  }(method);
}

// Quaternion class

var Quat = exports.Quat = function (_extendableBuiltin6) {
  _inherits(Quat, _extendableBuiltin6);

  function Quat(x, y, z, w) {
    _classCallCheck(this, Quat);

    var _this3 = _possibleConstructorReturn(this, (Quat.__proto__ || Object.getPrototypeOf(Quat)).call(this, 4));

    _this3[0] = x || 0;
    _this3[1] = y || 0;
    _this3[2] = z || 0;
    _this3[3] = w || 0;

    _this3.typedContainer = new Float32Array(4);
    return _this3;
  }

  _createClass(Quat, null, [{
    key: 'create',
    value: function create() {
      return new Array(4);
    }
  }, {
    key: 'fromVec3',
    value: function fromVec3(v, r) {
      return new Quat(v[0], v[1], v[2], r || 0);
    }
  }, {
    key: 'fromMat4',
    value: function fromMat4(m) {
      var u;
      var v;
      var w;

      // Choose u, v, and w such that u is the index of the biggest diagonal entry
      // of m, and u v w is an even permutation of 0 1 and 2.
      if (m[0] > m[5] && m[0] > m[10]) {
        u = 0;
        v = 1;
        w = 2;
      } else if (m[5] > m[0] && m[5] > m[10]) {
        u = 1;
        v = 2;
        w = 0;
      } else {
        u = 2;
        v = 0;
        w = 1;
      }

      var r = sqrt(1 + m[u * 5] - m[v * 5] - m[w * 5]);
      var q = new Quat();

      q[u] = 0.5 * r;
      q[v] = 0.5 * (m['n' + v + '' + u] + m['n' + u + '' + v]) / r;
      q[w] = 0.5 * (m['n' + u + '' + w] + m['n' + w + '' + u]) / r;
      q[3] = 0.5 * (m['n' + v + '' + w] - m['n' + w + '' + v]) / r;

      return q;
    }
  }, {
    key: 'fromXRotation',
    value: function fromXRotation(angle) {
      return new Quat(sin(angle / 2), 0, 0, cos(angle / 2));
    }
  }, {
    key: 'fromYRotation',
    value: function fromYRotation(angle) {
      return new Quat(0, sin(angle / 2), 0, cos(angle / 2));
    }
  }, {
    key: 'fromZRotation',
    value: function fromZRotation(angle) {
      return new Quat(0, 0, sin(angle / 2), cos(angle / 2));
    }
  }, {
    key: 'fromAxisRotation',
    value: function fromAxisRotation(vec, angle) {
      var x = vec[0],
          y = vec[1],
          z = vec[2],
          d = 1 / sqrt(x * x + y * y + z * z),
          s = sin(angle / 2),
          c = cos(angle / 2);

      return new Quat(s * x * d, s * y * d, s * z * d, c);
    }
  }]);

  return Quat;
}(_extendableBuiltin5(Array));

generics = {
  setQuat: function setQuat(dest, q) {
    dest[0] = q[0];
    dest[1] = q[1];
    dest[2] = q[2];
    dest[3] = q[3];

    return dest;
  },
  set: function set(dest, x, y, z, w) {
    dest[0] = x || 0;
    dest[1] = y || 0;
    dest[2] = z || 0;
    dest[3] = w || 0;

    return dest;
  },
  clone: function clone(dest) {
    if (dest instanceof Quat) {
      return new Quat(dest[0], dest[1], dest[2], dest[3]);
    }
    return Quat.setQuat(new typedArray(4), dest);
  },
  neg: function neg(dest) {
    return new Quat(-dest[0], -dest[1], -dest[2], -dest[3]);
  },
  $neg: function $neg(dest) {
    dest[0] = -dest[0];
    dest[1] = -dest[1];
    dest[2] = -dest[2];
    dest[3] = -dest[3];

    return dest;
  },
  add: function add(dest, q) {
    return new Quat(dest[0] + q[0], dest[1] + q[1], dest[2] + q[2], dest[3] + q[3]);
  },
  $add: function $add(dest, q) {
    dest[0] += q[0];
    dest[1] += q[1];
    dest[2] += q[2];
    dest[3] += q[3];

    return dest;
  },
  sub: function sub(dest, q) {
    return new Quat(dest[0] - q[0], dest[1] - q[1], dest[2] - q[2], dest[3] - q[3]);
  },
  $sub: function $sub(dest, q) {
    dest[0] -= q[0];
    dest[1] -= q[1];
    dest[2] -= q[2];
    dest[3] -= q[3];

    return dest;
  },
  scale: function scale(dest, s) {
    return new Quat(dest[0] * s, dest[1] * s, dest[2] * s, dest[3] * s);
  },
  $scale: function $scale(dest, s) {
    dest[0] *= s;
    dest[1] *= s;
    dest[2] *= s;
    dest[3] *= s;

    return dest;
  },
  mulQuat: function mulQuat(dest, q) {
    var aX = dest[0],
        aY = dest[1],
        aZ = dest[2],
        aW = dest[3],
        bX = q[0],
        bY = q[1],
        bZ = q[2],
        bW = q[3];

    return new Quat(aW * bX + aX * bW + aY * bZ - aZ * bY, aW * bY + aY * bW + aZ * bX - aX * bZ, aW * bZ + aZ * bW + aX * bY - aY * bX, aW * bW - aX * bX - aY * bY - aZ * bZ);
  },
  $mulQuat: function $mulQuat(dest, q) {
    var aX = dest[0],
        aY = dest[1],
        aZ = dest[2],
        aW = dest[3],
        bX = q[0],
        bY = q[1],
        bZ = q[2],
        bW = q[3];

    dest[0] = aW * bX + aX * bW + aY * bZ - aZ * bY;
    dest[1] = aW * bY + aY * bW + aZ * bX - aX * bZ;
    dest[2] = aW * bZ + aZ * bW + aX * bY - aY * bX;
    dest[3] = aW * bW - aX * bX - aY * bY - aZ * bZ;

    return dest;
  },
  divQuat: function divQuat(dest, q) {
    var aX = dest[0],
        aY = dest[1],
        aZ = dest[2],
        aW = dest[3],
        bX = q[0],
        bY = q[1],
        bZ = q[2],
        bW = q[3];

    var d = 1 / (bW * bW + bX * bX + bY * bY + bZ * bZ);

    return new Quat((aX * bW - aW * bX - aY * bZ + aZ * bY) * d, (aX * bZ - aW * bY + aY * bW - aZ * bX) * d, (aY * bX + aZ * bW - aW * bZ - aX * bY) * d, (aW * bW + aX * bX + aY * bY + aZ * bZ) * d);
  },
  $divQuat: function $divQuat(dest, q) {
    var aX = dest[0],
        aY = dest[1],
        aZ = dest[2],
        aW = dest[3],
        bX = q[0],
        bY = q[1],
        bZ = q[2],
        bW = q[3];

    var d = 1 / (bW * bW + bX * bX + bY * bY + bZ * bZ);

    dest[0] = (aX * bW - aW * bX - aY * bZ + aZ * bY) * d;
    dest[1] = (aX * bZ - aW * bY + aY * bW - aZ * bX) * d;
    dest[2] = (aY * bX + aZ * bW - aW * bZ - aX * bY) * d;
    dest[3] = (aW * bW + aX * bX + aY * bY + aZ * bZ) * d;

    return dest;
  },
  invert: function invert(dest) {
    var q0 = dest[0],
        q1 = dest[1],
        q2 = dest[2],
        q3 = dest[3];

    var d = 1 / (q0 * q0 + q1 * q1 + q2 * q2 + q3 * q3);

    return new Quat(-q0 * d, -q1 * d, -q2 * d, q3 * d);
  },
  $invert: function $invert(dest) {
    var q0 = dest[0],
        q1 = dest[1],
        q2 = dest[2],
        q3 = dest[3];

    var d = 1 / (q0 * q0 + q1 * q1 + q2 * q2 + q3 * q3);

    dest[0] = -q0 * d;
    dest[1] = -q1 * d;
    dest[2] = -q2 * d;
    dest[3] = q3 * d;

    return dest;
  },
  norm: function norm(dest) {
    var a = dest[0],
        b = dest[1],
        c = dest[2],
        d = dest[3];

    return sqrt(a * a + b * b + c * c + d * d);
  },
  normSq: function normSq(dest) {
    var a = dest[0],
        b = dest[1],
        c = dest[2],
        d = dest[3];

    return a * a + b * b + c * c + d * d;
  },
  unit: function unit(dest) {
    return Quat.scale(dest, 1 / Quat.norm(dest));
  },
  $unit: function $unit(dest) {
    return Quat.$scale(dest, 1 / Quat.norm(dest));
  },
  conjugate: function conjugate(dest) {
    return new Quat(-dest[0], -dest[1], -dest[2], dest[3]);
  },
  $conjugate: function $conjugate(dest) {
    dest[0] = -dest[0];
    dest[1] = -dest[1];
    dest[2] = -dest[2];
    return dest;
  }
};

// add generics and instance methods

proto = Quat.prototype = {};

for (method in generics) {
  Quat[method] = generics[method];
  proto[method] = function (m) {
    return function () {
      var args = slice.call(arguments);

      args.unshift(this);
      return Quat[m].apply(Quat, args);
    };
  }(method);
}

// Add static methods
Vec3.fromQuat = function (q) {
  return new Vec3(q[0], q[1], q[2]);
};

Mat4.fromQuat = function (q) {
  var a = q[3],
      b = q[0],
      c = q[1],
      d = q[2];

  return new Mat4(a * a + b * b - c * c - d * d, 2 * b * c - 2 * a * d, 2 * b * d + 2 * a * c, 0, 2 * b * c + 2 * a * d, a * a - b * b + c * c - d * d, 2 * c * d - 2 * a * b, 0, 2 * b * d - 2 * a * c, 2 * c * d + 2 * a * b, a * a - b * b - c * c + d * d, 0, 0, 0, 0, 1);
};
//# sourceMappingURL=data:application/json;base64,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