'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _utils = require('../../utils');

var _math = require('../math');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Object3D = function () {
  function Object3D(_ref) {
    var id = _ref.id,
        _ref$display = _ref.display,
        display = _ref$display === undefined ? true : _ref$display;

    _classCallCheck(this, Object3D);

    // model position, rotation, scale and all in all matrix
    this.position = new _math.Vec3();
    this.rotation = new _math.Vec3();
    this.scale = new _math.Vec3(1, 1, 1);
    this.matrix = new _math.Mat4();

    // whether to display the object at all
    this.id = id || (0, _utils.uid)(this.constructor.name);
    this.display = true;
    this.userData = {};
  }

  _createClass(Object3D, [{
    key: 'setPosition',
    value: function setPosition(position) {
      (0, _assert2.default)(position.length === 3, 'setPosition requires vector argument');
      this.position = position;
      return this;
    }
  }, {
    key: 'setRotation',
    value: function setRotation(rotation) {
      (0, _assert2.default)(rotation.length === 3, 'setRotation requires vector argument');
      this.rotation = rotation;
      return this;
    }
  }, {
    key: 'setScale',
    value: function setScale(scale) {
      (0, _assert2.default)(scale.length === 3, 'setScale requires vector argument');
      this.scale = scale;
      return this;
    }
  }, {
    key: 'setMatrixComponents',
    value: function setMatrixComponents(_ref2) {
      var position = _ref2.position,
          rotation = _ref2.rotation,
          scale = _ref2.scale,
          _ref2$update = _ref2.update,
          update = _ref2$update === undefined ? true : _ref2$update;

      if (position) {
        this.setPosition(position);
      }
      if (rotation) {
        this.setRotation(rotation);
      }
      if (scale) {
        this.setScale(scale);
      }
      if (update) {
        this.updateMatrix();
      }
      return this;
    }
  }, {
    key: 'updateMatrix',
    value: function updateMatrix() {
      var pos = this.position;
      var rot = this.rotation;
      var scale = this.scale;

      this.matrix.id();
      this.matrix.$translate(pos[0], pos[1], pos[2]);
      this.matrix.$rotateXYZ(rot[0], rot[1], rot[2]);
      this.matrix.$scale(scale[0], scale[1], scale[2]);
      return this;
    }
  }, {
    key: 'update',
    value: function update() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          position = _ref3.position,
          rotation = _ref3.rotation,
          scale = _ref3.scale;

      if (position) {
        this.setPosition(position);
      }
      if (rotation) {
        this.setRotation(rotation);
      }
      if (scale) {
        this.setScale(scale);
      }
      this.updateMatrix();
      return this;
    }
  }, {
    key: 'getCoordinateUniforms',
    value: function getCoordinateUniforms(viewMatrix, modelMatrix) {
      // TODO - solve multiple class problem
      // assert(viewMatrix instanceof Mat4);
      (0, _assert2.default)(viewMatrix);
      modelMatrix = modelMatrix || this.matrix;
      var worldMatrix = new _math.Mat4().copy(viewMatrix).mulMat4(modelMatrix);
      var worldInverse = worldMatrix.invert();
      var worldInverseTranspose = worldInverse.transpose();

      return {
        viewMatrix: viewMatrix,
        modelMatrix: modelMatrix,
        objectMatrix: modelMatrix,
        worldMatrix: worldMatrix,
        worldInverseMatrix: worldInverse,
        worldInverseTransposeMatrix: worldInverseTranspose
      };
    }

    // TODO - copied code, not yet vetted

  }, {
    key: 'transform',
    value: function transform() {

      if (!this.parent) {
        this.endPosition.setVec3(this.position);
        this.endRotation.setVec3(this.rotation);
        this.endScale.setVec3(this.scale);
      } else {
        var parent = this.parent;
        this.endPosition.setVec3(this.position.add(parent.endPosition));
        this.endRotation.setVec3(this.rotation.add(parent.endRotation));
        this.endScale.setVec3(this.scale.add(parent.endScale));
      }

      var ch = this.children;
      for (var i = 0; i < ch.length; ++i) {
        ch[i].transform();
      }

      return this;
    }
  }]);

  return Object3D;
}();

exports.default = Object3D;
//# sourceMappingURL=data:application/json;base64,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