var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* eslint-disable no-console */
import { IS_NODE, logger, timestamp } from './env';

// TODO - this used to use d3.format(.3s)
function formatSI(value) {
  return value.toFixed(3);
}

// TODO: Currently unused, keeping in case we want it later for log formatting
export function formatTime(ms) {
  var formatted = void 0;
  if (ms < 10) {
    formatted = ms.toFixed(2) + 'ms';
  } else if (ms < 100) {
    formatted = ms.toFixed(1) + 'ms';
  } else if (ms < 1000) {
    formatted = (ms / 1000).toFixed(3) + 's';
  } else {
    formatted = (ms / 1000).toFixed(2) + 's';
  }
  return formatted;
}

var DEFAULT_CONFIG = {
  // off by default
  isEnabled: false,
  // logging level
  level: 1,
  // Whether logging is turned on
  isLogEnabled: true,
  // Whether logging prints to console
  isPrintEnabled: true,
  // Whether Probe#run executes code
  isRunEnabled: true
};

function noop() {}

var TO_DISABLE = ['_probe', '_fps', '_externalProbe', '_log', 'run', 'getOption', 'getIterationsPerSecond', 'logIterationsPerSecond'];

var Probe = function () {

  /**
   * @constructor
   * @param {Object} config Optional configuration args; see #configure
   */
  function Probe() {
    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Probe);

    // Data containers
    this._logStore = [];
    this._sampleStore = {};
    this._fpsStore = {};
    this._startStore = {};
    // Timestamps - pegged to an arbitrary time in the past
    this._startTs = timestamp();
    this._deltaTs = timestamp();
    // Other systems passing in epoch info require an epoch ts to convert
    this._startEpochTs = Date.now();
    this._iterationsTs = null;
    // Configuration
    this._config = config.ignoreEnvironment ? Object.assign({}, DEFAULT_CONFIG) : this._getConfigFromEnvironment();
    // Override with new configuration, if any
    this.configure(config);
    // Disable methods if necessary
    if (!this._config.isEnabled) {
      this.disable();
    }
  }

  /**
   * Turn probe on
   * @return {Probe} self, to support chaining
   */


  _createClass(Probe, [{
    key: 'enable',
    value: function enable() {
      // Swap in live methods
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = TO_DISABLE[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var method = _step.value;

          this[method] = Probe.prototype[method];
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this.configure({ isEnabled: true });
    }

    /**
     * Turn probe off
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'disable',
    value: function disable() {
      // Swap in noops for live methods
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = TO_DISABLE[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var method = _step2.value;

          this[method] = noop;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return this.configure({ isEnabled: false });
    }

    /**
     * Convenience function: Set probe level
     * @param {Number} level Level to set
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'setLevel',
    value: function setLevel(level) {
      return this.configure({ level: level });
    }

    /**
     * Configure probe with new values (can include custom key/value pairs).
     * Configuration will be persisted across browser sessions
     * @param {Object} config - named parameters
     * @param {Boolean} config.isEnabled Whether probe is enabled
     * @param {Number} config.level Logging level
     * @param {Boolean} config.isLogEnabled Whether logging prints to console
     * @param {Boolean} config.isRunEnabled Whether #run executes code
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'configure',
    value: function configure() {
      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var newConfig = Object.assign({}, this._config, config);
      this._config = newConfig;
      // if (!IS_NODE) {
      //   const serialized = JSON.stringify(newConfig);
      //   cookie.set(COOKIE_NAME, serialized);
      // }
      // Support chaining
      return this;
    }

    /**
     * Get a single option from preset configuration. Useful when using Probe to
     * set developer-only switches.
     * @param  {String} key Key to get value for
     * @return {mixed}     Option value, or undefined
     */

  }, {
    key: 'getOption',
    value: function getOption(key) {
      return this._config[key];
    }

    /**
     * Get current log, as an array of log row objects
     * @return {Object[]} Log
     */

  }, {
    key: 'getLog',
    value: function getLog() {
      return this._logStore.slice();
    }

    /**
     * Whether Probe is currently enabled
     * @return {Boolean} isEnabled
     */

  }, {
    key: 'isEnabled',
    value: function isEnabled() {
      return Boolean(this._config.isEnabled);
    }

    /**
     * Reset all internal stores, dropping logs
     */

  }, {
    key: 'reset',
    value: function reset() {
      // Data containers
      this._logStore = [];
      this._sampleStore = {};
      this._fpsStore = {};
      this._startStore = {};
      // Timestamps
      this._startTs = timestamp();
      this._deltaTs = timestamp();
      this._iterationsTs = null;
    }

    /**
     * Reset the long timer
     */

  }, {
    key: 'resetStart',
    value: function resetStart() {
      this._startTs = this._deltaTs = timestamp();
    }

    /**
     * Reset the time since last probe
     */

  }, {
    key: 'resetDelta',
    value: function resetDelta() {
      this._deltaTs = timestamp();
    }

    /**
     * @return {Number} milliseconds, with fractions
     */

  }, {
    key: 'getTotal',
    value: function getTotal() {
      return timestamp() - this._startTs;
    }

    /**
     * @return {Number} milliseconds, with fractions
     */

  }, {
    key: 'getDelta',
    value: function getDelta() {
      return timestamp() - this._deltaTs;
    }
  }, {
    key: '_getElapsedTime',
    value: function _getElapsedTime() {
      var total = timestamp() - this._startTs;
      var delta = timestamp() - this._deltaTs;
      // reset delta timer
      this._deltaTs = timestamp();
      return { total: total, delta: delta };
    }
  }, {
    key: '_log',
    value: function _log(level, name) {
      var meta = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var times = this._getElapsedTime();
      var logRow = Object.assign({ level: level, name: name }, times, meta);
      // duration handling
      if (meta.start) {
        this._startStore[name] = timestamp();
      } else if (meta.end) {
        // If start isn't found, take the full duration since initialization
        var start = this._startStore[name] || this._startTs;
        logRow.duration = timestamp() - start;
      }
      this._logStore.push(logRow);
      // Log to console if enabled
      if (this._config.isPrintEnabled) {
        // TODO: Nicer console logging
        logger.debug(JSON.stringify(logRow));
      }
    }
  }, {
    key: '_shouldLog',
    value: function _shouldLog(probeLevel) {
      var _config = this._config,
          isEnabled = _config.isEnabled,
          isLogEnabled = _config.isLogEnabled,
          level = _config.level;

      return isEnabled && isLogEnabled && level >= probeLevel;
    }

    /**
     * Displays a double timing (from "start time" and from last probe).
     */

  }, {
    key: 'probe',
    value: function probe() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      this._probe.apply(this, [1].concat(args));
    }
  }, {
    key: 'probe1',
    value: function probe1() {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      this._probe.apply(this, [1].concat(args));
    }
  }, {
    key: 'probe2',
    value: function probe2() {
      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      this._probe.apply(this, [2].concat(args));
    }
  }, {
    key: 'probe3',
    value: function probe3() {
      for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }

      this._probe.apply(this, [3].concat(args));
    }
  }, {
    key: '_probe',
    value: function _probe(level, name, meta) {
      if (this._shouldLog(level)) {
        this._log(level, name, meta);
      }
    }

    /**
     * Display an averaged value of the time since last probe.
     * Keyed on the first string argument.
     */

  }, {
    key: 'sample',
    value: function sample() {
      for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        args[_key5] = arguments[_key5];
      }

      this._sample.apply(this, [1].concat(args));
    }
  }, {
    key: 'sample1',
    value: function sample1() {
      for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        args[_key6] = arguments[_key6];
      }

      this._sample.apply(this, [1].concat(args));
    }
  }, {
    key: 'sample2',
    value: function sample2() {
      for (var _len7 = arguments.length, args = Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        args[_key7] = arguments[_key7];
      }

      this._sample.apply(this, [2].concat(args));
    }
  }, {
    key: 'sample3',
    value: function sample3() {
      for (var _len8 = arguments.length, args = Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
        args[_key8] = arguments[_key8];
      }

      this._sample.apply(this, [3].concat(args));
    }
  }, {
    key: '_sample',
    value: function _sample(level, name, meta) {
      if (this._shouldLog(level)) {
        var samples = this._sampleStore;

        var probeData = samples[name] || (samples[name] = { timeSum: 0, count: 0, averageTime: 0 });
        probeData.timeSum += timestamp() - this._deltaTs;
        probeData.count += 1;
        probeData.averageTime = probeData.timeSum / probeData.count;

        this._log(level, name, Object.assign({}, meta, { averageTime: probeData.averageTime }));

        // Weight more heavily on later samples. Otherwise it gets almost
        // impossible to see outliers after a while.
        if (probeData.count === 10) {
          probeData.count = 5;
          probeData.timeSum /= 2;
        }
      }
    }

    /**
     * These functions will average the time between calls and log that value
     * every couple of calls, in effect showing a times per second this
     * function is called - sometimes representing a "frames per second" count.
     */

  }, {
    key: 'fps',
    value: function fps() {
      for (var _len9 = arguments.length, args = Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
        args[_key9] = arguments[_key9];
      }

      this._fps.apply(this, [1].concat(args));
    }
  }, {
    key: 'fps1',
    value: function fps1() {
      for (var _len10 = arguments.length, args = Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
        args[_key10] = arguments[_key10];
      }

      this._fps.apply(this, [1].concat(args));
    }
  }, {
    key: 'fps2',
    value: function fps2() {
      for (var _len11 = arguments.length, args = Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
        args[_key11] = arguments[_key11];
      }

      this._fps.apply(this, [2].concat(args));
    }
  }, {
    key: 'fps3',
    value: function fps3() {
      for (var _len12 = arguments.length, args = Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
        args[_key12] = arguments[_key12];
      }

      this._fps.apply(this, [3].concat(args));
    }
  }, {
    key: '_fps',
    value: function _fps(level) {
      var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'default';
      var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var _opts$count = opts.count,
          count = _opts$count === undefined ? 10 : _opts$count;

      if (this._shouldLog(level)) {
        var fpsLog = this._fpsStore;
        var fpsData = fpsLog[name];
        if (!fpsData) {
          fpsLog[name] = { count: 1, time: timestamp() };
        } else if (++fpsData.count >= count) {
          var fps = fpsData.count / (timestamp() - fpsData.time);
          fpsData.count = 0;
          fpsData.time = timestamp();
          this._log(level, name, Object.assign({ fps: fps }, opts));
        }
      }
    }

    /**
     * Display a measurement from an external source, such as a server,
     * inline with other local measurements in the style of Probe's output.
     */

  }, {
    key: 'externalProbe',
    value: function externalProbe() {
      for (var _len13 = arguments.length, args = Array(_len13), _key13 = 0; _key13 < _len13; _key13++) {
        args[_key13] = arguments[_key13];
      }

      this._externalProbe.apply(this, [1].concat(args));
    }
  }, {
    key: 'externalProbe1',
    value: function externalProbe1() {
      for (var _len14 = arguments.length, args = Array(_len14), _key14 = 0; _key14 < _len14; _key14++) {
        args[_key14] = arguments[_key14];
      }

      this._externalProbe.apply(this, [1].concat(args));
    }
  }, {
    key: 'externalProbe2',
    value: function externalProbe2() {
      for (var _len15 = arguments.length, args = Array(_len15), _key15 = 0; _key15 < _len15; _key15++) {
        args[_key15] = arguments[_key15];
      }

      this._externalProbe.apply(this, [2].concat(args));
    }
  }, {
    key: 'externalProbe3',
    value: function externalProbe3() {
      for (var _len16 = arguments.length, args = Array(_len16), _key16 = 0; _key16 < _len16; _key16++) {
        args[_key16] = arguments[_key16];
      }

      this._externalProbe.apply(this, [3].concat(args));
    }
  }, {
    key: '_externalProbe',
    value: function _externalProbe(level, name, timeStart, timeSpent, meta) {
      if (this._shouldLog(level)) {
        // External probes are expected to provide epoch timestamps
        var total = timeStart - this._startEpochTs;
        var delta = timeSpent;
        this._log(level, name, Object.assign({ total: total, delta: delta }, meta));
      }
    }

    /* Conditionally run a function only when probe is enabled */

  }, {
    key: 'run',
    value: function run(func, arg) {
      var _config2 = this._config,
          isEnabled = _config2.isEnabled,
          isRunEnabled = _config2.isRunEnabled;

      if (isEnabled && isRunEnabled) {
        func(arg);
      }
    }
  }, {
    key: 'startIiterations',
    value: function startIiterations() {
      this._iterationsTs = timestamp();
    }

    /**
     * Get config from persistent store, if available
     * @return {Object} config
     */

  }, {
    key: '_getConfigFromEnvironment',
    value: function _getConfigFromEnvironment() {
      var customConfig = {};
      if (!IS_NODE) {
        var serialized = {}; // cookie.get(COOKIE_NAME);
        if (serialized) {
          customConfig = JSON.parse(serialized);
        }
      }
      return Object.assign({}, DEFAULT_CONFIG, customConfig);
    }

    /* Count iterations per second. Runs the provided function a
     * specified number of times and normalizes the result to represent
     * iterations per second.
     *
     * TODO/ib Measure one iteration and auto adjust iteration count.
     */

  }, {
    key: 'getIterationsPerSecond',
    value: function getIterationsPerSecond() {
      var iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 10000;
      var func = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var context = arguments[2];

      if (func) {
        Probe.startIiterations();
        // Keep call overhead minimal, only use Function.call if context supplied
        if (context) {
          for (var i = 0; i < iterations; i++) {
            func.call(context);
          }
        } else {
          for (var _i = 0; _i < iterations; _i++) {
            func();
          }
        }
      }
      var elapsedMillis = timestamp() - this._iterationsTs;
      var iterationsPerSecond = formatSI(iterations * 1000 / elapsedMillis);
      return iterationsPerSecond;
    }

    /*
     * Print the number of iterations per second measured using the provided
     * function
     */

  }, {
    key: 'logIterationsPerSecond',
    value: function logIterationsPerSecond(testName) {
      var iterations = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10000;
      var func = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

      var elapsedMs = this.getIterationsPerSecond(iterations, func, context);
      var iterationsPerSecond = formatSI(iterations * 1000 / elapsedMs);
      logger.log(testName + ': ' + iterationsPerSecond + ' iterations/s');
    }

    /**
     * Show current log in a table, if supported by console
     * @param {Number} tail If supplied, show only the last n entries
     */

  }, {
    key: 'table',
    value: function table(tail) {
      if (typeof logger.table === 'function') {
        var rows = tail ? this._logStore.slice(-tail) : this._logStore;
        logger.table(rows);
      }
    }
  }]);

  return Probe;
}();

export { Probe as default };
//# sourceMappingURL=data:application/json;base64,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