var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { VertexShader, FragmentShader } from '../../webgl';
import assert from 'assert';

var ERR_SOURCE = 'ShaderCache expects source strings';
var ERR_CONTEXT = 'ShaderCache does not support caching across multiple contexts';

var ShaderCache = function () {

  /**
   * A cache of compiled shaders, keyed by shader source strings.
   * Compilation of long shaders can be time consuming.
   * By using this class, the application can ensure that each shader
   * is only compiled once.
   */
  function ShaderCache() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        gl = _ref.gl;

    _classCallCheck(this, ShaderCache);

    this.gl = gl;
    this.vertexShaders = {};
    this.fragmentShaders = {};
  }

  /**
   * Deletes shader references
   * @return {ShaderCache} - returns this for chaining
   */


  _createClass(ShaderCache, [{
    key: 'delete',
    value: function _delete() {
      // TODO - requires reference counting to avoid deleting shaders in use
      return this;
    }

    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {VertexShader} - a compiled vertex shader
     */

  }, {
    key: 'getVertexShader',
    value: function getVertexShader(gl, source) {
      assert(typeof source === 'string', ERR_SOURCE);

      var shader = this.vertexShaders[source];
      assert(!shader || shader.gl === gl, ERR_CONTEXT);

      if (!shader) {
        shader = new VertexShader(gl, source);
        this.vertexShaders[source] = shader;
      }
      return shader;
    }

    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {FragmentShader} - a compiled fragment shader, possibly from chache
     */

  }, {
    key: 'getFragmentShader',
    value: function getFragmentShader(gl, source) {
      assert(typeof source === 'string', ERR_SOURCE);

      var shader = this.fragmentShaders[source];
      assert(!shader || shader.gl === gl, ERR_CONTEXT);

      if (!shader) {
        shader = new FragmentShader(gl, source);
        this.fragmentShaders[source] = shader;
      }
      return shader;
    }
  }]);

  return ShaderCache;
}();

export { ShaderCache as default };
//# sourceMappingURL=data:application/json;base64,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