import 'luma.gl/headless';
import { createGLContext, VertexShader, FragmentShader, Program } from 'luma.gl';
import { ShaderCache } from '..';

import test from 'tape-catch';

var fixture = {
  gl: createGLContext()
};

var VS1 = '\nattribute vec3 positions;\n\nuniform mat4 uMVMatrix;\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * uMVMatrix * vec4(positions, 1.0);\n}\n';

var VS2 = '\nattribute vec3 positions;\n\nuniform mat4 uMVMatrix;\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * uMVMatrix * vec4(positions, 1.0);\n}\n';

var VS3 = '\nattribute vec3 positions;\n\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * vec4(positions, 1.0);\n}\n';

var FS1 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n}\n';

var FS2 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n}\n';

var FS3 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n}\n';

test('Experimental#ShaderCache import', function (t) {
  t.ok(ShaderCache !== undefined, 'ShaderCache import successful');
  t.end();
});

test('Experimental#ShaderCache construct/delete', function (t) {
  var shaderCache = new ShaderCache();
  t.ok(shaderCache instanceof ShaderCache, 'ShaderCache construction successful');
  shaderCache = shaderCache.delete();
  t.ok(shaderCache instanceof ShaderCache, 'ShaderCache delete successful');
  t.end();
});

test('Experimental#ShaderCache get cached vertex shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new ShaderCache(gl);

  var vs1 = shaderCache.getVertexShader(gl, VS1);
  var vs2 = shaderCache.getVertexShader(gl, VS2);

  t.ok(vs1 instanceof VertexShader, 'Got good VertexShader from cache');
  t.ok(vs2 instanceof VertexShader, 'Got good VertexShader from cache');

  t.equal(vs1, vs2, 'Second VertexShader was cached');

  var vs3 = shaderCache.getVertexShader(gl, VS3);
  t.ok(vs3 instanceof VertexShader, 'Got good VertexShader from cache');

  t.notEqual(vs1, vs3, 'Third VertexShader was not cached');

  t.end();
});

test('Experimental#ShaderCache get cached fragment shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new ShaderCache(gl);

  var fs1 = shaderCache.getFragmentShader(gl, FS1);
  var fs2 = shaderCache.getFragmentShader(gl, FS2);

  t.ok(fs1 instanceof FragmentShader, 'Got good FragmentShader from cache');
  t.ok(fs2 instanceof FragmentShader, 'Got good FragmentShader from cache');

  t.equal(fs1, fs2, 'Second FragmentShader was cached');

  var fs3 = shaderCache.getFragmentShader(gl, FS3);
  t.ok(fs3 instanceof FragmentShader, 'Got good FragmentShader from cache');

  t.notEqual(fs1, fs3, 'Third FragmentShader was not cached');

  t.end();
});

test('Experimental#ShaderCache - construct Program from cached shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new ShaderCache();
  shaderCache.getVertexShader(gl, VS1);
  shaderCache.getFragmentShader(gl, FS1);

  var program = new Program(gl, {
    vs: shaderCache.getVertexShader(gl, VS1),
    fs: shaderCache.getFragmentShader(gl, FS1)
  });
  t.ok(program instanceof Program, 'Program constructed from cached shaders successful ');

  program = program.delete();
  t.ok(program instanceof Program, 'Program delete successful');

  var program2 = new Program(gl, {
    vs: shaderCache.getVertexShader(gl, VS1),
    fs: shaderCache.getFragmentShader(gl, FS1)
  });
  t.ok(program2 instanceof Program, 'Program constructed from cached shaders successful after delete of first program');

  t.end();
});
//# sourceMappingURL=data:application/json;base64,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