'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHADERS = undefined;

var _path = require('path');

// Default Shaders
var vs = '#define SHADER_NAME luma-default-vs\n\n#define LIGHT_MAX 4\n\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec4 color;\nattribute vec2 texCoord1;\n\nuniform mat4 worldMatrix;\nuniform mat4 viewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 worldInverseTransposeMatrix;\n\nuniform bool enableLights;\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\nuniform vec3 pointLocation[LIGHT_MAX];\nuniform vec3 pointColor[LIGHT_MAX];\nuniform int numberPoints;\n\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying vec3 lightWeighting;\n\nvoid main(void) {\n  vec4 mvPosition = worldMatrix * vec4(position, 1.0);\n\n  if(!enableLights) {\n    lightWeighting = vec3(1.0, 1.0, 1.0);\n  } else {\n    vec3 plightDirection;\n    vec3 pointWeight = vec3(0.0, 0.0, 0.0);\n    vec4 transformedNormal = worldInverseTransposeMatrix * vec4(normal, 1.0);\n    float directionalLightWeighting = max(dot(transformedNormal.xyz, lightingDirection), 0.0);\n    for (int i = 0; i < LIGHT_MAX; i++) {\n      if (i < numberPoints) {\n        plightDirection = normalize((viewMatrix * vec4(pointLocation[i], 1.0)).xyz - mvPosition.xyz);\n        pointWeight += max(dot(transformedNormal.xyz, plightDirection), 0.0) * pointColor[i];\n      } else {\n        break;\n      }\n    }\n\n    lightWeighting = ambientColor + (directionalColor * directionalLightWeighting) + pointWeight;\n  }\n\n  vColor = color;\n  vTexCoord = texCoord1;\n  gl_Position = projectionMatrix * worldMatrix * vec4(position, 1.0);\n}\n';
var fs = '#ifdef GL_ES\nprecision highp float;\n#endif\n\n#define SHADER_NAME luma-default-fs\n\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying vec3 lightWeighting;\n\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\n\nuniform bool enablePicking;\nuniform vec3 pickColor;\n\nuniform bool hasFog;\nuniform vec3 fogColor;\n\nuniform float fogNear;\nuniform float fogFar;\n\nvoid main() {\n  if(!hasTexture1) {\n    gl_FragColor = vec4(vColor.rgb * lightWeighting, vColor.a);\n  } else {\n    gl_FragColor = vec4(texture2D(sampler1, vec2(vTexCoord.s, vTexCoord.t)).rgb * lightWeighting, 1.0);\n  }\n\n  if (enablePicking) {\n    gl_FragColor = vec4(pickColor, 1.0);\n  }\n\n  /* handle fog */\n  if (hasFog) {\n    float depth = gl_FragCoord.z / gl_FragCoord.w;\n    float fogFactor = smoothstep(fogNear, fogFar, depth);\n    gl_FragColor = mix(gl_FragColor, vec4(fogColor, gl_FragColor.w), fogFactor);\n  }\n}\n';
var defaultUniforms = require('./default-uniforms');

var SHADERS = exports.SHADERS = {
  vs: vs,
  fs: fs,
  defaultUniforms: defaultUniforms
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9leHBlcmltZW50YWwvc2hhZGVycy9pbmRleC5qcyJdLCJuYW1lcyI6WyJ2cyIsImZzIiwiZGVmYXVsdFVuaWZvcm1zIiwicmVxdWlyZSIsIlNIQURFUlMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFDQTs7QUFFQTtBQUNBLElBQU1BLHNoREFBTjtBQUNBLElBQU1DLHk1QkFBTjtBQUNBLElBQU1DLGtCQUFrQkMsUUFBUSxvQkFBUixDQUF4Qjs7QUFFTyxJQUFNQyw0QkFBVTtBQUNyQkosUUFEcUI7QUFFckJDLFFBRnFCO0FBR3JCQztBQUhxQixDQUFoQiIsImZpbGUiOiJpbmRleC5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7cmVhZEZpbGVTeW5jfSBmcm9tICdmcyc7XG5pbXBvcnQge2pvaW59IGZyb20gJ3BhdGgnO1xuXG4vLyBEZWZhdWx0IFNoYWRlcnNcbmNvbnN0IHZzID0gcmVhZEZpbGVTeW5jKGpvaW4oX19kaXJuYW1lLCAnLi9kZWZhdWx0LnZzLmdsc2wnKSwgJ3V0ZjgnKTtcbmNvbnN0IGZzID0gcmVhZEZpbGVTeW5jKGpvaW4oX19kaXJuYW1lLCAnLi9kZWZhdWx0LmZzLmdsc2wnKSwgJ3V0ZjgnKTtcbmNvbnN0IGRlZmF1bHRVbmlmb3JtcyA9IHJlcXVpcmUoJy4vZGVmYXVsdC11bmlmb3JtcycpO1xuXG5leHBvcnQgY29uc3QgU0hBREVSUyA9IHtcbiAgdnMsXG4gIGZzLFxuICBkZWZhdWx0VW5pZm9ybXNcbn07XG4iXX0=