var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { uid } from '../utils';
import { log } from '../utils';
import assert from 'assert';

var ILLEGAL_ARG = 'Geometry: Illegal argument';

var Geometry = function () {
  function Geometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Geometry);

    var id = opts.id,
        _opts$drawMode = opts.drawMode,
        drawMode = _opts$drawMode === undefined ? 'TRIANGLES' : _opts$drawMode,
        _opts$vertexCount = opts.vertexCount,
        vertexCount = _opts$vertexCount === undefined ? undefined : _opts$vertexCount,
        attributes = opts.attributes;


    assert(drawMode, ILLEGAL_ARG);

    this.id = id || uid(this.constructor.name);
    this.drawMode = drawMode;
    this.vertexCount = vertexCount;
    this.attributes = {};
    this.needsRedraw = true;
    this.userData = {};
    Object.seal(this);

    if (attributes) {
      this.setAttributes(attributes);
    } else {
      log.once('Geometry: top-level attributes are deprecated, use "attributes" param');
      // TODO this is deprecated
      delete opts.id;
      delete opts.drawMode;
      delete opts.vertexCount;
      delete opts.attributes;
      this.setAttributes(opts);
    }
  }

  _createClass(Geometry, [{
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.needsRedraw = redraw;
      return this;
    }
  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$clearRedrawFlags = _ref.clearRedrawFlags,
          clearRedrawFlags = _ref$clearRedrawFlags === undefined ? false : _ref$clearRedrawFlags;

      var redraw = false;
      redraw = redraw || this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !clearRedrawFlags;
      return redraw;
    }
  }, {
    key: 'setVertexCount',
    value: function setVertexCount(vertexCount) {
      this.vertexCount = vertexCount;
    }
  }, {
    key: 'getVertexCount',
    value: function getVertexCount() {
      if (this.vertexCount !== undefined) {
        return this.vertexCount;
      } else if (this.attributes.indices) {
        return this.attributes.indices.value.length;
      } else if (this.attributes.vertices) {
        return this.attributes.vertices.value.length / 3;
      } else if (this.attributes.positions) {
        return this.attributes.positions.value.length / 3;
      }
      return false;
    }
  }, {
    key: 'hasAttribute',
    value: function hasAttribute(attributeName) {
      return Boolean(this.attributes[attributeName]);
    }
  }, {
    key: 'getAttribute',
    value: function getAttribute(attributeName) {
      var attribute = this.attributes[attributeName];
      assert(attribute);
      return attribute.value;
    }
  }, {
    key: 'getArray',
    value: function getArray(attributeName) {
      var attribute = this.attributes[attributeName];
      assert(attribute);
      return attribute.value;
    }
  }, {
    key: 'getAttributes',
    value: function getAttributes() {
      return this.attributes;
    }

    // Attribute
    // value: typed array
    // type: indices, vertices, uvs
    // size: elements per vertex
    // target: WebGL buffer type (string or constant)

  }, {
    key: 'setAttributes',
    value: function setAttributes(attributes) {
      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        // Wrap "unwrapped" arrays and try to autodetect their type
        attribute = ArrayBuffer.isView(attribute) ? { value: attribute } : attribute;

        assert(ArrayBuffer.isView(attribute.value), this._print(attributeName) + ': must be typed array or object with value as typed array');

        this._autoDetectAttribute(attributeName, attribute);

        this.attributes[attributeName] = Object.assign({}, attribute, {
          instanced: attribute.instanced || 0
        });
      }
      this.setNeedsRedraw();
      return this;
    }

    // Check for well known attribute names
    /* eslint-disable default-case, complexity */

  }, {
    key: '_autoDetectAttribute',
    value: function _autoDetectAttribute(attributeName, attribute) {
      var category = void 0;
      switch (attributeName) {
        case 'indices':
          category = category || 'indices';
          break;
        case 'texCoords':
        case 'texCoord1':
        case 'texCoord2':
        case 'texCoord3':
          category = 'uvs';
          break;
        case 'vertices':
        case 'positions':
        case 'normals':
        case 'pickingColors':
          category = 'vectors';
          break;
      }

      // Check for categorys
      switch (category) {
        case 'vectors':
          attribute.size = attribute.size || 3;
          break;
        case 'uvs':
          attribute.size = attribute.size || 2;
          break;
        case 'indices':
          attribute.size = attribute.size || 1;
          attribute.isIndexed = attribute.isIndexed || true;
          assert(attribute.value instanceof Uint16Array || attribute.value instanceof Uint32Array, 'attribute array for "indices" must be of integer type');
          break;
      }

      assert(attribute.size, 'attribute ' + attributeName + ' needs size');
    }
    /* eslint-enable default-case, complexity */

  }, {
    key: '_print',
    value: function _print(attributeName) {
      return 'Geometry ' + this.id + ' attribute ' + attributeName;
    }
  }]);

  return Geometry;
}();

export { Geometry as default };
//# sourceMappingURL=data:application/json;base64,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