function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import Geometry from './geometry';
import { uid } from '../utils';

var PlaneGeometry = function (_Geometry) {
  _inherits(PlaneGeometry, _Geometry);

  // Primitives inspired by TDL http://code.google.com/p/webglsamples/,
  // copyright 2011 Google Inc. new BSD License
  // (http://www.opensource.org/licenses/bsd-license.php).
  /* eslint-disable max-statements, complexity */
  /* eslint-disable complexity, max-statements */
  function PlaneGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, PlaneGeometry);

    var _opts$type = opts.type,
        type = _opts$type === undefined ? 'x,y' : _opts$type,
        _opts$offset = opts.offset,
        offset = _opts$offset === undefined ? 0 : _opts$offset,
        _opts$flipCull = opts.flipCull,
        flipCull = _opts$flipCull === undefined ? false : _opts$flipCull,
        _opts$unpack = opts.unpack,
        unpack = _opts$unpack === undefined ? false : _opts$unpack,
        _opts$id = opts.id,
        id = _opts$id === undefined ? uid('plane-geometry') : _opts$id;


    var coords = type.split(',');
    // width, height
    var c1len = opts[coords[0] + 'len'];
    var c2len = opts[coords[1] + 'len'];
    // subdivisionsWidth, subdivisionsDepth
    var subdivisions1 = opts['n' + coords[0]] || 1;
    var subdivisions2 = opts['n' + coords[1]] || 1;
    var numVertices = (subdivisions1 + 1) * (subdivisions2 + 1);

    var positions = new Float32Array(numVertices * 3);
    var normals = new Float32Array(numVertices * 3);
    var texCoords = new Float32Array(numVertices * 2);

    if (flipCull) {
      c1len = -c1len;
    }

    var i2 = 0;
    var i3 = 0;
    for (var z = 0; z <= subdivisions2; z++) {
      for (var x = 0; x <= subdivisions1; x++) {
        var u = x / subdivisions1;
        var v = z / subdivisions2;
        texCoords[i2 + 0] = flipCull ? 1 - u : u;
        texCoords[i2 + 1] = v;

        switch (type) {
          case 'x,y':
            positions[i3 + 0] = c1len * u - c1len * 0.5;
            positions[i3 + 1] = c2len * v - c2len * 0.5;
            positions[i3 + 2] = offset;

            normals[i3 + 0] = 0;
            normals[i3 + 1] = 0;
            normals[i3 + 2] = flipCull ? 1 : -1;
            break;

          case 'x,z':
            positions[i3 + 0] = c1len * u - c1len * 0.5;
            positions[i3 + 1] = offset;
            positions[i3 + 2] = c2len * v - c2len * 0.5;

            normals[i3 + 0] = 0;
            normals[i3 + 1] = flipCull ? 1 : -1;
            normals[i3 + 2] = 0;
            break;

          case 'y,z':
            positions[i3 + 0] = offset;
            positions[i3 + 1] = c1len * u - c1len * 0.5;
            positions[i3 + 2] = c2len * v - c2len * 0.5;

            normals[i3 + 0] = flipCull ? 1 : -1;
            normals[i3 + 1] = 0;
            normals[i3 + 2] = 0;
            break;

          default:
            break;
        }

        i2 += 2;
        i3 += 3;
      }
    }

    var numVertsAcross = subdivisions1 + 1;
    var indices = new Uint16Array(subdivisions1 * subdivisions2 * 6);

    for (var _z = 0; _z < subdivisions2; _z++) {
      for (var _x2 = 0; _x2 < subdivisions1; _x2++) {
        var index = (_z * subdivisions1 + _x2) * 6;
        // Make triangle 1 of quad.
        indices[index + 0] = (_z + 0) * numVertsAcross + _x2;
        indices[index + 1] = (_z + 1) * numVertsAcross + _x2;
        indices[index + 2] = (_z + 0) * numVertsAcross + _x2 + 1;

        // Make triangle 2 of quad.
        indices[index + 3] = (_z + 1) * numVertsAcross + _x2;
        indices[index + 4] = (_z + 1) * numVertsAcross + _x2 + 1;
        indices[index + 5] = (_z + 0) * numVertsAcross + _x2 + 1;
      }
    }

    // Optionally, unpack indexed geometry
    if (unpack) {
      var positions2 = new Float32Array(indices.length * 3);
      var normals2 = new Float32Array(indices.length * 3);
      var texCoords2 = new Float32Array(indices.length * 2);

      for (var _x3 = 0; _x3 < indices.length; ++_x3) {
        var _index = indices[_x3];
        positions2[_x3 * 3 + 0] = positions[_index * 3 + 0];
        positions2[_x3 * 3 + 1] = positions[_index * 3 + 1];
        positions2[_x3 * 3 + 2] = positions[_index * 3 + 2];
        normals2[_x3 * 3 + 0] = normals[_index * 3 + 0];
        normals2[_x3 * 3 + 1] = normals[_index * 3 + 1];
        normals2[_x3 * 3 + 2] = normals[_index * 3 + 2];
        texCoords2[_x3 * 2 + 0] = texCoords[_index * 2 + 0];
        texCoords2[_x3 * 2 + 1] = texCoords[_index * 2 + 1];
      }

      positions = positions2;
      normals = normals2;
      texCoords = texCoords2;
      indices = undefined;
    }

    var attributes = {
      positions: positions,
      normals: normals,
      texCoords: texCoords
    };

    if (indices) {
      attributes.indices = indices;
    }

    return _possibleConstructorReturn(this, (PlaneGeometry.__proto__ || Object.getPrototypeOf(PlaneGeometry)).call(this, Object.assign({}, opts, { attributes: attributes, id: id })));
  }

  return PlaneGeometry;
}(Geometry);

export { PlaneGeometry as default };
//# sourceMappingURL=data:application/json;base64,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