function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import Geometry from './geometry';
import { uid } from '../utils';

var SphereGeometry = function (_Geometry) {
  _inherits(SphereGeometry, _Geometry);

  function SphereGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, SphereGeometry);

    var _opts$nlat = opts.nlat,
        nlat = _opts$nlat === undefined ? 10 : _opts$nlat,
        _opts$nlong = opts.nlong,
        nlong = _opts$nlong === undefined ? 10 : _opts$nlong,
        _opts$radius = opts.radius,
        radius = _opts$radius === undefined ? 1 : _opts$radius,
        _opts$id = opts.id,
        id = _opts$id === undefined ? uid('sphere-geometry') : _opts$id;
    return _possibleConstructorReturn(this, (SphereGeometry.__proto__ || Object.getPrototypeOf(SphereGeometry)).call(this, Object.assign({}, opts, { id: id, attributes: getSphereAttributes(nlat, nlong, radius) })));
  }

  return SphereGeometry;
}(Geometry);

// Primitives inspired by TDL http://code.google.com/p/webglsamples/,
// copyright 2011 Google Inc. new BSD License
// (http://www.opensource.org/licenses/bsd-license.php).
/* eslint-disable max-statements, complexity */


export { SphereGeometry as default };
function getSphereAttributes(nlat, nlong, radius) {
  var startLat = 0;
  var endLat = Math.PI;
  var latRange = endLat - startLat;
  var startLong = 0;
  var endLong = 2 * Math.PI;
  var longRange = endLong - startLong;
  var numVertices = (nlat + 1) * (nlong + 1);

  if (typeof radius === 'number') {
    (function () {
      var value = radius;
      radius = function radius(n1, n2, n3, u, v) {
        return value;
      };
    })();
  }

  var positions = new Float32Array(numVertices * 3);
  var normals = new Float32Array(numVertices * 3);
  var texCoords = new Float32Array(numVertices * 2);
  var indices = new Uint16Array(nlat * nlong * 6);

  // Create positions, normals and texCoords
  for (var y = 0; y <= nlat; y++) {
    for (var x = 0; x <= nlong; x++) {

      var u = x / nlong;
      var v = y / nlat;

      var index = x + y * (nlong + 1);
      var i2 = index * 2;
      var i3 = index * 3;

      var theta = longRange * u;
      var phi = latRange * v;
      var sinTheta = Math.sin(theta);
      var cosTheta = Math.cos(theta);
      var sinPhi = Math.sin(phi);
      var cosPhi = Math.cos(phi);
      var ux = cosTheta * sinPhi;
      var uy = cosPhi;
      var uz = sinTheta * sinPhi;

      var r = radius(ux, uy, uz, u, v);

      positions[i3 + 0] = r * ux;
      positions[i3 + 1] = r * uy;
      positions[i3 + 2] = r * uz;

      normals[i3 + 0] = ux;
      normals[i3 + 1] = uy;
      normals[i3 + 2] = uz;

      texCoords[i2 + 0] = u;
      texCoords[i2 + 1] = v;
    }
  }

  // Create indices
  var numVertsAround = nlat + 1;
  for (var _x2 = 0; _x2 < nlat; _x2++) {
    for (var _y = 0; _y < nlong; _y++) {
      var _index = (_x2 * nlong + _y) * 6;

      indices[_index + 0] = _y * numVertsAround + _x2;
      indices[_index + 1] = _y * numVertsAround + _x2 + 1;
      indices[_index + 2] = (_y + 1) * numVertsAround + _x2;

      indices[_index + 3] = (_y + 1) * numVertsAround + _x2;
      indices[_index + 4] = _y * numVertsAround + _x2 + 1;
      indices[_index + 5] = (_y + 1) * numVertsAround + _x2 + 1;
    }
  }

  return {
    positions: positions,
    indices: indices,
    normals: normals,
    texCoords: texCoords
  };
}
//# sourceMappingURL=data:application/json;base64,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