function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import Geometry from './geometry';

var TruncatedConeGeometry = function (_Geometry) {
  _inherits(TruncatedConeGeometry, _Geometry);

  // Primitives inspired by TDL http://code.google.com/p/webglsamples/,
  // copyright 2011 Google Inc. new BSD License
  // (http://www.opensource.org/licenses/bsd-license.php).
  /* eslint-disable max-statements, complexity */
  function TruncatedConeGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, TruncatedConeGeometry);

    var _opts$bottomRadius = opts.bottomRadius,
        bottomRadius = _opts$bottomRadius === undefined ? 0 : _opts$bottomRadius,
        _opts$topRadius = opts.topRadius,
        topRadius = _opts$topRadius === undefined ? 0 : _opts$topRadius,
        _opts$height = opts.height,
        height = _opts$height === undefined ? 1 : _opts$height,
        _opts$nradial = opts.nradial,
        nradial = _opts$nradial === undefined ? 10 : _opts$nradial,
        _opts$nvertical = opts.nvertical,
        nvertical = _opts$nvertical === undefined ? 10 : _opts$nvertical,
        _opts$topCap = opts.topCap,
        topCap = _opts$topCap === undefined ? false : _opts$topCap,
        _opts$bottomCap = opts.bottomCap,
        bottomCap = _opts$bottomCap === undefined ? false : _opts$bottomCap;


    var extra = (topCap ? 2 : 0) + (bottomCap ? 2 : 0);
    var numVertices = (nradial + 1) * (nvertical + 1 + extra);

    var slant = Math.atan2(bottomRadius - topRadius, height);
    var msin = Math.sin;
    var mcos = Math.cos;
    var mpi = Math.PI;
    var cosSlant = mcos(slant);
    var sinSlant = msin(slant);
    var start = topCap ? -2 : 0;
    var end = nvertical + (bottomCap ? 2 : 0);
    var vertsAroundEdge = nradial + 1;

    var positions = new Float32Array(numVertices * 3);
    var normals = new Float32Array(numVertices * 3);
    var texCoords = new Float32Array(numVertices * 2);
    var indices = new Uint16Array(nradial * (nvertical + extra) * 6);

    var i3 = 0;
    var i2 = 0;
    for (var i = start; i <= end; i++) {
      var v = i / nvertical;
      var y = height * v;
      var ringRadius = void 0;

      if (i < 0) {
        y = 0;
        v = 1;
        ringRadius = bottomRadius;
      } else if (i > nvertical) {
        y = height;
        v = 1;
        ringRadius = topRadius;
      } else {
        ringRadius = bottomRadius + (topRadius - bottomRadius) * (i / nvertical);
      }
      if (i === -2 || i === nvertical + 2) {
        ringRadius = 0;
        v = 0;
      }
      y -= height / 2;
      for (var j = 0; j < vertsAroundEdge; j++) {
        var sin = msin(j * mpi * 2 / nradial);
        var cos = mcos(j * mpi * 2 / nradial);

        positions[i3 + 0] = sin * ringRadius;
        positions[i3 + 1] = y;
        positions[i3 + 2] = cos * ringRadius;

        normals[i3 + 0] = i < 0 || i > nvertical ? 0 : sin * cosSlant;
        normals[i3 + 1] = i < 0 ? -1 : i > nvertical ? 1 : sinSlant;
        normals[i3 + 2] = i < 0 || i > nvertical ? 0 : cos * cosSlant;

        texCoords[i2 + 0] = j / nradial;
        texCoords[i2 + 1] = v;

        i2 += 2;
        i3 += 3;
      }
    }

    for (var _i = 0; _i < nvertical + extra; _i++) {
      for (var _j = 0; _j < nradial; _j++) {
        var index = (_i * nradial + _j) * 6;
        indices[index + 0] = vertsAroundEdge * (_i + 0) + 0 + _j;
        indices[index + 1] = vertsAroundEdge * (_i + 0) + 1 + _j;
        indices[index + 2] = vertsAroundEdge * (_i + 1) + 1 + _j;
        indices[index + 3] = vertsAroundEdge * (_i + 0) + 0 + _j;
        indices[index + 4] = vertsAroundEdge * (_i + 1) + 1 + _j;
        indices[index + 5] = vertsAroundEdge * (_i + 1) + 0 + _j;
      }
    }

    return _possibleConstructorReturn(this, (TruncatedConeGeometry.__proto__ || Object.getPrototypeOf(TruncatedConeGeometry)).call(this, Object.assign({}, opts, {
      attributes: {
        positions: positions,
        normals: normals,
        texCoords: texCoords,
        indices: indices
      }
    })));
  }

  return TruncatedConeGeometry;
}(Geometry);

export { TruncatedConeGeometry as default };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9nZW9tZXRyeS90cnVuY2F0ZWQtY29uZS1nZW9tZXRyeS5qcyJdLCJuYW1lcyI6WyJHZW9tZXRyeSIsIlRydW5jYXRlZENvbmVHZW9tZXRyeSIsIm9wdHMiLCJib3R0b21SYWRpdXMiLCJ0b3BSYWRpdXMiLCJoZWlnaHQiLCJucmFkaWFsIiwibnZlcnRpY2FsIiwidG9wQ2FwIiwiYm90dG9tQ2FwIiwiZXh0cmEiLCJudW1WZXJ0aWNlcyIsInNsYW50IiwiTWF0aCIsImF0YW4yIiwibXNpbiIsInNpbiIsIm1jb3MiLCJjb3MiLCJtcGkiLCJQSSIsImNvc1NsYW50Iiwic2luU2xhbnQiLCJzdGFydCIsImVuZCIsInZlcnRzQXJvdW5kRWRnZSIsInBvc2l0aW9ucyIsIkZsb2F0MzJBcnJheSIsIm5vcm1hbHMiLCJ0ZXhDb29yZHMiLCJpbmRpY2VzIiwiVWludDE2QXJyYXkiLCJpMyIsImkyIiwiaSIsInYiLCJ5IiwicmluZ1JhZGl1cyIsImoiLCJpbmRleCIsIk9iamVjdCIsImFzc2lnbiIsImF0dHJpYnV0ZXMiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLE9BQU9BLFFBQVAsTUFBcUIsWUFBckI7O0lBRXFCQyxxQjs7O0FBRW5CO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsbUNBQXVCO0FBQUEsUUFBWEMsSUFBVyx1RUFBSixFQUFJOztBQUFBOztBQUFBLDZCQVNqQkEsSUFUaUIsQ0FFbkJDLFlBRm1CO0FBQUEsUUFFbkJBLFlBRm1CLHNDQUVKLENBRkk7QUFBQSwwQkFTakJELElBVGlCLENBR25CRSxTQUhtQjtBQUFBLFFBR25CQSxTQUhtQixtQ0FHUCxDQUhPO0FBQUEsdUJBU2pCRixJQVRpQixDQUluQkcsTUFKbUI7QUFBQSxRQUluQkEsTUFKbUIsZ0NBSVYsQ0FKVTtBQUFBLHdCQVNqQkgsSUFUaUIsQ0FLbkJJLE9BTG1CO0FBQUEsUUFLbkJBLE9BTG1CLGlDQUtULEVBTFM7QUFBQSwwQkFTakJKLElBVGlCLENBTW5CSyxTQU5tQjtBQUFBLFFBTW5CQSxTQU5tQixtQ0FNUCxFQU5PO0FBQUEsdUJBU2pCTCxJQVRpQixDQU9uQk0sTUFQbUI7QUFBQSxRQU9uQkEsTUFQbUIsZ0NBT1YsS0FQVTtBQUFBLDBCQVNqQk4sSUFUaUIsQ0FRbkJPLFNBUm1CO0FBQUEsUUFRbkJBLFNBUm1CLG1DQVFQLEtBUk87OztBQVdyQixRQUFNQyxRQUFRLENBQUNGLFNBQVMsQ0FBVCxHQUFhLENBQWQsS0FBb0JDLFlBQVksQ0FBWixHQUFnQixDQUFwQyxDQUFkO0FBQ0EsUUFBTUUsY0FBYyxDQUFDTCxVQUFVLENBQVgsS0FBaUJDLFlBQVksQ0FBWixHQUFnQkcsS0FBakMsQ0FBcEI7O0FBRUEsUUFBTUUsUUFBUUMsS0FBS0MsS0FBTCxDQUFXWCxlQUFlQyxTQUExQixFQUFxQ0MsTUFBckMsQ0FBZDtBQUNBLFFBQU1VLE9BQU9GLEtBQUtHLEdBQWxCO0FBQ0EsUUFBTUMsT0FBT0osS0FBS0ssR0FBbEI7QUFDQSxRQUFNQyxNQUFNTixLQUFLTyxFQUFqQjtBQUNBLFFBQU1DLFdBQVdKLEtBQUtMLEtBQUwsQ0FBakI7QUFDQSxRQUFNVSxXQUFXUCxLQUFLSCxLQUFMLENBQWpCO0FBQ0EsUUFBTVcsUUFBUWYsU0FBUyxDQUFDLENBQVYsR0FBYyxDQUE1QjtBQUNBLFFBQU1nQixNQUFNakIsYUFBYUUsWUFBWSxDQUFaLEdBQWdCLENBQTdCLENBQVo7QUFDQSxRQUFNZ0Isa0JBQWtCbkIsVUFBVSxDQUFsQzs7QUFFQSxRQUFNb0IsWUFBWSxJQUFJQyxZQUFKLENBQWlCaEIsY0FBYyxDQUEvQixDQUFsQjtBQUNBLFFBQU1pQixVQUFVLElBQUlELFlBQUosQ0FBaUJoQixjQUFjLENBQS9CLENBQWhCO0FBQ0EsUUFBTWtCLFlBQVksSUFBSUYsWUFBSixDQUFpQmhCLGNBQWMsQ0FBL0IsQ0FBbEI7QUFDQSxRQUFNbUIsVUFBVSxJQUFJQyxXQUFKLENBQWdCekIsV0FBV0MsWUFBWUcsS0FBdkIsSUFBZ0MsQ0FBaEQsQ0FBaEI7O0FBRUEsUUFBSXNCLEtBQUssQ0FBVDtBQUNBLFFBQUlDLEtBQUssQ0FBVDtBQUNBLFNBQUssSUFBSUMsSUFBSVgsS0FBYixFQUFvQlcsS0FBS1YsR0FBekIsRUFBOEJVLEdBQTlCLEVBQW1DO0FBQ2pDLFVBQUlDLElBQUlELElBQUkzQixTQUFaO0FBQ0EsVUFBSTZCLElBQUkvQixTQUFTOEIsQ0FBakI7QUFDQSxVQUFJRSxtQkFBSjs7QUFFQSxVQUFJSCxJQUFJLENBQVIsRUFBVztBQUNURSxZQUFJLENBQUo7QUFDQUQsWUFBSSxDQUFKO0FBQ0FFLHFCQUFhbEMsWUFBYjtBQUNELE9BSkQsTUFJTyxJQUFJK0IsSUFBSTNCLFNBQVIsRUFBbUI7QUFDeEI2QixZQUFJL0IsTUFBSjtBQUNBOEIsWUFBSSxDQUFKO0FBQ0FFLHFCQUFhakMsU0FBYjtBQUNELE9BSk0sTUFJQTtBQUNMaUMscUJBQWFsQyxlQUNYLENBQUNDLFlBQVlELFlBQWIsS0FBOEIrQixJQUFJM0IsU0FBbEMsQ0FERjtBQUVEO0FBQ0QsVUFBSTJCLE1BQU0sQ0FBQyxDQUFQLElBQVlBLE1BQU0zQixZQUFZLENBQWxDLEVBQXFDO0FBQ25DOEIscUJBQWEsQ0FBYjtBQUNBRixZQUFJLENBQUo7QUFDRDtBQUNEQyxXQUFLL0IsU0FBUyxDQUFkO0FBQ0EsV0FBSyxJQUFJaUMsSUFBSSxDQUFiLEVBQWdCQSxJQUFJYixlQUFwQixFQUFxQ2EsR0FBckMsRUFBMEM7QUFDeEMsWUFBTXRCLE1BQU1ELEtBQUt1QixJQUFJbkIsR0FBSixHQUFVLENBQVYsR0FBY2IsT0FBbkIsQ0FBWjtBQUNBLFlBQU1ZLE1BQU1ELEtBQUtxQixJQUFJbkIsR0FBSixHQUFVLENBQVYsR0FBY2IsT0FBbkIsQ0FBWjs7QUFFQW9CLGtCQUFVTSxLQUFLLENBQWYsSUFBb0JoQixNQUFNcUIsVUFBMUI7QUFDQVgsa0JBQVVNLEtBQUssQ0FBZixJQUFvQkksQ0FBcEI7QUFDQVYsa0JBQVVNLEtBQUssQ0FBZixJQUFvQmQsTUFBTW1CLFVBQTFCOztBQUVBVCxnQkFBUUksS0FBSyxDQUFiLElBQW1CRSxJQUFJLENBQUosSUFBU0EsSUFBSTNCLFNBQWQsR0FBMkIsQ0FBM0IsR0FBZ0NTLE1BQU1LLFFBQXhEO0FBQ0FPLGdCQUFRSSxLQUFLLENBQWIsSUFBbUJFLElBQUksQ0FBTCxHQUFVLENBQUMsQ0FBWCxHQUFnQkEsSUFBSTNCLFNBQUosR0FBZ0IsQ0FBaEIsR0FBb0JlLFFBQXREO0FBQ0FNLGdCQUFRSSxLQUFLLENBQWIsSUFBbUJFLElBQUksQ0FBSixJQUFTQSxJQUFJM0IsU0FBZCxHQUEyQixDQUEzQixHQUFnQ1csTUFBTUcsUUFBeEQ7O0FBRUFRLGtCQUFVSSxLQUFLLENBQWYsSUFBb0JLLElBQUloQyxPQUF4QjtBQUNBdUIsa0JBQVVJLEtBQUssQ0FBZixJQUFvQkUsQ0FBcEI7O0FBRUFGLGNBQU0sQ0FBTjtBQUNBRCxjQUFNLENBQU47QUFDRDtBQUNGOztBQUVELFNBQUssSUFBSUUsS0FBSSxDQUFiLEVBQWdCQSxLQUFJM0IsWUFBWUcsS0FBaEMsRUFBdUN3QixJQUF2QyxFQUE0QztBQUMxQyxXQUFLLElBQUlJLEtBQUksQ0FBYixFQUFnQkEsS0FBSWhDLE9BQXBCLEVBQTZCZ0MsSUFBN0IsRUFBa0M7QUFDaEMsWUFBTUMsUUFBUSxDQUFDTCxLQUFJNUIsT0FBSixHQUFjZ0MsRUFBZixJQUFvQixDQUFsQztBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNBUixnQkFBUVMsUUFBUSxDQUFoQixJQUFxQmQsbUJBQW1CUyxLQUFJLENBQXZCLElBQTRCLENBQTVCLEdBQWdDSSxFQUFyRDtBQUNEO0FBQ0Y7O0FBbkZvQix5SUFxRmZFLE9BQU9DLE1BQVAsQ0FBYyxFQUFkLEVBQWtCdkMsSUFBbEIsRUFBd0I7QUFDNUJ3QyxrQkFBWTtBQUNWaEIsNEJBRFU7QUFFVkUsd0JBRlU7QUFHVkMsNEJBSFU7QUFJVkM7QUFKVTtBQURnQixLQUF4QixDQXJGZTtBQTZGdEI7OztFQW5HZ0Q5QixROztTQUE5QkMscUIiLCJmaWxlIjoidHJ1bmNhdGVkLWNvbmUtZ2VvbWV0cnkuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgR2VvbWV0cnkgZnJvbSAnLi9nZW9tZXRyeSc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFRydW5jYXRlZENvbmVHZW9tZXRyeSBleHRlbmRzIEdlb21ldHJ5IHtcblxuICAvLyBQcmltaXRpdmVzIGluc3BpcmVkIGJ5IFRETCBodHRwOi8vY29kZS5nb29nbGUuY29tL3Avd2ViZ2xzYW1wbGVzLyxcbiAgLy8gY29weXJpZ2h0IDIwMTEgR29vZ2xlIEluYy4gbmV3IEJTRCBMaWNlbnNlXG4gIC8vIChodHRwOi8vd3d3Lm9wZW5zb3VyY2Uub3JnL2xpY2Vuc2VzL2JzZC1saWNlbnNlLnBocCkuXG4gIC8qIGVzbGludC1kaXNhYmxlIG1heC1zdGF0ZW1lbnRzLCBjb21wbGV4aXR5ICovXG4gIGNvbnN0cnVjdG9yKG9wdHMgPSB7fSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGJvdHRvbVJhZGl1cyA9IDAsXG4gICAgICB0b3BSYWRpdXMgPSAwLFxuICAgICAgaGVpZ2h0ID0gMSxcbiAgICAgIG5yYWRpYWwgPSAxMCxcbiAgICAgIG52ZXJ0aWNhbCA9IDEwLFxuICAgICAgdG9wQ2FwID0gZmFsc2UsXG4gICAgICBib3R0b21DYXAgPSBmYWxzZVxuICAgIH0gPSBvcHRzO1xuXG4gICAgY29uc3QgZXh0cmEgPSAodG9wQ2FwID8gMiA6IDApICsgKGJvdHRvbUNhcCA/IDIgOiAwKTtcbiAgICBjb25zdCBudW1WZXJ0aWNlcyA9IChucmFkaWFsICsgMSkgKiAobnZlcnRpY2FsICsgMSArIGV4dHJhKTtcblxuICAgIGNvbnN0IHNsYW50ID0gTWF0aC5hdGFuMihib3R0b21SYWRpdXMgLSB0b3BSYWRpdXMsIGhlaWdodCk7XG4gICAgY29uc3QgbXNpbiA9IE1hdGguc2luO1xuICAgIGNvbnN0IG1jb3MgPSBNYXRoLmNvcztcbiAgICBjb25zdCBtcGkgPSBNYXRoLlBJO1xuICAgIGNvbnN0IGNvc1NsYW50ID0gbWNvcyhzbGFudCk7XG4gICAgY29uc3Qgc2luU2xhbnQgPSBtc2luKHNsYW50KTtcbiAgICBjb25zdCBzdGFydCA9IHRvcENhcCA/IC0yIDogMDtcbiAgICBjb25zdCBlbmQgPSBudmVydGljYWwgKyAoYm90dG9tQ2FwID8gMiA6IDApO1xuICAgIGNvbnN0IHZlcnRzQXJvdW5kRWRnZSA9IG5yYWRpYWwgKyAxO1xuXG4gICAgY29uc3QgcG9zaXRpb25zID0gbmV3IEZsb2F0MzJBcnJheShudW1WZXJ0aWNlcyAqIDMpO1xuICAgIGNvbnN0IG5vcm1hbHMgPSBuZXcgRmxvYXQzMkFycmF5KG51bVZlcnRpY2VzICogMyk7XG4gICAgY29uc3QgdGV4Q29vcmRzID0gbmV3IEZsb2F0MzJBcnJheShudW1WZXJ0aWNlcyAqIDIpO1xuICAgIGNvbnN0IGluZGljZXMgPSBuZXcgVWludDE2QXJyYXkobnJhZGlhbCAqIChudmVydGljYWwgKyBleHRyYSkgKiA2KTtcblxuICAgIGxldCBpMyA9IDA7XG4gICAgbGV0IGkyID0gMDtcbiAgICBmb3IgKGxldCBpID0gc3RhcnQ7IGkgPD0gZW5kOyBpKyspIHtcbiAgICAgIGxldCB2ID0gaSAvIG52ZXJ0aWNhbDtcbiAgICAgIGxldCB5ID0gaGVpZ2h0ICogdjtcbiAgICAgIGxldCByaW5nUmFkaXVzO1xuXG4gICAgICBpZiAoaSA8IDApIHtcbiAgICAgICAgeSA9IDA7XG4gICAgICAgIHYgPSAxO1xuICAgICAgICByaW5nUmFkaXVzID0gYm90dG9tUmFkaXVzO1xuICAgICAgfSBlbHNlIGlmIChpID4gbnZlcnRpY2FsKSB7XG4gICAgICAgIHkgPSBoZWlnaHQ7XG4gICAgICAgIHYgPSAxO1xuICAgICAgICByaW5nUmFkaXVzID0gdG9wUmFkaXVzO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmluZ1JhZGl1cyA9IGJvdHRvbVJhZGl1cyArXG4gICAgICAgICAgKHRvcFJhZGl1cyAtIGJvdHRvbVJhZGl1cykgKiAoaSAvIG52ZXJ0aWNhbCk7XG4gICAgICB9XG4gICAgICBpZiAoaSA9PT0gLTIgfHwgaSA9PT0gbnZlcnRpY2FsICsgMikge1xuICAgICAgICByaW5nUmFkaXVzID0gMDtcbiAgICAgICAgdiA9IDA7XG4gICAgICB9XG4gICAgICB5IC09IGhlaWdodCAvIDI7XG4gICAgICBmb3IgKGxldCBqID0gMDsgaiA8IHZlcnRzQXJvdW5kRWRnZTsgaisrKSB7XG4gICAgICAgIGNvbnN0IHNpbiA9IG1zaW4oaiAqIG1waSAqIDIgLyBucmFkaWFsKTtcbiAgICAgICAgY29uc3QgY29zID0gbWNvcyhqICogbXBpICogMiAvIG5yYWRpYWwpO1xuXG4gICAgICAgIHBvc2l0aW9uc1tpMyArIDBdID0gc2luICogcmluZ1JhZGl1cztcbiAgICAgICAgcG9zaXRpb25zW2kzICsgMV0gPSB5O1xuICAgICAgICBwb3NpdGlvbnNbaTMgKyAyXSA9IGNvcyAqIHJpbmdSYWRpdXM7XG5cbiAgICAgICAgbm9ybWFsc1tpMyArIDBdID0gKGkgPCAwIHx8IGkgPiBudmVydGljYWwpID8gMCA6IChzaW4gKiBjb3NTbGFudCk7XG4gICAgICAgIG5vcm1hbHNbaTMgKyAxXSA9IChpIDwgMCkgPyAtMSA6IChpID4gbnZlcnRpY2FsID8gMSA6IHNpblNsYW50KTtcbiAgICAgICAgbm9ybWFsc1tpMyArIDJdID0gKGkgPCAwIHx8IGkgPiBudmVydGljYWwpID8gMCA6IChjb3MgKiBjb3NTbGFudCk7XG5cbiAgICAgICAgdGV4Q29vcmRzW2kyICsgMF0gPSBqIC8gbnJhZGlhbDtcbiAgICAgICAgdGV4Q29vcmRzW2kyICsgMV0gPSB2O1xuXG4gICAgICAgIGkyICs9IDI7XG4gICAgICAgIGkzICs9IDM7XG4gICAgICB9XG4gICAgfVxuXG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBudmVydGljYWwgKyBleHRyYTsgaSsrKSB7XG4gICAgICBmb3IgKGxldCBqID0gMDsgaiA8IG5yYWRpYWw7IGorKykge1xuICAgICAgICBjb25zdCBpbmRleCA9IChpICogbnJhZGlhbCArIGopICogNjtcbiAgICAgICAgaW5kaWNlc1tpbmRleCArIDBdID0gdmVydHNBcm91bmRFZGdlICogKGkgKyAwKSArIDAgKyBqO1xuICAgICAgICBpbmRpY2VzW2luZGV4ICsgMV0gPSB2ZXJ0c0Fyb3VuZEVkZ2UgKiAoaSArIDApICsgMSArIGo7XG4gICAgICAgIGluZGljZXNbaW5kZXggKyAyXSA9IHZlcnRzQXJvdW5kRWRnZSAqIChpICsgMSkgKyAxICsgajtcbiAgICAgICAgaW5kaWNlc1tpbmRleCArIDNdID0gdmVydHNBcm91bmRFZGdlICogKGkgKyAwKSArIDAgKyBqO1xuICAgICAgICBpbmRpY2VzW2luZGV4ICsgNF0gPSB2ZXJ0c0Fyb3VuZEVkZ2UgKiAoaSArIDEpICsgMSArIGo7XG4gICAgICAgIGluZGljZXNbaW5kZXggKyA1XSA9IHZlcnRzQXJvdW5kRWRnZSAqIChpICsgMSkgKyAwICsgajtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBzdXBlcihPYmplY3QuYXNzaWduKHt9LCBvcHRzLCB7XG4gICAgICBhdHRyaWJ1dGVzOiB7XG4gICAgICAgIHBvc2l0aW9ucyxcbiAgICAgICAgbm9ybWFscyxcbiAgICAgICAgdGV4Q29vcmRzLFxuICAgICAgICBpbmRpY2VzXG4gICAgICB9XG4gICAgfSkpO1xuICB9XG59XG4iXX0=