import { isBrowser } from './utils/is-browser';
import { global } from './utils/globals';
import log from './utils/log';
// Version detection
// TODO - this imports a rather large JSON file, we only need one field
import { version } from '../package.json';

var STARTUP_MESSAGE = 'Assign luma.log.priority in console to control logging: 0: none, 1: minimal, 2: verbose, 3: attribute/uniforms, 4: gl logs\nluma.log.break[], set to gl funcs, luma.log.profile[] set to model names';

if (global.luma && global.luma.VERSION !== version) {
  throw new Error('luma.gl - multiple versions detected: ' + global.luma.VERSION + ' vs ' + version);
}

if (!global.luma) {
  /* global console */
  /* eslint-disable no-console */
  if (isBrowser) {
    console.log('luma.gl ' + version + ' - ' + STARTUP_MESSAGE);
  }

  global.luma = global.luma || {
    VERSION: version,
    version: version,
    log: log,

    // Keep some luma globals in a sub-object
    // This allows us to dynamically detect if certain modules have been
    // included (such as IO and headless) and enable related functionality,
    // without unconditionally requiring and thus bundling big dependencies
    // into the app.
    globals: {
      headlessGL: null,
      headlessTypes: null,
      modules: {},
      nodeIO: {}
    }
  };
}

export { global };
export default global.luma;
//# sourceMappingURL=data:application/json;base64,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