'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFile = loadFile;
exports.loadImage = loadImage;

var _browserRequestFile = require('./browser-request-file');

function loadFile(opts) {
  return (0, _browserRequestFile.requestFile)(opts);
}

/* global Image */

/*
 * Loads images asynchronously
 * image.crossOrigin can be set via opts.crossOrigin, default to 'anonymous'
 * returns a promise tracking the load
 */
function loadImage(url) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    crossOrigin: 'anonymous'
  };

  return new Promise(function (resolve, reject) {
    try {
      (function () {
        var image = new Image();
        image.onload = function () {
          return resolve(image);
        };
        image.onerror = function () {
          return reject(new Error('Could not load image ' + url + '.'));
        };
        image.crossOrigin = opts.crossOrigin;
        image.src = url;
      })();
    } catch (error) {
      reject(error);
    }
  });
}
//# sourceMappingURL=data:application/json;base64,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