'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.requestFile = requestFile;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Supports loading (requesting) assets with XHR (XmlHttpRequest)
/* eslint-disable guard-for-in, complexity, no-try-catch */

/* global XMLHttpRequest */
function noop() {}

var XHR_STATES = {
  UNINITIALIZED: 0,
  LOADING: 1,
  LOADED: 2,
  INTERACTIVE: 3,
  COMPLETED: 4
};

var XHR = function () {
  function XHR(_ref) {
    var url = _ref.url,
        _ref$path = _ref.path,
        path = _ref$path === undefined ? null : _ref$path,
        _ref$method = _ref.method,
        method = _ref$method === undefined ? 'GET' : _ref$method,
        _ref$asynchronous = _ref.asynchronous,
        asynchronous = _ref$asynchronous === undefined ? true : _ref$asynchronous,
        _ref$noCache = _ref.noCache,
        noCache = _ref$noCache === undefined ? false : _ref$noCache,
        _ref$sendAsBinary = _ref.sendAsBinary,
        sendAsBinary = _ref$sendAsBinary === undefined ? false : _ref$sendAsBinary,
        _ref$responseType = _ref.responseType,
        responseType = _ref$responseType === undefined ? false : _ref$responseType,
        _ref$onProgress = _ref.onProgress,
        onProgress = _ref$onProgress === undefined ? noop : _ref$onProgress,
        _ref$onError = _ref.onError,
        onError = _ref$onError === undefined ? noop : _ref$onError,
        _ref$onAbort = _ref.onAbort,
        onAbort = _ref$onAbort === undefined ? noop : _ref$onAbort,
        _ref$onComplete = _ref.onComplete,
        onComplete = _ref$onComplete === undefined ? noop : _ref$onComplete;

    _classCallCheck(this, XHR);

    this.url = path ? path.join(path, url) : url;
    this.method = method;
    this.async = asynchronous;
    this.noCache = noCache;
    this.sendAsBinary = sendAsBinary;
    this.responseType = responseType;

    this.req = new XMLHttpRequest();

    this.req.onload = function (e) {
      return onComplete(e);
    };
    this.req.onerror = function (e) {
      return onError(e);
    };
    this.req.onabort = function (e) {
      return onAbort(e);
    };
    this.req.onprogress = function (e) {
      if (e.lengthComputable) {
        onProgress(e, Math.round(e.loaded / e.total * 100));
      } else {
        onProgress(e, -1);
      }
    };
  }

  _createClass(XHR, [{
    key: 'setRequestHeader',
    value: function setRequestHeader(header, value) {
      this.req.setRequestHeader(header, value);
      return this;
    }

    // /* eslint-disable max-statements */

  }, {
    key: 'sendAsync',
    value: function sendAsync() {
      var _this = this;

      var body = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.body || null;

      return new Promise(function (resolve, reject) {
        try {
          (function () {
            var req = _this.req,
                method = _this.method,
                noCache = _this.noCache,
                sendAsBinary = _this.sendAsBinary,
                responseType = _this.responseType;


            var url = noCache ? _this.url + (_this.url.indexOf('?') >= 0 ? '&' : '?') + Date.now() : _this.url;

            req.open(method, url, _this.async);

            if (responseType) {
              req.responseType = responseType;
            }

            if (_this.async) {
              req.onreadystatechange = function (e) {
                if (req.readyState === XHR_STATES.COMPLETED) {
                  if (req.status === 200) {
                    resolve(req.responseType ? req.response : req.responseText);
                  } else {
                    reject(new Error(req.status + ': ' + url));
                  }
                }
              };
            }

            if (sendAsBinary) {
              req.sendAsBinary(body);
            } else {
              req.send(body);
            }

            if (!_this.async) {
              if (req.status === 200) {
                resolve(req.responseType ? req.response : req.responseText);
              } else {
                reject(new Error(req.status + ': ' + url));
              }
            }
          })();
        } catch (error) {
          reject(error);
        }
      });
    }
    /* eslint-enable max-statements */

  }]);

  return XHR;
}();

function requestFile(opts) {
  var xhr = new XHR(opts);
  return xhr.sendAsync();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pby9icm93c2VyLXJlcXVlc3QtZmlsZS5qcyJdLCJuYW1lcyI6WyJyZXF1ZXN0RmlsZSIsIm5vb3AiLCJYSFJfU1RBVEVTIiwiVU5JTklUSUFMSVpFRCIsIkxPQURJTkciLCJMT0FERUQiLCJJTlRFUkFDVElWRSIsIkNPTVBMRVRFRCIsIlhIUiIsInVybCIsInBhdGgiLCJtZXRob2QiLCJhc3luY2hyb25vdXMiLCJub0NhY2hlIiwic2VuZEFzQmluYXJ5IiwicmVzcG9uc2VUeXBlIiwib25Qcm9ncmVzcyIsIm9uRXJyb3IiLCJvbkFib3J0Iiwib25Db21wbGV0ZSIsImpvaW4iLCJhc3luYyIsInJlcSIsIlhNTEh0dHBSZXF1ZXN0Iiwib25sb2FkIiwiZSIsIm9uZXJyb3IiLCJvbmFib3J0Iiwib25wcm9ncmVzcyIsImxlbmd0aENvbXB1dGFibGUiLCJNYXRoIiwicm91bmQiLCJsb2FkZWQiLCJ0b3RhbCIsImhlYWRlciIsInZhbHVlIiwic2V0UmVxdWVzdEhlYWRlciIsImJvZHkiLCJQcm9taXNlIiwicmVzb2x2ZSIsInJlamVjdCIsImluZGV4T2YiLCJEYXRlIiwibm93Iiwib3BlbiIsIm9ucmVhZHlzdGF0ZWNoYW5nZSIsInJlYWR5U3RhdGUiLCJzdGF0dXMiLCJyZXNwb25zZSIsInJlc3BvbnNlVGV4dCIsIkVycm9yIiwic2VuZCIsImVycm9yIiwib3B0cyIsInhociIsInNlbmRBc3luYyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7UUF3R2dCQSxXLEdBQUFBLFc7Ozs7QUF4R2hCO0FBQ0E7O0FBRUE7QUFDQSxTQUFTQyxJQUFULEdBQWdCLENBQUU7O0FBRWxCLElBQU1DLGFBQWE7QUFDakJDLGlCQUFlLENBREU7QUFFakJDLFdBQVMsQ0FGUTtBQUdqQkMsVUFBUSxDQUhTO0FBSWpCQyxlQUFhLENBSkk7QUFLakJDLGFBQVc7QUFMTSxDQUFuQjs7SUFRTUMsRztBQUNKLHFCQWFHO0FBQUEsUUFaREMsR0FZQyxRQVpEQSxHQVlDO0FBQUEseUJBWERDLElBV0M7QUFBQSxRQVhEQSxJQVdDLDZCQVhNLElBV047QUFBQSwyQkFWREMsTUFVQztBQUFBLFFBVkRBLE1BVUMsK0JBVlEsS0FVUjtBQUFBLGlDQVREQyxZQVNDO0FBQUEsUUFUREEsWUFTQyxxQ0FUYyxJQVNkO0FBQUEsNEJBUkRDLE9BUUM7QUFBQSxRQVJEQSxPQVFDLGdDQVJTLEtBUVQ7QUFBQSxpQ0FOREMsWUFNQztBQUFBLFFBTkRBLFlBTUMscUNBTmMsS0FNZDtBQUFBLGlDQUxEQyxZQUtDO0FBQUEsUUFMREEsWUFLQyxxQ0FMYyxLQUtkO0FBQUEsK0JBSkRDLFVBSUM7QUFBQSxRQUpEQSxVQUlDLG1DQUpZZixJQUlaO0FBQUEsNEJBSERnQixPQUdDO0FBQUEsUUFIREEsT0FHQyxnQ0FIU2hCLElBR1Q7QUFBQSw0QkFGRGlCLE9BRUM7QUFBQSxRQUZEQSxPQUVDLGdDQUZTakIsSUFFVDtBQUFBLCtCQUREa0IsVUFDQztBQUFBLFFBRERBLFVBQ0MsbUNBRFlsQixJQUNaOztBQUFBOztBQUNELFNBQUtRLEdBQUwsR0FBV0MsT0FBT0EsS0FBS1UsSUFBTCxDQUFVVixJQUFWLEVBQWdCRCxHQUFoQixDQUFQLEdBQThCQSxHQUF6QztBQUNBLFNBQUtFLE1BQUwsR0FBY0EsTUFBZDtBQUNBLFNBQUtVLEtBQUwsR0FBYVQsWUFBYjtBQUNBLFNBQUtDLE9BQUwsR0FBZUEsT0FBZjtBQUNBLFNBQUtDLFlBQUwsR0FBb0JBLFlBQXBCO0FBQ0EsU0FBS0MsWUFBTCxHQUFvQkEsWUFBcEI7O0FBRUEsU0FBS08sR0FBTCxHQUFXLElBQUlDLGNBQUosRUFBWDs7QUFFQSxTQUFLRCxHQUFMLENBQVNFLE1BQVQsR0FBa0I7QUFBQSxhQUFLTCxXQUFXTSxDQUFYLENBQUw7QUFBQSxLQUFsQjtBQUNBLFNBQUtILEdBQUwsQ0FBU0ksT0FBVCxHQUFtQjtBQUFBLGFBQUtULFFBQVFRLENBQVIsQ0FBTDtBQUFBLEtBQW5CO0FBQ0EsU0FBS0gsR0FBTCxDQUFTSyxPQUFULEdBQW1CO0FBQUEsYUFBS1QsUUFBUU8sQ0FBUixDQUFMO0FBQUEsS0FBbkI7QUFDQSxTQUFLSCxHQUFMLENBQVNNLFVBQVQsR0FBc0IsYUFBSztBQUN6QixVQUFJSCxFQUFFSSxnQkFBTixFQUF3QjtBQUN0QmIsbUJBQVdTLENBQVgsRUFBY0ssS0FBS0MsS0FBTCxDQUFXTixFQUFFTyxNQUFGLEdBQVdQLEVBQUVRLEtBQWIsR0FBcUIsR0FBaEMsQ0FBZDtBQUNELE9BRkQsTUFFTztBQUNMakIsbUJBQVdTLENBQVgsRUFBYyxDQUFDLENBQWY7QUFDRDtBQUNGLEtBTkQ7QUFPRDs7OztxQ0FFZ0JTLE0sRUFBUUMsSyxFQUFPO0FBQzlCLFdBQUtiLEdBQUwsQ0FBU2MsZ0JBQVQsQ0FBMEJGLE1BQTFCLEVBQWtDQyxLQUFsQztBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7O2dDQUNvQztBQUFBOztBQUFBLFVBQTFCRSxJQUEwQix1RUFBbkIsS0FBS0EsSUFBTCxJQUFhLElBQU07O0FBQ2xDLGFBQU8sSUFBSUMsT0FBSixDQUFZLFVBQUNDLE9BQUQsRUFBVUMsTUFBVixFQUFxQjtBQUN0QyxZQUFJO0FBQUE7QUFBQSxnQkFDS2xCLEdBREwsU0FDS0EsR0FETDtBQUFBLGdCQUNVWCxNQURWLFNBQ1VBLE1BRFY7QUFBQSxnQkFDa0JFLE9BRGxCLFNBQ2tCQSxPQURsQjtBQUFBLGdCQUMyQkMsWUFEM0IsU0FDMkJBLFlBRDNCO0FBQUEsZ0JBQ3lDQyxZQUR6QyxTQUN5Q0EsWUFEekM7OztBQUdGLGdCQUFNTixNQUFNSSxVQUNWLE1BQUtKLEdBQUwsSUFBWSxNQUFLQSxHQUFMLENBQVNnQyxPQUFULENBQWlCLEdBQWpCLEtBQXlCLENBQXpCLEdBQTZCLEdBQTdCLEdBQW1DLEdBQS9DLElBQXNEQyxLQUFLQyxHQUFMLEVBRDVDLEdBRVYsTUFBS2xDLEdBRlA7O0FBSUFhLGdCQUFJc0IsSUFBSixDQUFTakMsTUFBVCxFQUFpQkYsR0FBakIsRUFBc0IsTUFBS1ksS0FBM0I7O0FBRUEsZ0JBQUlOLFlBQUosRUFBa0I7QUFDaEJPLGtCQUFJUCxZQUFKLEdBQW1CQSxZQUFuQjtBQUNEOztBQUVELGdCQUFJLE1BQUtNLEtBQVQsRUFBZ0I7QUFDZEMsa0JBQUl1QixrQkFBSixHQUF5QixhQUFLO0FBQzVCLG9CQUFJdkIsSUFBSXdCLFVBQUosS0FBbUI1QyxXQUFXSyxTQUFsQyxFQUE2QztBQUMzQyxzQkFBSWUsSUFBSXlCLE1BQUosS0FBZSxHQUFuQixFQUF3QjtBQUN0QlIsNEJBQVFqQixJQUFJUCxZQUFKLEdBQW1CTyxJQUFJMEIsUUFBdkIsR0FBa0MxQixJQUFJMkIsWUFBOUM7QUFDRCxtQkFGRCxNQUVPO0FBQ0xULDJCQUFPLElBQUlVLEtBQUosQ0FBYTVCLElBQUl5QixNQUFqQixVQUE0QnRDLEdBQTVCLENBQVA7QUFDRDtBQUNGO0FBQ0YsZUFSRDtBQVNEOztBQUVELGdCQUFJSyxZQUFKLEVBQWtCO0FBQ2hCUSxrQkFBSVIsWUFBSixDQUFpQnVCLElBQWpCO0FBQ0QsYUFGRCxNQUVPO0FBQ0xmLGtCQUFJNkIsSUFBSixDQUFTZCxJQUFUO0FBQ0Q7O0FBRUQsZ0JBQUksQ0FBQyxNQUFLaEIsS0FBVixFQUFpQjtBQUNmLGtCQUFJQyxJQUFJeUIsTUFBSixLQUFlLEdBQW5CLEVBQXdCO0FBQ3RCUix3QkFBUWpCLElBQUlQLFlBQUosR0FBbUJPLElBQUkwQixRQUF2QixHQUFrQzFCLElBQUkyQixZQUE5QztBQUNELGVBRkQsTUFFTztBQUNMVCx1QkFBTyxJQUFJVSxLQUFKLENBQWE1QixJQUFJeUIsTUFBakIsVUFBNEJ0QyxHQUE1QixDQUFQO0FBQ0Q7QUFDRjtBQXJDQztBQXNDSCxTQXRDRCxDQXNDRSxPQUFPMkMsS0FBUCxFQUFjO0FBQ2RaLGlCQUFPWSxLQUFQO0FBQ0Q7QUFDRixPQTFDTSxDQUFQO0FBMkNEO0FBQ0Q7Ozs7Ozs7QUFHSyxTQUFTcEQsV0FBVCxDQUFxQnFELElBQXJCLEVBQTJCO0FBQ2hDLE1BQU1DLE1BQU0sSUFBSTlDLEdBQUosQ0FBUTZDLElBQVIsQ0FBWjtBQUNBLFNBQU9DLElBQUlDLFNBQUosRUFBUDtBQUNEIiwiZmlsZSI6ImJyb3dzZXItcmVxdWVzdC1maWxlLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gU3VwcG9ydHMgbG9hZGluZyAocmVxdWVzdGluZykgYXNzZXRzIHdpdGggWEhSIChYbWxIdHRwUmVxdWVzdClcbi8qIGVzbGludC1kaXNhYmxlIGd1YXJkLWZvci1pbiwgY29tcGxleGl0eSwgbm8tdHJ5LWNhdGNoICovXG5cbi8qIGdsb2JhbCBYTUxIdHRwUmVxdWVzdCAqL1xuZnVuY3Rpb24gbm9vcCgpIHt9XG5cbmNvbnN0IFhIUl9TVEFURVMgPSB7XG4gIFVOSU5JVElBTElaRUQ6IDAsXG4gIExPQURJTkc6IDEsXG4gIExPQURFRDogMixcbiAgSU5URVJBQ1RJVkU6IDMsXG4gIENPTVBMRVRFRDogNFxufTtcblxuY2xhc3MgWEhSIHtcbiAgY29uc3RydWN0b3Ioe1xuICAgIHVybCxcbiAgICBwYXRoID0gbnVsbCxcbiAgICBtZXRob2QgPSAnR0VUJyxcbiAgICBhc3luY2hyb25vdXMgPSB0cnVlLFxuICAgIG5vQ2FjaGUgPSBmYWxzZSxcbiAgICAvLyBib2R5ID0gbnVsbCxcbiAgICBzZW5kQXNCaW5hcnkgPSBmYWxzZSxcbiAgICByZXNwb25zZVR5cGUgPSBmYWxzZSxcbiAgICBvblByb2dyZXNzID0gbm9vcCxcbiAgICBvbkVycm9yID0gbm9vcCxcbiAgICBvbkFib3J0ID0gbm9vcCxcbiAgICBvbkNvbXBsZXRlID0gbm9vcFxuICB9KSB7XG4gICAgdGhpcy51cmwgPSBwYXRoID8gcGF0aC5qb2luKHBhdGgsIHVybCkgOiB1cmw7XG4gICAgdGhpcy5tZXRob2QgPSBtZXRob2Q7XG4gICAgdGhpcy5hc3luYyA9IGFzeW5jaHJvbm91cztcbiAgICB0aGlzLm5vQ2FjaGUgPSBub0NhY2hlO1xuICAgIHRoaXMuc2VuZEFzQmluYXJ5ID0gc2VuZEFzQmluYXJ5O1xuICAgIHRoaXMucmVzcG9uc2VUeXBlID0gcmVzcG9uc2VUeXBlO1xuXG4gICAgdGhpcy5yZXEgPSBuZXcgWE1MSHR0cFJlcXVlc3QoKTtcblxuICAgIHRoaXMucmVxLm9ubG9hZCA9IGUgPT4gb25Db21wbGV0ZShlKTtcbiAgICB0aGlzLnJlcS5vbmVycm9yID0gZSA9PiBvbkVycm9yKGUpO1xuICAgIHRoaXMucmVxLm9uYWJvcnQgPSBlID0+IG9uQWJvcnQoZSk7XG4gICAgdGhpcy5yZXEub25wcm9ncmVzcyA9IGUgPT4ge1xuICAgICAgaWYgKGUubGVuZ3RoQ29tcHV0YWJsZSkge1xuICAgICAgICBvblByb2dyZXNzKGUsIE1hdGgucm91bmQoZS5sb2FkZWQgLyBlLnRvdGFsICogMTAwKSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBvblByb2dyZXNzKGUsIC0xKTtcbiAgICAgIH1cbiAgICB9O1xuICB9XG5cbiAgc2V0UmVxdWVzdEhlYWRlcihoZWFkZXIsIHZhbHVlKSB7XG4gICAgdGhpcy5yZXEuc2V0UmVxdWVzdEhlYWRlcihoZWFkZXIsIHZhbHVlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIC8qIGVzbGludC1kaXNhYmxlIG1heC1zdGF0ZW1lbnRzICovXG4gIHNlbmRBc3luYyhib2R5ID0gdGhpcy5ib2R5IHx8IG51bGwpIHtcbiAgICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgICAgdHJ5IHtcbiAgICAgICAgY29uc3Qge3JlcSwgbWV0aG9kLCBub0NhY2hlLCBzZW5kQXNCaW5hcnksIHJlc3BvbnNlVHlwZX0gPSB0aGlzO1xuXG4gICAgICAgIGNvbnN0IHVybCA9IG5vQ2FjaGUgP1xuICAgICAgICAgIHRoaXMudXJsICsgKHRoaXMudXJsLmluZGV4T2YoJz8nKSA+PSAwID8gJyYnIDogJz8nKSArIERhdGUubm93KCkgOlxuICAgICAgICAgIHRoaXMudXJsO1xuXG4gICAgICAgIHJlcS5vcGVuKG1ldGhvZCwgdXJsLCB0aGlzLmFzeW5jKTtcblxuICAgICAgICBpZiAocmVzcG9uc2VUeXBlKSB7XG4gICAgICAgICAgcmVxLnJlc3BvbnNlVHlwZSA9IHJlc3BvbnNlVHlwZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICh0aGlzLmFzeW5jKSB7XG4gICAgICAgICAgcmVxLm9ucmVhZHlzdGF0ZWNoYW5nZSA9IGUgPT4ge1xuICAgICAgICAgICAgaWYgKHJlcS5yZWFkeVN0YXRlID09PSBYSFJfU1RBVEVTLkNPTVBMRVRFRCkge1xuICAgICAgICAgICAgICBpZiAocmVxLnN0YXR1cyA9PT0gMjAwKSB7XG4gICAgICAgICAgICAgICAgcmVzb2x2ZShyZXEucmVzcG9uc2VUeXBlID8gcmVxLnJlc3BvbnNlIDogcmVxLnJlc3BvbnNlVGV4dCk7XG4gICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgcmVqZWN0KG5ldyBFcnJvcihgJHtyZXEuc3RhdHVzfTogJHt1cmx9YCkpO1xuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChzZW5kQXNCaW5hcnkpIHtcbiAgICAgICAgICByZXEuc2VuZEFzQmluYXJ5KGJvZHkpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJlcS5zZW5kKGJvZHkpO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCF0aGlzLmFzeW5jKSB7XG4gICAgICAgICAgaWYgKHJlcS5zdGF0dXMgPT09IDIwMCkge1xuICAgICAgICAgICAgcmVzb2x2ZShyZXEucmVzcG9uc2VUeXBlID8gcmVxLnJlc3BvbnNlIDogcmVxLnJlc3BvbnNlVGV4dCk7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHJlamVjdChuZXcgRXJyb3IoYCR7cmVxLnN0YXR1c306ICR7dXJsfWApKTtcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgIHJlamVjdChlcnJvcik7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cbiAgLyogZXNsaW50LWVuYWJsZSBtYXgtc3RhdGVtZW50cyAqL1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVxdWVzdEZpbGUob3B0cykge1xuICBjb25zdCB4aHIgPSBuZXcgWEhSKG9wdHMpO1xuICByZXR1cm4geGhyLnNlbmRBc3luYygpO1xufVxuIl19