'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /* eslint-disable guard-for-in, complexity, no-try-catch */


exports.loadFiles = loadFiles;
exports.loadImages = loadImages;
exports.loadTextures = loadTextures;
exports.loadProgram = loadProgram;
exports.loadModel = loadModel;
exports.parseModel = parseModel;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _browserLoad = require('./browser-load');

var _webgl = require('../webgl');

var _core = require('../core');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function noop() {}

/*
 * Loads (Requests) multiple files asynchronously
 */
function loadFiles() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoad.loadFile)(Object.assign({ url: url }, opts));
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}

/*
 * Loads (requests) multiple images asynchronously
 */
function loadImages() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoad.loadImage)(url);
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}

function loadTextures(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var urls = opts.urls,
      _opts$onProgress3 = opts.onProgress,
      onProgress = _opts$onProgress3 === undefined ? noop : _opts$onProgress3;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadTextures: {urls} must be array of strings');

  return loadImages(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      var params = Array.isArray(opts.parameters) ? opts.parameters[i] : opts.parameters;
      params = params === undefined ? {} : params;
      return new _webgl.Texture2D(gl, Object.assign({ id: urls[i] }, params, { data: img }));
    });
  });
}

function loadProgram(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var vs = opts.vs,
      fs = opts.fs,
      _opts$onProgress4 = opts.onProgress,
      onProgress = _opts$onProgress4 === undefined ? noop : _opts$onProgress4;

  return loadFiles(Object.assign({ urls: [vs, fs], onProgress: onProgress }, opts)).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        vsText = _ref2[0],
        fsText = _ref2[1];

    return new _webgl.Program(gl, Object.assign({ vs: vsText, fs: fsText }, opts));
  });
}

// Loads a simple JSON format
function loadModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var url = opts.url,
      _opts$onProgress5 = opts.onProgress,
      onProgress = _opts$onProgress5 === undefined ? noop : _opts$onProgress5;

  return loadFiles(Object.assign({ urls: [url], onProgress: onProgress }, opts)).then(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
        file = _ref4[0];

    return parseModel(gl, Object.assign({ file: file }, opts));
  });
}

function parseModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var file = opts.file,
      _opts$program = opts.program,
      program = _opts$program === undefined ? new _webgl.Program(gl) : _opts$program;

  var json = typeof file === 'string' ? parseJSON(file) : file;
  // Remove any attributes so that we can create a geometry
  // TODO - change format to put these in geometry sub object?
  var attributes = {};
  var modelOptions = {};
  for (var key in json) {
    var value = json[key];
    if (Array.isArray(value)) {
      attributes[key] = key === 'indices' ? new Uint16Array(value) : new Float32Array(value);
    } else {
      modelOptions[key] = value;
    }
  }

  return new _core.Model(Object.assign({ program: program, geometry: new _core.Geometry({ attributes: attributes }) }, modelOptions, opts));
}

function parseJSON(file) {
  try {
    return JSON.parse(file);
  } catch (error) {
    throw new Error('Failed to parse JSON: ' + error);
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pby9sb2FkLWZpbGVzLmpzIl0sIm5hbWVzIjpbImxvYWRGaWxlcyIsImxvYWRJbWFnZXMiLCJsb2FkVGV4dHVyZXMiLCJsb2FkUHJvZ3JhbSIsImxvYWRNb2RlbCIsInBhcnNlTW9kZWwiLCJub29wIiwib3B0cyIsInVybHMiLCJvblByb2dyZXNzIiwiZXZlcnkiLCJ1cmwiLCJjb3VudCIsIlByb21pc2UiLCJhbGwiLCJtYXAiLCJwcm9taXNlIiwiT2JqZWN0IiwiYXNzaWduIiwidGhlbiIsInByb2dyZXNzIiwibGVuZ3RoIiwidG90YWwiLCJnbCIsImltYWdlcyIsImltZyIsImkiLCJwYXJhbXMiLCJBcnJheSIsImlzQXJyYXkiLCJwYXJhbWV0ZXJzIiwidW5kZWZpbmVkIiwiaWQiLCJkYXRhIiwidnMiLCJmcyIsInZzVGV4dCIsImZzVGV4dCIsImZpbGUiLCJwcm9ncmFtIiwianNvbiIsInBhcnNlSlNPTiIsImF0dHJpYnV0ZXMiLCJtb2RlbE9wdGlvbnMiLCJrZXkiLCJ2YWx1ZSIsIlVpbnQxNkFycmF5IiwiRmxvYXQzMkFycmF5IiwiZ2VvbWV0cnkiLCJKU09OIiwicGFyc2UiLCJlcnJvciIsIkVycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7eXBCQUFBOzs7UUFXZ0JBLFMsR0FBQUEsUztRQXFCQUMsVSxHQUFBQSxVO1FBa0JBQyxZLEdBQUFBLFk7UUFhQUMsVyxHQUFBQSxXO1FBU0FDLFMsR0FBQUEsUztRQU1BQyxVLEdBQUFBLFU7O0FBN0VoQjs7OztBQUNBOztBQUNBOztBQUNBOzs7O0FBRUEsU0FBU0MsSUFBVCxHQUFnQixDQUFFOztBQUVsQjs7O0FBR08sU0FBU04sU0FBVCxHQUE4QjtBQUFBLE1BQVhPLElBQVcsdUVBQUosRUFBSTtBQUFBLE1BQzVCQyxJQUQ0QixHQUNERCxJQURDLENBQzVCQyxJQUQ0QjtBQUFBLHlCQUNERCxJQURDLENBQ3RCRSxVQURzQjtBQUFBLE1BQ3RCQSxVQURzQixvQ0FDVEgsSUFEUzs7QUFFbkMsd0JBQU9FLEtBQUtFLEtBQUwsQ0FBVztBQUFBLFdBQU8sT0FBT0MsR0FBUCxLQUFlLFFBQXRCO0FBQUEsR0FBWCxDQUFQLEVBQW1ELDZDQUFuRDtBQUNBLE1BQUlDLFFBQVEsQ0FBWjtBQUNBLFNBQU9DLFFBQVFDLEdBQVIsQ0FBWU4sS0FBS08sR0FBTCxDQUNqQixlQUFPO0FBQ0wsUUFBTUMsVUFBVSwyQkFBU0MsT0FBT0MsTUFBUCxDQUFjLEVBQUNQLFFBQUQsRUFBZCxFQUFxQkosSUFBckIsQ0FBVCxDQUFoQjtBQUNBUyxZQUFRRyxJQUFSLENBQWE7QUFBQSxhQUFRVixXQUFXO0FBQzlCVyxrQkFBVSxFQUFFUixLQUFGLEdBQVVKLEtBQUthLE1BREs7QUFFOUJULG9CQUY4QjtBQUc5QlUsZUFBT2QsS0FBS2EsTUFIa0I7QUFJOUJWO0FBSjhCLE9BQVgsQ0FBUjtBQUFBLEtBQWI7QUFNQSxXQUFPSyxPQUFQO0FBQ0QsR0FWZ0IsQ0FBWixDQUFQO0FBWUQ7O0FBRUQ7OztBQUdPLFNBQVNmLFVBQVQsR0FBK0I7QUFBQSxNQUFYTSxJQUFXLHVFQUFKLEVBQUk7QUFBQSxNQUM3QkMsSUFENkIsR0FDRkQsSUFERSxDQUM3QkMsSUFENkI7QUFBQSwwQkFDRkQsSUFERSxDQUN2QkUsVUFEdUI7QUFBQSxNQUN2QkEsVUFEdUIscUNBQ1ZILElBRFU7O0FBRXBDLHdCQUFPRSxLQUFLRSxLQUFMLENBQVc7QUFBQSxXQUFPLE9BQU9DLEdBQVAsS0FBZSxRQUF0QjtBQUFBLEdBQVgsQ0FBUCxFQUFtRCw2Q0FBbkQ7QUFDQSxNQUFJQyxRQUFRLENBQVo7QUFDQSxTQUFPQyxRQUFRQyxHQUFSLENBQVlOLEtBQUtPLEdBQUwsQ0FDakIsZUFBTztBQUNMLFFBQU1DLFVBQVUsNEJBQVVMLEdBQVYsQ0FBaEI7QUFDQUssWUFBUUcsSUFBUixDQUFhO0FBQUEsYUFBUVYsV0FBVztBQUM5Qlcsa0JBQVUsRUFBRVIsS0FBRixHQUFVSixLQUFLYSxNQURLO0FBRTlCVCxvQkFGOEI7QUFHOUJVLGVBQU9kLEtBQUthLE1BSGtCO0FBSTlCVjtBQUo4QixPQUFYLENBQVI7QUFBQSxLQUFiO0FBTUEsV0FBT0ssT0FBUDtBQUNELEdBVmdCLENBQVosQ0FBUDtBQVlEOztBQUVNLFNBQVNkLFlBQVQsQ0FBc0JxQixFQUF0QixFQUFxQztBQUFBLE1BQVhoQixJQUFXLHVFQUFKLEVBQUk7QUFBQSxNQUNuQ0MsSUFEbUMsR0FDUkQsSUFEUSxDQUNuQ0MsSUFEbUM7QUFBQSwwQkFDUkQsSUFEUSxDQUM3QkUsVUFENkI7QUFBQSxNQUM3QkEsVUFENkIscUNBQ2hCSCxJQURnQjs7QUFFMUMsd0JBQU9FLEtBQUtFLEtBQUwsQ0FBVztBQUFBLFdBQU8sT0FBT0MsR0FBUCxLQUFlLFFBQXRCO0FBQUEsR0FBWCxDQUFQLEVBQ0UsK0NBREY7O0FBR0EsU0FBT1YsV0FBV2dCLE9BQU9DLE1BQVAsQ0FBYyxFQUFDVixVQUFELEVBQU9DLHNCQUFQLEVBQWQsRUFBa0NGLElBQWxDLENBQVgsRUFDTlksSUFETSxDQUNEO0FBQUEsV0FBVUssT0FBT1QsR0FBUCxDQUFXLFVBQUNVLEdBQUQsRUFBTUMsQ0FBTixFQUFZO0FBQ3JDLFVBQUlDLFNBQVNDLE1BQU1DLE9BQU4sQ0FBY3RCLEtBQUt1QixVQUFuQixJQUFpQ3ZCLEtBQUt1QixVQUFMLENBQWdCSixDQUFoQixDQUFqQyxHQUFzRG5CLEtBQUt1QixVQUF4RTtBQUNBSCxlQUFTQSxXQUFXSSxTQUFYLEdBQXVCLEVBQXZCLEdBQTRCSixNQUFyQztBQUNBLGFBQU8scUJBQWNKLEVBQWQsRUFBa0JOLE9BQU9DLE1BQVAsQ0FBYyxFQUFDYyxJQUFJeEIsS0FBS2tCLENBQUwsQ0FBTCxFQUFkLEVBQTZCQyxNQUE3QixFQUFxQyxFQUFDTSxNQUFNUixHQUFQLEVBQXJDLENBQWxCLENBQVA7QUFDRCxLQUplLENBQVY7QUFBQSxHQURDLENBQVA7QUFNRDs7QUFFTSxTQUFTdEIsV0FBVCxDQUFxQm9CLEVBQXJCLEVBQW9DO0FBQUEsTUFBWGhCLElBQVcsdUVBQUosRUFBSTtBQUFBLE1BQ2xDMkIsRUFEa0MsR0FDTDNCLElBREssQ0FDbEMyQixFQURrQztBQUFBLE1BQzlCQyxFQUQ4QixHQUNMNUIsSUFESyxDQUM5QjRCLEVBRDhCO0FBQUEsMEJBQ0w1QixJQURLLENBQzFCRSxVQUQwQjtBQUFBLE1BQzFCQSxVQUQwQixxQ0FDYkgsSUFEYTs7QUFFekMsU0FBT04sVUFBVWlCLE9BQU9DLE1BQVAsQ0FBYyxFQUFDVixNQUFNLENBQUMwQixFQUFELEVBQUtDLEVBQUwsQ0FBUCxFQUFpQjFCLHNCQUFqQixFQUFkLEVBQTRDRixJQUE1QyxDQUFWLEVBQ05ZLElBRE0sQ0FFTDtBQUFBO0FBQUEsUUFBRWlCLE1BQUY7QUFBQSxRQUFVQyxNQUFWOztBQUFBLFdBQXNCLG1CQUFZZCxFQUFaLEVBQWdCTixPQUFPQyxNQUFQLENBQWMsRUFBQ2dCLElBQUlFLE1BQUwsRUFBYUQsSUFBSUUsTUFBakIsRUFBZCxFQUF3QzlCLElBQXhDLENBQWhCLENBQXRCO0FBQUEsR0FGSyxDQUFQO0FBSUQ7O0FBRUQ7QUFDTyxTQUFTSCxTQUFULENBQW1CbUIsRUFBbkIsRUFBa0M7QUFBQSxNQUFYaEIsSUFBVyx1RUFBSixFQUFJO0FBQUEsTUFDaENJLEdBRGdDLEdBQ05KLElBRE0sQ0FDaENJLEdBRGdDO0FBQUEsMEJBQ05KLElBRE0sQ0FDM0JFLFVBRDJCO0FBQUEsTUFDM0JBLFVBRDJCLHFDQUNkSCxJQURjOztBQUV2QyxTQUFPTixVQUFVaUIsT0FBT0MsTUFBUCxDQUFjLEVBQUNWLE1BQU0sQ0FBQ0csR0FBRCxDQUFQLEVBQWNGLHNCQUFkLEVBQWQsRUFBeUNGLElBQXpDLENBQVYsRUFDTlksSUFETSxDQUNEO0FBQUE7QUFBQSxRQUFFbUIsSUFBRjs7QUFBQSxXQUFZakMsV0FBV2tCLEVBQVgsRUFBZU4sT0FBT0MsTUFBUCxDQUFjLEVBQUNvQixVQUFELEVBQWQsRUFBc0IvQixJQUF0QixDQUFmLENBQVo7QUFBQSxHQURDLENBQVA7QUFFRDs7QUFFTSxTQUFTRixVQUFULENBQW9Ca0IsRUFBcEIsRUFBbUM7QUFBQSxNQUFYaEIsSUFBVyx1RUFBSixFQUFJO0FBQUEsTUFDakMrQixJQURpQyxHQUNFL0IsSUFERixDQUNqQytCLElBRGlDO0FBQUEsc0JBQ0UvQixJQURGLENBQzNCZ0MsT0FEMkI7QUFBQSxNQUMzQkEsT0FEMkIsaUNBQ2pCLG1CQUFZaEIsRUFBWixDQURpQjs7QUFFeEMsTUFBTWlCLE9BQU8sT0FBT0YsSUFBUCxLQUFnQixRQUFoQixHQUEyQkcsVUFBVUgsSUFBVixDQUEzQixHQUE2Q0EsSUFBMUQ7QUFDQTtBQUNBO0FBQ0EsTUFBTUksYUFBYSxFQUFuQjtBQUNBLE1BQU1DLGVBQWUsRUFBckI7QUFDQSxPQUFLLElBQU1DLEdBQVgsSUFBa0JKLElBQWxCLEVBQXdCO0FBQ3RCLFFBQU1LLFFBQVFMLEtBQUtJLEdBQUwsQ0FBZDtBQUNBLFFBQUloQixNQUFNQyxPQUFOLENBQWNnQixLQUFkLENBQUosRUFBMEI7QUFDeEJILGlCQUFXRSxHQUFYLElBQWtCQSxRQUFRLFNBQVIsR0FBb0IsSUFBSUUsV0FBSixDQUFnQkQsS0FBaEIsQ0FBcEIsR0FBNkMsSUFBSUUsWUFBSixDQUFpQkYsS0FBakIsQ0FBL0Q7QUFDRCxLQUZELE1BRU87QUFDTEYsbUJBQWFDLEdBQWIsSUFBb0JDLEtBQXBCO0FBQ0Q7QUFDRjs7QUFFRCxTQUFPLGdCQUFVNUIsT0FBT0MsTUFBUCxDQUNmLEVBQUNxQixnQkFBRCxFQUFVUyxVQUFVLG1CQUFhLEVBQUNOLHNCQUFELEVBQWIsQ0FBcEIsRUFEZSxFQUVmQyxZQUZlLEVBR2ZwQyxJQUhlLENBQVYsQ0FBUDtBQUtEOztBQUVELFNBQVNrQyxTQUFULENBQW1CSCxJQUFuQixFQUF5QjtBQUN2QixNQUFJO0FBQ0YsV0FBT1csS0FBS0MsS0FBTCxDQUFXWixJQUFYLENBQVA7QUFDRCxHQUZELENBRUUsT0FBT2EsS0FBUCxFQUFjO0FBQ2QsVUFBTSxJQUFJQyxLQUFKLDRCQUFtQ0QsS0FBbkMsQ0FBTjtBQUNEO0FBQ0YiLCJmaWxlIjoibG9hZC1maWxlcy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIGd1YXJkLWZvci1pbiwgY29tcGxleGl0eSwgbm8tdHJ5LWNhdGNoICovXG5pbXBvcnQgYXNzZXJ0IGZyb20gJ2Fzc2VydCc7XG5pbXBvcnQge2xvYWRGaWxlLCBsb2FkSW1hZ2V9IGZyb20gJy4vYnJvd3Nlci1sb2FkJztcbmltcG9ydCB7UHJvZ3JhbSwgVGV4dHVyZTJEfSBmcm9tICcuLi93ZWJnbCc7XG5pbXBvcnQge0dlb21ldHJ5LCBNb2RlbH0gZnJvbSAnLi4vY29yZSc7XG5cbmZ1bmN0aW9uIG5vb3AoKSB7fVxuXG4vKlxuICogTG9hZHMgKFJlcXVlc3RzKSBtdWx0aXBsZSBmaWxlcyBhc3luY2hyb25vdXNseVxuICovXG5leHBvcnQgZnVuY3Rpb24gbG9hZEZpbGVzKG9wdHMgPSB7fSkge1xuICBjb25zdCB7dXJscywgb25Qcm9ncmVzcyA9IG5vb3B9ID0gb3B0cztcbiAgYXNzZXJ0KHVybHMuZXZlcnkodXJsID0+IHR5cGVvZiB1cmwgPT09ICdzdHJpbmcnKSwgJ2xvYWRJbWFnZXM6IHt1cmxzfSBtdXN0IGJlIGFycmF5IG9mIHN0cmluZ3MnKTtcbiAgbGV0IGNvdW50ID0gMDtcbiAgcmV0dXJuIFByb21pc2UuYWxsKHVybHMubWFwKFxuICAgIHVybCA9PiB7XG4gICAgICBjb25zdCBwcm9taXNlID0gbG9hZEZpbGUoT2JqZWN0LmFzc2lnbih7dXJsfSwgb3B0cykpO1xuICAgICAgcHJvbWlzZS50aGVuKGZpbGUgPT4gb25Qcm9ncmVzcyh7XG4gICAgICAgIHByb2dyZXNzOiArK2NvdW50IC8gdXJscy5sZW5ndGgsXG4gICAgICAgIGNvdW50LFxuICAgICAgICB0b3RhbDogdXJscy5sZW5ndGgsXG4gICAgICAgIHVybFxuICAgICAgfSkpO1xuICAgICAgcmV0dXJuIHByb21pc2U7XG4gICAgfVxuICApKTtcbn1cblxuLypcbiAqIExvYWRzIChyZXF1ZXN0cykgbXVsdGlwbGUgaW1hZ2VzIGFzeW5jaHJvbm91c2x5XG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBsb2FkSW1hZ2VzKG9wdHMgPSB7fSkge1xuICBjb25zdCB7dXJscywgb25Qcm9ncmVzcyA9IG5vb3B9ID0gb3B0cztcbiAgYXNzZXJ0KHVybHMuZXZlcnkodXJsID0+IHR5cGVvZiB1cmwgPT09ICdzdHJpbmcnKSwgJ2xvYWRJbWFnZXM6IHt1cmxzfSBtdXN0IGJlIGFycmF5IG9mIHN0cmluZ3MnKTtcbiAgbGV0IGNvdW50ID0gMDtcbiAgcmV0dXJuIFByb21pc2UuYWxsKHVybHMubWFwKFxuICAgIHVybCA9PiB7XG4gICAgICBjb25zdCBwcm9taXNlID0gbG9hZEltYWdlKHVybCk7XG4gICAgICBwcm9taXNlLnRoZW4oZmlsZSA9PiBvblByb2dyZXNzKHtcbiAgICAgICAgcHJvZ3Jlc3M6ICsrY291bnQgLyB1cmxzLmxlbmd0aCxcbiAgICAgICAgY291bnQsXG4gICAgICAgIHRvdGFsOiB1cmxzLmxlbmd0aCxcbiAgICAgICAgdXJsXG4gICAgICB9KSk7XG4gICAgICByZXR1cm4gcHJvbWlzZTtcbiAgICB9XG4gICkpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbG9hZFRleHR1cmVzKGdsLCBvcHRzID0ge30pIHtcbiAgY29uc3Qge3VybHMsIG9uUHJvZ3Jlc3MgPSBub29wfSA9IG9wdHM7XG4gIGFzc2VydCh1cmxzLmV2ZXJ5KHVybCA9PiB0eXBlb2YgdXJsID09PSAnc3RyaW5nJyksXG4gICAgJ2xvYWRUZXh0dXJlczoge3VybHN9IG11c3QgYmUgYXJyYXkgb2Ygc3RyaW5ncycpO1xuXG4gIHJldHVybiBsb2FkSW1hZ2VzKE9iamVjdC5hc3NpZ24oe3VybHMsIG9uUHJvZ3Jlc3N9LCBvcHRzKSlcbiAgLnRoZW4oaW1hZ2VzID0+IGltYWdlcy5tYXAoKGltZywgaSkgPT4ge1xuICAgIGxldCBwYXJhbXMgPSBBcnJheS5pc0FycmF5KG9wdHMucGFyYW1ldGVycykgPyBvcHRzLnBhcmFtZXRlcnNbaV0gOiBvcHRzLnBhcmFtZXRlcnM7XG4gICAgcGFyYW1zID0gcGFyYW1zID09PSB1bmRlZmluZWQgPyB7fSA6IHBhcmFtcztcbiAgICByZXR1cm4gbmV3IFRleHR1cmUyRChnbCwgT2JqZWN0LmFzc2lnbih7aWQ6IHVybHNbaV19LCBwYXJhbXMsIHtkYXRhOiBpbWd9KSk7XG4gIH0pKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGxvYWRQcm9ncmFtKGdsLCBvcHRzID0ge30pIHtcbiAgY29uc3Qge3ZzLCBmcywgb25Qcm9ncmVzcyA9IG5vb3B9ID0gb3B0cztcbiAgcmV0dXJuIGxvYWRGaWxlcyhPYmplY3QuYXNzaWduKHt1cmxzOiBbdnMsIGZzXSwgb25Qcm9ncmVzc30sIG9wdHMpKVxuICAudGhlbihcbiAgICAoW3ZzVGV4dCwgZnNUZXh0XSkgPT4gbmV3IFByb2dyYW0oZ2wsIE9iamVjdC5hc3NpZ24oe3ZzOiB2c1RleHQsIGZzOiBmc1RleHR9LCBvcHRzKSlcbiAgKTtcbn1cblxuLy8gTG9hZHMgYSBzaW1wbGUgSlNPTiBmb3JtYXRcbmV4cG9ydCBmdW5jdGlvbiBsb2FkTW9kZWwoZ2wsIG9wdHMgPSB7fSkge1xuICBjb25zdCB7dXJsLCBvblByb2dyZXNzID0gbm9vcH0gPSBvcHRzO1xuICByZXR1cm4gbG9hZEZpbGVzKE9iamVjdC5hc3NpZ24oe3VybHM6IFt1cmxdLCBvblByb2dyZXNzfSwgb3B0cykpXG4gIC50aGVuKChbZmlsZV0pID0+IHBhcnNlTW9kZWwoZ2wsIE9iamVjdC5hc3NpZ24oe2ZpbGV9LCBvcHRzKSkpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcGFyc2VNb2RlbChnbCwgb3B0cyA9IHt9KSB7XG4gIGNvbnN0IHtmaWxlLCBwcm9ncmFtID0gbmV3IFByb2dyYW0oZ2wpfSA9IG9wdHM7XG4gIGNvbnN0IGpzb24gPSB0eXBlb2YgZmlsZSA9PT0gJ3N0cmluZycgPyBwYXJzZUpTT04oZmlsZSkgOiBmaWxlO1xuICAvLyBSZW1vdmUgYW55IGF0dHJpYnV0ZXMgc28gdGhhdCB3ZSBjYW4gY3JlYXRlIGEgZ2VvbWV0cnlcbiAgLy8gVE9ETyAtIGNoYW5nZSBmb3JtYXQgdG8gcHV0IHRoZXNlIGluIGdlb21ldHJ5IHN1YiBvYmplY3Q/XG4gIGNvbnN0IGF0dHJpYnV0ZXMgPSB7fTtcbiAgY29uc3QgbW9kZWxPcHRpb25zID0ge307XG4gIGZvciAoY29uc3Qga2V5IGluIGpzb24pIHtcbiAgICBjb25zdCB2YWx1ZSA9IGpzb25ba2V5XTtcbiAgICBpZiAoQXJyYXkuaXNBcnJheSh2YWx1ZSkpIHtcbiAgICAgIGF0dHJpYnV0ZXNba2V5XSA9IGtleSA9PT0gJ2luZGljZXMnID8gbmV3IFVpbnQxNkFycmF5KHZhbHVlKSA6IG5ldyBGbG9hdDMyQXJyYXkodmFsdWUpO1xuICAgIH0gZWxzZSB7XG4gICAgICBtb2RlbE9wdGlvbnNba2V5XSA9IHZhbHVlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBuZXcgTW9kZWwoT2JqZWN0LmFzc2lnbihcbiAgICB7cHJvZ3JhbSwgZ2VvbWV0cnk6IG5ldyBHZW9tZXRyeSh7YXR0cmlidXRlc30pfSxcbiAgICBtb2RlbE9wdGlvbnMsXG4gICAgb3B0c1xuICApKTtcbn1cblxuZnVuY3Rpb24gcGFyc2VKU09OKGZpbGUpIHtcbiAgdHJ5IHtcbiAgICByZXR1cm4gSlNPTi5wYXJzZShmaWxlKTtcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYEZhaWxlZCB0byBwYXJzZSBKU09OOiAke2Vycm9yfWApO1xuICB9XG59XG4iXX0=