'use strict';

require('luma.gl/headless');

var _io = require('../../../dist/io');

var _setup = require('../../setup');

var _setup2 = _interopRequireDefault(_setup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable quotes */
var PNG_BITS = 'iVBORw0KGgoAAAANSUhEUgAAAAIAAAACCAYAAABytg0kAAAAFElEQVQIW2P8z/D/PwMDAwMjjAEAQOwF/W1Dp54AAAAASUVORK5CYII=';
/* eslint-enable quotes */

var DATA_URL = 'data:image/png;base64,' + PNG_BITS;

(0, _setup2.default)('io#read-image', function (t) {
  (0, _io.loadImage)(DATA_URL).then(function (image) {
    t.equals(image.width, 2, 'width');
    t.equals(image.height, 2, 'height');
    t.end();
  });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9pby90ZXN0L3JlYWQtaW1hZ2UuanMiXSwibmFtZXMiOlsiUE5HX0JJVFMiLCJEQVRBX1VSTCIsInRoZW4iLCJ0IiwiZXF1YWxzIiwiaW1hZ2UiLCJ3aWR0aCIsImhlaWdodCIsImVuZCJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7QUFDQTs7QUFDQTs7Ozs7O0FBRUE7QUFDQSxJQUFNQSxxSEFBTjtBQUdBOztBQUVBLElBQU1DLHNDQUFvQ0QsUUFBMUM7O0FBRUEscUJBQUssZUFBTCxFQUFzQixhQUFLO0FBQ3pCLHFCQUFVQyxRQUFWLEVBQ0NDLElBREQsQ0FDTSxpQkFBUztBQUNiQyxNQUFFQyxNQUFGLENBQVNDLE1BQU1DLEtBQWYsRUFBc0IsQ0FBdEIsRUFBeUIsT0FBekI7QUFDQUgsTUFBRUMsTUFBRixDQUFTQyxNQUFNRSxNQUFmLEVBQXVCLENBQXZCLEVBQTBCLFFBQTFCO0FBQ0FKLE1BQUVLLEdBQUY7QUFDRCxHQUxEO0FBTUQsQ0FQRCIsImZpbGUiOiJyZWFkLWltYWdlLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICdsdW1hLmdsL2hlYWRsZXNzJztcbmltcG9ydCB7bG9hZEltYWdlfSBmcm9tICcuLi8uLi8uLi9kaXN0L2lvJztcbmltcG9ydCB0ZXN0IGZyb20gJy4uLy4uL3NldHVwJztcblxuLyogZXNsaW50LWRpc2FibGUgcXVvdGVzICovXG5jb25zdCBQTkdfQklUUyA9IGBcXFxuaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFJQUFBQUNDQVlBQUFCeXRnMGtBQUFBRkVsRVFWUUlXMlA4elxcXG4vRC9Qd01EQXdNampBRUFRT3dGL1cxRHA1NEFBQUFBU1VWT1JLNUNZSUk9YDtcbi8qIGVzbGludC1lbmFibGUgcXVvdGVzICovXG5cbmNvbnN0IERBVEFfVVJMID0gYGRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCwke1BOR19CSVRTfWA7XG5cbnRlc3QoJ2lvI3JlYWQtaW1hZ2UnLCB0ID0+IHtcbiAgbG9hZEltYWdlKERBVEFfVVJMKVxuICAudGhlbihpbWFnZSA9PiB7XG4gICAgdC5lcXVhbHMoaW1hZ2Uud2lkdGgsIDIsICd3aWR0aCcpO1xuICAgIHQuZXF1YWxzKGltYWdlLmhlaWdodCwgMiwgJ2hlaWdodCcpO1xuICAgIHQuZW5kKCk7XG4gIH0pO1xufSk7XG4iXX0=