function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// ClipSpaceQuad
import { Model } from '../core';
import { Geometry } from '../geometry';
import { GL } from '../webgl';

var CLIPSPACE_QUAD_VERTEX_SHADER = 'attribute vec2 aClipSpacePosition;\nattribute vec2 aTexCoord;\nattribute vec2 aCoordinate;\n\nvarying vec2 position;\nvarying vec2 coordinate;\nvarying vec2 uv;\n\nvoid main(void) {\n  gl_Position = vec4(aClipSpacePosition, 0., 1.);\n  position = aClipSpacePosition;\n  coordinate = aCoordinate;\n  uv = aTexCoord;\n}\n';

/* eslint-disable indent, no-multi-spaces */
var POSITIONS = [-1, -1, 1, -1, -1, 1, 1, 1
// -1, -1,
//  1, -1,
//  1,  1,
// -1, -1,
//  1,  1,
// -1,  1
];

var TEX_COORDS = POSITIONS.map(function (coord) {
  return coord === -1 ? 0 : coord;
});
/* eslint-enable indent, no-multi-spaces */

var ClipSpaceQuad = function (_Model) {
  _inherits(ClipSpaceQuad, _Model);

  function ClipSpaceQuad(opts) {
    _classCallCheck(this, ClipSpaceQuad);

    var _this = _possibleConstructorReturn(this, (ClipSpaceQuad.__proto__ || Object.getPrototypeOf(ClipSpaceQuad)).call(this, Object.assign({}, opts, {
      vs: CLIPSPACE_QUAD_VERTEX_SHADER,
      geometry: new Geometry({
        drawMode: GL.TRIANGLE_STRIP,
        attributes: {
          aClipSpacePosition: {
            value: new Float32Array(POSITIONS),
            size: 2
          },
          aTexCoord: {
            value: new Float32Array(TEX_COORDS),
            size: 2
          },
          aCoordinate: {
            value: new Float32Array(TEX_COORDS),
            size: 2
          }
        }
      })
    })));

    _this.setVertexCount(4);
    return _this;
  }

  return ClipSpaceQuad;
}(Model);

export { ClipSpaceQuad as default };
//# sourceMappingURL=data:application/json;base64,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