'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _matrix = require('./matrix4');

var _quaternion = require('./quaternion');

var _vector = require('./vector3');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Internal constants
var ERR_UNKNOWN_ORDER = 'Unknown Euler angle order';
var ALMOST_ONE = 0.99999;

function validateOrder(value) {
  return value >= 0 && value < 6;
}

function checkOrder(value) {
  if (value < 0 && value >= 6) {
    throw new Error(ERR_UNKNOWN_ORDER);
  }
  return value;
}

var Euler = function (_MathArray) {
  _inherits(Euler, _MathArray);

  _createClass(Euler, [{
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    /*
     * Number|Number[], Number, Number, Number
     */

  }], [{
    key: 'rotationOrder',
    value: function rotationOrder(order) {
      return Euler.RotationOrders[order];
    }
  }, {
    key: 'ZYX',


    // Constants
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */
    get: function get() {
      return 0;
    }
  }, {
    key: 'YXZ',
    get: function get() {
      return 1;
    }
  }, {
    key: 'XZY',
    get: function get() {
      return 2;
    }
  }, {
    key: 'ZXY',
    get: function get() {
      return 3;
    }
  }, {
    key: 'YZX',
    get: function get() {
      return 4;
    }
  }, {
    key: 'XYZ',
    get: function get() {
      return 5;
    }
  }, {
    key: 'RollPitchYaw',
    get: function get() {
      return 0;
    }
  }, {
    key: 'DefaultOrder',
    get: function get() {
      return Euler.ZYX;
    }
  }, {
    key: 'RotationOrders',
    get: function get() {
      return ['ZYX', 'YXZ', 'XZY', 'ZXY', 'YZX', 'XYZ'];
    }
  }]);

  function Euler() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var order = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Euler.DefaultOrder;

    _classCallCheck(this, Euler);

    var _this = _possibleConstructorReturn(this, (Euler.__proto__ || Object.getPrototypeOf(Euler)).call(this));

    if (arguments.length > 0 && Array.isArray(arguments[0])) {
      _this.fromVector3.apply(_this, arguments);
    } else {
      _this.set(x, y, z, order);
    }
    return _this;
  }

  // If copied array does contain fourth element, preserves currently set order


  _createClass(Euler, [{
    key: 'copy',
    value: function copy(array) {
      for (var i = 0; i < 3; ++i) {
        this[i] = array[i];
      }
      this[3] = Number.isFinite(array[3]) || this.order;
      this.check();
      return this;
    }

    // Sets the three angles, and optionally sets the rotation order
    // If order is not specified, preserves currently set order

  }, {
    key: 'set',
    value: function set() {
      var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var order = arguments[3];

      this[0] = x;
      this[1] = y;
      this[2] = z;
      this[3] = Number.isFinite(order) ? order : this[3];
      this.check();
      return this;
    }
  }, {
    key: 'validate',
    value: function validate() {
      return validateOrder(this[3]) && Number.isFinite(this[0]) && Number.isFinite(this[1]) && Number.isFinite(this[2]);
    }

    // Does not copy the orientation element

  }, {
    key: 'toArray',
    value: function toArray() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      array[offset] = this[0];
      array[offset + 1] = this[1];
      array[offset + 2] = this[2];
      return array;
    }

    // Copies the orientation element

  }, {
    key: 'toArray4',
    value: function toArray4() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      array[offset] = this[0];
      array[offset + 1] = this[1];
      array[offset + 2] = this[2];
      array[offset + 3] = this[3];
      return array;
    }
  }, {
    key: 'toVector3',
    value: function toVector3(optionalResult) {
      if (optionalResult) {
        return optionalResult.set(this[0], this[1], this[2]);
      }
      return new _vector.Vector3(this[0], this[1], this[2]);
    }

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */
    // x, y, z angle notation (note: only corresponds to axis in XYZ orientation)

  }, {
    key: 'fromVector3',

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

    // Constructors
    value: function fromVector3(v, order) {
      return this.set(v[0], v[1], v[2], Number.isFinite(order) ? order : this[3]);
    }

    // TODO - with and without 4th element

  }, {
    key: 'fromArray',
    value: function fromArray(array) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      this[0] = array[0 + offset];
      this[1] = array[1 + offset];
      this[2] = array[2 + offset];
      if (array[3] !== undefined) {
        this[3] = array[3];
      }
      this.check();
      return this;
    }

    // Common ZYX rotation order

  }, {
    key: 'fromRollPitchYaw',
    value: function fromRollPitchYaw(roll, pitch, yaw) {
      return this.set(roll, pitch, yaw, Euler.ZYX);
    }
  }, {
    key: 'fromQuaternion',
    value: function fromQuaternion(q, order) {
      this._fromRotationMatrix(_matrix.Matrix4.fromQuaternion(q), order);
      this.check();
      return this;
    }
  }, {
    key: 'fromRotationMatrix',
    value: function fromRotationMatrix(m) {
      var order = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Euler.DefaultOrder;

      this._fromRotationMatrix(m, order);
      this.check();
      return this;
    }

    // ACCESSORS

    // @return {Matrix4} a rotation matrix corresponding to rotations
    //   per the specified euler angles

  }, {
    key: 'getRotationMatrix',
    value: function getRotationMatrix() {
      var m = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new _matrix.Matrix4();

      this._getRotationMatrix(m);
      return m;
    }
  }, {
    key: 'getQuaternion',
    value: function getQuaternion() {
      var q = new _quaternion.Quaternion();
      switch (this[4]) {
        case Euler.XYZ:
          return q.rotateX(this[0]).rotateY(this[1]).rotateZ(this[2]);
        case Euler.YXZ:
          return q.rotateY(this[0]).rotateX(this[1]).rotateZ(this[2]);
        case Euler.ZXY:
          return q.rotateZ(this[0]).rotateX(this[1]).rotateY(this[2]);
        case Euler.ZYX:
          return q.rotateZ(this[0]).rotateY(this[1]).rotateX(this[2]);
        case Euler.YZX:
          return q.rotateY(this[0]).rotateZ(this[1]).rotateX(this[2]);
        case Euler.XZY:
          return q.rotateX(this[0]).rotateZ(this[1]).rotateY(this[2]);
        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }
    }

    // INTERNAL METHODS

    // Concersion from Euler to rotation matrix and from matrix to Euler
    // Adapted from three.js under MIT license

    // // WARNING: this discards revolution information -bhouston
    // reorder(newOrder) {
    //   const q = new Quaternion().setFromEuler(this);
    //   return this.setFromQuaternion(q, newOrder);

    /* eslint-disable complexity, max-statements, one-var */

  }, {
    key: '_fromRotationMatrix',
    value: function _fromRotationMatrix(m) {
      var order = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Euler.DefaultOrder;

      // assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)

      var te = m.elements;
      var m11 = te[0],
          m12 = te[4],
          m13 = te[8];
      var m21 = te[1],
          m22 = te[5],
          m23 = te[9];
      var m31 = te[2],
          m32 = te[6],
          m33 = te[10];

      order = order || this[3];

      switch (order) {
        case Euler.XYZ:
          this[1] = Math.asin((0, _common.clamp)(m13, -1, 1));

          if (Math.abs(m13) < ALMOST_ONE) {
            this[0] = Math.atan2(-m23, m33);
            this[2] = Math.atan2(-m12, m11);
          } else {
            this[0] = Math.atan2(m32, m22);
            this[2] = 0;
          }
          break;

        case Euler.YXZ:
          this[0] = Math.asin(-(0, _common.clamp)(m23, -1, 1));

          if (Math.abs(m23) < ALMOST_ONE) {
            this[1] = Math.atan2(m13, m33);
            this[2] = Math.atan2(m21, m22);
          } else {
            this[1] = Math.atan2(-m31, m11);
            this[2] = 0;
          }
          break;

        case Euler.ZXY:
          this[0] = Math.asin((0, _common.clamp)(m32, -1, 1));

          if (Math.abs(m32) < ALMOST_ONE) {
            this[1] = Math.atan2(-m31, m33);
            this[2] = Math.atan2(-m12, m22);
          } else {
            this[1] = 0;
            this[2] = Math.atan2(m21, m11);
          }
          break;

        case Euler.ZYX:
          this[1] = Math.asin(-(0, _common.clamp)(m31, -1, 1));

          if (Math.abs(m31) < ALMOST_ONE) {
            this[0] = Math.atan2(m32, m33);
            this[2] = Math.atan2(m21, m11);
          } else {
            this[0] = 0;
            this[2] = Math.atan2(-m12, m22);
          }
          break;

        case Euler.YZX:
          this[2] = Math.asin((0, _common.clamp)(m21, -1, 1));

          if (Math.abs(m21) < ALMOST_ONE) {
            this[0] = Math.atan2(-m23, m22);
            this[1] = Math.atan2(-m31, m11);
          } else {
            this[0] = 0;
            this[1] = Math.atan2(m13, m33);
          }
          break;

        case Euler.XZY:
          this[2] = Math.asin(-(0, _common.clamp)(m12, -1, 1));

          if (Math.abs(m12) < ALMOST_ONE) {
            this[0] = Math.atan2(m32, m22);
            this[1] = Math.atan2(m13, m11);
          } else {
            this[0] = Math.atan2(-m23, m33);
            this[1] = 0;
          }
          break;

        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }

      this[3] = order;

      return this;
    }
  }, {
    key: '_getRotationMatrix',
    value: function _getRotationMatrix() {
      var te = new _matrix.Matrix4();

      var x = this.x,
          y = this.y,
          z = this.z;
      var a = Math.cos(x);
      var c = Math.cos(y);
      var e = Math.cos(z);
      var b = Math.sin(x);
      var d = Math.sin(y);
      var f = Math.sin(z);

      switch (this[3]) {
        case Euler.XYZ:
          {
            var ae = a * e,
                af = a * f,
                be = b * e,
                bf = b * f;

            te[0] = c * e;
            te[4] = -c * f;
            te[8] = d;

            te[1] = af + be * d;
            te[5] = ae - bf * d;
            te[9] = -b * c;

            te[2] = bf - ae * d;
            te[6] = be + af * d;
            te[10] = a * c;
            break;
          }

        case Euler.YXZ:
          {
            var ce = c * e,
                cf = c * f,
                de = d * e,
                df = d * f;

            te[0] = ce + df * b;
            te[4] = de * b - cf;
            te[8] = a * d;

            te[1] = a * f;
            te[5] = a * e;
            te[9] = -b;

            te[2] = cf * b - de;
            te[6] = df + ce * b;
            te[10] = a * c;
            break;
          }

        case Euler.ZXY:
          {
            var _ce = c * e,
                _cf = c * f,
                _de = d * e,
                _df = d * f;

            te[0] = _ce - _df * b;
            te[4] = -a * f;
            te[8] = _de + _cf * b;

            te[1] = _cf + _de * b;
            te[5] = a * e;
            te[9] = _df - _ce * b;

            te[2] = -a * d;
            te[6] = b;
            te[10] = a * c;
            break;
          }

        case Euler.ZYX:
          {
            var _ae = a * e,
                _af = a * f,
                _be = b * e,
                _bf = b * f;

            te[0] = c * e;
            te[4] = _be * d - _af;
            te[8] = _ae * d + _bf;

            te[1] = c * f;
            te[5] = _bf * d + _ae;
            te[9] = _af * d - _be;

            te[2] = -d;
            te[6] = b * c;
            te[10] = a * c;
            break;
          }

        case Euler.YZX:
          {
            var ac = a * c,
                ad = a * d,
                bc = b * c,
                bd = b * d;

            te[0] = c * e;
            te[4] = bd - ac * f;
            te[8] = bc * f + ad;

            te[1] = f;
            te[5] = a * e;
            te[9] = -b * e;

            te[2] = -d * e;
            te[6] = ad * f + bc;
            te[10] = ac - bd * f;
            break;
          }

        case Euler.XZY:
          {
            var _ac = a * c,
                _ad = a * d,
                _bc = b * c,
                _bd = b * d;

            te[0] = c * e;
            te[4] = -f;
            te[8] = d * e;

            te[1] = _ac * f + _bd;
            te[5] = a * e;
            te[9] = _ad * f - _bc;

            te[2] = _bc * f - _ad;
            te[6] = b * e;
            te[10] = _bd * f + _ac;
            break;
          }

        default:
          throw new Error(ERR_UNKNOWN_ORDER);
      }

      // last column
      te[3] = 0;
      te[7] = 0;
      te[11] = 0;

      // bottom row
      te[12] = 0;
      te[13] = 0;
      te[14] = 0;
      te[15] = 1;

      return this;
    }
    /* eslint-enable complexity, max-statements, one-var */

  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // alpha, beta, gamma angle notation

  }, {
    key: 'alpha',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'beta',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'gamma',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // phi, theta, psi angle notation

  }, {
    key: 'phi',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'theta',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'psi',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }

    // rotation order, in all three angle notations

  }, {
    key: 'order',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = checkOrder(value);
    }
  }]);

  return Euler;
}(_mathArray2.default);

exports.default = Euler;
//# sourceMappingURL=data:application/json;base64,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