'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _common = require('./common');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _extendableBuiltin(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
}

var MathArray = function (_extendableBuiltin2) {
  _inherits(MathArray, _extendableBuiltin2);

  function MathArray() {
    _classCallCheck(this, MathArray);

    return _possibleConstructorReturn(this, (MathArray.__proto__ || Object.getPrototypeOf(MathArray)).apply(this, arguments));
  }

  _createClass(MathArray, [{
    key: 'clone',
    value: function clone() {
      var Subclass = this.constructor;
      var clone = new Subclass().copy(this);
      clone.check();
      return clone;
    }
  }, {
    key: 'copy',
    value: function copy(array) {
      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = array[i];
      }
      this.check();
      return this;
    }
  }, {
    key: 'set',
    value: function set() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = args[i] || 0;
      }
      this.check();
      return this;
    }
  }, {
    key: 'fromArray',
    value: function fromArray(array) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      for (var i = 0; i < this.ELEMENTS; ++i) {
        this[i] = array[i + offset];
      }
      this.check();
      return this;
    }
  }, {
    key: 'toString',
    value: function toString() {
      var string = '';
      for (var i = 0; i < this.ELEMENTS; ++i) {
        string += (i > 0 ? ', ' : '') + (0, _common.formatValue)(this[i]);
      }
      return this.constructor.name + '(' + string + ')';
    }
  }, {
    key: 'toArray',
    value: function toArray() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      for (var i = 0; i < this.ELEMENTS; ++i) {
        array[offset + i] = this[i];
      }
      return array;
    }
  }, {
    key: 'toFloat32Array',
    value: function toFloat32Array() {
      return new Float32Array(this);
    }
  }, {
    key: 'equals',
    value: function equals(array) {
      if (this.length !== array.length) {
        return false;
      }
      for (var i = 0; i < this.ELEMENTS; ++i) {
        if (!(0, _common.equals)(this[i], array[i])) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(array) {
      if (this.length !== array.length) {
        return false;
      }
      for (var i = 0; i < this.ELEMENTS; ++i) {
        if (this[i] !== array[i]) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: 'validate',
    value: function validate() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;

      var valid = array.length === this.ELEMENTS;
      for (var i = 0; i < this.ELEMENTS; ++i) {
        valid = valid && Number.isFinite(array[i]);
      }
      return valid;
    }
  }, {
    key: 'check',
    value: function check() {
      var array = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;

      if (_common.glMatrix.debug && !this.validate(array)) {
        throw new Error('Invalid ' + this.constructor.name);
      }
    }
  }]);

  return MathArray;
}(_extendableBuiltin(Array));

exports.default = MathArray;
//# sourceMappingURL=data:application/json;base64,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