'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /* eslint-disable max-statements */


var _index = require('./index');

var _tapeCatch = require('tape-catch');

var _tapeCatch2 = _interopRequireDefault(_tapeCatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var IDENTITY_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];

var INDICES_MATRIX = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];

var TRANSPOSED_INDICES_MATRIX = [1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15, 4, 8, 12, 16];

// const MATRIX_TEST_CASES = {
//   identity: {
//     title: 'identity matrix',
//     INPUTS: [],
//     RESULT: IDENTITY_MATRIX
//   },
//   set: {}
// };

(0, _tapeCatch2.default)('Math#types', function (t) {
  t.equals(typeof _index.Vector2 === 'undefined' ? 'undefined' : _typeof(_index.Vector2), 'function');
  t.equals(typeof _index.Vector3 === 'undefined' ? 'undefined' : _typeof(_index.Vector3), 'function');
  t.equals(typeof _index.Vector4 === 'undefined' ? 'undefined' : _typeof(_index.Vector4), 'function');
  t.equals(typeof _index.Matrix4 === 'undefined' ? 'undefined' : _typeof(_index.Matrix4), 'function');
  t.equals(typeof _index.Quaternion === 'undefined' ? 'undefined' : _typeof(_index.Quaternion), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Math#construct and Array.isArray check', function (t) {
  t.ok(Array.isArray(new _index.Vector2()));
  t.ok(Array.isArray(new _index.Vector3()));
  t.ok(Array.isArray(new _index.Vector4()));
  t.ok(Array.isArray(new _index.Matrix4()));
  t.ok(Array.isArray(new _index.Quaternion()));
  t.end();
});

// ['add', 'cross'];
var VECTOR_METHODS = ['clone'];

(0, _tapeCatch2.default)('Vector2#members and methods', function (t) {
  var v = new _index.Vector2();
  t.equals(v.x, 0);
  t.equals(v.y, 0);

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = VECTOR_METHODS[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var method = _step.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Vector3#members and methods', function (t) {
  var v = new _index.Vector3();
  t.equals(v.x, 0);
  t.equals(v.y, 0);
  t.equals(v.z, 0);

  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = VECTOR_METHODS[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var method = _step2.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Vector4#members and methods', function (t) {
  var v = new _index.Vector4();
  t.equals(v.x, 0);
  t.equals(v.y, 0);
  t.equals(v.z, 0);
  t.equals(v.w, 0);

  var _iteratorNormalCompletion3 = true;
  var _didIteratorError3 = false;
  var _iteratorError3 = undefined;

  try {
    for (var _iterator3 = VECTOR_METHODS[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
      var method = _step3.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError3 = true;
    _iteratorError3 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion3 && _iterator3.return) {
        _iterator3.return();
      }
    } finally {
      if (_didIteratorError3) {
        throw _iteratorError3;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Matrix4.toFloat32Array', function (t) {
  t.equals(_typeof(_index.Matrix4.prototype.toFloat32Array), 'function');
  var m = new _index.Matrix4();
  m.identity();
  t.equals(m.toFloat32Array().BYTES_PER_ELEMENT, 4);
  t.end();
});

(0, _tapeCatch2.default)('Matrix4#identity (identity matrix)', function (t) {
  t.equals(_typeof(_index.Matrix4.prototype.identity), 'function');
  var m = new _index.Matrix4();
  m.identity();

  var RESULT = IDENTITY_MATRIX;

  (0, _index.tapeEquals)(t, m, RESULT);
  t.end();
});

(0, _tapeCatch2.default)('Matrix4#set', function (t) {
  var _ref;

  t.equals(_typeof(_index.Matrix4.prototype.set), 'function');

  var INPUT = INDICES_MATRIX;
  var RESULT = INDICES_MATRIX;

  var m = (_ref = new _index.Matrix4()).set.apply(_ref, INPUT);

  (0, _index.tapeEquals)(t, m, RESULT, 'set gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.transpose', function (t) {
  var _ref2;

  t.equals(_typeof(_index.Matrix4.prototype.transpose), 'function');

  var INPUT = INDICES_MATRIX;
  var RESULT = TRANSPOSED_INDICES_MATRIX;

  var m = (_ref2 = new _index.Matrix4()).set.apply(_ref2, INPUT);

  var result = m.transpose();

  (0, _index.tapeEquals)(t, result, RESULT, 'transpose gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.add', function (t) {
  var RESULT = [2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2];

  t.equals(_typeof(_index.Matrix4.prototype.add), 'function');
  var m = new _index.Matrix4().identity();
  m = m.add(m);

  (0, _index.tapeEquals)(t, m, RESULT, 'add gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.scale', function (t) {
  var RESULT = [1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1];

  t.equals(_typeof(_index.Matrix4.prototype.scale), 'function');
  var m = new _index.Matrix4().identity();
  var result = m.scale([1, 2, 3]);

  (0, _index.tapeEquals)(t, result, RESULT, 'scale gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.translate', function (t) {
  var RESULT = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 2, 3, 1];

  t.equals(_typeof(_index.Matrix4.prototype.translate), 'function');
  var m = new _index.Matrix4().identity();
  var result = m.translate([1, 2, 3]);

  (0, _index.tapeEquals)(t, result, RESULT, 'translate gave the right result');
  t.end();
});

// test('Matrix4.invert', t => {
//   t.equals(typeof Matrix4.prototype.invert, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.frustum(-1, 1, -1, 1, 0.1, 100).invert();
//   t.ok(abs(ans.n11 - 9.99999999) < delta);
//   t.ok(abs(ans.n12 - 0) < delta);
//   t.ok(abs(ans.n13 - 0) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0) < delta);
//   t.ok(abs(ans.n22 - 9.99999999) < delta);
//   t.ok(abs(ans.n23 - 0) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - 0) < delta);
//   t.ok(abs(ans.n32 - 0) < delta);
//   t.ok(abs(ans.n33 - 0) < delta);
//   t.ok(abs(ans.n34 - -1) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - -4.995) < delta);
//   t.ok(abs(ans.n44 - 5.005) < delta);
//   t.end();
// });

// test('Matrix4.mulVector3', t => {
//   t.equals(typeof Matrix4.prototype.mulVector3, 'function');
//   const v = new Vector3(1, 1, 1);
//   const m = new Matrix4();
//   const ans = m.mulVector3(v);

//   t.equals(ans[0], 1);
//   t.equals(ans[1], 1);
//   t.equals(ans[2], 1);
//   t.end();
// });

// test('Matrix4.$mulVector3', t => {
//   t.equals(typeof Matrix4.prototype.$mulVector3, 'function');
//   const v = new Vector3(1, 1, 1);
//   const m = new Matrix4();

//   m.$mulVector3(v);

//   t.equals(v[0], 1);
//   t.equals(v[1], 1);
//   t.equals(v[2], 1);
//   t.end();
// });

// test('Matrix4.mulMatrix42', t => {
//   t.equals(typeof Matrix4.prototype.mulMatrix42, 'function');
//   const m1 = new Matrix4();
//   m1.set(1, 2, 3, 4,
//          5, 6, 7, 8,
//          9, 10, 11, 12,
//          13, 14, 15, 16);

//   const m2 = new Matrix4();
//   m2.set(1, 2, 3, 4,
//          5, 6, 7, 8,
//          9, 10, 11, 12,
//          13, 14, 15, 16).$transpose();

//   const ans = new Matrix4();
//   ans.mulMatrix42(m1, m2);
//   t.ok(abs(ans.n11 - 30) < delta);
//   t.ok(abs(ans.n12 - 70) < delta);
//   t.ok(abs(ans.n13 - 110) < delta);
//   t.ok(abs(ans.n14 - 150) < delta);
//   t.ok(abs(ans.n21 - 70) < delta);
//   t.ok(abs(ans.n22 - 174) < delta);
//   t.ok(abs(ans.n23 - 278) < delta);
//   t.ok(abs(ans.n24 - 382) < delta);
//   t.ok(abs(ans.n31 - 110) < delta);
//   t.ok(abs(ans.n32 - 278) < delta);
//   t.ok(abs(ans.n33 - 446) < delta);
//   t.ok(abs(ans.n34 - 614) < delta);
//   t.ok(abs(ans.n41 - 150) < delta);
//   t.ok(abs(ans.n42 - 382) < delta);
//   t.ok(abs(ans.n43 - 614) < delta);
//   t.ok(abs(ans.n44 - 846) < delta);
//   t.end();
// });

// test('Matrix4.lookAt', t => {
//   t.equals(typeof Matrix4.prototype.lookAt, 'function');
//   t.end();
// });

// test('Matrix4.perspective', t => {
//   t.equals(typeof Matrix4.prototype.perspective, 'function');
//   t.end();
// });

// test('Matrix4.frustum', t => {
//   t.equals(typeof Matrix4.prototype.frustum, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.frustum(-1, 1, -1, 1, 0.1, 100);
//   t.ok(abs(ans.n11 - 0.1) < delta);
//   t.ok(abs(ans.n12 - 0) < delta);
//   t.ok(abs(ans.n13 - 0) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0) < delta);
//   t.ok(abs(ans.n22 - 0.1) < delta);
//   t.ok(abs(ans.n23 - 0) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - 0) < delta);
//   t.ok(abs(ans.n32 - 0) < delta);
//   t.ok(abs(ans.n33 - -1.002002002002002) < delta);
//   t.ok(abs(ans.n34 - -0.20020020020020018) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - -1) < delta);
//   t.ok(abs(ans.n44 - 0) < delta);
//   t.end();
// });

// test('Matrix4.rotateAxis', t => {
//   t.equals(typeof Matrix4.prototype.rotateAxis, 'function');
//   const v = [1, 2, 3];
//   const len = Math.sqrt(1 * 1 + 2 * 2 + 3 * 3);
//   const theta = Math.PI / 4;
//   const m = new Matrix4();

//   v[0] /= len;
//   v[1] /= len;
//   v[2] /= len;

//   const ans = m.rotateAxis(theta, v);
//   t.ok(abs(ans.n11 - 0.7280277013778687) < delta);
//   t.ok(abs(ans.n12 - -0.525104820728302) < delta);
//   t.ok(abs(ans.n13 - 0.4407272934913635) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0.6087885979157627) < delta);
//   t.ok(abs(ans.n22 - 0.7907905578613281) < delta);
//   t.ok(abs(ans.n23 - -0.06345657259225845) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - -0.3152016404063445) < delta);
//   t.ok(abs(ans.n32 - 0.3145079017103789) < delta);
//   t.ok(abs(ans.n33 - 0.8953952789306641) < delta);
//   t.ok(abs(ans.n34 - 0) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - 0) < delta);
//   t.ok(abs(ans.n44 - 1) < delta);
//   t.end();
// });

// test('Matrix4.rotateXYZ', t => {
//   t.equals(typeof Matrix4.prototype.rotateXYZ, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.rotateXYZ(1, 2, 3);
//   t.ok(abs(ans.n11 - 0.411982245665683) < delta);
//   t.ok(abs(ans.n12 - -0.8337376517741568) < delta);
//   t.ok(abs(ans.n13 - -0.36763046292489926) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - -0.05872664492762098) < delta);
//   t.ok(abs(ans.n22 - -0.42691762127620736) < delta);
//   t.ok(abs(ans.n23 - 0.9023815854833308) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - -0.9092974268256817) < delta);
//   t.ok(abs(ans.n32 - -0.35017548837401463) < delta);
//   t.ok(abs(ans.n33 - -0.2248450953661529) < delta);
//   t.ok(abs(ans.n34 - 0) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - 0) < delta);
//   t.ok(abs(ans.n44 - 1) < delta);
//   t.end();
// });

(0, _tapeCatch2.default)('Quaternion#methods', function (t) {
  var q = new _index.Quaternion();
  t.equals(q[0], 0);
  t.equals(q[1], 0);
  t.equals(q[2], 0);
  t.equals(q[3], 1);
  t.equals(_typeof(q.add), 'function');
  t.equals(_typeof(q.clone), 'function');
  t.equals(_typeof(q.conjugate), 'function');
  // t.equals(typeof q.divQuaternion, 'function');
  t.equals(_typeof(q.invert), 'function');
  t.equals(_typeof(q.multiply), 'function');
  // t.equals(typeof q.negate, 'function');
  // t.equals(typeof q.norm, 'function');
  // t.equals(typeof q.normSq, 'function');
  t.equals(_typeof(q.scale), 'function');
  t.equals(_typeof(q.set), 'function');
  // t.equals(typeof q.setQuaternion, 'function');
  // t.equals(typeof q.sub, 'function');
  // t.equals(typeof q.unit, 'function');
  t.end();
});

// test('Quaternion.fromAxisRotation', t => {
//   let q = Quaternion.fromAxisRotation(new Vector3(0, 0, 1), Math.PI);
//   t.equals(q[0], 0);
//   t.equals(q[1], 0);
//   t.equals(q[2], 1);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   q = Quaternion.fromAxisRotation(new Vector3(0, 1, 0), Math.PI);
//   t.equals(q[0], 0);
//   t.equals(q[1], 1);
//   t.equals(q[2], 0);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   q = Quaternion.fromAxisRotation(new Vector3(1, 0, 0), Math.PI);
//   t.equals(q[0], 1);
//   t.equals(q[1], 0);
//   t.equals(q[2], 0);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   const q1 = Quaternion.fromAxisRotation(new Vector3(5, 0, -2), Math.PI / 3);
//   const q2 = Quaternion.fromAxisRotation(new Vector3(1, 3, 0), Math.PI / 4);
//   q1.$mulQuaternion(q2);
//   t.equals(q1[0], 0.6011183144537015);
//   t.equals(q1[1], 0.29193457751898655);
//   t.equals(q1[2], -0.0030205353559888126);
//   t.equals(q1[3], 0.7439232829017486);
//   t.end();
// });
//# sourceMappingURL=data:application/json;base64,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