'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.unary = unary;
exports.staticMethod = staticMethod;
exports.binary = binary;
exports.spread = spread;

function _toArray(arr) { return Array.isArray(arr) ? arr : Array.from(arr); }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// From https://github.com/jayphelps/core-decorators.js, MIT license
function isDescriptor(descriptor) {
  if (!descriptor || !descriptor.hasOwnProperty) {
    return false;
  }

  var keys = ['value', 'initializer', 'get', 'set'];

  for (var i = 0, l = keys.length; i < l; i++) {
    if (descriptor.hasOwnProperty(keys[i])) {
      return true;
    }
  }

  return false;
}

// From https://github.com/jayphelps/core-decorators.js, MIT license
function decorate(entryArgs, handleDescriptor) {
  if (isDescriptor(entryArgs[entryArgs.length - 1])) {
    return handleDescriptor.apply(undefined, _toConsumableArray(entryArgs).concat([[]]));
  }
  return function _decorate() {
    return handleDescriptor.apply(undefined, Array.prototype.slice.call(arguments).concat([entryArgs]));
  };
}

function unary() {
  for (var _len = arguments.length, decoratorArgs = Array(_len), _key = 0; _key < _len; _key++) {
    decoratorArgs[_key] = arguments[_key];
  }

  return decorate(decoratorArgs, function (target, methodKey, descriptor, _ref) {
    var _ref2 = _toArray(_ref);

    var Class = target.constructor;
    Class[methodKey] = function () {
      var _ref3;

      return (_ref3 = new Class())[methodKey].apply(_ref3, arguments);
    };
    return _extends({}, descriptor, {
      value: function unaryWrapper() {
        return descriptor.value.apply(this, arguments);
      }
    });
  });
}

function staticMethod() {
  for (var _len2 = arguments.length, decoratorArgs = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    decoratorArgs[_key2] = arguments[_key2];
  }

  return decorate(decoratorArgs, function (target, methodKey, descriptor, _ref4) {
    var _ref5 = _toArray(_ref4);

    var Class = target.constructor;
    Class[methodKey] = function () {
      var _ref6;

      return (_ref6 = new Class())[methodKey].apply(_ref6, arguments);
    };
    return _extends({}, descriptor, {
      value: function staticMethodWrapper() {
        return descriptor.value.apply(this, arguments);
      }
    });
  });
}

function binary() {
  for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    args[_key3] = arguments[_key3];
  }

  return decorate(args, function (target, methodKey, descriptor, _ref7) {
    var _ref8 = _toArray(_ref7);

    var Class = target.constructor;
    Class[methodKey] = function (a, b) {
      return new Class().copy(a)[methodKey](b);
    };

    return _extends({}, descriptor, {
      value: function binaryWrapper() {
        return descriptor.value.apply(this, arguments);
      }
    });
  });
}

function spread() {
  for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
    args[_key4] = arguments[_key4];
  }

  return decorate(args, function (target, methodKey, descriptor, _ref9) {
    var _ref10 = _toArray(_ref9);

    var Class = target.constructor;
    Class[methodKey] = function (a) {
      for (var _len5 = arguments.length, rest = Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
        rest[_key5 - 1] = arguments[_key5];
      }

      return rest.reduce(function (acc, elt) {
        return acc[methodKey](elt);
      }, new Class().copy(a));
    };

    return _extends({}, descriptor, {
      value: function spreadWrapper() {
        return descriptor.value.apply(this, arguments);
      }
    });
  });
}
//# sourceMappingURL=data:application/json;base64,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