'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkArguments = checkArguments;
exports.validateVector2 = validateVector2;
exports.checkVector2 = checkVector2;
exports.validateVector3 = validateVector3;
exports.checkVector3 = checkVector3;
exports.validateVector4 = validateVector4;
exports.checkVector4 = checkVector4;
exports.validateQuaternion = validateQuaternion;
exports.checkQuaternion = checkQuaternion;
exports.validateMatrix2 = validateMatrix2;
exports.checkMatrix2 = checkMatrix2;
exports.validateMatrix2d = validateMatrix2d;
exports.checkMatrix2d = checkMatrix2d;
exports.validateMatrix3 = validateMatrix3;
exports.checkMatrix3 = checkMatrix3;
exports.validateMatrix4 = validateMatrix4;
exports.checkMatrix4 = checkMatrix4;

var _glMatrix = require('gl-matrix');

function checkArguments() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  for (var i = 0; i < args.length; ++i) {
    if (args[i] === undefined) {
      throw new Error('Invalid math argument');
    }
  }
}

function validateVector2(v) {
  return v.length === 2 && Number.isFinite(v[0]) && Number.isFinite(v[1]);
}

function checkVector2(v) {
  if (_glMatrix.glMatrix.debug && !validateVector2(v)) {
    throw new Error('Invalid Vector2');
  }
}

function validateVector3(v) {
  return v.length === 3 && Number.isFinite(v[0]) && Number.isFinite(v[1]) && Number.isFinite(v[2]);
}

function checkVector3(v) {
  if (_glMatrix.glMatrix.debug && !validateVector3(v)) {
    throw new Error('Invalid Vector3');
  }
}

function validateVector4(v) {
  return v.length === 4 && Number.isFinite(v[0]) && Number.isFinite(v[1]) && Number.isFinite(v[2]) && Number.isFinite(v[3]);
}

function checkVector4(v) {
  if (_glMatrix.glMatrix.debug && !validateVector4(v)) {
    throw new Error('Invalid Vector4');
  }
}

function validateQuaternion(q) {
  return q.length === 4 && Number.isFinite(q[0]) && Number.isFinite(q[1]) && Number.isFinite(q[2]) && Number.isFinite(q[3]);
}

function checkQuaternion(q) {
  if (_glMatrix.glMatrix.debug && !validateQuaternion(q)) {
    throw new Error('Invalid Quaternion');
  }
}

function validateMatrix2(m) {
  return m.length === 4 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]);
}

function checkMatrix2(m) {
  if (_glMatrix.glMatrix.debug && !validateMatrix2(m)) {
    throw new Error('Invalid Matrix2');
  }
}

function validateMatrix2d(m) {
  return m.length === 6 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]);
}

function checkMatrix2d(m) {
  if (_glMatrix.glMatrix.debug && !validateMatrix2d(m)) {
    throw new Error('Invalid Matrix2d');
  }
}

function validateMatrix3(m) {
  return m.length === 9 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]) && Number.isFinite(m[6]) && Number.isFinite(m[7]) && Number.isFinite(m[8]);
}

function checkMatrix3(m) {
  if (_glMatrix.glMatrix.debug && !validateMatrix3(m)) {
    throw new Error('Invalid Matrix3');
  }
}

function validateMatrix4(m) {
  return m.length === 16 && Number.isFinite(m[0]) && Number.isFinite(m[1]) && Number.isFinite(m[2]) && Number.isFinite(m[3]) && Number.isFinite(m[4]) && Number.isFinite(m[5]) && Number.isFinite(m[6]) && Number.isFinite(m[7]) && Number.isFinite(m[8]) && Number.isFinite(m[9]) && Number.isFinite(m[10]) && Number.isFinite(m[11]) && Number.isFinite(m[12]) && Number.isFinite(m[13]) && Number.isFinite(m[14]) && Number.isFinite(m[15]);
}

function checkMatrix4(m) {
  if (_glMatrix.glMatrix.debug && !validateMatrix4(m)) {
    throw new Error('Invalid Matrix4');
  }
}
//# sourceMappingURL=data:application/json;base64,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