'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _glMatrix = require('gl-matrix');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Vector2 = function (_MathArray) {
  _inherits(Vector2, _MathArray);

  // Creates a new, empty vec2
  function Vector2() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

    _classCallCheck(this, Vector2);

    var _this = _possibleConstructorReturn(this, (Vector2.__proto__ || Object.getPrototypeOf(Vector2)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y);
    }
    return _this;
  }

  _createClass(Vector2, [{
    key: 'set',
    value: function set(x, y) {
      _glMatrix.vec2.set(this, x, y);
      this.check();
      return this;
    }
  }, {
    key: 'equals',
    value: function equals(vector) {
      return _glMatrix.vec2.equals(this, vector);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(vector) {
      return _glMatrix.vec2.exactEquals(this, vector);
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'add',

    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          _glMatrix.vec2.add(this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 2;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }]);

  return Vector2;
}(_mathArray2.default);

exports.default = Vector2;
//# sourceMappingURL=data:application/json;base64,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